#include <stdlib.h>
#include <qdir.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>

#include "printerpage.h"

PrinterPage::PrinterPage(QWidget *parent, const char *name)
  : QWidget(parent,name)
{
  QGridLayout *grid = new QGridLayout(this, 4,3, 8);

  QPixmap pixmap(locate("data", "kdewizard/html/wizard_small.png"));
  QLabel *l = new QLabel(this);
  l->setPixmap(pixmap);
  l->setFixedSize(pixmap.size());
  grid->addMultiCellWidget(l, 0,1 ,1,2, AlignRight);

  l = new QLabel(i18n("You probably have a printer, don't you? "
		      "Then why not create a little icon for the printer that "
		      "allows you to drag & drop files to the printer, and to "
		      "invoke the printer queue utility!"), this);
  l->setAlignment(WordBreak);
  l->setBackgroundColor(white);
  grid->addMultiCellWidget(l, 0,0, 0,1);
  grid->setRowStretch(0,1);

  l = new QLabel(i18n("Printer icon"), this);
  l->setMinimumSize(l->sizeHint());
  l->setAlignment(AlignTop);
  l->setBackgroundColor(white);
  grid->addWidget(l, 2,1);

  QButton *button = new QPushButton(this);
  button->setPixmap(BarIcon("printer"));
  button->setFixedSize(button->sizeHint());
  grid->addWidget(button, 2,0);
  connect(button, SIGNAL(clicked()), this, SLOT(togglePrinter()));

  grid->setRowStretch(3,1);

  setBackgroundColor(white);
}


void PrinterPage::togglePrinter()
{
  QString destname = QDir::homeDirPath()+"/Desktop/Printer.desktop";
  QFile dest(destname);

  if (dest.exists())
    dest.remove();
  else {
    QString srcname = locate("data", "kdewizard/printer.desktop");
    QString command = "cp "+srcname+" "+destname;
    system(command.latin1());
  }

  // obsolete...does konqi already support this?
  // KFM kfm;
  // kfm.refreshDesktop();
}
