/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __desktop_h__
#define __desktop_h__

#include "KDesktopIface.h"

#include <qstringlist.h>
#include <konqfileitem.h>
#include <konqiconviewwidget.h>
#include <qiconview.h>

#include <kurl.h>

class KonqDirLister;
class KonqSettings;
class QCloseEvent;
class QPopupMenu;
class KGlobalAccel;
class KWinModule;
class KDesktopFile;

#include <kaction.h>

class KDesktop : public KonqIconViewWidget, virtual public KDesktopIface
{
  Q_OBJECT
public:

  KDesktop(const QString& _url, bool x_root_hack, bool auto_start, bool wait_for_kded );
  ~KDesktop();


  /**
   * Re-arrange the desktop icons
   * @param bAsk if true a confirmation is asked first
   */
  virtual void rearrangeIcons( int bAsk );
  /**
   * Select icons in the rectangle given
   */
  virtual void selectIconsInRect( int /*x*/, int /*y*/, int /*dx*/, int /*dy*/ )
   {/* selectByRubber( QRect(x, y, dx, dy) ); */ }
  /**
   * Select all icons
   */
  virtual void selectAll() { QIconView::selectAll( true ); }
  /**
   * Unselect all icons
   */
  virtual void unselectAll()  { QIconView::selectAll( false ); }
  /**
   * @return the urls of selected icons
   */
  virtual QStringList selectedURLs();
  /**
   * Re-read KDesktop's configuration
   */
  virtual void configure();
  /**
   * Display the "Execute Command" dialog (min-cli)
   */
  virtual void popupExecuteCommand();

  virtual void setMoveSelection( int b ) { s_bMoveSelection = (bool) b; }

  virtual void clientAreaUpdated(QRect);


  KWinModule* kwinModule() const { return m_pKwinmodule; }

protected slots:

  /**
   * Activate the desktop.
   */
  void slotStart();

  /*
   * Reconfigures
   */
  void slotConfigure();

  /**
   * Remove the splash screen if the desktop is active already.
   */
  void slotSplashDone();

  void slotExecuteCommand();

  /**
   * Connected to KSycoca
   */
  virtual void slotDatabaseChanged();

  // slots connected to the icon view
  void slotReturnPressed( QIconViewItem *item );
  void slotMouseButtonPressed(int, QIconViewItem*, const QPoint&);
  void slotEnableAction( const char * name, bool enabled );
  void slotSaveDropPosition( QDropEvent *ev, const QValueList<QIconDragItem> & );

  void slotItemRenamed(QIconViewItem*);

  // slots connected to the directory lister
  void slotClear();
  void slotStarted();
  void slotCompleted();
  void slotNewItems( const KFileItemList& );
  void slotDeleteItem( KFileItem * );

  // slots connected to the popupmenu (actions)
  void slotCut();
  void slotCopy();
  void slotTrash();
  void slotDelete();
  void slotShred();

public slots: // for krootwm

  void slotPaste();

protected:
  virtual void initConfig();
  virtual void popupMenu( const QPoint &_global, KFileItemList _items );
  virtual void showEvent( QShowEvent *e );
  virtual void closeEvent( QCloseEvent * );
  virtual void viewportWheelEvent( QWheelEvent * );

  /**
   * Set to true while the constructor is running.
   * @ref #initConfig needs to know about that.
   */
  bool m_bInit;

  /** Show dot files ? */
  bool m_bShowDot;

  /** Execute files from autoexec folder? */
  bool m_bAutoStart;

  /** Wait for kded to finish building database? */
  bool m_bWaitForKded;

  /** Vertical or Horizontal align of icons on desktop */
  bool m_bVertAlign;
  QIconView::Arrangement m_tAlign;

  /** Settings - see libkonq/konqsettings.* */
  KonqSettings* m_pSettings;

  /** The directory lister for this URL */
  KonqDirLister* m_dirLister;

  KGlobalAccel *m_keys;

  KActionCollection m_actionCollection;

  static bool s_bMoveSelection;

  KWinModule* m_pKwinmodule;

  /** Initial plash screen */
  QFrame *splash;

  /** The desktop's .directory, used for storing icon positions */
  KDesktopFile *m_dotDirectory;

  /** true if even one icon has an icon-position entry in the .directory */
  bool m_hasExistingPos;

  /** Last added icon - used when renaming a file */
  KFileIVI * m_lastIcon;

};

#endif
