/*
 *  MoniKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef PREFERENCES_H
#define PREFERENCES_H


#include <qobject.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qtabdialog.h>
#include <qradiobutton.h>
#include <qmultilinedit.h>
#include <qlabel.h>
#include <qcombobox.h>

#include <keditcl.h>


class DlgFontColor : public QTabDialog
{
   Q_OBJECT;
public:
   DlgFontColor( QWidget *parent );
   ~DlgFontColor();

public slots:
   void slotChangeField(int index);
   void slotChangeColor(int index);
   void slotOkPressed();

private:
   void setupColorWindow();
   void setupFontWindow();
   void setStandard();
   void saveData();
   void readFonts();

   QWidget *parent;
   QWidget *winColor, *winFont;
   // Colors
   QListBox *desc, *colors;
   QCheckBox *hdrbold, *markbold;
   // Fonts
   QComboBox *cmbMoni;
   QLabel *lMoni;
   KIntLineEdit *sizeMoni;

   int changedColors[25];
};



class DlgDX : public QDialog
{
   Q_OBJECT;
public:
   DlgDX();
   ~DlgDX();

public slots:
   void slotOkPressed();
   void slotActToggled( bool active );

private:
   void setupWindow();
   void setStandard();

   QPushButton *ok, *abort;
   QCheckBox *act;
   QLineEdit *pos;
//   QButtonGroup *buttongroup;
   QLineEdit *dxdata;
   QRadioButton *km, *mls;
   QButtonGroup *btngrpKmMiles;
   QLabel *lKmMiles;
};


class DlgQSOSpy : public QTabDialog
{
   Q_OBJECT;
public:
   DlgQSOSpy();
   ~DlgQSOSpy();

public slots:
   void slotOkPressed();
   void slotSpyFollow( bool toggled );
   void slotIgnoreFollow( bool toggled );
   void slotEnabled( bool toggled );

private:
   void setupWindowGeneral();
   void setupWindowIgnore();
   void setupWindowSpy();
   void setStandard();

   QWidget *winGeneral, *winIgnore, *winSpy;
   QRadioButton *spyAll, *spyNothing, *spyFollow;
   QRadioButton *ignAll, *ignNothing, *ignFollow;
   QMultiLineEdit *spy, *ignore;

   QPushButton *ok, *abort;
   QCheckBox *act;
};




#endif

