/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef OUTPUTCTRL_H
#define OUTPUTCTRL_H


#include <qwidget.h>
#include <qlist.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <qtableview.h>

#include "output.h"
#include "mondefs.h"


#define OCE_TYPE_MONITOR 1
#define OCE_TYPE_SPY 2


class OutputCtrlEntry : public QObject
{
   Q_OBJECT;
public:
   OutputCtrlEntry( QWidget *parent, int type );
   ~OutputCtrlEntry();

   OutputWidget *output;
   QPushButton *btn;

   void setFonts();
   void setNew( bool neu );
   void setSpyData( char *call, t_qsoid spyid, t_qsoid otherid );
   void show();
   void hide();
   int getNr();
   void setNr( int nr );
   int isSpyId( t_qsoid id );
   void setOtherId( t_qsoid id );
   char * getCalls();
   void getIDs( t_qsoid & id, t_qsoid & otherid );
   bool isSaving();
   void saveLine( char *data, int len );

   bool open;

public slots:
   void slotBtnClicked();
   void slotIgnoreQSO();
   void slotSaveQSO();
   void slotKontextMenu();

private:
   QPopupMenu *kontextmenu;
   QWidget *parent;
   int type;
   int mnu_save;
   bool neu;
   int nr;
   t_qsoid spyid;
   t_qsoid otherid;
   char *calls;
   bool saving;
   int fdsave;
};


class OutputCtrl : public QWidget
{
   Q_OBJECT;
public:
   OutputCtrl( QWidget *parent );
   ~OutputCtrl();

   void resizeEvent(QResizeEvent *e);
   void repaintButtons();
   void chooseChannel( OutputCtrlEntry *entry );

   // Monitor-Befehle
   void monitorWrite( char *text, QColor color );
   void monitorNewLine();

   // QSO-Spy-Befehle
   bool addSpy( char *tocall, t_qsoid id, t_qsoid otherid );
   void spyData( char *data, int len );
   void spyEnd( t_QSOMheard *data );
   void closeQSO( OutputCtrlEntry *w );
   void setFonts();

   QList <OutputCtrlEntry> *windows;

public slots:
   void slotBildAuf();
   void slotBildAb();

private:
   void getNextNr( int & nr, int & at );
   OutputCtrlEntry * getSpy( t_qsoid id );

   OutputCtrlEntry *moni;
   OutputCtrlEntry *visible;
};


class QSOListe : public QTableView
{
   Q_OBJECT;
public:
   QSOListe( QWidget *parent );
   ~QSOListe();

private:

};


#endif // OUTPUTCTRL_H

