/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "monitor.h"
#include "global.h"
#include "main.h"
#include "mondefs.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#include <kapp.h>
#include <kmsgbox.h>



extern TopLevel *toplevel;
extern KApplication *mykapp;


/* Macht ein Connect zum angegebenen Port auf der Maschine mit der bergebenen Adresse
 * und gibt den File-Descriptor zurck, oder -1, wenn ein Fehler aufgetreten ist.
 */
int make_connect(unsigned short int port, unsigned long int addr)
{
   struct sockaddr_in sock_addr;
   int sock_fd;


   // Socket oeffnen
   if ((sock_fd = socket(AF_INET,SOCK_STREAM,0)) == -1) return(-1);

   // Adressen fuer die Connect-Geschichte festlegen
   sock_addr.sin_family = AF_INET;
   sock_addr.sin_port = htons(port);
   sock_addr.sin_addr.s_addr = addr;

   // Und jetzt connecten
   if (::connect(sock_fd,(struct sockaddr *)&sock_addr,sizeof(struct sockaddr)) != 0) return(-1);

   return(sock_fd);
}


Monitor::Monitor() : QObject()
{
   // Versucht die Verbindung zu ax25spyd aufzubauen
   if ((fd = make_connect(config->ax25spyd_port, inet_addr("127.0.0.1"))) == -1)
   {
      result = 1;
      return;
   }

   // ax25spyd initialisieren
   if (config->timestamp)
      sendCmd("TIMESTAMP YES");

   if (config->onlyIFrames)
      sendCmd("ONLYIFRAMES");

   if (config->onlyHeaders)
      sendCmd("ONLYHEADERS");

   if (config->dxclusterspy)
      sendCmd("DXCLUSTERSPY");

   if (config->mheard)
      sendCmd("MHEARD");

   if (config->qsospy)
   {
      // Erstmal alle aktiven QSOs anfordern
      sendCmd("OFFERALLQSO");
      // Und danach alle neu entdeckten anbieten lassen
      sendCmd("OFFERALLNEWQSO");
   }

   sendCmd("STARTMONI");

/*    if( sfilter ) {
        char buf[60];
        sprintf(buf,"HEADERFILTER %s",sfilter);
        sendCmd(buf);
    }*/


   sockrx = new QSocketNotifier( fd, QSocketNotifier::Read, this );
   connect( sockrx, SIGNAL(activated(int)), this, SLOT(receiveData(int)) );

   result = 0;
}


Monitor::~Monitor()
{
   delete sockrx;
   ::close(fd);
}


//   void Monitor::receiveData(int)
//
// Es kommen irgendwelche Monitor-Daten 'rein
void Monitor::receiveData(int)
{
   struct t_protHeader protHeader;
   int count;
   char buffer[BUFSIZE];

   // Header einlesen
   count = read(fd, &protHeader, sizeof(protHeader));

   if (count == 0)
   {
printf("ax25spyd-error: Read-Failure 1\n");
//      KMsgBox::message(0, klocale->translate("ax25spyd-Error"), klocale->translate("Read-Failure"));
      toplevel->exitApplication();
      return;
   }

   if (count == -1)
   {
printf("ax25spyd-error: Read-Failure 2\n");
//      KMsgBox::message(0, klocale->translate("ax25spyd-Error"), klocale->translate("Read-Failure"));
      toplevel->exitApplication();
      return;
   }

   if (protHeader.dsize > 0)
   {
      // Und jetzt die eigentlichen Daten lesen
      if ((count = read(fd, buffer, protHeader.dsize)) == -1)
      {
printf("ax25spyd-error: Read-Failure 3\n");
//         KMsgBox::message(0, klocale->translate("ax25spyd-Error"), klocale->translate("Read-Failure"));
         toplevel->exitApplication();
         return;
      }

      buffer[count] = '\0';
      toplevel->showData(protHeader.dtype, buffer, count);
   }
}


//   void Monitor::sendCmd(char *cmd)
//
// Sendet einen Befehl an ax25spyd
void Monitor::sendCmd(char *cmd)
{
   struct t_protHeader protHeader;

   protHeader.version = 1;
   protHeader.dsize   = strlen(cmd) ;
   protHeader.dtype   = TT_CMD_FOLLOWS;
   write( fd, &protHeader, sizeof(protHeader) ) ;
   write(fd, cmd, strlen(cmd));
}


#include "monitor.moc"

