#include <sys/stat.h>
#include "window.h"
#include "PMbitchx.h"
#include "server.h"
#include "hook.h"

MenuStruct *findmenu(char *menuname);

int	new_window_being_created = 0;
int 	avio_redraw=0;
int 	avio_resized=0;
int     inwmchar=0;
int     inselect=2;
int 	VIO_staticx=200;
int 	VIO_staticy=100;
int 	VIO_font_width=6;
int 	VIO_font_height=10;

/* These are for $lastclickline() function */
char *lastclicklinedata = NULL;
int lastclickcol, lastclickrow;

/* These are for the context menu */
HWND contextmenu;
int contextx, contexty;

HAB	hab = 0;		 /* handle to the anchor block			  */
HMQ	hmq = 0;		 /* handle to the message queue 		  */
HWND	hwndClient = 0;		 /* handle to the client				  */
HWND	hwndFrame = 0; 		 /* handle to the frame window			  */
HWND	hwndMenu = 0;              /* handle to the menu */
QMSG	qmsg = { 0 };			 /* message-queue structure 			  */
HDC	hdc = 0;		 /* handle to the device context		  */
HVPS	hvps = 0,
	mainHvps = 0;				   /* handle to the AVIO presentation space */
static HEV sem = 0;
ULONG	scrbuf,
	scrlen; /* rosmo */
VIOMODEINFO viomode;
FILE	*debug;
static unsigned char output_buf[256];
int    output_tail = 0;
LONG   menuY;
clock_t flush_counter;


HMTX    mutex = 0;
HMTX    screenMutex = 0;
HEV     hgenev;

ULONG  cx, cy;
int    just_resized = 0, dont_resize = 0, no_resize;
Screen *focus_screen, *just_resized_screen;
extern MenuStruct *morigin;

/* Used by window_menu_stub() */
ULONG   menuroot=4000;
ULONG   tmpmenuid=3000;
extern Screen *menuscreen;
extern char *addthismenu;

#ifdef WINDOW_CREATE
/* Used by Window Create */
Window *WCWindow;
#endif

/* Used by popupmsg */
extern char *msgtext;

/* Used by the scrollers */
int newscrollerpos=0, lastscrollerpos=0, lastscrollerwindow=-1, lastpos=0;

/* Used by properties notebook */
static HWND hwndPage1;		   /* Page 1 Window Handle		*/
static HWND hwndPage2;		   /* Page 2 Window Handle		*/
static HWND hwndPage3;		   /* Page 3 Window Handle		*/
static HWND hwndPage4;		   /* Page 4 Window Handle		*/
static HWND hwndPage5;		   /* Page 5 Window Handle		*/
int p1e, p2e, p3e, p4e, inproperties=0;
ChannelList *chan = NULL;
Window *nb_window=NULL;
FONTMETRICS fm;

IrcVariable *return_irc_var(int nummer);
IrcVariable *return_fset_var(int nummer);
CSetArray *return_cset_var(int nummer);
WSetArray *return_wset_var(int nummer);

int fontstart=0;

#include "input.h"

#define         WIDTH   10

/* needed for rclick */
#include "keys.h"
void wm_process(int param);
unsigned long menucmd;

extern int guiipc[2];

void avio_set_var(int aviovar, int value) {
   if (aviovar==AVIOREDRAW)
		 avio_redraw=value;
   if (aviovar==AVIORESIZED)
		 avio_resized=value;
   if (aviovar==AVIOINSELECT) 
                inselect=value;
   if (aviovar==AVIOINWMCHAR) 
                inwmchar=value;
}

int avio_get_var(int aviovar) {
   if (aviovar==AVIOREDRAW)
	  return avio_redraw;
   if (aviovar==AVIORESIZED)
	  return avio_resized;
   if (aviovar==AVIOINSELECT) 
          return inselect;
   if (aviovar==AVIOINWMCHAR) 
          return inwmchar;
}

void avio_refresh_screen(void) {
   if (avio_redraw==1)
	  refresh_screen(0, NULL);
   avio_set_var(AVIORESIZED,0);
}

void gui_settitle(char *titletext, Screen *os2win) {
   WinSetWindowText(os2win->hwndFrame, titletext);
}

int aflush() {
  HMTX h = mutex;

  /* flush */
  if (output_tail > 0)
   {
	DosOpenMutexSem(NULL, &h);
	DosRequestMutexSem(h, SEM_INDEFINITE_WAIT);

    VioWrtTTY((PCH)output_buf, output_tail, (output_screen ? output_screen->hvps : hvps));
	output_tail = 0;
	DosReleaseMutexSem(h);
	DosCloseMutexSem(h);
   }
}

void flush_thread(void *param)
{
 clock_t foo;

 while (1 & 1)
  {
   foo = clock();
   if ((foo - flush_counter) > 10)
	{ if (output_tail > 0) { aflush(); } }
   DosSleep(100L);
  }
}

void cursor_thread(void)
{
   VIOCURSORINFO bleah;
   while(1 & 1)
      {
         DosSleep(500L);
         if(last_input_screen)
            {
             VioGetCurType(&bleah, last_input_screen->hvps);
             bleah.attr = 0;
             VioSetCurType(&bleah, last_input_screen->hvps);
            }
         DosSleep(500L);
         if(last_input_screen)
            {
             VioGetCurType(&bleah, last_input_screen->hvps);
             bleah.attr = -1;
             VioSetCurType(&bleah, last_input_screen->hvps);
            }
      }
}

int aputc(int c) {
   static char tmpos2[2];
   USHORT row, col;
   char *tmpbuf=NULL;
   HMTX h;

   DosOpenMutexSem(NULL, &h);
   DosRequestMutexSem(h, SEM_INDEFINITE_WAIT);

   /* buffer */
   if (output_tail < 256)
	{ output_buf[output_tail] = (unsigned char) c; output_tail++; flush_counter = clock(); }

   /* flush */
   if (output_tail == 256 || c == '\n' || c == '\r')
	{
	 VioWrtTTY((PCH)output_buf, output_tail, (output_screen ? output_screen->hvps : hvps));
	 output_tail = 0;
	}

   DosReleaseMutexSem(h);
   DosCloseMutexSem(h);
}

int gui_read(Screen *screen, char *buffer, int maxbufsize) {
   int i, tmplen;	/* Ignore the window handle for now because there is only one window. Not! */

   if (strlen(screen->aviokbdbuffer)> maxbufsize) {
	  for(i=0;i<=strlen(screen->aviokbdbuffer);i++)
		 {
			if (i<maxbufsize) {
			   buffer[i]=screen->aviokbdbuffer[i];
			}
			else if(i==maxbufsize) {
			   buffer[i]=0;
			   screen->aviokbdbuffer[0]=screen->aviokbdbuffer[i];
			   }
			else {
			   screen->aviokbdbuffer[i-maxbufsize]=screen->aviokbdbuffer[i];
			}
	  }
   } else {
		 strcpy(buffer,screen->aviokbdbuffer);
		 screen->aviokbdbuffer[0]='\0';
   }
   tmplen=strlen(buffer);
   for(i=0;i<tmplen;i++)
      if(buffer[i]==(char)0xFF)
         buffer[i]=0;
   return tmplen;
}

int aprintf(char *format, ...) {
  va_list args;
  char	  putbuf[AVIO_BUFFER+1], bluf[AVIO_BUFFER];
  USHORT  x, y, i, o;

  va_start(args, format);
  vsprintf(putbuf, format, args);
  va_end(args);

  i = o = 0;
  while (putbuf[i] != '\n' && putbuf[i] != 0) {
	i++;
	if (putbuf[i] == '\n' || putbuf[i] == 0) {
		 strcpy(bluf, "");
		 strncat(bluf, &putbuf[o], i - o);
	  if (putbuf[i] != 0) strcat(bluf, "\r\n");
	  VioWrtTTY((PCH)bluf,
				strlen(bluf),
				(output_screen ? output_screen->hvps : hvps));
	  i++; o = i;
	}
  }
}

MRESULT EXPENTRY FontDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 ULONG				 Remfonts = 0, Metlen = 0, Fonts = 0, i, i2;
 static PFONTMETRICS fonts;
 char				 buf[256];
 PMYWINDATA          wd;
 int                 bcx, bcy;
 ULONG               maxX, maxY, len;
 SWP                 menupos;
 unsigned char      *scr;
 char fontsize[10];

 switch (msg) {
  case WM_DESTROY:
	free(fonts);
	break;
  case WM_INITDLG:
	VioQueryFonts(&Remfonts,
				  NULL,
				  0,
				  &Fonts,
				  "System VIO",
				  VQF_PUBLIC,
				  hvps);

	fonts = malloc(sizeof(FONTMETRICS) * Remfonts);

	Fonts = Remfonts;
	VioQueryFonts(&Remfonts,
				  fonts,
				  sizeof(FONTMETRICS),
				  &Fonts,
				  "System VIO",
				  VQF_PUBLIC,
				  hvps);

	for (i = 0; i < Fonts; i++)
	 {
                if(fonts[i].lAveCharWidth != 5)
                   {
	           sprintf(buf, "%s %ux%u", fonts[i].szFacename, fonts[i].lMaxBaselineExt, fonts[i].lAveCharWidth);
	           WinSendMsg(WinWindowFromID(hwnd, 101),
				 LM_INSERTITEM,
				 MPFROMSHORT(LIT_END),
				 MPFROMP(buf));
                   }
                else
                   fontstart=i;
	 }
        fontstart++;
	break;
  case WM_COMMAND:
	switch (COMMANDMSG(&msg)->cmd)
	 {
	  case DID_CANCEL:
		WinDismissDlg(hwnd, 0);
		break;
	  case DID_OK:
        wd = (PMYWINDATA)WinQueryWindowPtr(WinWindowFromID(WinQueryWindow(hwnd, QW_OWNER), FID_CLIENT), QWP_USER);
        if (!wd) { DosBeep(500, 100); WinDismissDlg(hwnd, 0); return((MRESULT)0); }

        len = (wd->screen->co + 1) * wd->screen->li * 2;
        scr = malloc(len);
        VioReadCellStr(scr, (PUSHORT)&len, 0, 0, wd->screen->hvps);


        i = (ULONG)WinSendMsg(WinWindowFromID(hwnd, 101),
							  LM_QUERYSELECTION,
							  MPFROMSHORT(LIT_CURSOR),
							  0)+fontstart;

        wd->screen->VIO_font_width = fonts[i].lAveCharWidth;
        wd->screen->VIO_font_height = fonts[i].lMaxBaselineExt;

        i2 = (ULONG)WinSendMsg(WinWindowFromID(hwnd, 102),
							  BM_QUERYCHECK,
							  0,
							  0);
        if(i2)
           {
           sprintf(fontsize, "%dx%d", fonts[i].lAveCharWidth, fonts[i].lMaxBaselineExt);
           set_string_var(DEFAULT_FONT_VAR, fontsize);
           }
        co = wd->screen->co;
        li = wd->screen->li;

        cx = (co - 1) * wd->screen->VIO_font_width;
        cy = li * wd->screen->VIO_font_height;

        maxX = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
        maxY = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
        if (cx > maxX) /* No point in making bigger windows than the screen */
          wd->screen->co = (maxX / wd->screen->VIO_font_width) -1;

        if (cy > maxY) /* No point in making bigger windows than the screen */
          wd->screen->li = (maxY / wd->screen->VIO_font_height) -1;

        /* Recalculate in case we modified the values */
        cx = (co - 1) * wd->screen->VIO_font_width;
        cy = li * wd->screen->VIO_font_height;

        /*dont_resize = 1;*/

        if(wd->screen->hwndMenu==(HWND)NULL)
           WinSetWindowPos(wd->screen->hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + 1, cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR), SWP_SIZE);
        else
           {
           WinQueryWindowPos(wd->screen->hwndMenu, &menupos);
           WinSetWindowPos(wd->screen->hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + 1, cy + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + menupos.cy, SWP_SIZE);
           }
        VioSetDeviceCellSize(wd->screen->VIO_font_height, wd->screen->VIO_font_width, wd->hvps);

        VioWrtCellStr(scr, len, 0, 0, wd->screen->hvps);
        free(scr);

        WinDismissDlg(hwnd, 0);
		break;
	  default: break;
	}
   return((MRESULT)0);
   break;
  default: return (WinDefDlgProc(hwnd, msg, mp1, mp2));
 }
}

void gui_font_dialog(Screen *screen)
{
 WinDlgBox(HWND_DESKTOP, screen->hwndFrame, FontDlgProc, NULLHANDLE, FONTDIALOG, NULL);
 refresh_window_screen(screen->current_window);
}

int set_right_window(HWND hwnd)
{
 Screen *this_screen = NULL;
 static Screen *last_screen = NULL;

 this_screen = (Screen *)WinQueryWindowPtr(WinQueryWindow(hwnd, QW_PARENT), 0);
 if (!this_screen)
   this_screen = (Screen *)WinQueryWindowPtr(hwnd, 0);
 if (!this_screen)
   this_screen = output_screen;

 if (this_screen != last_screen)
   make_window_current(this_screen->current_window);

 last_screen = this_screen;
}

HWND *newsubmenu(MenuStruct *menutoadd, HWND *location)
{
        ULONG ulSzFirst=1;
        ULONG ulSzText=2;
        ULONG ulItemCount=1;
        ULONG ulSzBuf;
        ULONG tmpmenuid2;
        LPMT pmtMenu;
        HPS hpsTemp;
        MTI *pmtiItem;
        USHORT usIndex;
        HWND *tmphandle;
        MenuList *tmp;
        MENUITEM miSubMenu;
        HWND hwndSubmenu;
        ULONG itemmask;

        ulSzBuf=(sizeof(MT) + (ulSzFirst-1) + ((sizeof(MTI) - 1) * (ulItemCount - 1)) + (ulSzText - ulSzFirst));
        pmtMenu=calloc(1,ulSzBuf);

        pmtMenu->len=ulSzBuf;

        hpsTemp=WinGetPS((HWND)location);
        pmtMenu->codepage=GpiQueryCp(hpsTemp);
        WinReleasePS(hpsTemp);

        pmtMenu->reserved=0;
        pmtMenu->cMti=ulItemCount;

        /* Make a temporary item before to allow WinCreateMenu() to succeed */

        pmtiItem = &pmtMenu->rgMti[0];
        pmtiItem->afStyle=MIS_TEXT;
        pmtiItem->pad=0;
        tmpmenuid++;
        pmtiItem->idItem=tmpmenuid2=tmpmenuid;
        strcpy(pmtiItem->c," ");
        pmtiItem=(MTI *)(((PBYTE)pmtiItem) + (sizeof(MTI)));

        tmphandle=(HWND *)WinCreateMenu((HWND)location,pmtMenu);
        free(pmtMenu);

        /* Go through all menuitems adding items and submenus (and subitems) as neccessary */

        tmp = menutoadd->menuorigin;
        while(tmp!=NULL)
           {
              itemmask=0;
              if(tmp->menutype==GUISUBMENU || tmp->menutype==GUISHARED || tmp->menutype==GUIBRKSUBMENU)
                 hwndSubmenu=(HWND)newsubmenu((MenuStruct *)findmenu(tmp->submenu), tmphandle);
              else
                 hwndSubmenu=(HWND)NULLHANDLE;
              miSubMenu.iPosition=MIT_END;
              switch(tmp->menutype) 
              {
              case GUISEPARATOR:
                 miSubMenu.afStyle=MIS_SEPARATOR;
                 break;
              case GUIBRKMENUITEM:
                 miSubMenu.afStyle=MIS_BREAKSEPARATOR | MIS_TEXT;
                 break;
              case GUIBRKSUBMENU:
                 miSubMenu.afStyle=MIS_BREAKSEPARATOR | MIS_TEXT;
                 break;
              case GUIIAMENUITEM:
                 miSubMenu.afStyle=MIS_TEXT;
                 itemmask=itemmask || MIA_DISABLED;
                 break;
              case GUICHECKEDMENUITEM:
                 miSubMenu.afStyle=MIS_TEXT;
                 itemmask=itemmask || MIA_CHECKED;
                 break;
              case GUINDMENUITEM:
                 miSubMenu.afStyle=MIS_TEXT;
                 itemmask=itemmask || MIA_NODISMISS;
                 break;
              default:
                 miSubMenu.afStyle=MIS_TEXT;
                 break;
              }
              miSubMenu.afAttribute=0;
              miSubMenu.id=tmp->menuid;
              miSubMenu.hwndSubMenu=hwndSubmenu;
              miSubMenu.hItem=NULLHANDLE;

              WinSendMsg((HWND)tmphandle,
                       MM_INSERTITEM,
                       MPFROMP(&miSubMenu),
                       MPFROMP(tmp->name));
              /* Set other options */
              if(itemmask != 0)
                 WinSendMsg((HWND)tmphandle, MM_SETITEMATTR, MPFROM2SHORT(tmp->menuid, TRUE), MPFROM2SHORT(itemmask, TRUE));
              if(tmp->menutype==GUIDEFMENUITEM)
                 {
                 WinSetWindowBits((HWND)tmphandle, QWL_STYLE, MS_CONDITIONALCASCADE,MS_CONDITIONALCASCADE );
                 /* Set cascade menu default */
                 WinSendMsg((HWND)tmphandle, MM_SETDEFAULTITEMID, MPFROMSHORT(tmp->menuid), NULL );
                 }

              tmp=tmp->next;
           }

        /* Remove the temporary item */

        WinSendMsg((HWND)tmphandle,
                       MM_DELETEITEM,
                       MPFROM2SHORT(tmpmenuid2, FALSE),
                       MPFROMSHORT(NULL)); 

        return tmphandle;
}

/* This is so I can create a menu easily from elsewhere in the code */

HWND *menucreatestub(char *addthismenu, HWND *location)
{
        MenuStruct *menutoadd;

        if((menutoadd = (MenuStruct *)findmenu(addthismenu))==NULL)
           {
           say("Menu not found.");
           return NULL;
           }

        if(menutoadd->menuorigin==NULL)
           {
              say("Cannot create blank menu.");
              return NULL;
           }
   return newsubmenu(menutoadd, location);
}

void window_menu_stub(void)
{
int menustate=0, newmenustate=0;

        tmpmenuid=3000;

        if(menuscreen->hwndMenu != (HWND)NULL)
           {
           menustate=1;
           if(WinDestroyWindow(menuscreen->hwndMenu)==FALSE)
              {
                 /* Might be a mem leak...not sure why it would fail */
                 /*bitchsay("WinDestroyWindow() failed!");*/
              }

              new_free(&menuscreen->menu);
           }

        /* Create toplevel menu */

        aflush();
        if(strcmp(addthismenu, "-delete")!=0)
           {
           if((menuscreen->hwndMenu=(HWND)menucreatestub(addthismenu, (HWND *)menuscreen->hwndFrame))!=(HWND)NULL)
              newmenustate=1;
           }
        else
           menuscreen->hwndMenu=(HWND)NULL;

        if(newmenustate==1)
           menuscreen->menu=m_strdup(addthismenu);
        else
           menuscreen->menu=NULL;

        /* Tell the Window to resize because of menu */
        WinSendMsg(menuscreen->hwndFrame, WM_UPDATEFRAME, 0, 0);

        if(menustate != newmenustate)
           WinSendMsg(menuscreen->hwndFrame, WM_USER, 0, 0);
        new_free(&addthismenu);
}

void pm_resize(Screen *this_screen)
{
             if(this_screen->co < 20) this_screen->old_co=this_screen->co=20;
             if(this_screen->li < 10) this_screen->old_li=this_screen->li=10;
             if(this_screen->co > 199) this_screen->old_co=this_screen->co=199;
             if(this_screen->li > 99) this_screen->old_li=this_screen->li=99;
             cx = this_screen->co * this_screen->VIO_font_width;
             cy = this_screen->li * this_screen->VIO_font_height;

             co = this_screen->co; li = this_screen->li;

             /* Recalculate some stuff that was done in input.c previously */
	     this_screen->input_line = this_screen->li-1;

	     this_screen->input_zone_len = this_screen->co - (WIDTH * 2);
	     if (this_screen->input_zone_len < 10)
		  this_screen->input_zone_len = 10;		/* Take that! */

             this_screen->input_start_zone = WIDTH;
	     this_screen->input_end_zone = this_screen->co - WIDTH;
}

MRESULT EXPENTRY GenericWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

 HPS   hps;
 int tmp, statusstart;
 SHORT x, y, i;
 SWP winpos, swp, menupos;
 RECTL rcl;
 char *Reason;
 HVPS hvps;
 Screen *this_screen = NULL;
 Window *this_window = NULL;
 Window *tmpwind;
 PMYWINDATA wd;
 static int sx, sy, tx, ty, _sx, _sy, _tx = 0, _ty = 0;
 static int marking = 0;
 static unsigned char *scr = NULL, *mark = NULL, *clipdata = NULL;
 ULONG len, cliplen;
 POINTS pts;
 POINTL ptl;
 PVOID textdata;
 static int copying = 0; /* copy */
 static PVOID shared;
 TRACKINFO ti;
 APIRET rc;
 ULONG flOptions, mouselen=1, paramlen=0;
 char mousemask, *selectionbuffer;
 MRESULT mr;
 ULONG pcount;
 VIOCURSORINFO bleah;

 wd = (PMYWINDATA)WinQueryWindowPtr(hwnd, QWP_USER);
 if (!wd)
  wd = (PMYWINDATA)WinQueryWindowPtr(WinWindowFromID(hwnd, FID_CLIENT), QWP_USER);

 if (wd)
  {
   hvps = wd->hvps;
   this_screen = wd->screen;
   if (!this_screen) { wd->screen = main_screen; this_screen = wd->screen; }
  }
 
 switch (msg) {
    case WM_DESTROY:
     if (wd) free(wd);
     break;
	/* rosmo's awesome copy functions ---------------------------------- */
	case WM_BUTTON1MOTIONSTART:
	  WinQueryPointerPos(HWND_DESKTOP, &ptl);
	  WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptl, 1);

	  WinQueryWindowPos(hwnd, &swp);
      ti.rclTrack.xLeft   = ti.rclTrack.xRight = (int)(((int)(ptl.x/VIO_font_width))*VIO_font_width) + 2;
      ti.rclTrack.yBottom = ti.rclTrack.yTop   = (int)(((int)(ptl.y/VIO_font_height)+1)*VIO_font_height) + 2;
	  ti.rclTrack.xLeft--;
	  ti.rclTrack.yBottom--;

	  WinQueryWindowRect(hwnd, &ti.rclBoundary);
	  ti.cxBorder	= ti.cyBorder = 2;
	  ti.cxGrid 	= VIO_font_width;
	  ti.cyGrid 	= VIO_font_height;
	  ti.cxKeyboard = 1;
	  ti.cyKeyboard = 1;
	  ti.ptlMinTrackSize.x = 0;
	  ti.ptlMinTrackSize.y = 0;
	  ti.ptlMaxTrackSize.x = swp.cx;
	  ti.ptlMaxTrackSize.y = swp.cx;
	  ti.fs = TF_BOTTOM | TF_RIGHT | TF_GRID;

        /* Allocate a buffer to store the entire screen so it won't change
           during selection - NuKe */

        selectionbuffer = new_malloc((this_screen->li * this_screen->co) + 1);

        for(i=0;i<this_screen->li;i++)
              VioReadCharStr(&selectionbuffer[i*this_screen->co], (PUSHORT)&this_screen->co, i, 0, hvps);

	  if (WinTrackRect(hwnd, NULLHANDLE, &ti))
	   {
        sx = (int)(ti.rclTrack.xLeft/VIO_font_width);
        ty = this_screen->li - (int)(ti.rclTrack.yBottom/VIO_font_height);
        tx = (int)(ti.rclTrack.xRight/VIO_font_width);
        sy = this_screen->li - (int)(ti.rclTrack.yTop/VIO_font_height);

        mark = new_malloc((ty - sy) * (tx - sx + 2) + 1); i = 0;
        for (y = sy; y < ty; y++)
          {
           len = tx - sx;
           memcpy(&mark[i], &selectionbuffer[(y * this_screen->co) + sx], len);
           /* VioReadCharStr(&mark[i], &len, y, sx, hvps);*/
           i += len - 1;
           mark[i + 1] = '\r';
           mark[i + 2] = '\n';
           i += 2;
          }

        mark[i] = '\0';

/*        debug = fopen("debug", "at");
        fprintf(debug, "[%s]\n", mark);
        fclose(debug);*/

        /* Ok, we got the stuff - now place it in the clipboard */
        WinOpenClipbrd(hab); /* Open clipboard */
        WinEmptyClipbrd(hab); /* Empty clipboard */

        /* Ok, clipboard wants giveable unnamed shared memory */

        shared = NULL;
        rc = DosAllocSharedMem(&shared,
                               NULL,
                               i,
                               OBJ_GIVEABLE | PAG_COMMIT | PAG_READ | PAG_WRITE);

        if (rc == 0)
         {
          memcpy(shared, mark, i);

          WinSetClipbrdData(hab,
                            (ULONG)shared,
                            CF_TEXT,
                            CFI_POINTER);
         }

        WinCloseClipbrd(hab); /* Close clipboard */

        new_free(&selectionbuffer);
        new_free(&mark);
       }
	 break;
    case WM_SETFOCUS:
        if (SHORT1FROMMP(mp2)==TRUE)
         {
          if(this_screen && this_screen->current_window)
             {
             write(guiipc[1], "3", 1);
             write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
             }
         }
         else
         {
           if(this_screen)
              {
               VioGetCurType(&bleah, this_screen->hvps);
               bleah.attr = -1;
               VioSetCurType(&bleah, this_screen->hvps);
              }
         }
	  break;
        case WM_COMMAND:
            menucmd=COMMANDMSG(&msg)->cmd;
            write(guiipc[1], "2", 1);
            write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
	    return((MRESULT)0);
	    break;
	case WM_CLOSE:
#ifdef WINDOW_CREATE
               kill_screen(this_screen);
#else
               irc_exit(1, "PMBitchX rocks your world!", NULL);
#endif
            break;
         case WM_PAINT:
            hps = WinBeginPaint(hwnd, hvps, NULL);
            if (this_screen)
             {
                VioShowPS(this_screen->li+1,
                         this_screen->co+1,
						 0,
						 hvps);
             }
	     WinEndPaint(hps);
	     return (0L);
	 case WM_CHAR:

		if((SHORT1FROMMP(mp1) & KC_KEYUP)) break;
                 if(strlen(this_screen->aviokbdbuffer)==254) {
					DosBeep(1000, 200);
				 } else {
				if(SHORT1FROMMP(mp2) != 0) {
                   tmp=strlen(this_screen->aviokbdbuffer);
                   if (CHAR1FROMMP(mp2) == 224) {
                      this_screen->aviokbdbuffer[tmp]=0xFF;
                      this_screen->aviokbdbuffer[tmp+1]=CHAR2FROMMP(mp2);
                      this_screen->aviokbdbuffer[tmp+2]=0;
                   } else {
                      if ((SHORT1FROMMP(mp1) & KC_CTRL) && (SHORT1FROMMP(mp2) > 96) && (SHORT1FROMMP(mp2) < 122)) 
                         this_screen->aviokbdbuffer[tmp]=SHORT1FROMMP(mp2)-96;
                      else
                         this_screen->aviokbdbuffer[tmp]=SHORT1FROMMP(mp2);
                      this_screen->aviokbdbuffer[tmp+1]=0;
                   }
		 }
              }
            /* Force select() to exit */
            write(guiipc[1], "1 ", 2);
            break;
         case WM_CONTEXTMENU:
            contextx=SHORT1FROMMP(mp1);contexty=SHORT2FROMMP(mp1);
 	    WinQueryPointerPos(HWND_DESKTOP, &ptl);
	    WinMapWindowPoints(HWND_DESKTOP, hwnd, &ptl, 1);
            lastclickrow=this_screen->li - ((int)(ptl.y/this_screen->VIO_font_height)) - 1;
            lastclickcol=((int)(ptl.x/this_screen->VIO_font_width));
            if(lastclicklinedata != NULL)
               VioReadCharStr((PCH)lastclicklinedata,(PUSHORT)&this_screen->co,lastclickrow,0,hvps);
            last_input_screen=output_screen=this_screen;
            make_window_current(this_screen->current_window);
            statusstart=this_screen->li - 2;

            /* I was hoping there was an easier way but....I gave up */

            if(this_screen->window_list_end->status_lines == 0 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 1)
               statusstart=statusstart-1;
            if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 0 && this_screen->window_list_end->status_split == 0)
               statusstart=statusstart-1;
            if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 1)
               statusstart=statusstart-1;
            if(this_screen->window_list_end->status_lines == 1 && this_screen->window_list_end->double_status == 1 && this_screen->window_list_end->status_split == 0)
               statusstart=statusstart-2;
            if(lastclickrow <= (current_window->screen->li - 2) && lastclickrow >= statusstart)
               wm_process(STATUSRCLICK);
            else
               wm_process(RCLICK);
            break;
         case WM_VSCROLL:
             switch(SHORT2FROMMP(mp2))
             {
             case SB_LINEUP:
                write(guiipc[1], "6", 1);
                write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
                break;
             case SB_LINEDOWN:
                write(guiipc[1], "7", 1);
                write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
                break;
             case SB_PAGEUP:
                write(guiipc[1], "8", 1);
                write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
                break;
             case SB_PAGEDOWN:
                write(guiipc[1], "9", 1);
                write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
                break;
             case SB_SLIDERTRACK:
                newscrollerpos=SHORT1FROMMP(mp2);
                if(newscrollerpos<0)
                   newscrollerpos=0;
                if(newscrollerpos>get_int_var(SCROLLBACK_VAR))
                   newscrollerpos=get_int_var(SCROLLBACK_VAR);
                write(guiipc[1], "5", 1);
                write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
                break;
             }
             break;
        case WM_USER:
             dont_resize=1;
             if(this_screen->hwndMenu==(HWND)NULL)
                {
	        WinSetWindowPos(this_screen->hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + 1, SWP_SIZE);
                }
             else
                {
                WinQueryWindowPos(this_screen->hwndMenu, &menupos);
                if(menupos.cy<3)
		   WinSetWindowPos(this_screen->hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + WinQuerySysValue(HWND_DESKTOP, SV_CYMENU), SWP_SIZE);
                else
		   WinSetWindowPos(this_screen->hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + menupos.cy, SWP_SIZE);
                }
             write(guiipc[1], "4", 1);
             write(guiipc[1], (char *)&this_screen->current_window->refnum, 1);
             break;
          case WM_USER+1:
             dont_resize=1;
             window_menu_stub();
             break;
          case WM_USER+2:
#ifdef WINDOW_CREATE
	    if ((tmpwind = (Window *)create_additional_screen()))
	        {
                pm_resize(tmpwind->screen);
        	refresh_window_screen(tmpwind);
		output_screen = last_input_screen = tmpwind->screen;
		make_window_current(tmpwind);
                WCWindow = tmpwind;
	        }
             else
#endif
                say("Cannot create new screen!");
             DosPostEventSem(hgenev);
             break;
          case 0x041e:
             if(just_resized == 1 && this_screen == just_resized_screen)
                {
                WinPostMsg(hwnd, WM_USER, 0, 0);
                just_resized=0;
                }
             break;
          case 0x041f:
             if(just_resized == 1 && this_screen == just_resized_screen)
                {
                WinPostMsg(hwnd, WM_USER, 0, 0);
                just_resized=0;
                }
             break;
          case WM_MINMAXFRAME:
             dont_resize=1;
             WinPostMsg(hwnd, WM_USER, 0, 0);
             break;
	case WM_SIZE:
             if (!this_screen) return((MRESULT)0);

	     x=SHORT1FROMMP(mp2); y=SHORT2FROMMP(mp2);
	     if(x != 0 && y != 0) {
             this_screen->old_co = this_screen->co=((int)(x/this_screen->VIO_font_width));
             this_screen->old_li = this_screen->li=((int)(y/this_screen->VIO_font_height));

             pm_resize(this_screen);

             recalculate_windows(this_screen);
             make_window_current(this_screen->current_window);
             if(dont_resize == 1)
                dont_resize = 0;
             else
                {
                just_resized_screen=this_screen;
                just_resized=1;
                }
             }
         return WinDefAVioWindowProc(hwnd, msg, (ULONG)mp1, (ULONG)mp2);
         break;
      }
 return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

void avio_exit(void) {
	VioAssociate((HDC)NULL, (output_screen ? output_screen->hvps : hvps));		/* disassociates the AVIO PS */
	VioDestroyPS((output_screen ? output_screen->hvps : hvps)); 				/* destroys the AVIO PS 	 */
	WinDestroyWindow(hwndFrame);
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	DosCloseMutexSem(mutex);
        DosCloseEventSem(hgenev);
	DosExit(EXIT_PROCESS, 0);
}

void avio_init() {

   HEV	 mySem = sem;
   SWP winpos, menupos;
   PMYWINDATA mywindata;

   ULONG flStyle = FCF_MINMAX | FCF_SYSMENU | FCF_TITLEBAR |
			  FCF_SIZEBORDER | FCF_SHELLPOSITION | FCF_TASKLIST | FCF_ICON | FCF_VERTSCROLL;

   DosOpenEventSem(NULL, (PHEV)&mySem);

   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);

		if (!WinRegisterClass(hab, "AVIO",
            GenericWndProc, CS_SIZEREDRAW, 32))
		DosExit(EXIT_PROCESS, 1);

	hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
								   WS_VISIBLE,
								   &flStyle,
								   "AVIO",
								   irc_version,
								   0L,
								   NULLHANDLE,
								   IDM_MAINMENU,
								   &hwndClient);

        hwndMenu=(HWND)NULL;

        co = 81; li = 25;
		cx = (co-1) * VIO_font_width;
		cy = li * VIO_font_height;
                if(hwndMenu==0)
		   WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR), SWP_SIZE);
                else
                   {
                   WinQueryWindowPos(hwndMenu, &menupos);
		   WinSetWindowPos(hwndFrame, HWND_TOP, 0, 0, cx + (WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + menupos.cy, SWP_SIZE);
                   }

	hdc = WinOpenWindowDC(hwndClient);									  /* opens device context */
	VioCreatePS(&hvps, VIO_staticy, VIO_staticx, 1, 					  /* creates AVIO PS */
				1, 0);
        VioAssociate(hdc, hvps);

              VIO_font_width=6;VIO_font_height=10;

		VioSetDeviceCellSize(VIO_font_height, VIO_font_width, hvps);			  /* Set the font size */
		VioGetBuf(&scrbuf, (PUSHORT)&scrlen, hvps);

		DosPostEventSem(mySem);
		DosCloseEventSem(mySem);

        WinSendMsg(WinWindowFromID(hwndFrame, FID_VERTSCROLL), SBM_SETSCROLLBAR, (MPARAM)get_int_var(SCROLLBACK_VAR), MPFROM2SHORT(0, get_int_var(SCROLLBACK_VAR)));

/* rosmo */
		DosCreateMutexSem(NULL, &mutex, 0, FALSE);

/* rosmo loves mutexes nowadays */
		DosCreateMutexSem("\\SEM32\\BITCHX_OWNS_ME", &screenMutex, DC_SEM_SHARED, FALSE);

        lastclicklinedata = new_malloc(500);

        mywindata = malloc(sizeof(MYWINDATA));
        memset(mywindata, '\0', sizeof(MYWINDATA));
        mywindata->hvps  = hvps;
        mywindata->screen = NULL;
        WinSetWindowPtr(hwndClient, QWP_USER, mywindata);

        DosCreateEventSem("\\SEM32\\BITCHX_GEN_EVENT_SEM", &hgenev, DC_SEM_SHARED, TRUE);

		while (WinGetMsg(hab, &qmsg, (HWND)NULL, 0, 0))
			 WinDispatchMsg(hab, &qmsg);

}

void load_default_font(Screen *font_screen)
{
        char *fontsize, *height, *width;
        int t, cy, cx;
        SWP     menupos;

        if((fontsize=get_string_var(DEFAULT_FONT_VAR))!=NULL)
           {
           width=new_malloc(10);
           strcpy(width, fontsize);
           t=0;
           while(width[t]!='x' && t<9)
              t++;
           height=&width[t+1];
           width[t]=0;
           VIO_font_width=atoi(width);
           VIO_font_height=atoi(height);
           new_free(&width);
           if (VIO_font_width < 6 || VIO_font_height < 8) 
              {
              VIO_font_width=6;VIO_font_height=10;
              }
           }
        else
           {
              VIO_font_width=6;VIO_font_height=10;
           }

        font_screen->VIO_font_width=VIO_font_width;
        font_screen->VIO_font_height=VIO_font_height;
        
     if(VIO_font_width != 6 || VIO_font_height != 10)
        {
        cx = (font_screen->co - 1) * font_screen->VIO_font_width;
        cy = font_screen->li * font_screen->VIO_font_height;

	VioSetDeviceCellSize(font_screen->VIO_font_height, font_screen->VIO_font_width, font_screen->hvps);			  /* Set the font size */
        if(font_screen->hwndMenu==(HWND)NULL)
              WinSetWindowPos(font_screen->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)+1, cy+(WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR), SWP_SIZE);
           else
              {
              WinQueryWindowPos(font_screen->hwndMenu, &menupos);
              WinSetWindowPos(font_screen->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)+1, cy+(WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR)+menupos.cy, SWP_SIZE);
              }
        }
}

/* Individual Page Procs */
MRESULT	EXPENTRY NotebookPage1DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
char szBuffer[1024];		   /* String Buffer			*/
int i;
char *ptr;

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	WinSetDlgItemText(hWnd,	EF_ENTRY1, "");
        p1e=LIT_NONE;
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
      switch(SHORT1FROMMP(mp1))
        {
        case SETS1:
        if(p1e!=LIT_NONE)
           {
           switch(return_irc_var(p1e)->type) 
              {
           case BOOL_TYPE_VAR:
              i = (ULONG)WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),
							  BM_QUERYCHECK,
							  0,
							  0);
              set_int_var(p1e, i);
              break;
           case CHAR_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
              set_string_var(p1e, szBuffer);
              break; 
           case STR_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
              set_string_var(p1e, szBuffer);
              break;
           case INT_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
              set_int_var(p1e, my_atol((char *)&szBuffer));
              break;
              }
           }
        p1e = (ULONG)WinSendMsg(WinWindowFromID(hWnd, SETS1),
							  LM_QUERYSELECTION,
							  MPFROMSHORT(LIT_CURSOR),
							  0);
        if(p1e!=LIT_NONE)
           {
           switch(return_irc_var(p1e)->type) 
              {
           case BOOL_TYPE_VAR:
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF1), TRUE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY1), FALSE);
              i = get_int_var(p1e);
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),BM_SETCHECK,MPFROMSHORT(i),0);
  	      WinSetDlgItemText(hWnd,	EF_ENTRY1, "");
              break;
           case INT_TYPE_VAR:
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF1), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY1), TRUE);
              sprintf(szBuffer, "%d", get_int_var(p1e));
  	      WinSetDlgItemText(hWnd,	EF_ENTRY1, szBuffer);
              break;
           case STR_TYPE_VAR: 
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF1), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY1), TRUE);
              ptr=get_string_var(p1e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY1, szBuffer);
              break;
           case CHAR_TYPE_VAR: 
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF1), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY1), TRUE);
              ptr = get_string_var(p1e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY1, szBuffer);
              break;
              }
           }
        break;
     case CB_ONOFF1:
        if(WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),BM_QUERYCHECK,0,0))
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),BM_SETCHECK,MPFROMSHORT(0),0);
        else
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),BM_SETCHECK,MPFROMSHORT(1),0);
        break;
        }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
               if(p1e!=LIT_NONE)
               {
               switch(return_irc_var(p1e)->type) 
                 {
                 case BOOL_TYPE_VAR:
                    i = (ULONG)WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF1),BM_QUERYCHECK,0,0);
                    set_int_var(p1e, i);
                    break;
                 case CHAR_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
                    set_string_var(p1e, szBuffer);
                    break;
                 case STR_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
                    set_string_var(p1e, szBuffer);
                    break;
                 case INT_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY1,	1024L, szBuffer);
                    set_int_var(p1e, my_atol((char *)&szBuffer));
                     break;
                 }
               }
	       break;
	    }
        
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}

MRESULT	EXPENTRY NotebookPage2DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
char szBuffer[1024];		   /* String Buffer			*/
int i;
char *ptr;

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	WinSetDlgItemText(hWnd,	EF_ENTRY2, "");
        if(nb_window && nb_window->current_channel)
	   chan = (ChannelList *) find_in_list((List **)&(server_list[from_server].chan_list), nb_window->current_channel, 0);
        else 
           chan = NULL;
        p2e=LIT_NONE;
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
      switch(SHORT1FROMMP(mp1))
        {
        case SETS2:
        if(p2e!=LIT_NONE && chan)
           {
           switch(return_cset_var(p2e)->type) 
              {
           case BOOL_TYPE_VAR:
              i = (ULONG)WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),
							  BM_QUERYCHECK,
							  0,
							  0);
              set_cset_int_var(chan->csets, p2e, i);
              break;
           case CHAR_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
              set_cset_str_var(chan->csets, p2e, szBuffer);
              break; 
           case STR_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
              set_cset_str_var(chan->csets, p2e, szBuffer);
              break;
           case INT_TYPE_VAR:
              WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
              set_cset_int_var(chan->csets, p2e, my_atol((char *)&szBuffer));
              break;
              }
           }
        p2e = (ULONG)WinSendMsg(WinWindowFromID(hWnd, SETS2),
							  LM_QUERYSELECTION,
							  MPFROMSHORT(LIT_CURSOR),
							  0);
        if(p2e!=LIT_NONE && chan)
           {
           switch(return_cset_var(p2e)->type) 
              {
           case BOOL_TYPE_VAR:
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF2), TRUE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY2), FALSE);
              i = get_cset_int_var(chan->csets, p2e);
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),
							  BM_SETCHECK,
							  MPFROMSHORT(i),
							  0);
  	      WinSetDlgItemText(hWnd,	EF_ENTRY2, empty_string);
              break;
           case INT_TYPE_VAR:
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF2), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY2), TRUE);
              sprintf(szBuffer, "%d", get_cset_int_var(chan->csets, p2e));
  	      WinSetDlgItemText(hWnd,	EF_ENTRY2, szBuffer);
              break;
           case STR_TYPE_VAR: 
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF2), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY2), TRUE);
              ptr=get_cset_str_var(chan->csets, p2e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY2, szBuffer);
              break;
           case CHAR_TYPE_VAR: 
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF2), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY2), TRUE);
              ptr = get_cset_str_var(chan->csets, p2e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY2, szBuffer);
              break;
              }
           }
         break;
     case CB_ONOFF2:
        if(WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),BM_QUERYCHECK,0,0))
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),BM_SETCHECK,MPFROMSHORT(0),0);
        else
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),BM_SETCHECK,MPFROMSHORT(1),0);
        break;
        }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
               if(p2e!=LIT_NONE && chan)
               {
               switch(return_cset_var(p2e)->type) 
                 {
                 case BOOL_TYPE_VAR:
                    i = (ULONG)WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF2),
							  BM_QUERYCHECK,
							  0,
							  0);
                    set_cset_int_var(chan->csets, p2e, i);
                    break;
                 case CHAR_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
                    set_cset_str_var(chan->csets, p2e, szBuffer);
                    break;
                 case STR_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
                    set_cset_str_var(chan->csets, p2e, szBuffer);
                    break;
                 case INT_TYPE_VAR:
                    WinQueryDlgItemText(hWnd, EF_ENTRY2,	1024L, szBuffer);
                    set_cset_int_var(chan->csets, p2e, my_atol((char *)&szBuffer));
                     break;
                 }
               }
	       break;
	    }
        
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}

MRESULT	EXPENTRY NotebookPage3DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
char szBuffer[1024];		   /* String Buffer			*/
int i;
char *ptr;

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	WinSetDlgItemText(hWnd,	EF_ENTRY3, empty_string);
        p3e=LIT_NONE;
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
      switch(SHORT1FROMMP(mp1))
        {
        case SETS3:
        if(p3e!=LIT_NONE)
           {
              WinQueryDlgItemText(hWnd, EF_ENTRY3,	1024L, szBuffer);
              fset_string_var(p3e, szBuffer);
           }
        p3e = (ULONG)WinSendMsg(WinWindowFromID(hWnd, SETS3),
							  LM_QUERYSELECTION,
							  MPFROMSHORT(LIT_CURSOR),
							  0);
        if(p3e!=LIT_NONE)
           {
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF3), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY3), TRUE);
              ptr=fget_string_var(p3e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY3, szBuffer);
           }
         break;
     /*case CB_ONOFF3:
        if(WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF3),BM_QUERYCHECK,0,0))
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF3),BM_SETCHECK,MPFROMSHORT(0),0);
        else
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF3),BM_SETCHECK,MPFROMSHORT(1),0);
        break;*/
        }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
               if(p3e!=LIT_NONE)
               {
                    WinQueryDlgItemText(hWnd, EF_ENTRY3,	1024L, szBuffer);
                    fset_string_var(p3e, szBuffer);
               }
	       break;
	    }
        
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}

MRESULT	EXPENTRY NotebookPage4DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
char szBuffer[1024];		   /* String Buffer			*/
int i;
char *ptr;

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	WinSetDlgItemText(hWnd,	EF_ENTRY4, empty_string);
        p4e=LIT_NONE;
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
      switch(SHORT1FROMMP(mp1))
        {
        case SETS4:
        if(p4e!=LIT_NONE && nb_window)
           {
              WinQueryDlgItemText(hWnd, EF_ENTRY4,	1024L, szBuffer);
              set_wset_string_var(nb_window->wset, p4e, szBuffer);
           }
        p4e = (ULONG)WinSendMsg(WinWindowFromID(hWnd, SETS4),
							  LM_QUERYSELECTION,
							  MPFROMSHORT(LIT_CURSOR),
							  0);
        if(p4e!=LIT_NONE && nb_window)
           {
              WinEnableWindow(WinWindowFromID(hWnd, CB_ONOFF4), FALSE);
              WinEnableWindow(WinWindowFromID(hWnd, EF_ENTRY4), TRUE);
              ptr=get_wset_string_var(nb_window->wset, p4e);
              if(ptr && *ptr)
                 strcpy(szBuffer, ptr);
              else
                 strcpy(szBuffer, empty_string);
   	      WinSetDlgItemText(hWnd,	EF_ENTRY4, szBuffer);
           }
         break;
     /*case CB_ONOFF4:
        if(WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF4),BM_QUERYCHECK,0,0))
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF4),BM_SETCHECK,MPFROMSHORT(0),0);
        else
              WinSendMsg(WinWindowFromID(hWnd, CB_ONOFF4),BM_SETCHECK,MPFROMSHORT(1),0);
        break;*/
        }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
               if(p4e!=LIT_NONE && nb_window)
               {
                    WinQueryDlgItemText(hWnd, EF_ENTRY4,	1024L, szBuffer);
                    set_wset_string_var(nb_window->wset, p4e, szBuffer);
               }
	       break;
	    }
        
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}



MRESULT	EXPENTRY NotebookPage5DlgProc(HWND hWnd, ULONG msg, MPARAM mp1,	MPARAM mp2)

{
CHAR szBuffer[32];		   /* String Buffer			*/

switch ( msg )
   {
   case	WM_CHAR	:
	break;
			/* Perform dialog initialization		*/
   case	WM_INITDLG :
	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
	       break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}




MRESULT	EXPENTRY NotebookDlgProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)

{
HPS   hPS;			   /* Temporary	Presentation Space	*/
HWND  hwndNBK;			   /* Notebook Window Handle		*/
PVOID ppb;			   /* Dialogue Template	Pointer		*/
RECTL rcl;			   /* Rectangle	Holder			*/
ULONG ulPageID;			   /* Inserted Page ID			*/
int t;
HWND tmp;
char szBuffer[200];

switch ( msg )
   {
			/* Perform dialog initialization		*/
   case	WM_INITDLG :

       inproperties=1;

       nb_window=current_window;

       GpiQueryFontMetrics(hPS = WinGetPS(hWnd), sizeof(FONTMETRICS), &fm);

       if(nb_window->current_channel)
          sprintf(szBuffer, "PMBitchX Properties for %s", nb_window->current_channel);
       else
          strcpy(szBuffer, "PMBitchX Properties");

       hwndNBK = WinWindowFromID(hWnd, ID_PROP);
       
       WinSetWindowText(WinWindowFromID(hWnd, FID_TITLEBAR), szBuffer);

       /* Page 1 - Sets */

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 1 of 5"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~Sets"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBKP_SETS1, (PPVOID)&ppb);
       hwndPage1 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage1DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage1));

       /* Page 2 - Csets */

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 2 of 5"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~Csets"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBKP_SETS2, (PPVOID)&ppb);
       hwndPage2 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage2DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage2));

       /* Page 3 - Fsets */

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 3 of 5"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~Fsets"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBKP_SETS3, (PPVOID)&ppb);
       hwndPage3 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage3DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage3));

       /* Page 4 - Wsets */

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 4 of 5"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~Wsets"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBKP_SETS4, (PPVOID)&ppb);
       hwndPage4 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage4DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage4));

       /* Page 5 - OS/2 Settings */

       ulPageID	= (ULONG)WinSendMsg(hwndNBK, BKM_INSERTPAGE, 0L,
				    MPFROM2SHORT((BKA_STATUSTEXTON | BKA_AUTOPAGESIZE |	BKA_MAJOR), BKA_LAST));

       WinSendMsg(hwndNBK, BKM_SETSTATUSLINETEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("Page 5 of 5"));

       WinSendMsg(hwndNBK, BKM_SETTABTEXT,
		  MPFROMLONG(ulPageID),	MPFROMP("~OS/2 Settings"));

       DosGetResource((HMODULE)NULL, RT_DIALOG,	NBKP_OSSETTINGS, (PPVOID)&ppb);
       hwndPage5 = WinCreateDlg(HWND_DESKTOP, (HWND)NULL, (PFNWP)NotebookPage4DlgProc,
			       (PDLGTEMPLATE)ppb, NULL);
       DosFreeResource((PVOID)ppb);
       WinSendMsg(hwndNBK, BKM_SETPAGEWINDOWHWND,
		  MPFROMLONG(ulPageID),	MPFROMHWND(hwndPage5));

       rcl.xLeft = rcl.yBottom = 0L;
       rcl.xRight = rcl.yTop = 400L;

       WinDrawText(hPS = WinGetPS(hWnd), -1, " Second Page ", &rcl, CLR_BLACK, CLR_BLACK,
		   DT_LEFT | DT_BOTTOM | DT_QUERYEXTENT);
       WinReleasePS(hPS);
       WinSendMsg(hwndNBK, BKM_SETDIMENSIONS,
		  MPFROM2SHORT((SHORT)(rcl.xRight - rcl.xLeft),	(SHORT)(fm.lMaxBaselineExt * 2)),
		  MPFROMSHORT(BKA_MAJORTAB));

		       /* Set the dimension of the notebook buttons	*/

       WinSendMsg(hwndNBK, BKM_SETDIMENSIONS, MPFROM2SHORT(21, 21),
		  MPFROMLONG(BKA_PAGEBUTTON));

		       /* Set the background colours to	that of	the	*/
		       /* dialogue					*/

       WinSendMsg(hwndNBK, BKM_SETNOTEBOOKCOLORS, MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
		  MPFROMLONG(BKA_BACKGROUNDPAGECOLORINDEX));
       WinSendMsg(hwndNBK, BKM_SETNOTEBOOKCOLORS, MPFROMLONG(SYSCLR_DIALOGBACKGROUND),
		  MPFROMLONG(BKA_BACKGROUNDMAJORCOLORINDEX));

        for(t=0; t<NUMBER_OF_VARIABLES; t++)
           {
	   WinSendMsg(WinWindowFromID(hwndPage1, SETS1),
				 LM_INSERTITEM,
				 MPFROMSHORT(LIT_END),
				 MPFROMP(return_irc_var(t)->name));
           }

        for(t=0; t<NUMBER_OF_CSETS; t++)
           {
	   WinSendMsg(WinWindowFromID(hwndPage2, SETS2),
				 LM_INSERTITEM,
				 MPFROMSHORT(LIT_END),
				 MPFROMP(return_cset_var(t)->name));
           }

        for(t=0; t<NUMBER_OF_FSET; t++)
           {
	   WinSendMsg(WinWindowFromID(hwndPage3, SETS3),
				 LM_INSERTITEM,
				 MPFROMSHORT(LIT_END),
				 MPFROMP(return_fset_var(t)->name));
           }

        for(t=0; t<NUMBER_OF_WSETS; t++)
           {
	   WinSendMsg(WinWindowFromID(hwndPage4, SETS4),
				 LM_INSERTITEM,
				 MPFROMSHORT(LIT_END),
				 MPFROMP(return_wset_var(t)->name));
           }

	break;
			/* Process control selections			*/
   case	WM_CONTROL :
	switch ( SHORT2FROMMP(mp1) )
	    {
	    }
	break;
			/* Process push	button selections		*/
   case	WM_COMMAND :
	switch ( SHORT1FROMMP(mp1) )
	    {
	    case DID_OK	:
		WinSendMsg(hwndPage1, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
		WinSendMsg(hwndPage2, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
		WinSendMsg(hwndPage3, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
		WinSendMsg(hwndPage4, WM_COMMAND,
			   MPFROMLONG(DID_OK), MPFROMLONG(CMDSRC_OTHER));
                inproperties=0;
		WinDismissDlg(hWnd, TRUE);
		break;
	    }
	break;
			/* Close requested, exit dialogue		*/
   case	WM_CLOSE :
        inproperties=0;
	WinDismissDlg(hWnd, FALSE);
	break;

			/* Pass	through	unhandled messages		*/
   default :
       return(WinDefDlgProc(hWnd, msg, mp1, mp2));
   }
return(0L);
}

void properties_notebook(void)
{
HAB hnbab;
HMQ hnbmq;

 hnbab = WinInitialize(0);
 hnbmq = WinCreateMsgQueue(hnbab, 0);
 if(inproperties==0)
    WinDlgBox(HWND_DESKTOP, HWND_DESKTOP, NotebookDlgProc, NULLHANDLE, PROPNBK, NULL);

 WinDestroyMsgQueue(hnbmq);
 WinTerminate(hnbab);
}

void msgbox(void)
{
HAB hmbab;
HMQ hmbmq;

 hmbab = WinInitialize(0);
 hmbmq = WinCreateMsgQueue(hmbab, 0);

 WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msgtext, "PMBitchX", 0, MB_OK | MB_INFORMATION | MB_MOVEABLE);
 
 new_free(&msgtext);
			     
 WinDestroyMsgQueue(hmbmq);
 WinTerminate(hmbab);
}

void pm_clrscr(Screen *tmp)
{
VioScrollUp(0, 0, -1, -1, -1, (PBYTE)&default_pair, tmp->hvps);
}


void PM_Init(void)
{
        char *fontsize, *height, *width;
        int t, cy, cx;
        SWP     menupos;

        if((fontsize=get_string_var(DEFAULT_FONT_VAR))!=NULL)
           {
           width=new_malloc(10);
           strcpy(width, fontsize);
           t=0;
           while(width[t]!='x' && t<9)
              t++;
           height=&width[t+1];
           width[t]=0;
           VIO_font_width=atoi(width);
           VIO_font_height=atoi(height);
           new_free(&width);
           if (VIO_font_width < 6 || VIO_font_height < 8) 
              {
              VIO_font_width=6;VIO_font_height=10;
              }
           }
        else
           {
              VIO_font_width=6;VIO_font_height=10;
           }

        main_screen->VIO_font_width=VIO_font_width;
        main_screen->VIO_font_height=VIO_font_height;
        
     if(VIO_font_width != 6 || VIO_font_height != 10)
        {
        cx = (main_screen->co - 1) * main_screen->VIO_font_width;
        cy = main_screen->li * main_screen->VIO_font_height;

	VioSetDeviceCellSize(main_screen->VIO_font_height, main_screen->VIO_font_width, main_screen->hvps);			  /* Set the font size */
        if(main_screen->hwndMenu==(HWND)NULL)
              WinSetWindowPos(main_screen->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)+1, cy+(WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR), SWP_SIZE);
           else
              {
              WinQueryWindowPos(main_screen->hwndMenu, &menupos);
              WinSetWindowPos(main_screen->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2)+1, cy+(WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR)+menupos.cy, SWP_SIZE);
              }
        DosSleep(1000);
        }
/*        if(get_int_var(SCROLLERBARS_VAR))
           {
              WinCreateWindow(main_screen->hwndClient, WC_SCROLLBAR, (PSZ)NULL, SBS_VERT | WS_VISIBLE, */
}

/* This section is for portability considerations */
void gui_init(void)
{
	/* Create an unnamed semaphore */
	DosCreateEventSem(NULL,
					  (PHEV)&sem,
					  DC_SEM_SHARED,
					  FALSE);

	TI_lines = 25;
	TI_cols = 80;
	li = TI_lines;
	co = TI_cols;

	_beginthread((void *)avio_init, NULL, (4*0xFFFF), main_screen );
        _beginthread((void *)flush_thread, NULL, 0xFFFF, &hvps);
        _beginthread((void *)cursor_thread, NULL, 0xFFFF, NULL);

	DosWaitEventSem(sem, SEM_INDEFINITE_WAIT);
	DosCloseEventSem(sem);


	default_pair[0] = ' ';
	default_pair[1] = 7;
}

void gui_clreol(void)
{
USHORT row, col;
char *tmpbuf=NULL;

    aflush();
    VioGetCurPos((PUSHORT)&row, (PUSHORT)&col, output_screen ? output_screen->hvps : hvps);
    if((output_screen->co - col + 1) > 0)
       {
       tmpbuf=new_malloc(output_screen->co - col + 2);
       memset(tmpbuf, ' ', output_screen->co - col + 1);
       tmpbuf[output_screen->co - col + 1]=0;
       VioWrtTTY((PCH)tmpbuf, output_screen->co - col + 1, (output_screen ? output_screen->hvps : hvps));
       VioSetCurPos((USHORT)row, (USHORT)col, output_screen ? output_screen->hvps : hvps);
       new_free(&tmpbuf);
       }
}

void gui_gotoxy(int col, int row)
{
	aflush();
	VioSetCurPos((USHORT)row, (USHORT)col, output_screen ? output_screen->hvps : hvps);
}

void gui_clrscr(void)
{
	Screen *tmp;
	
	aflush();
	for (tmp = screen_list; tmp; tmp = tmp->next)
                pm_clrscr(tmp);
}

void gui_left(int num)
{
        unsigned int row,col;
        aflush();
        VioGetCurPos((PUSHORT)&row, (PUSHORT)&col, output_screen ? output_screen->hvps : hvps);
        if(col>num)
           col=col-num;
        else
           col=0;
	VioSetCurPos((USHORT)row, (USHORT)col, output_screen ? output_screen->hvps : hvps);
}

void gui_right(int num)
{
        unsigned int row,col;
        aflush();
        VioGetCurPos((PUSHORT)&row, (PUSHORT)&col, output_screen->hvps);
        if(output_screen->co > num)
           col=col+num;
        else
           col=output_screen->co;
	VioSetCurPos((USHORT)row, (USHORT)col, output_screen->hvps);
}

void gui_scroll(int top, int bot, int n)
{
	aflush();
	if (n > 0) VioScrollUp(top, 0, bot, output_screen->co, n, (PBYTE)&pair, output_screen->hvps);
	else if (n < 0) { n = -n; VioScrollDn(top, 0, bot, output_screen->co, n, (PBYTE)&pair, output_screen->hvps); }
	return;
}

void gui_flush(void)
{
	aflush();

}

void gui_puts(char *buffer)
{
		int i;
		for (i = 0; i < strlen(buffer); i++) aputc(buffer[i]);
		aputc('\n'); aputc('\r');
}

void gui_new_window(Screen *new, Window *win)
{
int	cx,
	cy;
ULONG	borderw,
	borderh,
	titleh,
	menuY;
HDC	hdc;
ULONG	flStyle = FCF_MINMAX | FCF_SYSMENU | FCF_TITLEBAR | FCF_SIZEBORDER | FCF_SHELLPOSITION | FCF_TASKLIST | FCF_ICON | FCF_VERTSCROLL;
HAB	hab;
HMQ	hmq;
ULONG	scrbuf, scrlen;
PMYWINDATA	windata;
MenuStruct *menutoadd;
char    *defmenu, *fontsize, *width, *height;
int     t;

	/* 
	 * maybe this should be a new_malloc() in case we want to delete it
	 * using new_free() later. if so then the memset() is not needed.
	 */
	windata = malloc(sizeof(MYWINDATA));
	memset(windata, '\0', sizeof(MYWINDATA));

	hab = WinInitialize(0);
	hmq = WinCreateMsgQueue(hab, 0);

	new->hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                     WS_VISIBLE,
                                     &flStyle,
                                     "AVIO",
                                     irc_version,
                                     0L,
                                     NULLHANDLE,
                                     IDM_MAINMENU,
                                     &new->hwndClient);

	WinSetWindowPtr(new->hwndClient, QWP_USER, NULL);


	if (main_screen)
	{
		new->co = main_screen->co; 
		new->li = main_screen->li;
	} 
	else 
	{ 
		new->co = 81; 
		new->li = 25;  
	}

	if (main_screen)
	{
		new->VIO_font_width  = main_screen->VIO_font_width;
		new->VIO_font_height = main_screen->VIO_font_height;
	} 
	else
	{
		new->VIO_font_width  = VIO_font_width;
		new->VIO_font_height = VIO_font_height;
	}

        /* Get the default font and set the new window with it */

           if((fontsize=get_string_var(DEFAULT_FONT_VAR))!=NULL)
              {
              width=new_malloc(10);
              strcpy(width, fontsize);
              t=0;
              while(width[t]!='x' && t<9)
                 t++;
              height=&width[t+1];
              width[t]=0;
              VIO_font_width=atoi(width);
              VIO_font_height=atoi(height);
              new_free(&width);
              if (VIO_font_width < 6 || VIO_font_height < 8)
                 {
                 VIO_font_width=6;VIO_font_height=10;
                 }
              }
           else
              {
              VIO_font_width=6;VIO_font_height=10;
              }

		new->VIO_font_width  = VIO_font_width;
		new->VIO_font_height = VIO_font_height;

        /* Get the default menu and add it to the new window */

        defmenu=get_string_var(DEFAULT_MENU_VAR);
	if(defmenu && *defmenu)
                {
                if((menutoadd = (MenuStruct *)findmenu(defmenu))==NULL)
                    say("Menu not found.");
                else if(menutoadd->menuorigin==NULL)
                    say("Cannot create blank menu.");
                else
                   {
                    new->hwndMenu=(HWND)newsubmenu((MenuStruct *)menutoadd, (HWND *)new->hwndFrame);
                    new->menu=m_strdup(defmenu);
                   }
                }
	else 
		new->hwndMenu=(HWND)NULL;

	cx = new->co * new->VIO_font_width;
	cy = new->li * new->VIO_font_height;
	
	if(new->hwndMenu==(HWND)NULL)
		WinSetWindowPos(new->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+ WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR), SWP_SIZE | SWP_ZORDER | SWP_ACTIVATE);
	else
		WinSetWindowPos(new->hwndFrame, HWND_TOP, 0, 0, cx+(WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER)*2) + WinQuerySysValue(HWND_DESKTOP, SV_CXVSCROLL), cy + (WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER)*2)+ WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR) + /*menupos.cy*/ WinQuerySysValue(HWND_DESKTOP, SV_CYMENU) + 1, SWP_SIZE | SWP_ZORDER | SWP_ACTIVATE);

	hdc = WinOpenWindowDC(new->hwndClient);

	/* VIO_staticx and VIO_staticy */
	VioCreatePS(&new->hvps, 100, 200, 1, 1, 0);
	VioAssociate(hdc, new->hvps);

	VioGetBuf((PULONG)&scrbuf, (PUSHORT)&scrlen, new->hvps);

	VioSetDeviceCellSize(new->VIO_font_height, new->VIO_font_width, new->hvps);

	windata->hvps   = new->hvps;
	windata->screen = new;
        WinSendMsg(WinWindowFromID(new->hwndFrame, FID_VERTSCROLL), SBM_SETSCROLLBAR, (MPARAM)get_int_var(SCROLLBACK_VAR), MPFROM2SHORT(0, get_int_var(SCROLLBACK_VAR)));
	WinSetWindowPtr(new->hwndClient, QWP_USER, windata);

}
                                                              
void gui_kill_window(Screen *killscreen)
{
	killscreen->hvps = 0;
	WinDestroyWindow(killscreen->hwndFrame);
}

void gui_msgbox(void)
{
            _beginthread((void *)msgbox, NULL, 0xFFFF, NULL);
}

void gui_popupmenu(char *menuname)
{
      if (contextmenu) 
         WinDestroyWindow(contextmenu);
      contextmenu=(HWND)menucreatestub(menuname, (HWND *)last_input_screen->hwndFrame);
      WinPopupMenu(last_input_screen->hwndFrame, last_input_screen->hwndFrame, contextmenu, contextx, contexty, 0, PU_KEYBOARD | PU_MOUSEBUTTON1 | PU_VCONSTRAIN | PU_HCONSTRAIN);
}

/* These are support routines for gui_file_dialog() */
MRESULT EXPENTRY FileFilterProc(HWND hwnd, ULONG message, MPARAM mp1, MPARAM mp2 )
{
	return WinDefFileDlgProc( hwnd, message, mp1, mp2 ) ;
} 

/* Ripped from functions.c because I couldn't get it to link from there */
char * fencode (unsigned char * input)
{
	char	*result;
	int	i = 0;

	result = (char *)new_malloc(strlen((char *)input) * 2 + 1);
	while (*input)
	{
		result[i++] = (*input >> 4) + 0x41;
		result[i++] = (*input & 0x0f) + 0x41;
		input++;
	}
	result[i] = '\0';

	return result;		/* DONT USE RETURN_STR HERE! */
}

void gui_file_dialog(char *type, char *path, char *title, char *ok, char *apply, char *code, char *szButton)
{
	char *params;
	FILEDLG fild;
	char szFullFile[CCHMAXPATH] = "*.*";

	HWND hwndFile;

        convert_dos(path);

	fild.cbSize = sizeof(FILEDLG);
	fild.fl = FDS_HELPBUTTON | FDS_CENTER | FDS_OPEN_DIALOG;
	fild.pszTitle = title;
	   fild.pszOKButton = szButton;
	fild.ulUser = 0L;
	fild.pfnDlgProc = (PFNWP)FileFilterProc;
	fild.lReturn = 0L;
	fild.lSRC = 0L;
	fild.hMod = 0;
	/*fild.usDlgId = FILEOPEN;*/
	fild.x = 0;
	fild.y = 0;
	fild.pszIType       = (PSZ)NULL;
	fild.papszITypeList = (PAPSZ)NULL;
	fild.pszIDrive      = (PSZ)NULL;
	fild.papszIDriveList= (PAPSZ)NULL;
	fild.sEAType        = (SHORT)0;
	fild.papszFQFilename= (PAPSZ)NULL;
	fild.ulFQFCount     = 0L;
	strcpy(fild.szFullFile, path);
	
	hwndFile = WinFileDlg(HWND_DESKTOP, last_input_screen->hwndFrame, &fild);
        params=new_malloc(500);
	if(hwndFile) 
	{
          switch(fild.lReturn)
          {
          case DID_OK:
             strcpy(params, "OK ");
             break;
          case DID_CANCEL:
             strcpy(params, "CANCEL ");
             break;
          }
          convert_unix(fild.szFullFile);
          strcat(params, fencode(fild.szFullFile));
                parse_line(NULL, code, params, 0, 0);
	}
        new_free(&params);
}

void gui_properties_notebook(void)
{
	_beginthread((void *)properties_notebook, NULL, 0xFFFF, NULL);
}

#define current_screen      last_input_screen
#define INPUT_BUFFER        current_screen->input_buffer
#define ADD_TO_INPUT(x)     strmcat(INPUT_BUFFER, (x), INPUT_BUFFER_SIZE);

void gui_paste(char *args)
{
 ULONG  fmtInfo, handle;
 APIRET rc;
 PSZ    pszClipText;
 char   *oclip, *clip, *bit;
 int    line = 0, i = 0;
 char   *channel = NULL;
 Window *win;
 int winref = 0;
 int topic = 0;
 int smartpaste = 0;
 char smart[512]; /* SmartPaste buffer (256) */
 int smartsize = 80;
 FILE *debug;
 int input_line = 0;

 /* Parse arguments */
 if (!args || !*args)
     channel = get_current_channel_by_refnum(0);
 else
 {
     char *t;
     while (args && *args)
     {
         t = next_arg(args, &args);
         if (*t == '-')
         {
          if (!my_strnicmp(t, "-topic", strlen(t)))
          {
              topic = 1;
          }
          else if (!my_strnicmp(t, "-smart", strlen(t)))
          {
              /* Smartpaste */
              smartpaste = 1;
          }
          else if (!my_strnicmp(t, "-input", strlen(t)))
          {
              /* Smartpaste */
              input_line = 1;
          }
         }
         else
             channel = t;
     }
 }
 if (!channel)
  channel = get_current_channel_by_refnum(0);


 WinOpenClipbrd(hab);

 rc = WinQueryClipbrdFmtInfo(hab,
                             CF_TEXT,
                             &fmtInfo);
 if (rc) /* Text data in clipboard */
  {
   pszClipText = (PSZ)WinQueryClipbrdData(hab, CF_TEXT); /* Query data handle */
   oclip = clip = malloc(strlen(pszClipText) + 1); line = 0;
   while (*clip++ = *pszClipText++); /* Copy to own memory */

   if (!smartpaste)
    {
     /* Ordinary paste */
     clip = oclip; bit = strtok(clip, "\n\r");
     while (bit)
      {
       if (input_line)
        {
         ADD_TO_INPUT(bit);
         update_input(UPDATE_FROM_CURSOR);
        } else
         if (!topic)
          {
           if (do_hook(PASTE_LIST, "%s %s", channel, bit))
             send_text(channel, bit, NULL, 1, 0);
          } else
           {
            send_to_server("TOPIC %s :%s", channel, bit);
            break;
           }
       line++;
       bit = strtok(NULL, "\n\r");
       if (input_line && bit)
         send_line(0, NULL);

      }
    } else
     {
      /* Rosmo's Incredibly Dull SmartPaste:
         Fits as much as possible into a 80-nick_length buffer, stripping
         spaces from beginning and end and then pasting */

      if (!topic)
        smartsize = 512;
       else
        smartsize = 128; /* 'tis correct? */

      clip = oclip;
      while (*clip && *clip == ' ') clip++; /* Strip spaces from the start */

      *smart = '\0';
      while (*clip)
       {
        if (input_line && *smart)
          send_line(0, NULL);

        *smart = '\0';

        i = 0;
        while (*clip && i < smartsize)
         {
          if (*clip != '\n')
           {
            if (*clip != '\r') strncat(smart, clip, 1);
           }
           else
            {
             strcat(smart, " "); clip++; i++;
             while (*clip && *clip == ' ') clip++; /* Strip spaces */
             clip--;
            }
          clip++; i++;
         }

       if (strcmp(smart, "") != 0) /* If our smart buffer has stuff, send it! */
         {
          if (input_line)
           {
            ADD_TO_INPUT(smart);
            update_input(UPDATE_FROM_CURSOR);
           } else
            if (!topic)
             {
              if (do_hook(PASTE_LIST, "%s %s", channel, smart))
               send_text(channel, smart, NULL, 1, 0);
             }
             else
              {
               send_to_server("TOPIC %s :%s", channel, smart);
               break;
              }
         }
       }
     }

   free(oclip); /* Free */
  }
 WinCloseClipbrd(hab);
}

void gui_setfocus(Screen *screen)
{
        WinSetFocus(HWND_DESKTOP, screen->hwndClient);
}

void gui_scrollerchanged(Screen *screen, int position)
{
        WinSendMsg(WinWindowFromID(screen->hwndFrame, FID_VERTSCROLL), SBM_SETSCROLLBAR, (MPARAM)position, MPFROM2SHORT(0, get_int_var(SCROLLBACK_VAR)));
}

void gui_query_window_info(Screen *screen, char *fontinfo, int *x, int *y, int *cx, int *cy)
{

SWP wpos;

        if(screen)
           {
           WinQueryWindowPos(screen->hwndFrame, &wpos);
           *x = wpos.x;
           *y = wpos.y;
           *cx = wpos.cx;
           *cy = wpos.cy;
           }
        else
           {
           *x=*y=*cx=*cy=0;
           }
	sprintf(fontinfo, "%dx%d", screen ? screen->VIO_font_width : 0, screen ? screen->VIO_font_height : 0);
}

void play_sound(char *filename)
{
#ifdef MMPM
  struct stat tmpstat;
  HAB soundhab = 0;
  HMQ soundhmq = 0;

  soundhab = WinInitialize(0);
  soundhmq = WinCreateMsgQueue(soundhab, 0);

  if((stat(filename,&tmpstat))==0)
        mciPlayFile((HWND)NULL, filename, 0, 0, 0);


  WinDestroyMsgQueue(soundhmq);
  WinTerminate(soundhab);
#endif
}

void gui_play_sound(char *filename)
{
#ifdef MMPM
         _beginthread((void *)play_sound, NULL, 0xFFFF, (char *)filename);
#endif
}

int gui_send_mci_string(char *mcistring, char *retstring)
{
#ifdef MMPM
return mciSendString((PSZ)mcistring, (PSZ)retstring, 500, 0, 0);
#endif
}

void gui_get_sound_error(int errnum, char *errstring)
{
#ifdef MMPM
         mciGetErrorString(errnum, (PSZ)errstring, 500);
#endif
}

void gui_menu(Screen *screen, MenuStruct *menu, char *addmenu)
{
        /* Finish creating the menu in the Window thread */
        WinSendMsg(screen->hwndClient, WM_USER+1, 0, 0);
}

int gui_isset(Screen *screen, fd_set *rd, int what)
{
	if (screen->aviokbdbuffer[0] != 0)
                return TRUE;
        else
                return FALSE;

}

int gui_putc(int c)
{
   return aputc(c);
}

void gui_exit(void)
{
   avio_exit();
}
