#define         GUISUBMENU             0
#define         GUIMENUITEM            1
#define         GUIIAMENUITEM          2
#define         GUIDEFMENUITEM         3
#define         GUIBRKMENUITEM         4
#define         GUISEPARATOR           5
#define		GUISHARED              6
#define         GUIBRKSUBMENU          7
#define         GUICHECKEDMENUITEM     8
#define         GUINDMENUITEM          9

#ifdef GUI
#include "struct.h"
/* These are all the functions that each GUI module must provide for 
   a clean port to other GUI OSes. 

   gui_init() - main initialization routine.
   */
void gui_init(void);
void gui_clreol(void);
void gui_gotoxy(int col, int row);
void gui_clrscr(void);
void gui_left(int num);
void gui_right(int num);
void gui_scroll(int top, int bot, int n);
void gui_flush(void);
void gui_puts(char *buffer);
void gui_new_window(Screen *new, Window *win);
void gui_kill_window(Screen *killscreen);
void gui_settitle(char *titletext, Screen *screen);
void gui_font_dialog(Screen *screen);
void gui_file_dialog(char *type, char *path, char *title, char *ok, char *apply, char *code, char *szButton);
void gui_properties_notebook(void);
void gui_msgbox(void);
void gui_popupmenu(char *menuname);
void gui_paste(char *args);
void gui_setfocus(Screen *screen);
void gui_scrollerchanged(Screen *screen, int position);
void gui_query_window_info(Screen *screen, char *fontinfo, int *x, int *y, int *cx, int *cy);
void gui_play_sound(char *filename);
void gui_get_sound_error(int errnum, char *errstring);
void gui_menu(Screen *screen, MenuStruct *menu, char *addmenu);
void gui_exit(void);
int gui_send_mci_string(char *mcistring, char *retstring);
int gui_isset(Screen *screen, fd_set *rd, int what);
int gui_putc(int c);

/* These are just miscellaneous GUI function declarations */
MenuStruct *findmenu(char *menuname);
#endif
