#ifndef __GNOME_PRINTER_H__
#define __GNOME_PRINTER_H__


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#include <gtk/gtk.h>


#define GNOME_TYPE_PRINTER		 (gnome_printer_get_type ())
#define GNOME_PRINTER(obj)		 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINTER, GnomePrinter))
#define GNOME_PRINTER_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINTER, GnomePrinterClass))
#define GNOME_IS_PRINTER(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINTER))
#define GNOME_IS_PRINTER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINTER))



typedef struct _GnomePrinter       GnomePrinter;
typedef struct _GnomePrinterClass  GnomePrinterClass;

struct _GnomePrinter
{
  GtkObject object;

  char *driver;
  char *filename;
};

struct _GnomePrinterClass
{
  GtkObjectClass parent_class;

};


GtkType gnome_printer_get_type (void);

GnomePrinter *gnome_printer_new_generic_ps (const char *filename);

typedef enum {
	GNOME_PRINTER_ACTIVE,
	GNOME_PRINTER_INACTIVE,
	GNOME_PRINTER_OFFLINE,
	GNOME_PRINTER_NET_FAILURE,
} GnomePrinterStatus;

GnomePrinterStatus  gnome_printer_get_status (GnomePrinter *printer);
const char         *gnome_printer_str_status (GnomePrinterStatus status);       

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PRINTER_H__ */
