#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "gnomeicu.h"
#include "pixmaps.h"

#include "applet.h"

int flash_messages( struct sokandlb *data )
{
	static char flash = 0, prev_status = 0;
	int cx;
	int have_message = 0;
	char wintitle[256];

	flash = !flash;

	if( time( NULL ) > next_resend )
		Do_Resend( data->sok );

	for( cx = 0; cx < Num_Contacts; cx ++ )
	{
		if( Contacts[ cx ].chat_away == -1 )
		{
			sprintf( wintitle, "GnomeICU: %s, %s", ( strlen( our_info->nick ) ? our_info->nick : "User" ), Contacts[ cx ].nick );
			gtk_window_set_title( GTK_WINDOW( Contacts[ cx ].chat_window ),
			                      wintitle );
			Contacts[ cx ].chat_away = 0;
		}
		
		if( Contacts[ cx ].chat_away > 0 )
		{
			if( Contacts[ cx ].chat_sok )
			{
				int time_away = time(NULL) - Contacts[ cx ].chat_away;
				sprintf( wintitle, "GnomeICU: %s, %s: User is away [%02d:%02d:%02d]",
				         ( strlen( our_info->nick ) ? our_info->nick : "User" ), Contacts[ cx ].nick,
				         time_away / 3600, (time_away % 3600) / 60,
				         time_away % 60 );
				gtk_window_set_title( GTK_WINDOW( Contacts[ cx ].chat_window ),
				                      wintitle );
			}
		}

		if( Contacts[ cx ].messages )
		{
			have_message = 1;
			switch( flash )
			{
				case 0:
					gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
					                      Contacts[ cx ].lb_index, 0,
					                      icon_blank_pixmap,
					                      icon_blank_bitmap );
					break;
				case 1:
					switch( Contacts[ cx ].message[ 0 ][ 0 ] )
					{
						case 'm':
						default:
							gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
							                      Contacts[ cx ].lb_index, 0,
							                      icon_message_pixmap,
							                      icon_message_bitmap );
							break;
						case 'c':
							gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
							                      Contacts[ cx ].lb_index, 0,
							                      icon_chat_pixmap,
							                      icon_chat_bitmap );
							break;
						case 'u':
							gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
							                      Contacts[ cx ].lb_index, 0,
							                      icon_url_pixmap,
							                      icon_url_bitmap );
							break;
						case 'a':
						case 'n':
							gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
							                      Contacts[ cx ].lb_index, 0,
							                      icon_auth_pixmap,
							                      icon_auth_bitmap );
							 break;
						case 'f':
							gtk_clist_set_pixmap( GTK_CLIST( data->lb_userwin ),
							                      Contacts[ cx ].lb_index, 0,
							                      icon_file_pixmap,
							                      icon_file_bitmap );
							break;
					}
					
					break;
			}
		}
	}

#if 0
	if( system_messages )
	{
		switch( flash )
		{
			case 0:
				gtk_clist_set_pixmap( GTK_CLIST( data->lb_syswin ), 0, 0,
				                      icon_blank_pixmap,
				                      icon_blank_bitmap );
				break;
			case 1:
				gtk_clist_set_pixmap( GTK_CLIST( data->lb_syswin ), 0, 0,
				                      icon_message_pixmap,
				                      icon_message_bitmap );
				break;
		}
	}
#endif

	if( have_message )
	{
		if( flash )
			applet_update( Current_Status, icon_offline_pixmap, data );
		else
			applet_update( Current_Status, NULL, data );

	}

	if( have_message != prev_status )
	{
		prev_status = have_message;
		gtk_window_set_title( GTK_WINDOW( data->window ), have_message ? "GnomeICU: Msgs" : "GnomeICU" );
	}

	return TRUE;
}
