/*
 * Set user automatically to away or n/a mode after designated # of idle
 * minutes.
 * Originally written by Jeremy Wise <jwise@pathwaynet.com>
 * Modified by suggestion of John Rapp <jlrapp@ucsd.edu>
 */

#include "gnomeicu.h"
#include "gtkfunc.h"

#include <X11/Xlib.h>

#ifdef USE_XSCREENSAVER
#include <X11/Xutil.h>
#include <X11/extensions/scrnsaver.h>
#endif

int old_status = 0x9999;

guint auto_away( struct sokandlb *data )
{
	static Display *display = NULL;
	int time_idle = 0;
#ifdef USE_XSCREENSAVER
	static XScreenSaverInfo *info = NULL;
#endif

#if 0
	int event_base, error_base;
#endif

#ifdef USE_XPOINTER_CHANGE
	static Window w1, w2, root;
	static int x = -1, y = -1, x1, y1, x2, y2, b;
	static unsigned long last_idle = 0;
#endif

#ifdef TRACE_FUNCTION
	g_print( "auto_away\n" );
#endif

	if( !display )
		display = XOpenDisplay( gdk_get_display( ) );

	if( Current_Status != STATUS_ONLINE && Current_Status != STATUS_AWAY &&
		    Current_Status != STATUS_FREE_CHAT && Current_Status != STATUS_NA )
			return TRUE;

#ifdef USE_XSCREENSAVER
	if( !info )
		info = XScreenSaverAllocInfo();
	XScreenSaverQueryInfo ( display, DefaultRootWindow( display ),
	                        info );
	time_idle = info->idle;
#endif

#ifdef USE_XPOINTER_CHANGE
	if( x == -1 && y == -1 )
	{
		last_idle = time(0);
		root = RootWindow( display, DefaultScreen( display ) );
	}

	XQueryPointer( display, root, &w1, &w2, &x1, &y1, &x2, &y2, (uint*)&b );
	if( !( x1 == x && y1 == y ) )
	{
		x = x1;
		y = y1;
		last_idle = time( 0 );
	}
	
	time_idle = time( 0 ) - last_idle;
	time_idle = time_idle < 0 ? 0 : time_idle * 1000;
#endif

	if( time_idle > 60000 * AUTO_NA )
	{
		if( old_status == 0x9999 )
			old_status = Current_Status;
		if( Current_Status != STATUS_NA )
			icq_change_status( data->sok, STATUS_NA, data );
	}
	else if( time_idle > 60000 * AUTO_AWAY )
	{
		if( old_status == 0x9999 )
			old_status = Current_Status;
		if( Current_Status != STATUS_AWAY )
			icq_change_status( data->sok, STATUS_AWAY, data );
	}
	else
	{
		if( old_status != 0x9999 )
			icq_change_status( data->sok, old_status, data );
		old_status = 0x9999;
	}

	return TRUE;
}
