.TH Wharf 1.0 "October 1996" Wharf
.UC
.SH NAME
Wharf \- the AfterStep application "dock" module
.SH SYNOPSIS
Wharf is spawned by afterstep, so no command line invocation will work.

.SH DESCRIPTION
The Wharf module is a free-floating application loader that can
execute programs, "Swallow" running programs, and contain "Folders" of
more applications, among other things.  The user can press the first
button at any time to trigger invocation of one of these functions, or
the user can press button two in order to cause the entire Wharf
to withdraw to the nearest corner in an iconized state.  Wharf only 
works when afterstep is used as the window manager.

.SH COPYRIGHTS
The Wharf module is copyright 1995 and 1996 by a variety of contributors.
They are, in alphabetical order, Beat Christen, Frank Fejes, Alfredo 
Kenji Kojima, Dan Weeks, and Bo Yang

The GoodStuff program, and the concept for
interfacing this module to the Window Manager, are all original work
by Robert Nation

No guarantees or warranties or anything
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 


.SH INITIALIZATION
During initialization, \fIWharf\fP will search for a configuration
file which describes the button panel geometry, color, icons, and
actions. The format of 
this file will be described later. The configuration file will be the
one which afterstep used during its initialization.

If the Wharf executable is linked to another name, ie ln -s
Wharf Pier, then another module called Pier can be
started, with a completely different configuration than Wharf,
simply by changing the keywords Wharf??? to Pier???. This way multiple
button-bars can be used.

.SH INVOCATION
Wharf can be invoked by inserting the line 'Module Wharf' in
the .steprc file. This can be placed on a line by itself, if Wharf
is to be spawned during AfterStep's initialization, or can be bound to a
menu or mouse button or keystroke to invoke it later. AfterStep will search
directory specified in the ModulePath configuration option to attempt
to locate Wharf.

.SH CONFIGURATION OPTIONS
The following options can be placed in the .steprc file

.IP "*WharfAnimate"
If specified, the opening and closing of Folders will be animated, 
rather than simply drawn in one frame.

.IP "*WharfAnimateMain"
Designates that full-length Wharf windraws will be animated.

.IP "*WharfBgColor \fIcolor\fP"
If \fI*WharfTextureType 0\fP is specified, \fIWharf\fP's buttons
will be filled with \fIcolor\fP.

.IP "*WharfColumns \fIcolumns\fP"
Specifies the number of columns of buttons to be created. If unspecified,
the number of columns will be set to 1.
If the columns are set to a number greater than 1 then there will be that number
of columns with enough rows to satisfy the requested number of buttons.

.IP "*WharfForceSize"
If specified, will force pixmaps larger than 64x64 to the default
size.  Pixmaps smaller than 64x64 are not supported.

.IP "*WharfFullPush"
If specified, the entire Wharf button background will be moved down
and to the right when pushed.  Especially useful with *WharfNoBorder
textures.

.IP "*WharfGeometry \fIgeometry\fP"
Specifies the Wharf window location and/or size. If the size is
not specified, Wharf will auto-size itself in a reasonable manner.
The geometry is a standard X11 window geometry specification.  This option is
pre-set in the NEXTSTEP(tm) style section for a consistent look and feel with NEXTSTEP(tm).
Secondary Wharf invocations from links may have their own geometry.

.IP "*WharfMaxColors \fInumber\fP"
Specifies the maximum \fInumber\fP of colors to use on a gradient
fill.

.IP "*WharfNoBorder"
Denotes that beveled borders should not be drawn around the Wharf button.
Useful with textures that include their own bevels.

.IP "*WharfPixmap \fIpixmap\fP"
Sets the pixmap file to be used as \fIWharf\fP's button.  To be used
with \fI*WharfTextureType 128\fP.

.IP "*WharfTextureColor \fIfrom\fP \fIto\fP"
When used with a \fI*WharfTextureType\fP of 1 to 5, designates the
ends of the gradient range to be used on \fIWharf\fP's buttons.

.IP "*WharfTextureType  \fItype\fP"
Specifies the type of gradient fill to be used on 
\fIWharf\fP's buttons.  Valid values are:
.nf
0 - No texture - use \fIWharfBgColor\fP to set the desired color
1 - Gradient from upper-left to lower right
2 - Horizontal one way gradient from top to bottom
3 - Horizontal cylindrical gradient from top/bottom to center
4 - Vertical one way gradient from left to right
5 - Vertical cylindrical gradient from left/right to center
128 - User specified pixmap
.fi
The default is the builtin \fIWharf\fP texture pixmap.

.IP "*Wharf \fIlabel icon command\fP"
Specifies a window manager built-in command or folder to activate
(folders will be discussed below), as described in the afterstep
man page, which should be executed when a button is pressed. The label
field is an internal item that is still around from the GoodStuff module.
The icon field
specifies an X11 bitmap file, XPM color icon file, or a comma-delimited 
set of pixmaps containing the
icon(s) to display on the button. Wharf will search through the path
specified in the afterstep IconPath or PixmapPath configuration items to
find the icon file.

NOTE: Icons must have one transparent pixel or the definition of a transparent color in order to be valid.

If \fIcommand\fP is an afterstep Exec command, then the button will
appear pushed in until the mouse button is released.

A single extension to the afterstep built-in command set is provided.
A command of the form:
.nf

*Wharf junk clock.xpm Swallow "Clock" asclock -shape -12 &

.fi
will cause Wharf to spawn an asclock process, and capture 
the first window whose name or resource is "Clock", and display it in
the button-bar. This is handy for applications like xclock, xbiff,
xload, asclock, and asmail. Modules can be swallowed by specifying  SwallowModule instead
of just "swallow" NOTE: if you use xclock for this application, you will want
to specify xclock -padding 0. 

For certain applications that overrun the 48 pixel by 48 pixel boundary of Wharf
icons and Swallowed programs there is a special option called
.I MaxSwallow.
.I MaxSwallow
will allow the application to draw itself larger than the 48x48 boundary.  It is 
invoked the same way Swallow is.

To create folder "slide-outs" in
.B Wharf
the following format must be used:
.nf

*Wharf files Folders.xpm Folder
*Wharf xftp 3DRings.xpm	Exec "" xftp &
*Wharf xdir FolderDeposit.xpm Exec "" xdir &
*Wharf moxfm FilingCabinet.xpm Exec "" moxfm &
*Wharf ~Folders

.fi
The first line of this set tells Wharf that this button definition will be a 
folder.  All of the button definitions between the
.I Folder
and the line with the definition of 
.I *Wharf ~Folders
will appear on the "files" folder when it is exposed.  To expose the "files"
folder simply click on the Wharf button with the Folders.xpm icon showing.  A
button bar will appear perpendicular to your Wharf bar and toward the center
of the screen.  On this smaller bar will be the three icons that were configured 
between the 
.I Folder
and
.I ~Folder
parts of the Wharf configuration.  As many folder buttons may be configured as
is room on your screen.  The only items that may not be configured within
folders are Swallowed applications and more folders.
 
.SH DRAG AND DROP
\fIWharf\fP supports the OffiX Drag and Drop standard.  In order to
have Drag and Drop enabled on a particular button, the following syntax
must be adhered to:
.nf

*Wharf	nil      nil	     DropExec "\fIprogram\fP" \fIprogram\fP %s
*Wharf	\fIprogram\fP  \fIiconname\fP	Exec "\fIprogram\fP" \fIprogram\fP

.fi

The button will call \fIprogram\fP when pushed.  If a file is dragged
onto into it, \fIprogram\fP will be called with %s being replaced by
the dropped filename.

.SH AUTHORS
.nf
Beat Christen (bchriste@iiic.ethz.ch)
Frank Fejes (frank@ssax.com)
Alfredo Kengi Kojima (kojima@inf.ufrgs.br)
Dan Weeks (dan@mango.sfasu.edu)
Bo Yang (eric@coeus.ucsd.edu)
.fi
