#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/****************************************************************************
 *
 * Function:    scanf
 *
 * Description:
 *    scan the stdin file for the input arguments.
 *
 * Entry:
 *    pszFormat   - Pointer to the format string
 *    args        - Pointers to the various arguments being scanned.
 *
 * Returns:
 *    The number of characters scanned.
 */

int scanf (const char *pszFormat, ...)
    {
    va_list  vaArgs;
    int      nAnswer;
    FUNC_ENTRY ("scanf");
/*
 *  Initialize to start the scan and perform the scan operation.
 */
    va_start (vaArgs, pszFormat);
    nAnswer = _input (stdin, pszFormat, vaArgs);
    va_end (vaArgs);
/*
 *  Return to the caller
 */
    FUNC_EXIT ("scanf");
    return (nAnswer);
    }
