#ifndef STRING_H
#define STRING_H

#include <sys/types.h>

/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the, 1992 Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/*
 *	ANSI Standard: 4.11 STRING HANDLING	<string.h>
 */

/*
 *  The GNU C 2.2 compiler has trouble with the builtin functions. It
 *  complains about bad definitions and gives no way around the situation.
 *  So, for the COFF library, I give up and simply changed the names to
 *  avoid the problem. If you can find a solution to the problem by a better
 *  means (such as making this stuff work correctly) then let me know. Thanks.
 *  longyear@netcom.com.
 */

#undef  memcpy
#undef  memcmp
#undef  memset
#undef  memchr
#undef  strlen
#undef  strcpy
#undef  memccpy

#ifdef COFF_LIBRARY
#define memcpy  __ibcs_memcpy
#define memcmp  __ibcs_memcmp
#define memset  __ibcs_memset
#define strlen  __ibcs_strlen
#define strcpy  __ibcs_strcpy
#define memccpy __ibcs_memccpy
#define memchr  __ibcs_memchr
#else
#define __ibcs_memcpy  memcpy
#define __ibcs_memcmp  memcmp
#define __ibcs_memset  memset
#define __ibcs_strlen  strlen
#define __ibcs_strcpy  strcpy
#define __ibcs_memccpy memccpy
#define __ibcs_memchr  memchr
#endif

/* Get unsigned int and NULL from <stddef.h>.  */
#define	__need_unsigned int
#define	__need_NULL
#include <stddef.h>

/* Copy N bytes of SRC to DEST.  */
/* `memcpy' is a built-in function for gcc 2.x. */
#if defined(__STDC__) || __GNUC__ < 2
extern void *memcpy (void *dest, const void *src, unsigned int n);
#endif

/* Copy N bytes of SRC to DEST, guaranteeing
   correct behavior for overlapping strings.  */
extern void *memmove (void *dest, const void *src, unsigned int n);

/* Copy no more than N bytes of SRC to DEST, stopping when C is found.
   Return the position in DEST one byte past where C was copied,
   or NULL if C was not found in the first N bytes of SRC.  */
extern void *memccpy (void *dest, const void *src, int c, unsigned int n);

#if defined (__USE_SVID) || defined (__USE_BSD)
extern void *memccpy (void *dest, const void *src, int c, unsigned int n);

#ifdef	__OPTIMIZE__
/* #define memccpy(dest, src, c, n) __memccpy((dest), (src), (c), (n)) */
#endif /* Optimizing.  */
#endif /* SVID.  */

/* Set N bytes of S to C.  */
extern void *memset (void *s, int c, unsigned int n);

/* Compare N bytes of S1 and S2.  */
/* `memcmp' is a built-in function for gcc 2.x. */
#if defined(__STDC__) || __GNUC__ < 2
extern int memcmp (const void *s1, const void *s2, unsigned int n);
#endif

/* Search N bytes of S for C.  */
extern void *memchr (const void *s, int c, unsigned int n);

/* Copy SRC to DEST.  */
extern char *strcpy (char *dest, const char *src);
/* Copy no more than N characters of SRC to DEST.  */
extern char *strncpy (char *dest, const char *src, unsigned int n);

/* Append SRC onto DEST.  */
extern char *strcat (char *src, const char *dest);
/* Append no more than N characters from SRC onto DEST.  */
extern char *strncat (char *dest, const char *src, unsigned int n);

/* Compare S1 and S2.  */
extern int strcmp  (const char *s1, const char *s2);
/* Compare N characters of S1 and S2.  */
extern int strncmp  (const char *s1, const char *s2, unsigned int n);

/* Compare the collated forms of S1 and S2.  */
extern int strcoll  (const char *s1, const char *s2);
/* Put a transformation of SRC into no more than N bytes of DEST.  */
extern unsigned int strxfrm  (char *dest, const char *src, unsigned int n);

#if defined (__USE_SVID) || defined (__USE_BSD)
/* Duplicate S, returning an identical malloc'd string.  */
extern char *strdup  (const char *s);
#endif

/* Find the first occurrence of C in S.  */
extern char *strchr  (const char *s, int c);
/* Find the last occurrence of C in S.  */
extern char *strrchr  (const char *s, int c);
extern char *rindex   (const char *s, int c);

/* Swap byte pairs in a string */
void swab (const void *from, void *to, size_t len);

/* Edit the mode flags to printable format for a stat structure entry */
void strmode (register mode_t mode, register char *p);

/* Return the length of the initial segment of S which
   consists entirely of characters not in REJECT.  */
extern unsigned int strcspn  (const char *s, const char *reject);
/* Return the length of the initial segment of S which
   consists entirely of characters in ACCEPT.  */
extern unsigned int strspn  (const char *s, const char *accept);
/* Find the first occurence in S of any character in ACCEPT.  */
extern char *strpbrk  (const char *s, const char *accept);
/* Find the first occurence of NEEDLE in HAYSTACK.  */
extern char *strstr  (const char *haystack, const char *needle);
/* Divide S into tokens separated by characters in DELIM.  */
extern char *strtok  (char *s, const char *delim);

#ifdef	__USE_GNU
/* Find the first occurence of NEEDLE in HAYSTACK.
   NEEDLE is NEEDLELEN bytes long;
   HAYSTACK is HAYSTACKLEN bytes long.  */
extern void *memmem  (const void *needle, unsigned int needlelen,
			    const void *haystack, unsigned int haystacklen);
#endif

/* Return the length of S.  */
extern unsigned int strlen  (const char *s);

/* Return a string describing the meaning of the errno code in ERRNUM.  */
extern char *strerror  (int errnum);

#ifdef	__USE_BSD
/* Find the first occurrence of C in S (same as strchr).  */
extern char *index  (const char *s, int c);

/* Find the last occurrence of C in S (same as strrchr).  */
extern char *rindex  (const char *s, int c);

#ifndef __linux__

/* Copy N bytes of SRC to DEST (like memmove, but args reversed).  */
extern void bcopy  (const void *src, void *dest, unsigned int n);

/* Set N bytes of S to 0.  */
extern void bzero  (void *s, unsigned int n);

/* Compare N bytes of S1 and S2 (same as memcmp).  */
extern int bcmp  (const void *s1, const void *s2, unsigned int n);

#else

/* Copy N bytes of SRC to DEST (like memmove, but args reversed).  */
extern void bcopy (const void *src, void *dest, int n);

/* Set N bytes of S to 0.  */
extern void bzero (void *s, int n);

/* Compare N bytes of S1 and S2 (same as memcmp).  */
extern int bcmp (const void *s1, const void *s2, int n);

#endif

/* Return the position of the first bit set in I, or 0 if none are set.
   The least-significant bit is position 1, the most-significant 32.  */
extern int ffs  (int i);

/* Compare S1 and S2, ignoring case.  */
extern int strcasecmp (const char *s1, const char *s2);

/* Return the next DELIM-delimited token from *STRINGP,
   terminating it with a '\0', and update *STRINGP to point past it.  */
extern char *strsep (char **stringp, const char *delim);
#endif

#ifdef	__USE_GNU
/* Compare no more than N chars of S1 and S2, ignoring case.  */
extern int strncasecmp (const char *s1, const char *s2, unsigned int n);

/* Return a string describing the meaning of the signal number in SIG.  */
extern char *strsignal (int sig);

/* Copy SRC to DEST, returning the address of the terminating '\0' in DEST.  */
extern char *stpcpy (char *dest, const char *src);

/* Sautee STRING briskly.  */
extern char *strfry (char *string);

/* Frobnicate N bytes of S.  */
extern void *memfrob (void *s, unsigned int n);

extern void swab (const void *from, void *to, unsigned int nbytes);
#endif

#endif /* string.h  */
