dnl ---------------------------------------------------------------------------
dnl Add libraries and options according to whether we're building with an
dnl extension to curses, or not.
dnl Default to use "ncurses", as most linux distributions work this way now.
AC_DEFUN([CF_CURSES],
[if test $cf_cv_use_curses != no ; then
EXTRAOBJS="$EXTRAOBJS libcurses.o"
case "$cf_cv_use_curses" in
*)
	LDLIBS="$LDLIBS -lncurses"
	CFLAGS="$CFLAGS -I/usr/include/ncurses"
	;;
curses)
	LDLIBS="$LDLIBS -lcurses -ltermcap"
	;;
esac
	SHLIBDEPS="$LDLIBS"
else
	LDLIBS="$LDLIBS -lncurses"
	SHLIBDEPS=""
fi])
dnl ---------------------------------------------------------------------------
dnl Set configuration variables as a result of selecting the --with-debug
dnl option.
AC_DEFUN([CF_DEBUG],
[
LDFLAGS="$LDFLAGS -L."
if test -n "$GCC" ; then
if test "$cf_cv_use_debug" = "yes" ; then
	# we need -O, since the new includes define inline functions
	CFLAGS="$CFLAGS -g -O -Wall"
else
	CFLAGS="$CFLAGS -O3 -fomit-frame-pointer"
	LDFLAGS="$LDFLAGS -s"
fi
fi
if test "$cf_cv_use_debug" = "yes" ; then
	CFLAGS="$CFLAGS -DDEBUG"
fi])
dnl ---------------------------------------------------------------------------
dnl Extract the RELEASE and REL_MAJ variables from the configuration file so
dnl they can be used in the generated Makefile.
AC_DEFUN([CF_RELEASE],
[
AC_MSG_CHECKING(for release)
AC_CACHE_VAL(cf_cv_release,
[cf_cv_release=1.14])
AC_MSG_RESULT($cf_cv_release)
RELEASE=$cf_cv_release
changequote(,)dnl
REL_MAJ=`echo $RELEASE|sed -e 's/[.].*$//'`
changequote([,])dnl
])
dnl ---------------------------------------------------------------------------
dnl __u32 is important for alpha compatibility.
dnl This type is missing from older kernels (and include files).
AC_DEFUN([CF_TYPE_U32],
[
AC_MSG_CHECKING(for type __u32)
AC_CACHE_VAL(cf_cv_type_u32,
[AC_TRY_COMPILE([
#include <sys/types.h>],
[__u32 this],
	[cf_cv_type_u32=yes],
	[cf_cv_type_u32=no])
	])
AC_MSG_RESULT($cf_cv_type_u32)
test $cf_cv_type_u32 = no && AC_DEFINE(__u32,unsigned int)
])
dnl ---------------------------------------------------------------------------







