#include "gmailman.h"
#include <gnome.h>
/* #define DO_CHECKMEM */
/*#include "checkmem.h" */

GnomeUIInfo maintoolbar[] = {
  {GNOME_APP_UI_ITEM, N_("New list..."), N_("Add a new mailing list"), "addlist",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Contact info..."), N_("Add a new mailing list"), "edit_persona",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("About..."), N_("Brag box"), "about",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit the program"), "quit",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_EXIT, 0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo filemenu[] = {
  {GNOME_APP_UI_ITEM, N_("Exit"), N_("Exit the program"), "quit",
   NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] = {
  GNOMEUIINFO_HELP("gmailman"),
  {GNOME_APP_UI_ITEM, N_("About..."), N_("Copyright information"), "about",
   NULL, NULL, GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] = {
  GNOMEUIINFO_SUBTREE("File", &filemenu),
  GNOMEUIINFO_SUBTREE("Help", &helpmenu),
  GNOMEUIINFO_END
};

@interface AddNewListDialog : Gtk_Dialog
{
  id menu_type, optmenu_type;
  id menu_status, optmenu_status;
@public
  char *selected_type;
  id listaddr, ctladdr, name, desc;
  SubscriptionStatus selected_status;
  id clicked_widget;
  id btn_ok, btn_cancel;
}
- clicked:(id) anObject;
- run;
@end

@implementation AddNewListDialog
#ifdef DO_CHECKMEM
- domemcheck
{
  DMC();
  return self;
}
#endif

- init
{
  id abox, mitem = nil;
  GList *alist;
  self = [super init];

#define DO_ENTRY(label, var) \
  abox = [[[Gtk_HBox alloc] initWithBoxInfo:FALSE setSpacing:5] show]; \
  [abox add:[[[Gtk_Label alloc] initWithLabel:label] show]]; \
  [abox add:(var = [[Gtk_Entry new] show])]; \
  [vbox add:abox]
#define DO_WIDGET(label, widget) \
  abox = [[[Gtk_HBox alloc] initWithBoxInfo:FALSE setSpacing:5] show]; \
  [abox add:[[[Gtk_Label alloc] initWithLabel:label] show]]; \
  [abox add:(widget)]; \
  [vbox add:abox]

  DO_ENTRY("List name", name);
  DO_ENTRY("List address", listaddr);
  DO_ENTRY("Control address", ctladdr);
  DO_ENTRY("Description", desc);

  /* Listserv type menu */
  menu_type = [Gtk_Menu new];
  /* ASSUME we have at least one mailing list here */
  for(alist = MLGetListTypes(), selected_type = alist->data; alist; alist = g_list_next(alist))
    {
      mitem = [[Gtk_MenuItem alloc] initWithLabel:alist->data];
      [mitem set_data:"mltype" :alist->data];
      [mitem connectObj:"activate" :self];
      [menu_type add:[mitem show]];
    }
  optmenu_type = [[[[Gtk_OptionMenu new] show] set_menu:menu_type]
		   set_history:0];
  DO_WIDGET("List type", optmenu_type);

  /* Subscribed/unsubscribed menu */
  menu_status = [Gtk_Menu new];

  selected_status = LIST_UNSUBSCRIBED;
  mitem = [[Gtk_MenuItem alloc] initWithLabel:"Unsubscribed"];
  [mitem set_data:"mlstatus" :(gpointer)LIST_UNSUBSCRIBED];
  [mitem connectObj:"activate" :self];
  [menu_status add:[mitem show]];

  mitem = [[Gtk_MenuItem alloc] initWithLabel:"Subscribed"];
  [mitem set_data:"mlstatus" :(gpointer)LIST_SUBSCRIBED];
  [mitem connectObj:"activate" :self];
  [menu_status add:[mitem show]];

  optmenu_status = [[[[Gtk_OptionMenu new] show] set_menu:menu_status]
		     set_history:0];
  DO_WIDGET("Status", optmenu_status);

  [self connect:"delete_event"];
  btn_ok = [Gtk_Button alloc]; btn_cancel = [Gtk_Button alloc];
  [btn_ok
    castGtkButton:GTK_BUTTON(gnome_stock_button(GNOME_STOCK_BUTTON_OK))];
  [btn_cancel
    castGtkButton:GTK_BUTTON(gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL))];
  [[btn_ok show] connectObj:"clicked" :self];
  [[btn_cancel show] connectObj:"clicked" :self];
  [[action_area add:btn_ok] add:btn_cancel];

  [self set_title:"Add new mailing list"];

  return self;
}

- activate:(id) actobj
{
  if([actobj get_parent] == menu_type)
    {
      selected_type = [actobj get_data:"mltype"];
      g_print("Selected type was %s\n", selected_type);
    }
  else if([actobj get_parent] == menu_status)
    {
      selected_status = (SubscriptionStatus)[actobj get_data:"mlstatus"];
      g_print("Selected status was %d\n", selected_status);
    }
  return self;
}

- (BOOL)delete_event:(id) anObject
		    :(GdkEventAny *) event
{
  [self clicked:btn_cancel];
  return TRUE;
}

- clicked:(id) anObject
{
  clicked_widget = anObject;
  gtk_main_quit();
  return self;
}

- run
{
  gtk_grab_add(gtkwidget);
  [self show];
  gtk_main();
  gtk_grab_remove(gtkwidget);
  [self hide];
  return self;
}
@end

@implementation MyMainwin
#ifdef DO_CHECKMEM
- domemcheck
{
  DMC();
  return self;
}
#endif

- free
{
  GList *item;
  for(item = mlists; item; item = item->next)
    {
      g_string_sprintf(tmpstr, "/gmailman/lists/%s",
		       [(id)item->data getName]);
      [(id)item->data saveToConfig:tmpstr->str];
    }
  g_string_free(tmpstr, TRUE);
  return [super free];
}

- initForApp:(id) anapp
{
  id vbox;
  self = [super initWithAppWinInfo:"gmailman" :"GNOME Mailman"];
  myapp = anapp;
  mlists = NULL;

  /* Bits & pieces */
  vbox = [Gtk_VBox new];

  tmpstr = g_string_new(NULL);

  lbl_listaddr = [[Gtk_Label new] show];
  lbl_ctladdr = [[Gtk_Label new] show];
  lbl_mltype = [[Gtk_Label new] show];

  persona = [[Persona alloc] initFromConfig:"/gmailman/id/default"];

  /* Make the RMB popup menu */
  popup_oplist = [Gtk_Menu new];
  op_edit = [[[Gtk_MenuItem alloc]
	       initWithLabel:"Edit..."] show];
  op_export = [[[Gtk_MenuItem alloc]
		 initWithLabel:"Export..."] show];
  op_act = [[[Gtk_MenuItem alloc]
	      initWithLabel:"Unsubscribe"] show];
  op_delete = [[[Gtk_MenuItem alloc]
		 initWithLabel:"Delete"] show];
  [op_delete connectObj:"activate" :self];
  [op_edit set_sensitive:FALSE];
  [op_export set_sensitive:FALSE];
  [op_act connectObj:"activate" :self];
  [popup_oplist add:op_act];
  [popup_oplist add:op_delete];
  [popup_oplist add:op_edit];
  [popup_oplist add:op_export];

  /* This needs to go after the other controls because
     it sets the values of some of them */
  [self createMLList];

  /* Pack things into the window */
  [vbox pack_start:mlistlist doExpand:TRUE doFill:TRUE doPadding:5];
  [vbox pack_start:lbl_listaddr doExpand:TRUE doFill:TRUE doPadding:5];
  [vbox pack_start:lbl_ctladdr doExpand:TRUE doFill:TRUE doPadding:5];
  [vbox pack_start:lbl_mltype doExpand:TRUE doFill:TRUE doPadding:5];

#if 0
  [self create_menus:mainmenu];
#endif
  [self create_toolbar:maintoolbar];
  [self set_contents:vbox];
  [self connect:"delete_event"];

  [self set_usize:500 height:-1];
  [[mlistlist thaw] show];

  return self;
}

- edit_persona:(id) anobj
{
  /* Might be nice to put this in a separate class...
     I want a GUI builder. ;-) */
  Gtk_Dialog *nd = NULL;
  id hbox;
  id ent_name, ent_email;
  id btn_set;

  nd = [Gtk_Dialog new];
  [nd->action_area add:[(id)[[Gtk_Button alloc]
			      initWithLabel:"Close"]
			    signal_connect:"clicked"
			    signalFunc:gtk_main_quit funcData:NULL]];
  
  [nd signal_connect:"delete_event" signalFunc:GTK_SIGNAL_FUNC(gtk_main_quit) funcData:NULL];
  [nd signal_connect:"delete_event" signalFunc:GTK_SIGNAL_FUNC(gtk_widget_hide_on_delete) funcData:NULL];
  
  hbox = [[Gtk_HBox new] show];
  [nd->vbox add:hbox];
  [hbox add:[[[Gtk_Label alloc] initWithLabel:"Name:"] show]];
  ent_name = [[Gtk_Entry new] show];
  [hbox add:ent_name];
  
  hbox = [[Gtk_HBox new] show];
  [nd->vbox add:hbox];
  [hbox add:[[[Gtk_Label alloc] initWithLabel:"E-mail address:"] show]];
  ent_email = [[Gtk_Entry new] show];
  [hbox add:ent_email];
  btn_set = [[Gtk_Button alloc]
	      castGtkButton:GTK_BUTTON(gnome_stock_button(GNOME_STOCK_BUTTON_OK))];
  [btn_set signal_connect:"clicked" signalFunc:gtk_main_quit funcData:NULL];
  [nd->action_area add:[btn_set show]];

  if(persona)
    {
      [ent_email set_text:[persona getEmailAddress]];
      [ent_name set_text:[persona getFullName]];
    }
    
  [nd show];
  gtk_grab_add(nd->gtkwidget);
  gtk_main();
  gtk_grab_remove(nd->gtkwidget);

  [persona free];

  persona = [[Persona alloc]
	      initWithPersonaInfo:[ent_name get_text]
	      :[ent_email get_text]];
  [persona saveToConfig:"/gmailman/id/default"];

  [nd free];

  return self;
}

- activate:(id) anObj
{
  g_print("We have activation!\n");

  if(anObj == op_act)
    {
      [self changestatus:GTK_CLIST((Gtk_CList *)mlistlist->gtkclist)->selection->data];
    }
  else if(anObj == op_delete)
    {
      id mlobj;
      int rownum;
      mlobj = [mlistlist get_row_data:GPOINTER_TO_INT (GTK_CLIST((Gtk_CList *)mlistlist->gtkclist)->selection->data)];
      rownum = [mlistlist find_row_from_data:mlobj];
      if(rownum < 0)
	return self;
      g_print("We have row number %d\n", rownum);

      g_string_sprintf(tmpstr, "/gmailman/lists/%s",
		       [mlobj getName]);
      [mlobj free];
      gnome_config_clean_section(tmpstr->str);
      [mlistlist removeCListRow:rownum];
      mlists = g_list_remove(mlists, mlobj);
    }
  return self;
}

- about:(id) anObj
{
  static const char *authlist[] = {"Elliot Lee <sopwith@cuc.edu>", NULL};

  gtk_widget_show(gnome_about_new("gmailman", "0.1",
			 "Copyright (C) 1998",
			 authlist,
			 "This program helps you keep track of the mailing lists you are subscribed to.",
			 NULL));
  return self;
}

- quit:(id) anObj
{
  [myapp quit];
  return self;
}

- delete_event:(id) anObj :(GdkEventAny *) event
{
  return [self quit:anObj];
}

- changestatus:(id) mlobj
{
  int rownum;
  SubscriptionStatus newstat;
  rownum = [mlistlist find_row_from_data:mlobj];

  if(!persona)
    {
      GtkWidget *nw;

      nw = gnome_message_box_new("Your personal information,\nentered using the \"Options...\" form,\nis needed to (un)subscribe lists",
				GNOME_MESSAGE_BOX_ERROR, "Close", NULL);
      gtk_signal_connect(GTK_OBJECT(nw), "clicked",
			 GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
      gnome_message_box_set_modal(GNOME_MESSAGE_BOX(nw));
      gtk_widget_show(nw);

      gtk_main();

      gtk_widget_destroy(nw);

      return self;
    }

  newstat = ![mlobj getStatus];

  if(newstat == LIST_SUBSCRIBED)
    [mlobj subscribe:persona];
  else
    [mlobj unsubscribe:persona];

  [mlistlist set_text:rownum :1 :(newstat?"Yes":"   ")];

  return self;
}

- addlist:(id) anobj
{
  AddNewListDialog *dlg = [AddNewListDialog new];
  Class mlc;

  [dlg run];

  if(dlg->clicked_widget != dlg->btn_ok)
    {
      [dlg free];
      return self;
    }

  mlc = objc_get_class(dlg->selected_type);
  if(mlc != Nil)
    {
      g_string_sprintf(tmpstr, "/gmailman/lists/%s", [dlg->name get_text]);

      [self addML:[[[mlc alloc]
		     initWithMaillistInfo:[dlg->listaddr get_text]
		     :[dlg->ctladdr get_text]
		     :[dlg->name get_text]
		     :[dlg->desc get_text]
		     :dlg->selected_type
		     :dlg->selected_status]
		    saveToConfig:tmpstr->str]
	    ];
    }

  [dlg free];
  return self;
}

- addML:(id)alist
{
  gchar *vals[3];
  int rownum;

  vals[0] = (char *)[alist getName];
  vals[1] = "";
  switch([alist getStatus])
    {
    case LIST_UNSUBSCRIBED:
      vals[1] = "   ";
      break;
    case LIST_SUBSCRIBED:
      vals[1] = "Yes";
      break;
    default:
      g_error("Unknown subscription status %d\n", [alist getStatus]);
    }
  vals[2] = (char *)[alist getDescription];
  rownum = [mlistlist appendCListRow:(const char **)vals];
  [mlistlist set_row_data:rownum rowData:alist];

  return self;
}

- (id)createMLList
{
  GList *item;
  static const gchar *columns[] = {
    "List",
    "Subscribed",
    "Description"
  };

  mlists = MLGetListObjects();
  mlistlist =
    [[[Gtk_CList alloc] initWithCListInfoTitles:3 Titles:columns] freeze];
  [mlistlist set_data:"Mailman" :self];

  for(item = mlists; item; item = item->next)
    [self addML:(id)item->data];

  [mlistlist connectObj:"select_row" :self];
  [mlistlist set_column_width:0 :100];
  [mlistlist set_column_width:1 :75];
  [mlistlist set_usize:-1 height:270];
  [mlistlist set_selection_mode:GTK_SELECTION_BROWSE];

  return self;
}

- select_row:(id) anObj :(gint) row :(gint) column
	    :(GdkEventButton *) event
{
  if(anObj == mlistlist)
    {
      id mlobj;

      if(event)
	g_print("Button %d pressed\n", event->button);

      mlobj = [mlistlist get_row_data:row];
      if(mlobj == nil)
	return self;
      
      [lbl_listaddr set_text:(char *)[mlobj getListAddress]];
      [lbl_ctladdr set_text:(char *)[mlobj getControlAddress]];

      if(event && event->button == 3)
	{
	  char *tmp = NULL;

	  /* Do popup menu */
	  switch([mlobj getStatus])
	    {
	    case LIST_UNSUBSCRIBED:
	      tmp = "Subscribe"; break;
	    case LIST_SUBSCRIBED:
	      tmp = "Unsubscribe"; break;
	    default:
	      g_error("Boom, unknown status %d on list %s\n",
		      [mlobj getStatus], [mlobj getName]);
	    }

	  gtk_label_set(GTK_LABEL(GTK_BIN(((Gtk_ListItem *)op_act)->gtkbin)->child),
			tmp);

	  [popup_oplist popup:NULL menuItem:NULL posFunc:NULL
			posFuncData:mlobj posFuncBtn:event->button
			posFuncTime:event->time];
	}
    }
  return self;
}
@end

@implementation Mailman
#ifdef DO_CHECKMEM
- domemcheck
{
  DMC();
  return self;
}
#endif


- initMailman:(char *)app_id
	 :(int) argc
	 :(char **) argv
{
  self = [super initApp:app_id :VERSION :argc :argv];

  mainwin = [[[MyMainwin alloc] initForApp:self] show];

  return self;
}

- free
{
  [mainwin free];
  return [super free];
}
@end

int main(int argc, char *argv[])
{
  id myapp;
  Class mlist;

  mlist = [MailList class];
  myapp = [Mailman alloc];
  [myapp initMailman:"gmailman" :argc :argv];
  [myapp run];
  [myapp free];
  return 0;
}
