/*  ----------------------------------------------------------------------

    Copyright (C) 1998  Cesar Miquel  (miquel@df.uba.ar)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    ---------------------------------------------------------------------- */

#include <stdio.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <config.h>
#include <gnome.h>
#include "logview.h"
#include "log.xpm"
#include "logview.xpm"

#define ABOUT_WIDTH              340
#define ABOUT_HEIGHT             230

#define I_LIKE_GNOME_ABOUT


extern ConfigData *cfg;
static GtkWidget *about_window = NULL;
static GdkGC *gc = NULL;
static GdkPixmap *logviewpix = NULL, *logpix = NULL;

void
AboutCreatePixmaps(GdkWindow *window)
{
  GdkBitmap *mask;

  /* Log viewerimage */
  logviewpix = gdk_pixmap_create_from_xpm_d (window, &mask, NULL, logviewxpm);
  logpix = gdk_pixmap_create_from_xpm_d (window, &mask, NULL, logxpm);
}

void
AboutRepaint (GtkWidget *widget, gpointer data)
{
  GdkDrawable *canvas;
  char buffer[255];
  int i, y, h, w, skip;
  int column_x[] = {0, 100};
  int lm = 20;              /*  left margin */
  int numlines = 5;
  char *other_info[] = {
N_("This  program  is  part of  the  GNOME  project for  Linux."),
N_("Logview comes with ABSOLUTELY NO WARRANTY. This"),
N_("is free software, and you are welcome to redistribute it"),
N_("under the conditions of the GNU General Public Licence. The "),
N_("log icon is a courtesy of Tuomas Kuosmanen (a.k.a tigert).")};


  canvas = widget->window;
  if (canvas == NULL)
    return;
  if (gc == NULL)
    gc = gdk_gc_new (canvas);

  /* Erase page */
  gdk_window_clear (canvas);

  h = cfg->heading->descent + cfg->heading->ascent;
  w = gdk_string_measure (cfg->fixedb, "X");
  y = 80;

  /* Draw logview icon */
  gdk_draw_pixmap (canvas, gc, logviewpix, 
		   0,0,
		   lm, 10, 
		   113, 37);
  gdk_draw_pixmap (canvas, gc, logpix, 
		   0,0,
		   lm + ((column_x[1]-48)/2), y + (3*h-48)/2, 
		   48, 48);


  /* Draw title */
  gdk_gc_set_foreground (gc, &cfg->white);
  snprintf(buffer, 254, _("Version %s"), LOGVIEW_VERSION);
  gdk_draw_string (canvas, cfg->heading, gc, lm + column_x[1], y, buffer);
  y +=  h;
  gdk_draw_string (canvas, cfg->heading, gc, lm + column_x[1], y, _("Written by:"));
  y +=  h;
  gdk_draw_string (canvas, cfg->headingb, gc, lm + column_x[1], y, _("Cesar Miquel"));
  y +=  h;
  gdk_draw_string (canvas, cfg->heading, gc, lm + column_x[1], y, _("email:"));
  gdk_gc_set_foreground (gc, &cfg->gray50);
  skip = gdk_string_measure (cfg->heading, _("email: "));
  gdk_draw_string (canvas, cfg->heading, gc, lm + column_x[1] + skip, y, "miquel@df.uba.ar");

  y += h;
  h = cfg->small->descent + cfg->small->ascent;
  gdk_gc_set_foreground (gc, &cfg->white);
  for(i=0;i<numlines;i++)
    {
      y +=  h;
      gdk_draw_string (canvas, cfg->small, gc, lm + column_x[0], y, _(other_info[i]));
    }


}

void
AboutHideWindow ()
{
  if (about_window != NULL)
    {
      gtk_widget_unmap (about_window);
      gtk_widget_destroy (about_window);
      about_window = NULL;
    }
}

void
AboutClicked (GtkWidget *widget, gpointer data)
{
  AboutHideWindow ();
}

void
AboutShowWindow (GtkWidget *widget, gpointer user_data)
{
  GtkWidget *frame, *drawing_area;
  int w, h, x, y;

#ifdef I_LIKE_GNOME_ABOUT
  const char *author[] = {N_("Cesar Miquel (miquel@df.uba.ar)"), NULL};
  char *comments = N_("This  program  is  part of  the  GNOME  project " 
"for Linux. Logview comes with ABSOLUTELY NO WARRANTY. This is free " 
"software, and you are welcome to redistribute it under the conditions "
"of the GNU General Public Licence. The log icon is a courtesy of "
"Tuomas Kuosmanen (a.k.a tigert).");

  /* go get logview.xpm in $(prefix)/share/pixmaps/logview */
  about_window = gnome_about_new (_("Logview"), LOGVIEW_VERSION,
           			  N_("Copyright (C) 1998"),
				  author, _(comments),
				  "logview/logview.xpm");
  gtk_widget_show (about_window);
  return;
#endif
  
  about_window = gtk_window_new (GTK_WINDOW_POPUP); 
  w = ABOUT_WIDTH; h = ABOUT_HEIGHT;
  x = (gdk_screen_width ()  - w) / 2;
  y = (gdk_screen_height () - h) / 2;
                                          
  gtk_widget_set_usize (about_window, w, h);
  gtk_widget_set_uposition (about_window, x, y);
  gtk_container_border_width (GTK_CONTAINER (about_window), 3);       
  
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_container_border_width (GTK_CONTAINER (frame), 4);
  gtk_container_add (GTK_CONTAINER (about_window), frame);
  gtk_widget_show (frame);
  
  drawing_area = gtk_drawing_area_new ();
  gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK | 
			 GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect (GTK_OBJECT (drawing_area), "expose_event",
		      (GtkSignalFunc) AboutRepaint, drawing_area);
  gtk_signal_connect (GTK_OBJECT (drawing_area), "button_press_event",
		      (GtkSignalFunc) AboutClicked, drawing_area);
  
  /* Estimate size of window needed to display the calendar. */
  gtk_widget_set_style (drawing_area, cfg->black_bg_style);
  gtk_container_add (GTK_CONTAINER (frame), drawing_area);
  gtk_widget_show (drawing_area);

  if (logviewpix == NULL)
    AboutCreatePixmaps (drawing_area->window);

  gtk_widget_show (about_window);
  
}                           

