%
%  TeX mode for JED
%

%  This hook identifies lines containing TeX comments as paragraph separator

define tex_paragraph_separator ()
{
   bol();
   if (looking_at("\\")
       or (skip_white(), eolp())
       or looking_at("%"))  return(1);
   
   %
   %  look for comment
   %
   
   forever
     {
	!if (ffind("%")) return (0);
	go_left(1);
	if (what_char() != '\\') return (1);   %/* comment */
	go_right(2);
     }
} 

define tex_blink_dollar ()
{
   variable d;  d = "$";
   insert(d);
   POINT;
   go_left(1);
   if (bfind(d))
     {
	update(0);
	input_pending(10); pop();
     }
   POINT = ();
}

define tex_insert_quote ()
{
   variable c, l, r;
   l = char ('`');   r = char ('\'');
   

   if ((LAST_CHAR != '\'') and (LAST_CHAR != '"'))
     {
	insert(char(LAST_CHAR));
	return;
     }
   
   c = '[';
   !if (bolp())
     {
	go_left(1);
	c = what_char();
	go_right(1);
     }
   
   if (c == '\\')
     {
	insert (char(LAST_CHAR));
	return();
     }
   
   if (is_substr("[({\t ", char(c)))
     {
	insert (l);
	if (LAST_CHAR == '"') insert (l);
     }
   else
     {
	insert (r);
	if (LAST_CHAR == '"') insert (r);
     }
}

   
   
!if (keymap_p("TeX-Mode"))
{
   make_keymap ("TeX-Mode");
   definekey ("tex_insert_quote", "\"", "TeX-Mode");
   definekey ("tex_insert_quote", "'", "TeX-Mode");
   definekey ("tex_blink_dollar", "$", "TeX-Mode");
}

define tex_mode ()
{
   use_keymap ("TeX-Mode");
   setmode ("TeX", 1);
   set_paragraph_separator("tex_paragraph_separator");
}

