/* View file module for the Midnight Commander
   Copyright (C) 1994 Miguel de Icaza
   Copyright (C) 1994 Janne Kukonlehto
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */
#ifdef HAVE_UNISTD_H
#include <sys/types.h>
#include <unistd.h>
#endif
#include <stdio.h>
#include "mad.h"
#include "zip.h"

static char rcsid [] = "$Id: zip.c,v 1.5 1995/01/27 02:37:05 miguel Exp $";

#define CHECK(x) if (x == -1) return 0;

long get_small_endian_long (int fd)
{
    unsigned char a, b, c, d;

    /* It needs to be read one byte at the time to avoid endianess
       portability problems */
    CHECK (read (fd, &a, 1));
    CHECK (read (fd, &b, 1));
    CHECK (read (fd, &c, 1));
    CHECK (read (fd, &d, 1));
    return (d << 24) | (c << 16) | (b << 8) | a;
}

/* This function returns 0 if the file is not in gunzip format  */
/* or how much memory must be allocated to load the gziped file */
long int is_gunzipable (int fd)
{
     unsigned char magic [4];

    /* Read the magic signature */
    CHECK (read (fd, &magic [0], 1));
    CHECK (read (fd, &magic [1], 1));
    CHECK (read (fd, &magic [2], 1));
    CHECK (read (fd, &magic [3], 1));
    
    /* GZIP_MAGIC and OLD_GZIP_MAGIC */
    if (magic [0] == 037 && (magic [1] == 0213 || magic [1] == 0236)){
	/* Read the uncompressed size of the file */
	lseek (fd, -4, SEEK_END);
	return get_small_endian_long (fd);
    }

     /* PKZIP_MAGIC */
     if (magic [0] == 0120 && magic [1] == 0113 && magic [2] == 003 &&
	 magic [3] == 004){
	 /* Read compression type */
	 lseek (fd, 8, SEEK_SET);
	 CHECK (read (fd, &magic [0], 1));
	 CHECK (read (fd, &magic [1], 1));
	 /* Gzip can handle only deflated (8) or stored (0) files */
	 if ((magic [0] != 8 && magic [0] != 0) || magic [1] != 0)
	     return 0;
	 /* Read the uncompressed size of the first file in the archive */
	 lseek (fd, 22, SEEK_SET);
	 return get_small_endian_long (fd);
     }

     /* PACK_MAGIC and LZH_MAGIC and compress magic */
     if (magic [0] == 037 &&
	 (magic [1] ==  036 || magic [1] == 0240 || magic [1] == 0235)){
	 
	 /* In case the file is packed, sco lzhed or compress_magic, the */
	 /* program guesses that the uncompressed size is (at most) four */
	 /* times the length of the compressed size, if the compression  */
	 /* ratio is more than 4:1 the end of the file is not displayed  */
	 return 4*lseek (fd, 0, SEEK_END);
    }
    return 0;
}
