/* Configure box module for the Midnight Commander
   Copyright (C) 1994 Radek Doulik

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#include <string.h>
#include <stdio.h>
#include <ncurses.h>
#include "mad.h"
#include "win.h"
#include "color.h"
#include "input.h"
#include "dlg.h"
#include "widget.h"
#include "setup.h"		/* For save_setup() */
#include "dialog.h"		/* For do_refresh() */
#include "main.h"
#include "profile.h"		/* For sync_profiles */

/* Needed for the extern declarations of integer parameters */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#ifdef HAVE_UNISTD_H
    #include <unistd.h>
#endif
#include "dir.h"
#include "panel.h"		/* Needed for the externs */
#include "util.h"		/* Needed for the externs */
#include "file.h"

#define PX	5
#define PY	2

#define RX      5
#define RY      10

#define CX	5
#define CY	2

#define BX	15
#define BY	15

#define OX	34
#define OY	2

#define TX	36
#define TY	11


static WINDOW *conf_box;
static Dlg_head *conf_dlg;

static int r_but;

static chtype opt_colors[4];

static struct {
    char   *text;
    int    *variable;
    void   (*toggle_function)(void);
    WCheck *widget;
    int    hkey;
    int    hpos;
} check_options [] = {
   {"advanced chown",    &advanced_chfns,    toggle_advanced_chfns, 0, 0, -1 },
   {"8 bit clean",       &eight_bit_clean,   toggle_eight_bit,      0,'8',-1 },
   {"automount",         &auto_mount,        toggle_auto_mount,     0, 0, -1 },
   {"confirm Delete",    &confirm_delete,    toggle_confirm_delete, 0,'d',-1 },
   {"Use internal view", &use_internal_view, toggle_internal,       0,'u',-1 },
   {"auTo menus",        &auto_menu,         toggle_auto_menu,      0,'t',-1 },
   {"Auto save setup",   &auto_save_setup,   toggle_auto_save,      0,'a',-1 },
   {"shelL patterns",    &easy_patterns,     toggle_easy_patterns,  0,'l',-1 },
   {"Verbose operation", &verbose,           toggle_verbose,        0,'v',-1 },
   {"Fast dir reload",   &fast_reload,       toggle_fast_reload,    0,'f',-1 },
   {"Mix all files",     &mix_all_files,     toggle_mix_all_files,  0,'m',-1 },
   {"Drop down menus",   &drop_menus,        toggle_drop_menus,     0, 0, -1 },
   {"maRk moves down",   &mark_moves_down,   toggle_mark_move_down, 0,'r',-1 },
   {"show Hidden files", &show_dot_files,    toggle_show_hidden,    0,'h',-1 },
   {"show Backup files", &show_backups,      toggle_show_backup,    0,'b',-1 },
   { 0, 0, 0, 0 }
};

static WRadio *pause_radio;

static char *pause_options [3] = {
    "Never",
    "on dumb Terminals",
    "Always" };

static int configure_callback (struct Dlg_head *h, int Id, int Msg)
{
    switch (Msg) {
    case DLG_DRAW:
	wattrset (h->window, REVERSE_COLOR);
	wclr (conf_box);
	
	draw_box (h->window, 1, 2, 16, 62);
	draw_box (h->window, PY, PX, 8, 27);
	draw_box (h->window, OY, OX, 12, 27);
	draw_box (h->window, RY, RX, 5, 27);
	
	wattrset (h->window, COLOR_HOT_NORMAL);
	mvwprintw (h->window, 1, 24, " Configure options ");
	mvwprintw (h->window, PY, PX + 1, " Panel options ");
	mvwprintw (h->window, OY, OX + 1, " Other options ");
	mvwprintw (h->window, RY, RX + 1, " Pause after run... ");
	break;

    case DLG_END:
	r_but = Id;
	break;
    }
    return 0;
}

static void init_configure (void)
{
    int i;

#ifdef BUGGY_CURSES		/* See key.c: mi_getch /BUGGY_CURSES/ */
    touchwin (stdscr);
#endif

    opt_colors [0] = COLOR_NORMAL;
    opt_colors [1] = COLOR_FOCUS;
    opt_colors [2] = COLOR_HOT_NORMAL;
    opt_colors [3] = COLOR_HOT_FOCUS;
    conf_box = centerwin (18, 66);
    conf_dlg = dlg_new (conf_box, opt_colors, configure_callback,
			winpos (18, 66), "[Options Menu]");
    
#if 0
    wattrset (conf_box, SELECTED_COLOR);
    mvwprintw (conf_box, TY, TX, "Use SPACE to change");
    mvwprintw (conf_box, TY + 1, TX, "an option and ARROW KEYS");
    mvwprintw (conf_box, TY + 2, TX, "to move between options");
#endif
    
    add_widget (conf_dlg,
		button_new (BY, BX+26, B_CANCEL, "[ Cancel ]",'c',2, 0, 0));
    add_widget (conf_dlg,
		button_new (BY, BX+12, B_EXIT,   "[ Save ]",'s',2, 0, 0));
    add_widget (conf_dlg,
		button_new (BY, BX,    B_ENTER,  "[[ Ok ]]",'o',3, 0, 0));

#define XTRACT(i) *check_options[i].variable, check_options[i].text,                             check_options[i].hkey, check_options[i].hpos

    /* Add all the checkboxes */
    for (i = 0; i < 9; i++){
	check_options [i].widget = check_new (OY + (9-i), OX+2, XTRACT(i)); 
	add_widget (conf_dlg, check_options [i].widget);
    }

    pause_radio = radio_new (RY+1, RX+1, 3, pause_options, 1);
    pause_radio->sel = pause_after_run;
    add_widget (conf_dlg, pause_radio);
    
    for (i = 0; i < 6; i++){
	check_options [i+9].widget = check_new (PY + (6-i), PX+2,
						 XTRACT(i+9));
	add_widget (conf_dlg, check_options [i+9].widget);
    }

    wrefresh (conf_box);
}


void configure_box (void)
{
    int result, i;

    init_configure ();
    run_dlg (conf_dlg);

    result = conf_dlg->ret_value;
    if (result == B_ENTER || result == B_EXIT){
	for (i = 0; check_options [i].text; i++)
	    if (check_options [i].widget->state & C_CHANGE)
		(*check_options [i].toggle_function)();
	pause_after_run = pause_radio->sel;
    }

    /* If they pressed the save button */
    if (result == B_EXIT){
	save_configure ();
	sync_profiles ();
    }

    destroy_dlg (conf_dlg);
    delwin (conf_box);
    do_refresh ();
}
