#define MAXMENU 15
#define MAXQUERY 10

/* Must be powers of 2 (they are bit flags) */
#define BAR_ERROR      0x1
#define BAR_FILL       0x2
#define BAR_NO_REFRESH 0x4
typedef void (*callfn) ();
/* FIXME: We have to leave this type ambiguous, because `callfn' is
   used both for functions that take an argument and ones that don't.
   That ought to be cleared up. */

typedef struct {
    char *text;
    int  hot_key;
    callfn call_back;
} menu_entry;

typedef struct {
    char   *name;
    int    count;
    int    max_entry_len;
    int    selected;
    WINDOW *win;
    menu_entry *entries;
} Menu;

Menu *create_menu (char *name, menu_entry *entries, int count);
void add_menu_entry (Menu *menu, char *txt, int hot_key, callfn fn);
int run_menu (Menu *, int, int);
int run_bar (WINDOW *, int x, int y, int width, int space, int items,
	     int first_selected, Menu *Menus [], int flags, int, int);
