/* Some misc dialog boxes for the program.
   
   Copyright (C) 1994 Miguel de Icaza
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <ncurses.h>
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <malloc.h>
#include "global.h"
#include "mad.h"
#include "win.h"
#include "input.h"
#include "color.h"
#include "dlg.h"
#include "widget.h"
#include "dialog.h"     /* For do_refresh() */
#include "wtools.h"

#include "dir.h"
#include "panel.h"
#include "boxes.h"

#define DISPLAY_X  46
#define DISPLAY_Y  15

static chtype colors [4];

static WINDOW   *display_win;
static Dlg_head *dd;
static WInput *user;
static WInput *status;
static WCheck *check_status;
static int current_mode;

#define VIEW_TYPES 7

static char *displays [VIEW_TYPES] = {
    "[ Full file list ]", "[ Brief file list ]", "[ Long file list ]",
    "[ Info about files ]", "[ Tree of directories ]",
    "[ Quick view of files ]", "[ User: "
};

static int display_callback (struct Dlg_head *h, int id, int Msg)
{
    switch (Msg){
    case DLG_DRAW:
	wattrset (h->window, REVERSE_COLOR);
	wclr (display_win);
	draw_box (h->window, 1, 1, DISPLAY_Y-2, DISPLAY_X-2);
	mvwprintw (h->window, 9, 41, "]");
	wattrset (h->window, COLOR_HOT_NORMAL);
	mvwprintw (h->window, 1, 2, " Display mode ");
	mvwaddch (h->window, 3+current_mode, 3, '*');
	break;
	
    case DLG_KEY:
	if (id == '\n' && (WInput *) h->current->widget == user){
	    h->running = 0;
	    h->ret_value = B_USER + 6;
	    break;
	}
	if (id == '\n' && (WInput *) h->current->widget == status){
	    h->running = 0;
	    h->ret_value = B_USER + 7;
	    break;
	}
	if ((id|0x20) == 'u' && h->current->widget != (Widget *) user
	    && h->current->widget != (Widget *) status){
	    dlg_select_widget (h, user);
	    return 1;
	}
    }
    return 0;
}

static void display_init (int radio_sel, char *init_text,
			  int _check_status, char *_status)
{
    int i;
    
#ifdef BUGGY_CURSES		/* See key.c: mi_getch /BUGGY_CURSES/ */
    touchwin (stdscr);
#endif

    init_box_colors (colors);
    display_win = centerwin (DISPLAY_Y, DISPLAY_X);
    dd = dlg_new (display_win, colors, display_callback, 
		  winpos (DISPLAY_Y, DISPLAY_X), "[Left and Right Menus]");

    add_widget (dd, button_new (3, 32, B_CANCEL, "[ Cancel ]", 'c', 2, 0, 0));

    status = input_new (display_win, 12, 8, NORMAL_COLOR, 34, _status);
    input_set_point (status->in, 0);
    add_widget (dd, status);

    check_status = check_new (11, 4, _check_status, "user Mini status",'m', 5);
    add_widget (dd, check_status);

    user = input_new  (display_win, 9, 14, NORMAL_COLOR, 26, init_text);
    input_set_point (user->in, 0);
    add_widget (dd, user);

    for (i = VIEW_TYPES-1; i >= 0; i--){
	add_widget (dd, button_new (3+i, 4, B_USER+i, displays [i],
				    displays [i][2], 2, 0, 0));
    }
}

int display_box (Panel *panel)
{
    int result;

    current_mode = panel->view_type;
    display_init (panel->view_type, panel->user_format,
		  panel->user_mini_status, panel->mini_status_format);
    run_dlg (dd);

    result = -1;
    
    if (dd->ret_value != B_CANCEL && dd->ret_value >= B_USER){
	result = dd->ret_value - B_USER;
	free (panel->user_format);
	panel->user_format = strdup (user->in->buffer);
	free (panel->mini_status_format);
	panel->mini_status_format = strdup (status->in->buffer);
	panel->user_mini_status = check_status->state & C_BOOL;
    }
    if (result == 7)
	result = panel->view_type;

    destroy_dlg (dd);
    delwin (display_win);
    do_refresh ();

    return result;
}

#define SORT_X 40
#define SORT_Y 13

static int sort_callback (struct Dlg_head *h, int id, int Msg)
{
    switch (Msg){
    case DLG_DRAW:
	wattrset (h->window, REVERSE_COLOR);
	wclr (display_win);
	draw_box (h->window, 1, 1, SORT_Y-2, SORT_X-2);
	mvwaddch (h->window, 4+current_mode, 3, '*');
	wattrset (h->window, SELECTED_COLOR);
	wattrset (h->window, COLOR_HOT_NORMAL);
	mvwprintw (h->window, 1, 2, " Sort order ");
	break;
    }
    return 0;
}

sortfn *sort_box (sortfn *sort_fn, int *reverse)
{
    int i, r;
    sortfn *result;
    char txt [30];
    WCheck *c;
    
    result = 0;
    
#ifdef BUGGY_CURSES		/* See key.c: mi_getch /BUGGY_CURSES/ */
    touchwin (stdscr);
#endif

    for (i = 0; i < SORT_TYPES; i++)
	if ((sortfn *) (sort_orders [i].sort_fn) == sort_fn){
	    current_mode = i;
	    break;
	}
    
    init_box_colors (colors);
    display_win = centerwin (SORT_Y, SORT_X);
    dd = dlg_new (display_win, colors, sort_callback,
		  winpos (SORT_Y, SORT_X), "[Left and Right Menus]");

    add_widget (dd, button_new (6, 25, B_CANCEL, "[ Cancel ]", 'c', 2, 0, 0));

    c = check_new (4, 25, *reverse, "Reverse", 'r', 0);
    add_widget (dd, c);
    
    for (i = SORT_TYPES-1; i >= 0; i--){
	sprintf (txt, "[ %s ]", sort_orders [i].sort_name);
	add_widget (dd, button_new (4+i, 4, B_USER+i, txt, txt [2], 2, 0, 0));
    }
    run_dlg (dd);

    r = dd->ret_value;
    if (r == B_ENTER || r >= B_USER){
	if (r != B_ENTER)
	    result = (sortfn *) sort_orders [dd->ret_value-B_USER].sort_fn;
	else
	    result = sort_fn;
	*reverse = c->state & C_BOOL;
    }
    destroy_dlg (dd);
    delwin (display_win);
    do_refresh ();

    return result;
}
    
