C RAPPL1- SPECIAL PURPOSE ROOM ROUTINES, PART 1
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
       LOGICAL FUNCTION RAPPL1(RI)
       IMPLICIT INTEGER (A-Z)
       LOGICAL QOPEN,QON,QHERE,PROB,F
       LOGICAL MOVETO,LIT
C
C PARSER OUTPUT
C
       LOGICAL PRSWON
       COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
       LOGICAL TELFLG
       COMMON /PLAY/ WINNER,HERE,TELFLG
       COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
     1       LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C SCREEN OF LIGHT
C
       COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
       COMMON /SCREEN/ SCOLDR(8),SCOLWL(12)
C
C MISCELLANEOUS VARIABLES
C
       COMMON /BATS/ BATDRP(9)
C
C ROOMS
C
       COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     1       RACTIO(200),RVAL(200),RFLAG(200)
C
       COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
     1       RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
C
       COMMON /RINDEX/ WHOUS,LROOM,CELLA
       COMMON /RINDEX/ MTROL,MAZE1
       COMMON /RINDEX/ MGRAT,MAZ15
       COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
       COMMON /RINDEX/ STREA,EGYPT,ECHOR
       COMMON /RINDEX/ TSHAF
       COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
       COMMON /RINDEX/ CAROU
       COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
       COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
       COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
       COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
       COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
       COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
       COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
       COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
       COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
       COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
       COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
       COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C OBJECTS
C
       COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     1       OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     2       OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     3       OADV(220),OCAN(220),OREAD(220)
C
       COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
     1       NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
     2       TOOLBT,TURNBT,ONBT
       COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
     1       WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
     2       TCHBT,VEHBT,SCHBT
C
       COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
       COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
       COMMON /OINDEX/       LEAVE,TROLL,AXE
       COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
       COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
       COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
       COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
       COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
       COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
       COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
       COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
       COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
       COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
       COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
       COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
       COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
       COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
       COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
       COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
       COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
       COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
       COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C CLOCK INTERRUPTS
C
       LOGICAL CFLAG
       COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
       COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
     1       CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
     2       CEVGNO,CEVBUC,CEVSPH,CEVEGH,
     3       CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
     5       CEVMRS,CEVPIN,CEVINQ,CEVFOL
 
C
       LOGICAL THFFLG,THFACT,SWDACT
       COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
C
C ADVENTURERS
C
       COMMON /ADVS/ ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
     1       AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
C
       COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
       COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
       COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
       COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
       COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
       COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
       COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
       COMMON /VINDEX/OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
       COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
       COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
       COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
       COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
       COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
       COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
       LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
       LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
       LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
       LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
       LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
       LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
       LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
       LOGICAL FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     1       DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     2       MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     3       EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     4       GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     5       GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     6       MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     7       FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ BTIEF,BINFF
       COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
       COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
       COMMON /FINDEX/ MDIR,MLOC,POLEUF
       COMMON /FINDEX/ QUESNO,NQATT,CORRCT
       COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
       QOPEN(R)=ZAND(OFLAG2(R),OPENBT).NE.0
       QON(R)=ZAND(OFLAG1(R),ONBT).NE.0
C RAPPL1, PAGE 2
C
       RAPPL1=.TRUE.
C USUALLY IGNORED.
       IF(RI.EQ.0) RETURN
C RETURN IF NAUGHT.
C
C SET TO FALSE FOR
C
C NEW DESC NEEDED.
       GO TO (1000,2000,3000,4000,5000,6000,7000,8000,9000,10000,
     1 11000,12000,13000,14000,15000,16000,17000,18000,19000,20000,
     2 21000,22000,23000,24000,25000,26000,27000,28000,29000,30000,
     3 31000,32000,33000,34000,35000,36000,37000),RI
       CALL BUG(1,RI)
C
C R1--       EAST OF HOUSE.  DESCRIPTION DEPENDS ON STATE OF WINDOW
C
1000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=13
C ASSUME CLOSED.
       IF(QOPEN(WINDO)) I=12
C IF OPEN, AJAR.
       CALL RSPSUB(11,I)
C DESCRIBE.
       RETURN
C
C R2--       KITCHEN.  SAME VIEW FROM INSIDE.
C
2000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=13
C ASSUME CLOSED.
       IF(QOPEN(WINDO)) I=12
C IF OPEN, AJAR.
       CALL RSPSUB(14,I)
C DESCRIBE.
       RETURN
C
C R3--       LIVING ROOM.  DESCRIPTION DEPENDS ON MAGICF (STATE OF
C       DOOR TO CYCLOPS ROOM), RUG (MOVED OR NOT), DOOR (OPEN OR CLOSED)
C
3000       IF(PRSA.NE.LOOKW) GO TO 3500
C LOOK?
       I=15
C ASSUME NO HOLE.
       IF(MAGICF) I=16
C IF MAGICF, CYCLOPS HOLE.
       CALL RSPEAK(I)
C DESCRIBE.
       I=17+ORRUG
C ASSUME INITIAL STATE.
       IF(QOPEN(DOOR)) I=I+2
C DOOR OPEN?
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C       NOT A LOOK WORD.  REEVALUATE TROPHY CASE.
C
3500       IF((PRSA.NE.TAKEW).AND.((PRSA.NE.PUTW).OR.(PRSI.NE.TCASE)))
     1       RETURN
C IF NOT TAKE OR PUT.
       ASCORE(WINNER)=RWSCOR
C SCORE TROPHY CASE.
       DO 3600 I=1,OLNT
C RETAIN RAW SCORE AS WELL.
         J=I
C FIND OUT IF IN CASE.
3550         J=OCAN(J)
C TRACE OWNERSHIP.
         IF(J.EQ.0) GO TO 3600
         IF(J.NE.TCASE) GO TO 3550
C DO ALL LEVELS.
         ASCORE(WINNER)=ASCORE(WINNER)+OTVAL(I)
3600       CONTINUE
       CALL SCRUPD(0)
C SEE IF ENDGAME TRIG.
       RETURN
C RAPPL1, PAGE 3
C
C R4--       CELLAR.  SHUT DOOR AND BAR IT IF HE JUST WALKED IN.
C
4000       IF(PRSA.NE.LOOKW) GO TO 4500
C LOOK?
       CALL RSPEAK(21)
C DESCRIBE CELLAR.
       RETURN
C
4500       IF(PRSA.NE.WALKIW) RETURN
C WALKIN?
       IF(ZAND(OFLAG2(DOOR),(OPENBT+TCHBT)).NE.OPENBT) RETURN
       OFLAG2(DOOR)=ZAND(ZOR(OFLAG2(DOOR),TCHBT), ZNOT(OPENBT))
       CALL RSPEAK(22)
C SLAM AND BOLT DOOR.
       RETURN
C
C R5--       MAZE11.  DESCRIBE STATE OF GRATING.
C
5000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(23)
C DESCRIBE.
       I=24
C ASSUME LOCKED.
       IF(GRUNLF) I=26
C UNLOCKED?
       IF(QOPEN(GRATE)) I=25
C OPEN?
       CALL RSPEAK(I)
C DESCRIBE GRATE.
       RETURN
C
C R6--       CLEARING.  DESCRIBE CLEARING, MOVE LEAVES.
C
6000       IF(PRSA.NE.LOOKW) GO TO 6500
C LOOK?
       CALL RSPEAK(27)
C DESCRIBE.
       IF(RVCLR.EQ.0) RETURN
C LEAVES MOVED?
       I=28
C YES, ASSUME GRATE CLOSED.
       IF(QOPEN(GRATE)) I=29
C OPEN?
       CALL RSPEAK(I)
C DESCRIBE GRATE.
       RETURN
C
6500       IF((RVCLR.NE.0).OR.(QHERE(LEAVE,CLEAR).AND.
     1       ((PRSA.NE.MOVEW).OR.(PRSO.NE.LEAVE)))) RETURN
       CALL RSPEAK(30)
C MOVE LEAVES, REVEAL GRATE.
       RVCLR=1
C INDICATE LEAVES MOVED.
       RETURN
C RAPPL1, PAGE 4
C
C R7--       RESERVOIR SOUTH.  DESCRIPTION DEPENDS ON LOW TIDE FLAG.
C
7000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=31
C ASSUME FULL.
       IF(LWTIDF) I=32
C IF LOW TIDE, EMPTY.
       CALL RSPEAK(I)
C DESCRIBE.
       CALL RSPEAK(33)
C DESCRIBE EXITS.
       RETURN
C
C R8--       RESERVOIR.  STATE DEPENDS ON LOW TIDE FLAG.
C
8000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=34
C ASSUME FULL.
       IF(LWTIDF) I=35
C IF LOW TIDE, EMTPY.
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R9--       RESERVOIR NORTH.  ALSO DEPENDS ON LOW TIDE FLAG.
C
9000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=36
C YOU GET THE IDEA.
       IF(LWTIDF) I=37
       CALL RSPEAK(I)
       CALL RSPEAK(38)
       RETURN
C
C R10--       GLACIER ROOM.  STATE DEPENDS ON MELTED, VANISHED FLAGS.
C
10000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(39)
C BASIC DESCRIPTION.
       I=0
C ASSUME NO CHANGES.
       IF(GLACMF) I=40
C PARTIAL MELT?
       IF(GLACRF) I=41
C COMPLETE MELT?
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R11--       FOREST ROOM
C
11000       IF(PRSA.EQ.WALKIW) CFLAG(CEVFOR)=.TRUE.
C IF WALK IN, BIRDIE.
       RETURN
C
C R12--       MIRROR ROOM.  STATE DEPENDS ON MIRROR INTACT.
C
12000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(42)
C DESCRIBE.
       IF(MIRRMF) CALL RSPEAK(43)
C IF BROKEN, NASTY REMARK.
       RETURN
C RAPPL1, PAGE 5
C
C R13--       CAVE2 ROOM.  BLOW OUT CANDLES WITH 50% PROBABILITY.
C
13000       IF(PRSA.NE.WALKIW) RETURN
C WALKIN?
       IF(PROB(50,50).OR.(OADV(CANDL).NE.WINNER).OR.
     1       .NOT.QON(CANDL)) RETURN
C BLOW EM OUT?
       OFLAG1(CANDL)=ZAND(OFLAG1(CANDL),ZNOT( ONBT))
C YES.
       CALL RSPEAK(47)
C TELL OF WINDS.
       CFLAG(CEVCND)=.FALSE.
C HALT CANDLE COUNTDOWN.
       RETURN
C
C R14--       BOOM ROOM.  BLOW HIM UP IF CARRYING FLAMING OBJECT.
C
14000       J=ODESC2(CANDL)
C ASSUME CANDLE.
       IF((OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 14100
       J=ODESC2(TORCH)
C ASSUME TORCH.
       IF((OADV(TORCH).EQ.WINNER).AND.QON(TORCH)) GO TO 14100
       J=ODESC2(MATCH)
       IF((OADV(MATCH).EQ.WINNER).AND.QON(MATCH)) GO TO 14100
       RETURN
C SAFE
C
14100       IF(PRSA.NE.TRNONW) GO TO 14200
C TURN ON?
       CALL RSPSUB(294,J)
C BOOM
C 
       CALL JIGSUP(44)
       RETURN
C
14200       IF(PRSA.NE.WALKIW) RETURN
C WALKIN?
       CALL RSPSUB(295,J)
C BOOM
C 
       CALL JIGSUP(44)
       RETURN
C
C R15--       NO-OBJS.  SEE IF EMPTY HANDED, SCORE LIGHT SHAFT.
C
15000       EMPTHF=.TRUE.
C ASSUME TRUE.
       DO 15100 I=1,OLNT
C SEE IF CARRYING.
         IF(OADV(I).EQ.WINNER) EMPTHF=.FALSE.
15100       CONTINUE
C
       IF((HERE.NE.BSHAF).OR.(.NOT.LIT(HERE))) RETURN
       CALL SCRUPD(LTSHFT)
C SCORE LIGHT SHAFT.
       LTSHFT=0
C NEVER AGAIN.
       RETURN
C RAPPL1, PAGE 6
C
C R16--       MACHINE ROOM.  DESCRIBE MACHINE.
C
16000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
C ASSUME LID CLOSED.
       IF(QOPEN(MACHI)) I=12
C IF OPEN, OPEN.
       CALL RSPSUB(45,I)
C DESCRIBE.
       RETURN
C
C R17--       BAT ROOM.  UNLESS CARRYING GARLIC, FLY AWAY WITH ME...
C
17000       IF(PRSA.NE.LOOKW) GO TO 17500
C LOOK?
       CALL RSPEAK(48)
C DESCRIBE ROOM.
       IF(OADV(GARLI).EQ.WINNER) CALL RSPEAK(49) 
C BAT HOLDS NOSE.
       RETURN
C
17500       IF((PRSA.NE.WALKIW).OR.(OADV(GARLI).EQ.WINNER)) RETURN
       CALL RSPEAK(50)
C TIME TO FLY, JACK.
       F=MOVETO(BATDRP(ZRND(9)+1),WINNER)
C SELECT RANDOM DEST.
       RAPPL1=.FALSE.
C INDICATE NEW DESC NEEDED.
       RETURN
C
C R18--       DOME ROOM.  STATE DEPENDS ON WHETHER ROPE TIED TO RAILING.
C
18000       IF(PRSA.NE.LOOKW) GO TO 18500
C LOOK?
       CALL RSPEAK(51)
C DESCRIBE.
       IF(DOMEF) CALL RSPEAK(52)
C IF ROPE, DESCRIBE.
       RETURN
C
18500       IF(PRSA.EQ.LEAPW) CALL JIGSUP(53)
C DID HE JUMP???
       RETURN
C
C R19--       TORCH ROOM.  ALSO DEPENDS ON WHETHER ROPE TIED TO RAILING.
C
19000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(54)
C DESCRIBE.
       IF(DOMEF) CALL RSPEAK(55)
C IF ROPE, DESCRIBE.
       RETURN
C
C R20--       CAROUSEL ROOM.  SPIN HIM OR KILL HIM.
C
20000       IF(PRSA.NE.LOOKW) GO TO 20500
C LOOK?
       CALL RSPEAK(56)
C DESCRIBE.
       IF(.NOT.CAROFF) CALL RSPEAK(57)
C IF NOT FLIPPED, SPIN.
       RETURN
C
20500       IF((PRSA.EQ.WALKIW).AND.CAROZF) CALL JIGSUP(58)
C WALKED IN.
       RETURN
C RAPPL1, PAGE 7
C
C R21--       LLD ROOM.  HANDLE EXORCISE, DESCRIPTIONS.
C
21000       IF(PRSA.NE.LOOKW) GO TO 21500
C LOOK?
       CALL RSPEAK(59)
C DESCRIBE.
       IF(.NOT.LLDF) CALL RSPEAK(60)
C IF NOT VANISHED, GHOSTS.
       RETURN
C
21500       IF(PRSA.NE.EXORCW) RETURN
C EXORCISE?
       IF((OADV(BELL).EQ.WINNER).AND.(OADV(BOOK).EQ.WINNER).AND.
     1       (OADV(CANDL).EQ.WINNER).AND.QON(CANDL)) GO TO 21600
       CALL RSPEAK(62)
C NOT EQUIPPED.
       RETURN
C
21600       IF(QHERE(GHOST,HERE)) GO TO 21700
C GHOST HERE?
       CALL JIGSUP(61)
C NOPE, EXORCISE YOU.
       RETURN
C
21700       CALL NEWSTA(GHOST,63,0,0,0)
C VANISH GHOST.
       LLDF=.TRUE.
C OPEN GATE.
       RETURN
C
C R22--       LLD2-ROOM.  IS HIS HEAD ON A POLE?
C
22000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(64)
C DESCRIBE.
       IF(ONPOLF) CALL RSPEAK(65)
C ON POLE?
       RETURN
C
C R23--       DAM ROOM.  DESCRIBE RESERVOIR, PANEL.
C
23000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(66)
C DESCRIBE.
       I=67
       IF(LWTIDF) I=68
       CALL RSPEAK(I)
C DESCRIBE RESERVOIR.
       CALL RSPEAK(69)
C DESCRIBE PANEL.
       IF(GATEF) CALL RSPEAK(70)
C BUBBLE IS GLOWING.
       RETURN
C
C R24--       TREE ROOM
C
24000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(660)
C DESCRIBE.
       I=661
C SET FLAG FOR BELOW.
       DO 24200 J=1,OLNT
C DESCRIBE OBJ IN FORE3.
         IF(.NOT.QHERE(J,FORE3).OR.(J.EQ.FTREE)) GO TO 24200
         CALL RSPEAK(I)
C SET STAGE,
         I=0
         CALL RSPSUB(502,ODESC2(J))
C DESCRIBE.
24200       CONTINUE
       RETURN
C RAPPL1, PAGE 8
C
C R25--       CYCLOPS-ROOM.  DEPENDS ON CYCLOPS STATE, ASLEEP FLAG, MAGIC FLAG.
C
25000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(606)
C DESCRIBE.
       I=607
C ASSUME BASIC STATE.
       IF(RVCYC.GT.0) I=608
C >0?  HUNGRY.
       IF(RVCYC.LT.0) I=609
C <0?  THIRSTY.
       IF(CYCLOF) I=610
C ASLEEP?
       IF(MAGICF) I=611
C GONE?
       CALL RSPEAK(I)
C DESCRIBE.
       IF(.NOT.CYCLOF .AND.(RVCYC.NE.0))
     1       CALL RSPEAK(193+IABS(RVCYC))
C CYCLOPS IS ANNOYED.
       RETURN
C
C R26--       BANK BOX ROOM.
C
26000       IF(PRSA.NE.WALKIW) RETURN
C SURPRISE HIM.
       DO 26100 I=1,8,2
C SCOLRM DEPENDS ON
         IF(FROMDR.EQ.SCOLDR(I)) SCOLRM=SCOLDR(I+1)
26100       CONTINUE
C ENTRY DIRECTION.
       RETURN
C
C R27--       TREASURE ROOM.
C
27000       IF((PRSA.NE.WALKIW).OR. .NOT.THFACT)
     1       RETURN
C WALKIN, THIEF ACTIVE?
       IF(OROOM(THIEF).NE.HERE)
     1       CALL NEWSTA(THIEF,82,HERE,0,0)
C NO, MATERIALIZE HIM.
       THFPOS=HERE
C RESET SEARCH PATTERN.
       OFLAG2(THIEF)=ZOR(OFLAG2(THIEF),FITEBT)
C HE'S ANGRY.
       IF(OROOM(CHALI).EQ.HERE)
     1       OFLAG1(CHALI)=ZAND(OFLAG1(CHALI),ZNOT(TAKEBT))
C
C       VANISH EVERYTHING IN ROOM
C
       J=0
C ASSUME NOTHING TO VANISH.
       DO 27200 I=1,OLNT
         IF((I.EQ.CHALI).OR.(I.EQ.THIEF).OR..NOT.QHERE(I,HERE))
     1       GO TO 27200
C HERE?
         J=83
C FLAG BYEBYE.
         OFLAG1(I)=ZAND(OFLAG1(I),ZNOT(VISIBT))
C AWAY IT GOES.
27200       CONTINUE
       CALL RSPEAK(J)
C DESCRIBE.
       RETURN
C
C R28--       CLIFF FUNCTION.  SEE IF CARRYING INFLATED BOAT.
C
28000       DEFLAF=OADV(RBOAT).NE.WINNER
C TRUE IF NOT CARRYING.
       RETURN
C RAPPL1, PAGE 9
C
C R29--       RIVR4 ROOM.  PLAY WITH BUOY.
C
29000       IF(.NOT.BUOYF.OR.(OADV(BUOY).NE.WINNER)) RETURN
       CALL RSPEAK(84)
C GIVE HINT,
       BUOYF=.FALSE.
C THEN DISABLE.
       RETURN
C
C R30--       OVERFALLS.  DOOM.
C
30000       IF(PRSA.NE.LOOKW) CALL JIGSUP(85)
C OVER YOU GO.
       RETURN
C
C R31--       BEACH ROOM.  DIG A HOLE.
C
31000       IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
       RVSND=RVSND+1
C INCREMENT DIG STATE.
       GO TO (31100,31100,31100,31400,31500),RVSND 
C PROCESS STATE.
       CALL BUG(2,RVSND)
C
31100       CALL RSPEAK(85+RVSND)
C 1-3... DISCOURAGE HIM.
       RETURN
C
31400       I=89
C ASSUME DISCOVERY.
       IF(ZAND(OFLAG1(STATU),VISIBT).NE.0) I=88 
C ALREADY DONE.
       CALL RSPEAK(I)
       OFLAG1(STATU)=ZOR(OFLAG1(STATU),VISIBT)
C MATERIALIZE STATUE.
       RETURN
C
31500       RVSND=0
C 5... SAND COLLAPSES
       CALL JIGSUP(90)
C AND SO DOES HE.
       RETURN
C
C R32--       TCAVE ROOM.  DIG A HOLE IN GUANO.
C
32000       IF((PRSA.NE.DIGW).OR.(PRSO.NE.SHOVE)) RETURN
       I=91
C ASSUME NO GUANO.
       IF(.NOT. QHERE(GUANO,HERE)) GO TO 32100
C IS IT HERE?
       RVGUA=MIN0(4,RVGUA+1)
C YES, SET NEW STATE.
       I=91+RVGUA
C GET NASTY REMARK.
32100       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R33--       FALLS ROOM
C
33000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(96)
C DESCRIBE.
       I=97
C ASSUME NO RAINBOW.
       IF(RAINBF) I=98
C GOT ONE?
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C RAPPL1, PAGE 10
C
C R34--       LEDGE FUNCTION.  LEDGE CAN COLLAPSE.
C
34000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(100)
C DESCRIBE.
       I=102
C ASSUME SAFE ROOM OK.
       IF(ZAND(RFLAG(MSAFE),RMUNG).NE.0) I=101
C IF MUNGED, ROOM GONE.
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R35--       SAFE ROOM.  STATE DEPENDS ON WHETHER SAFE BLOWN.
C
35000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(104)
C DESCRIBE.
       I=105
C ASSUME OK.
       IF(SAFEF) I=106
C BLOWN?
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R36--       MAGNET ROOM.  DESCRIBE, CHECK FOR SPINDIZZY DOOM.
C
36000       IF(PRSA.NE.LOOKW) GO TO 36500
C LOOK?
       CALL RSPEAK(107)
C DESCRIBE.
       RETURN
C
36500       IF((PRSA.NE.WALKIW).OR. .NOT.CAROFF) RETURN
C WALKIN ON FLIPPED?
       IF(CAROZF) GO TO 36600
C ZOOM?
       CALL RSPEAK(108)
C NO, SPIN HIS COMPASS.
       RETURN
C
36600       I=58
C SPIN HIS INSIDES.
       IF(WINNER.NE.PLAYER) I=99
C SPIN ROBOT.
       CALL JIGSUP(I)
C DEAD.
       RETURN
C
C R37--       CAGE ROOM.  IF SOLVED CAGE, MOVE TO OTHER CAGE ROOM.
C
37000       IF(CAGESF) F=MOVETO(CAGER,WINNER)
C IF SOLVED, MOVE.
       RETURN
C
       END
C RAPPL2- SPECIAL PURPOSE ROOM ROUTINES, PART 2
C
C COPYRIGHT 1980, INFOCOM COMPUTERS AND COMMUNICATIONS, CAMBRIDGE MA. 02142
C ALL RIGHTS RESERVED, COMMERCIAL USAGE STRICTLY PROHIBITED
C WRITTEN BY R. M. SUPNIK
C
C DECLARATIONS
C
       LOGICAL FUNCTION RAPPL2(RI)
       IMPLICIT INTEGER (A-Z)
       LOGICAL QOPEN,QHERE,F
C
C PARSER OUTPUT
C
       LOGICAL PRSWON
       COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
C
C GAME STATE
C
       LOGICAL TELFLG
       COMMON /PLAY/ WINNER,HERE,TELFLG
       COMMON /STATE/ MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
     1       LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
C
C MISCELLANEOUS VARIABLES
C
       COMMON /CHAN/ INPCH,OUTCH,DBCH,ZRECL
C
C ROOMS
C
       COMMON /ROOMS/ RLNT,RDESC2,RDESC1(200),REXIT(200),
     1       RACTIO(200),RVAL(200),RFLAG(200)
C
       COMMON /RFLAG/ RSEEN,RLIGHT,RLAND,RWATER,RAIR,
     1       RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
C
       COMMON /RINDEX/ WHOUS,LROOM,CELLA
       COMMON /RINDEX/ MTROL,MAZE1
       COMMON /RINDEX/ MGRAT,MAZ15
       COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
       COMMON /RINDEX/ STREA,EGYPT,ECHOR
       COMMON /RINDEX/ TSHAF
       COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
       COMMON /RINDEX/ CAROU
       COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
       COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
       COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
       COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
       COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
       COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
       COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
       COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
       COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
       COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
       COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
       COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C OBJECTS
C
       COMMON /OBJCTS/ OLNT,ODESC1(220),ODESC2(220),ODESCO(220),
     1       OACTIO(220),OFLAG1(220),OFLAG2(220),OFVAL(220),
     2       OTVAL(220),OSIZE(220),OCAPAC(220),OROOM(220),
     3       OADV(220),OCAN(220),OREAD(220)
C
       COMMON /OFLAGS/ VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
     1       NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
     2       TOOLBT,TURNBT,ONBT
       COMMON /OFLAGS/ FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
     1       WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
     2       TCHBT,VEHBT,SCHBT
C
       COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
       COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
       COMMON /OINDEX/       LEAVE,TROLL,AXE
       COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
       COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
       COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
       COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
       COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
       COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
       COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
       COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
       COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
       COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
       COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
       COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
       COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
       COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
       COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
       COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
       COMMON /OINDEX/ WARNI,CSLIT,GCARD,STLDR
       COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
       COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
C
C EXITS
C
       COMMON /XSRCH/ XMIN,XMAX,XDOWN,XUP,
     1       XNORTH,XSOUTH,XENTER,XEXIT,XEAST,XWEST
C
C CLOCK INTERRUPTS
C
       LOGICAL CFLAG
       COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
C
       COMMON /CINDEX/ CEVCUR,CEVMNT,CEVLNT,CEVMAT,CEVCND,
     1       CEVBAL,CEVBRN,CEVFUS,CEVLED,CEVSAF,CEVVLG,
     2       CEVGNO,CEVBUC,CEVSPH,CEVEGH,
     3       CEVFOR,CEVSCL,CEVZGI,CEVZGO,CEVSTE,
     5       CEVMRS,CEVPIN,CEVINQ,CEVFOL
 
C
       COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
C
C VERBS
C
       COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
       COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
       COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
       COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
       COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
       COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
       COMMON /VINDEX/OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
       COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
       COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
       COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
       COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
       COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
       COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
C
C FLAGS
C
       LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
       LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
       LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
       LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
       LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
       LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
       LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
       LOGICAL FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     1       DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     2       MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     3       EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     4       GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     5       GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     6       MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     7       FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ BTIEF,BINFF
       COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
       COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
       COMMON /FINDEX/ MDIR,MLOC,POLEUF
       COMMON /FINDEX/ QUESNO,NQATT,CORRCT
       COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C
C FUNCTIONS AND DATA
C
       QOPEN(R)=ZAND(OFLAG2(R),OPENBT).NE.0
       DATA NEWRMS/38/
C RAPPL2, PAGE 2
C
       RAPPL2=.TRUE.
       GO TO (38000,39000,40000,41000,42000,43000,44000,
     1       45000,46000,47000,48000,49000,50000,
     2       51000,52000,53000,54000,55000,56000,
     3       57000,58000,59000,60000),
     2       (RI-NEWRMS+1)
       CALL BUG(70,RI)
       RETURN
C
C R38--       MIRROR D ROOM
C
38000       IF(PRSA.EQ.LOOKW) CALL LOOKTO(FDOOR,MRG,0,682,681)
       RETURN
C
C R39--       MIRROR G ROOM
C
39000       IF(PRSA.EQ.WALKIW) CALL JIGSUP(685)
       RETURN
C
C R40--       MIRROR C ROOM
C
40000       IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRG,MRB,683,0,681)
       RETURN
C
C R41--       MIRROR B ROOM
C
41000       IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRC,MRA,0,0,681)
       RETURN
C
C R42--       MIRROR A ROOM
C
42000       IF(PRSA.EQ.LOOKW) CALL LOOKTO(MRB,0,0,684,681)
       RETURN
C RAPPL2, PAGE 3
C
C R43--       MIRROR C EAST/WEST
C
43000       IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,683)
       RETURN
C
C R44--       MIRROR B EAST/WEST
C
44000       IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,686)
       RETURN
C
C R45--       MIRROR A EAST/WEST
C
45000       IF(PRSA.EQ.LOOKW) CALL EWTELL(HERE,687)
       RETURN
C
C R46--       INSIDE MIRROR
C
46000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(688)
C DESCRIBE
C
C NOW DESCRIBE POLE STATE.
C
C CASES 1,2--       MDIR=270 & MLOC=MRB, POLE IS UP OR IN HOLE
C CASES 3,4--       MDIR=0 V MDIR=180, POLE IS UP OR IN CHANNEL
C CASE 5--       POLE IS UP
C
       I=689
C ASSUME CASE 5.
       IF((MDIR.EQ.270).AND.(MLOC.EQ.MRB))
     1       I=690+MIN0(POLEUF,1)
C CASES 1,2.
       IF(MOD(MDIR,180).EQ.0)
     1       I=692+MIN0(POLEUF,1)
C CASES 3,4.
       CALL RSPEAK(I)
C DESCRIBE POLE.
       CALL RSPSUB(694,695+(MDIR/45))
C DESCRIBE ARROW.
       RETURN
C RAPPL2, PAGE 4
C
C R47--       MIRROR EYE ROOM
C
47000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=704
C ASSUME BEAM STOP.
       DO 47100 J=1,OLNT
         IF(QHERE(J,HERE).AND.(J.NE.RBEAM)) GO TO 47200
47100       CONTINUE
       I=703
47200       CALL RSPSUB(I,ODESC2(J))
C DESCRIBE BEAM.
       CALL LOOKTO(MRA,0,0,0,0)
C LOOK NORTH.
       RETURN
C
C R48--       INSIDE CRYPT
C
48000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
C CRYPT IS OPEN/CLOSED.
       IF(QOPEN(TOMB)) I=12
       CALL RSPSUB(705,I)
       RETURN
C
C R49--       SOUTH CORRIDOR
C
49000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL RSPEAK(706)
C DESCRIBE.
       I=46
C ODOOR IS OPEN/CLOSED.
       IF(QOPEN(ODOOR)) I=12
       IF(LCELL.EQ.4) CALL RSPSUB(707,I)
C DESCRIBE ODOOR IF THERE.
       RETURN
C
C R50--       BEHIND DOOR
C
50000       IF(PRSA.NE.WALKIW) GO TO 50100
C WALK IN?
       CFLAG(CEVFOL)=.TRUE.
C MASTER FOLLOWS.
       CTICK(CEVFOL)=-1
       RETURN
C
50100       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
C QDOOR IS OPEN/CLOSED.
       IF(QOPEN(QDOOR)) I=12
       CALL RSPSUB(708,I)
       RETURN
C RAPPL2, PAGE 5
C
C R51--       FRONT DOOR
C
51000       IF(PRSA.EQ.WALKIW) CTICK(CEVFOL)=0
C IF EXITS, KILL FOLLOW.
       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       CALL LOOKTO(0,MRD,709,0,0)
C DESCRIBE SOUTH.
       I=46
C PANEL IS OPEN/CLOSED.
       IF(INQSTF) I=12
C OPEN IF INQ STARTED.
       J=46
C QDOOR IS OPEN/CLOSED.
       IF(QOPEN(QDOOR)) J=12
       CALL RSPSB2(710,I,J)
       RETURN
C
C R52--       NORTH CORRIDOR
C
52000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
       IF(QOPEN(CDOOR)) I=12
C CDOOR IS OPEN/CLOSED.
       CALL RSPSUB(711,I)
       RETURN
C
C R53--       PARAPET
C
53000       IF(PRSA.EQ.LOOKW) CALL RSPSUB(712,712+PNUMB)
       RETURN
C
C R54--       CELL
C
54000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=721
C CDOOR IS OPEN/CLOSED.
       IF(QOPEN(CDOOR)) I=722
       CALL RSPEAK(I)
       I=46
C ODOOR IS OPEN/CLOSED.
       IF(QOPEN(ODOOR)) I=12
       IF(LCELL.EQ.4) CALL RSPSUB(723,I)
C DESCRIBE.
       RETURN
C
C R55--       PRISON CELL
C
55000       IF(PRSA.EQ.LOOKW) CALL RSPEAK(724)
C LOOK?
       RETURN
C
C R56--       NIRVANA CELL
C
56000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
C ODOOR IS OPEN/CLOSED.
       IF(QOPEN(ODOOR)) I=12
       CALL RSPSUB(725,I)
       RETURN
C RAPPL2, PAGE 6
C
C R57--       NIRVANA AND END OF GAME
C
57000       IF(PRSA.NE.WALKIW) RETURN
C WALKIN?
       CALL RSPEAK(726)
       CALL SCORE(.FALSE.)
       CLOSE(UNIT=DBCH)
       CALL EXIT
C
C R58--       TOMB ROOM
C
58000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=46
C TOMB IS OPEN/CLOSED.
       IF(QOPEN(TOMB)) I=12
       CALL RSPSUB(792,I)
       RETURN
C
C R59--       PUZZLE SIDE ROOM
C
59000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       I=861
C ASSUME DOOR CLOSED.
       IF(CPOUTF) I=862
C OPEN?
       CALL RSPEAK(I)
C DESCRIBE.
       RETURN
C
C R60--       PUZZLE ROOM
C
60000       IF(PRSA.NE.LOOKW) RETURN
C LOOK?
       IF(CPUSHF) GO TO 60100
C STARTED PUZZLE?
       CALL RSPEAK(868)
C NO, DESCRIBE.
       IF(ZAND(OFLAG2(WARNI),TCHBT).NE.0) CALL RSPEAK(869)
       RETURN
C
60100       CALL CPINFO(880,CPHERE)
C DESCRIBE ROOM.
       RETURN
C
       END
C LOOKTO--       DESCRIBE VIEW IN MIRROR HALLWAY
C
C DECLARATIONS
C
       SUBROUTINE LOOKTO(NRM,SRM,NT,ST,HT)
       IMPLICIT INTEGER(A-Z)
C
C GAME STATE
C
       LOGICAL TELFLG
       COMMON /PLAY/ WINNER,HERE,TELFLG
C
C FLAGS
C
       LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
       LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
       LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
       LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
       LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
       LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
       LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
       LOGICAL FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     1       DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     2       MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     3       EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     4       GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     5       GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     6       MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     7       FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ BTIEF,BINFF
       COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
       COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
       COMMON /FINDEX/ MDIR,MLOC,POLEUF
       COMMON /FINDEX/ QUESNO,NQATT,CORRCT
       COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C LOOKTO, PAGE 2
C
       CALL RSPEAK(HT)
C DESCRIBE HALL.
       CALL RSPEAK(NT)
C DESCRIBE NORTH VIEW.
       CALL RSPEAK(ST)
C DESCRIBE SOUTH VIEW.
       DIR=0
C ASSUME NO DIRECTION.
       IF(IABS(MLOC-HERE).NE.1) GO TO 200
C MIRROR TO N OR S?
       IF(MLOC.EQ.NRM) DIR=695
       IF(MLOC.EQ.SRM) DIR=699
C DIR=N/S.
       IF(MOD(MDIR,180).NE.0) GO TO 100
C MIRROR N-S?
       CALL RSPSUB(847,DIR)
C YES, HE SEES PANEL
       CALL RSPSB2(848,DIR,DIR)
C AND NARROW ROOMS.
       GO TO 200
C
100       M1=MRHERE(HERE)
C WHICH MIRROR?
       MRBF=0
C ASSUME INTACT.
       IF(((M1.EQ.1).AND..NOT.MR1F).OR.
     1  ((M1.EQ.2).AND..NOT.MR2F)) MRBF=1
C BROKEN?
       CALL RSPSUB(849+MRBF,DIR)
C DESCRIBE.
       IF((M1.EQ.1).AND.MROPNF) CALL RSPEAK(823+MRBF)
       IF(MRBF.NE.0) CALL RSPEAK(851)
C
200       I=0
C ASSUME NO MORE TO DO.
       IF((NT.EQ.0).AND.((DIR.EQ.0).OR.(DIR.EQ.699))) I=852
       IF((ST.EQ.0).AND.((DIR.EQ.0).OR.(DIR.EQ.695))) I=853
       IF((NT+ST+DIR).EQ.0) I=854
       IF(HT.NE.0) CALL RSPEAK(I)
C DESCRIBE HALLS.
       RETURN
C
       END
C EWTELL--       DESCRIBE E/W NARROW ROOMS
C
C DECLARATIONS
C
       SUBROUTINE EWTELL(RM,ST)
       IMPLICIT INTEGER(A-Z)
       LOGICAL M1
C
C ROOMS
C
       COMMON /RINDEX/ WHOUS,LROOM,CELLA
       COMMON /RINDEX/ MTROL,MAZE1
       COMMON /RINDEX/ MGRAT,MAZ15
       COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
       COMMON /RINDEX/ STREA,EGYPT,ECHOR
       COMMON /RINDEX/ TSHAF
       COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
       COMMON /RINDEX/ CAROU
       COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
       COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
       COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
       COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
       COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
       COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
       COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
       COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
       COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
       COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
       COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
       COMMON /RINDEX/ CPANT,CPOUT,CPUZZ
C
C FLAGS
C
       LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
       LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
       LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
       LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
       LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
       LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
       LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
       LOGICAL FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
     1       DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
     2       MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
     3       EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
     4       GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
     5       GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
     6       MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
     7       FOLLWF,SPELLF,CPOUTF,CPUSHF
       COMMON /FINDEX/ BTIEF,BINFF
       COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
       COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
       COMMON /FINDEX/ MDIR,MLOC,POLEUF
       COMMON /FINDEX/ QUESNO,NQATT,CORRCT
       COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL,CPHERE
C EWTELL, PAGE 2
C
C NOTE THAT WE ARE EAST OR WEST OF MIRROR, AND
C MIRROR MUST BE N-S.
C
       M1=(MDIR+(MOD(RM-MRAE,2)*180)).EQ.180
       I=819+MOD(RM-MRAE,2)
C GET BASIC E/W STRING.
       IF((M1.AND..NOT.MR1F).OR.(.NOT.M1.AND..NOT.MR2F))
     1       I=I+2
C MIRROR BROKEN?
       CALL RSPEAK(I)
       IF(M1.AND.MROPNF) CALL RSPEAK(823+((I-819)/2))
       CALL RSPEAK(825)
       CALL RSPEAK(ST)
       RETURN
C
       END
