.\" $XFree86: mit/server/ddx/x386/Xconfig.man,v 2.9 1994/03/08 08:07:19 dawes Exp $
.\" $XConsortium: X386.man,v 1.3 91/08/26 15:31:19 gildea Exp $
.TH Xconfig 4/5 "Version 2.1"  "XFree86"
.SH NAME
Xconfig - Configuration File for XFree86
.SH DESCRIPTION
.I XFree86
uses a configuration file called \fBXconfig\fP for its initial setup.  
If this file is not specified from the command line with the \fB\-xconfig\fP
flag then the methods described here are used to find the file.
If the environment variable XCONFIG is set to a pathname, this is used as
the name of the configuration file.  If XCONFIG is set, but is not a pathname
(i.e., doesn't contain a `/') it is appended to \fBXconfig\fP.  The
configuration file is then searched for in the following places:
.sp
.in 8
.nf
$HOME/Xconfig
/etc/Xconfig
/usr/X386/lib/X11/Xconfig.\fIhostname\fP
/usr/X386/lib/X11/Xconfig
.fi
.in -8
.PP
This file is composed of the following sections:
.sp
.in 8
.nf
General Server Parameters
Keyboard Configuration
Mouse Configuration
Video Mode Setup
Table of Known Video Modes
.fi
.in -8
.PP
The \fBGENERAL SERVER PARAMETERS\fP section lets you adjust some generic server
parameter which seldom change for a given site.  (The \fBfontpath\fP and
\fBrgbpath\fP parameters can also be set from the command line, see 
\fIXserver(1)\fP.):
.TP 8
.B fontpath \fI"path"\fP
sets the search path for fonts.  This path is a comma separated list of
directories which the sample server searches for font databases.  Multiple
\fBfontpath\fP entries may be specified, and they will be concatenated to
build up the fontpath used by the server.
.sp
Note that a new feature of X11R5 is the ability of the X server to
request fonts from a \fIfont server\fP.  One specifies a \fIfont
server\fP by placing a "tcp/<hostname>:<tcp_port_number>" into the fontpath.
In the above example, the fontpath "/usr/X386/lib/X11/fonts/misc/,tcp/zok:7000"
tells \fIXFree86\fP to first try to locate the font in the local directory
/usr/X386/lib/X11/fonts/misc.  If that fails, then request the font from
the \fIfont server\fP running on machine zok listening for connections on
TCP port number 7000.
.TP 8
.B rgbpath \fI"path"\fP
sets the name of RGB color database.
.TP 8
.B notrapsignals
prevents the server from trapping a range of unexpected fatal signals
and exiting cleanly.  Instead, the
server will die and drop core where the fault occurred.  The default 
behaviour is for the server exit cleanly, but still drop a core file.
In general you never want to use this option unless you are debugging
a server problem.
.PP
The \fBKEYBOARD CONFIGURATION\fP section starts with a keyword describing
which kind  of driver should be used:  \fBkeyboard\fP (the normal device) or 
\fBxqueue\fP (the event-queue driver in SVR3 and SVR4).  Following 
this keyword the following options can be specified:
.TP 8
.B autorepeat \fIdelay rate\fP
changes the behavior of the autorepeat of the keyboard.  This does not work
on all platforms.
.TP 8
.B dontzap
disallows the use of the \fBCtrl+Alt+Backspace\fP sequence.  This sequence
allows you to terminate the server.
.TP 8
.B servernumlock
forces the server to handle the numlock key internally.  The server sends
a different set of keycodes for the numpad when the numlock key is active.
This enables applications to make use of the numpad.
.PP
.nf
.B leftalt \fImapping\fP
.B rightalt \fImapping\fP
.B altgr \fImapping\fP
.B scrolllock \fImapping\fP
.B rightctl \fImapping\fP
.fi
.RS 8
Allows a default mapping to be set for the above keys (note that \fBaltgr\fP
is a synonym for \fBrightalt\fP).  The values that may
be specified for \fImapping\fP are:
.sp
.in 20
.nf
meta
compose
modeshift
modelock
scrolllock
control
.fi
.PP
The default mapping when none of these options are specified is:
.sp
.in 20
.nf
leftalt     meta
rightalt    meta
scrolllock  compose
rightctl    control
.fi
.PP
Refer to the
.I XFree86kbd(1)
manual page for more information.
.RE
.TP 8
.B xleds \fIled\fP ...
makes \fIled\fP available for clients instead of using the traditional function
(Scroll Lock, Caps Lock & Num Lock)
.TP 8
.B vtsysreq
enables the SYSV-style VT switch sequence for non-SYSV systems which support
VT switching.  This sequence is Alt-SysRq followed by a function key (Fn).
.TP 8
.B vtinit \fI"command"\fP
Runs \fIcommand\fP after the VT used by the server has been opened.  The
command string is passed to "/bin/sh -c", and is run with the real user's id
with stdin and stdout set to the VT.
The purpose of this option is to allow
system dependent VT initialisation commands to be run.  One example is a
command to disable the 2-key VT switching sequence which is the default on
some systems.
.PP
Similar to above, the \fBMOUSE CONFIGURATION\fP section starts with a special
keyword, but here we must select the type of mouse (i.e. its protocol) that
is connected to the computer.  (When using the \fIxqueue\fP driver this
section should be deleted (except the \fIemulate3buttons\fP keyword), since 
mouse I/O is handled by the xqueue driver.)  The mouse types available are:
.sp
.in 8
.nf
.B busmouse
.B logitech
.B microsoft
.B mmseries
.B mouseman
.B mousesystems
.B ps/2
.B mmhittab
.fi
.in -8
.PP
Under SCO another mouse type (\fBosmouse\fP) is available.  This mouse type
uses the SCO event drivers to access the mouse.  This type should be used
for bus and ps/2 mice but it may also be used for serial mice.  In order
to use this type you must first configure your OS appropriately with
"mkdev mouse". See the manual page ("man mouse") for more information
reguarding mouse configuration under SCO.  If the \fBosmouse\fP driver
incorrectly reports the number of buttons available for the currently
configured mouse then it may be followed by a number of buttons
(ie., \fBosmouse\ 4\fP for a four button mouse). 
.PP
(One should specify \fBbusmouse\fP for the Logitech bus mouse.)
Immediately following the mouse type should be the mouse device in
quotations (e.g. \fI"/dev/tty00"\fP).
The following options can be specified after this keyword:
.TP 8
.B baudrate \fIrate\fP
sets the baudrate of the serial mouse to \fIrate\fP. For mice that allow
dynamic speed adjustments (like logitech) the baudrate is changed in the mouse.
Otherwise the rate is simply set on the computer's side to allow mice with
non-standard rates (the standard rate is 1200).
.TP 8
.B emulate3buttons
enables the emulation of the third mouse button for mice which only have
two physical buttons.  The third button is emulated by pressing both
buttons simultaneously.
.TP 8
.B chordmiddle
handles mice which send left+right events when the middle button is used.
.TP 8
.B samplerate \fIrate\fP
sets the number of motion/button-events the mouse sends per second. This is
currently only supported for logitech mice.
.TP 8
.B cleardtr
This option clears the DTR line on the serial port used by the mouse.  This
option is only valid for a mouse using the \fBmousesystems\fP protocol.
Some dual-protocol mice require DTR to be cleared to operate in mousesystems
mode.  Note, in versions of XFree86 prior to 2.1, this option also cleared
the RTS line.  A separate \fBclearrts\fP option has been added for mice
which require this.
.TP 8
.B clearrts
This option clears the RTS line on the serial port used by the mouse.  This
option is only valid for a mouse using the \fBmousesystems\fP protocol.
Some dual-protocol mice require both DTR and RTS to be cleared to operate
in mousesystems mode.  Both the \fBcleardtr\fP and \fBclearrts\fP options
should be used for such mice.
.PP
The \fBGRAPHICS DRIVER SETUP\fP section depends on the actually used
server. Here only the general features are explained, for more detail
see the server specific manpages.
For the SVGA colour server the \fBGRAPHICS DRIVER SETUP\fP section starts with
the keyword \fBvga256\fP.  The section for the monochrome server starts
with the keyword \fBvga2\fP, the 4-bit server uses the keyword
\fBvga16\fP, and the section for the mono hga driver starts 
with the keyword \fBhga2\fP, and the section for the bdm driver starts with
the keyword \fBbdm2\fP. The accelerated servers like the S3
server, the Mach8 or the Mach32 server, use the keyword \fBaccel\fP.  
For servers with multiple screens supported,
only those with entries will be enabled.
After this keyword a variety of options may be specified (most
are not relevant to the \fBhga2\fP driver because it only supports a single
resolution):
.TP 8 
.B staticgray,grayscale,staticcolor,pseudocolor,truecolor,directcolor
sets the visual class for the root window of the screen.  Note that the
monochrome server only supports a \fIstaticgray\fP visual, and the 16 colour
VGA server only supports \fIpseudocolor\fP, \fIstaticgray\fP and
\fIgrayscale\fP visuals.
.br
.ne 3i
.TP 8
.B chipset \fI"name"\fP
specifies a chipset so the correct driver can be used or specifies a
special driver to be used with the detected chipset.
Details and valid values are given in the server specific manpages.
.TP 8
.B clocks \fIclock\fP  ...
specifies the dotclocks that are on your graphics board.  The clocks are
in MHz, and may be specified as a floating point number.  The value is
stored internally to the nearest kHz.  The ordering of the clocks
is important.  It must match the order in which they are selected on the
graphics board.  Multiple \fBclocks\fP lines may be specified.
For programmable clock chips the name of the clock chip is given.
Possible values include \fI"icd2061a"\fP and \fI"icd2061a_slow"\fP.  These
are currently only supported by the S3 server.
.TP 8
.B clockprog \fI"command"\fP [\fItextclock\fP]
Runs \fIcommand\fP to set the clock on the graphics board instead of using
the internal code.  The command string must consist of the full pathname
(and no flags).  When using this option, a \fBclocks\fP option is
required to specify which clock values are to be made available to the server
(up to 32 clocks may be specified).  The optional \fItextclock\fP value
is used to tell the server that \fIcommand\fP must be run to restore the
textmode clock at server exit (or when VT switching).  \fItextclock\fP must
match one of the values in the \fBclocks\fP line.  This parameter is
required when the clock used for text mode is a programmable clock.

The command is run with the real user's id with stdin and stdout set to
the graphics console device.  Two arguments are passed to the command.
The first is the clock frequency in MHz as a floating point number and the
second is the index of the clock in the \fBclocks\fP line.  The command
should return an exit status of 0 when successful, and something in the
range 1\-254 otherwise.

The command is run when the initial graphics mode is set and when changing
screen resolution with the hot-key sequences.  If the program fails at
initialisation the server exits.  If it fails during a mode switch, the
mode switch is aborted but the server keeps running.  It is assumed that
if the command fails the clock has not been changed.
.ig
.TP 8
.B displaysize \fIxdim\fP \fIydim\fP
sets the display size (internal) to \fIxdim\fP x \fIydim\fP (measured in mm).
This option is currently not implemented.
..
.TP 8
.B screenno \fIscrnum\fP
overrides the default screen numbering on a multi-display server.  The default
numbering is determined by the ordering of the screen sections in
\fIXconfig\fP.  To override this, all relevant screens must have this
option specified.  This is the only option applicable the the \fBhga2\fP
screen.
.TP 8
.B modes \fI"mode"\fP ...
selects the display modes for this screen.  The first one in the list will
be the default display mode for startup.  Internally this list is converted
into a circular list.  With \fBCtrl+Alt+Keypad-Plus\fP and
\fBCtrl+Alt+Keypad-Minus\fP the current display mode may be changed, and
the next (upward/downward) entry in the list will be used.
.TP 8
.B option \fI"optionstring"\fP
allows the user to select certain options provided by the drivers.
The supported values are given in the server specific manpages.
.TP 8
.B videoram \fImem\fP
specifies the amount of videoram that is installed on the graphics board. This
is measured in kBytes.
.TP 8
.B biosbase \fIbaseaddress\fP
specifies the base address of the video BIOS for the VGA card.  This address
is normally at 0xC0000, which is the default the server will use.  Some
systems, particularly those with on-board VGA hardware, have the BIOS located
at an alternate address, usually 0xE0000.  If your video BIOS is at an
address other than 0xC0000, you must specify the base address in the
Xconfig file.  Note that the server only uses the BIOS when searching for
information during the probe phase.
.TP 8
.B viewport \fIx0\fP \fIy0\fP
sets the upper left corner of the initial display.  If the virtual
resolution is larger than what is physically displayed, then the initial
display will be centered if \fBviewport\fP is not specified.
.TP 8
.B virtual \fIxdim\fP \fIydim\fP
sets the virtual resolution. For example one might use a display with 800x600,
but a virtual resolution of 1152x900.  \fIxdim\fP must be a multiple of
either 8 or 16 for the colour server (depending on the chipset), and a
multiple of 32 for the mono server.  The specified
valued will be rounded down if this is not the case.
If the mouse touches the borders of the
display the image scrolls accordingly. This is called panning.
.PP
Note that \fIXFree86\fP has some internal capabilities to determine
what hardware
it is running on. Thus normally the keywords \fIchipset\fP, \fIclocks\fP,
and \fIvideoram\fP don't have to be specified.  But there
may be occasions when this autodetection mechanism fails, (for example, too
high of load on the machine when you start the server).  For cases like this,
one should first run \fIXFree86\fP on an unloaded machine, look at the
results of the autodetection (that are printed out during server startup)
and then explicitly specify these parameters in the configuration file.
\fBIt is recommended that all parameters, especially Clock values,
be specified in the Xconfig file.\fP
.PP
The last section is the \fBTABLE OF VIDEO MODES\fP which starts with the
keyword \fBmodedb\fP.  A list of possible mode-records follows this keyword.
For every mode string in the previously specified \fBmodes\fP line, the server
scans the list of mode-records looking for a matching \fImodename\fP.  When a
match occurs, then the \fIdotclock\fP value is compared to those found on
the graphics board.  If the \fIdotclock\fP value matches, then the rest
of the values in the mode-record will be used for that display mode.  If
there is more than one matching mode-record (for a given \fImodename\fP and
\fIdotclock\fP), then the last one matched will be used.
.sp
A mode-record consists of seven parts (the first four are mandatory, while
the last three are optional):
.TP 8
.I modename
is the string that identifies this mode. If one is not specified, then the
\fImodename\fP string of the last valid mode-record is used.
.TP 8
.I dotclock
is the dotclock this mode uses. This is the basic timer for all video signals.
.TP 8
.I hdisp, hsyncstart, hsyncend, htotal
is the horizontal timing
.TP 8
.I vdisp, vsyncstart, vsyncend, vtotal
is the vertical timing
.TP 8
.B interlace
sets interlace display mode.
.TP 8
.B +hsync, -hsync
selects polarity of HSYNC signal
.TP 8
.B +vsync, -vsync
selects polarity of VSYNC signal
.PP
For details on how to build your own video modes please refer to the tutorial
written by Eric Raymond.
.PP
.ne 6i
A sample config file might look like this:
.sp
.in +5
\fB
.nf
RGBPath         "/usr/X386/lib/X11/rgb"
FontPath        "/usr/X386/lib/X11/fonts/misc/,tcp/zok:7000"

Keyboard
  AutoRepeat 500 5
  Xleds      1 2 3
  ServerNumLock
  DontZap

Logitech	"/dev/tty00"
  BaudRate	9600
  SampleRate	150
  Emulate3Buttons

vga256
  Chipset       "et4000"
  Option        "legend"
  Clocks        25 28 36 62
  Virtual       1152 900
  ViewPort      0 0
  Modes         "1024x768" "640x480"

ModeDB
 "640x480"   25     640  672  768  800    480  490  492  525
             28     640  672  768  800    480  490  492  525
 "1024x768"  62    1024 1092 1220 1344    768  786  791  810
.fi
\fP
.SH FILES
.PP
.nf
$HOME/Xconfig
/etc/Xconfig
/usr/X386/lib/X11/Xconfig.\fIhostname\fP
/usr/X386/lib/X11/Xconfig
.sp
/usr/X386/lib/X11/etc/README.Config
.fi
.SH "SEE ALSO"
X(1), Xserver(1), XFree86(1), XFree86kbd(1), XF86_SVGA(1), XF86_VGA16(1),
XF86_Mono(1), XF86_S3(1), XF86_8514(1), XF86_Mach8(1), XF86_Mach32(1)
.SH AUTHORS
.PP
Refer to the
.I XFree86(1)
manual page.
