// This program must compiled in large model
#include <stdio.h>
#include <dos.h>

static void near usage()
{
	fprintf (stderr,
		"linux loader alpha 0.0\n"
		"\n"
		"linux [options] zimage [ boot command line for zimage]\n"
		"DOS program to boot a zImage in memory\n"
		"It locates the directory \linux\etc on any drive\n"
		"and direct zImage to boot from there\n"
		);
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 1){
		usage();
	}else{
		int noarg = 1;
		while (1){
			char *arg = argv[noarg];
			if (arg[0] == '-'){
			}else{
				break;
			}
		}
		{
			char *fimage = argv[noarg];
			FILE *fin    = fopen(fimage,"rb");
			if (fin == NULL){
				fprintf (stderr,"Can't locate kernel image %s\n",fimage);
			}else{
				printf ("%04x %04x\n",_CS,_SS);
				printf ("Reading: ");
				/*
					We must read the first 6 sector at adresse 0x90000
				*/
				void *setup = MK_FP(0x9000,0);
				unsigned *check = (unsigned *)MK_FP(0x9000,0x1fe);
				if (fread(setup,1,5*0x200,fin)!=5*0x200){
					fprintf (stderr,"Can't read kernel setup pages\n");
				}else if (*check != 0xAA55){
					fprintf (stderr,"Bad magic 0xAA55. Not a valid kernel\n");
				}else{
					unsigned seg = 0x1000;
					unsigned off = 0;
					unsigned long total = 5*0x200;
					while (1){
						void *pt = MK_FP(seg,off);
						unsigned len = fread (pt,1,0x8000,fin);
						printf ("%04x ",len); fflush (stdout);
						total += len;
						if (len != 0x8000){
							break;
						}else if (off == 0){
							off = 0x8000;
						}else{
							off = 0;
							seg += 0x1000;
						}
					}
					printf ("\n%ld bytes loaded\n",total);
					fflush (stdout);
					asm cli
					asm mov bx,9000h
					asm mov ds,bx
					asm mov es,bx
					asm mov ss,bx
					asm mov sp,4000h
					asm sti
					asm mov bx,9020h
					asm push bx
					asm xor bx,bx
					asm push bx
					asm ret
				}
			}
		}
	}
	return ret;
}

