/******************************************************************************
 *
 *	File:	previewer.C
 *
 *	Functions(s):
 *
 *	Description:
 *		Template for prototyper generated application
 *		The root name of your application is "previewer"
 *		To ensure that this module compiles correctly, the user should
 *		place all additional definitions into previewer.H.
 *
 *	RCSid = "$Id: previewer.C,v 1.1.1.1 1993/06/10 17:13:29 mth Exp $"
 *
 ******************************************************************************
 */

#include <OI/oi.H>
#include "previewer.H"
#include "previewer_bd.H"


//	OI_UIB	start application resources
#ifdef	EXAMPLE_FETCHING_ADDITIONAL_RESOURCES
	static struct Personality {
		OI_bool	aa ;
		char	*bb ;
		int	cc ;
	} personality ;

#define offset(a)	offsetof(Personality, a)
	static OI_resource resources[] =
	{
		{ "aa", "Aa", XtRBoolean, sizeof (OI_bool), offset(aa), XtRString, "False",NULL_PMF, NULL, NULL },
		{ "bb", "Bb", XtRString, sizeof (char *), offset(bb), XtRString, "Normal", NULL_PMF, NULL, NULL },
		{ "cc", "Cc", XtRInt, sizeof (int), offset(cc), XtRString, "2",NULL_PMF,NULL,NULL},
	} ;
#undef	offset
	static	XrmOptionDescRec	opTable[] = {
		{"-aa",	"*Aa",	XrmoptionNoArg,		(caddr_t) "True" },
		{"-bb",	"*Bb",	XrmoptionSepArg,	(caddr_t) NULL },
		{"-cc",	"*Cc",	XrmoptionSepArg,	(caddr_t) NULL },
	} ;
#endif
//	OI_UIB	end application resources

/******************************************************************************
 *
 *	Function Name:	main
 *
 *		Description: 
 *
 *		Args:
 *
 *		Returns:
 * 
 *		Side Effects:
 *
 *		Warnings:
 *
 ******************************************************************************
 */
int
main( int argc, char ** argv )
{
 /*	External Variables */
		extern	OI_actions_rec	previewer_action_tbl[] ;		/* binding table */
		extern	int		n_previewer_bind_entries ;	/* number of elements in binding table */
 /*	External Procedures: */
 /*	Local Variables: */
			int		rtn ;
			OI_number	i ;
			OI_d_tech	**topLevel ;			/* vector of top level objects */
 /*
	Procedure:
 */


	rtn = 1;
#ifdef	EXAMPLE_FETCHING_ADDITIONAL_RESOURCES
	if (OI_uib_conn = OI_init( &argc, argv, "previewer", NULL, &opTable[0], OI_count( opTable ))) {
		OI_uib_conn->rm()->get_resources( resources, OI_count (resources), (char *) &personality );
		fprintf( stderr, "aa %s  bb %s  cc %d\n",
			personality.aa ? "yes" : "no", personality.bb, personality.cc );
#else
	if (OI_uib_conn = OI_init(&argc,argv,"previewer")) {
#endif
		OI_add_actions( previewer_action_tbl, n_previewer_bind_entries );

		if (OI_uib_conn->add_resources( OI_translate_filename( "previewer.cf" ) )) {
			topLevel = OI_make_top_level();
			for ( i=0 ; topLevel[i] ; ++i )
				topLevel[i]->set_associated_object(
					topLevel[i]->root(),OI_DEF_LOC,OI_DEF_LOC,OI_NOT_DISPLAYED);

			/*
			**	Perform any application initialization here.
			*/

			for ( i=0 ; topLevel[i] ; ++i )
				topLevel[i]->set_state(OI_ACTIVE);

#ifdef	TIME_CONSUMING_PROGRAM_INITIALIZATION
			for ( i=0 ; topLevel[i] ; ++i )
				topLevel[i]->set_working();
			/*
			**	do program initialization
			*/
			
			for ( i=0 ; topLevel[i] ; ++i )
				topLevel[i]->clear_working();
#endif
			free( (char *) topLevel );

			OI_begin_interaction() ;
			/*
			**	If you wish to have an exit (quit) button within your
			**	application, please specify the cbCellAction callback
			**	for the exit cell to be:
			**		OI_end_interaction
			**	The exit button is not necessary since selecting the
			**	appropriate quit option from the decoration around the
			**	main window provided by the window manager will serve
			**	the same function.
			**	
			*/
		}
		else {
			fprintf(stderr,"ERROR reading read file previewer.cf or no TopLevel resource available\n") ;
		}
		/*
		**	Perform any user interface dependent application
		**	cleanup here.
		*/
		OI_fini() ;
		/*
		**	Perform application cleanup here if you do not need
		**	access to any user interface information.
		*/
		rtn = 0 ;
	}
	return( rtn );
}
