#include <OI/oi.H>			/*	DateBook.C	*/

	const	char OI_n_timeStart[] =		"timeStart";		// start time resource name 
	const	char OI_n_timeEnd[] =		"timeEnd";		// end time resource name 

	const	char OI_c_TimeStart[] =		"TimeStart";		// start time resource class 
	const	char OI_c_TimeEnd[] =		"TimeEnd";		// end time resource class 

	const	char DefaultTimeStart[] =	"0800";			// default start time 
	const	char DefaultTimeEnd[] =		"1800";			// default end time 

	const	int DefaultTimeInterval =	30;			// default time interval (should also be a resource) 

struct MyRes {					// structure to hold my resources 
	int		timeStart;
	int		timeEnd;
};
static MyRes MyResources;

static OI_resource resources[] = {
	{ OI_n_timeStart, OI_c_TimeStart, OI_r_Int, sizeof(int), offsetof(MyRes, timeStart),
		OI_r_String, DefaultTimeStart },
	{ OI_n_timeEnd, OI_c_TimeEnd, OI_r_Int, sizeof(int), offsetof(MyRes, timeEnd),
		OI_r_String, DefaultTimeEnd },
};

static XrmOptionDescRec opTable[] = {
	{"-start",	"*timeStart",	XrmoptionSepArg, (caddr_t)NULL },
	{"-end",	"*timeEnd",	XrmoptionSepArg, (caddr_t) NULL},
} ;

int main (int argc, char **argv)
{
	char		*convertTime(int *);		// convert nmbr to a time string

	OI_connection	*conp;				// the connection to the server 
	OI_app_window	*wp;				// the enclosing app window 
	OI_entry_field	*efp;				// pointer to each entry field 
	int		time;				// the current time
	int		row;				// put entry field in this row
	char		*label;				// the label for each entry field 

	// Open a connection to the server
	if ((conp = OI_init(&argc, argv, "DateBook", argv[0], opTable, OI_count(opTable)))) {
		// go get the resources
		conp->get_resources(resources, OI_count(resources), (char *)&MyResources);
		// should make sure the fetched resources are valid
		// create main window and fill with entry fields

		wp = oi_create_app_window("myapp", 10, 10, "Date Book");
		wp->set_layout(OI_layout_row);

		for (time = MyResources.timeStart, row = 0; time <= MyResources.timeEnd; time += DefaultTimeInterval) {
			label = convertTime(&time);
			efp = oi_create_entry_field("timeSlot", 30, label, NULL);
			efp->layout_associated_object(wp, 0, row++, OI_active);
		}
		wp->set_associated_object(wp->root(), OI_def_loc, OI_def_loc, OI_active);

		OI_begin_interaction();
		OI_fini();
	}
}

char *convertTime(
	int *time)
{
	static char label[20];
	int hour;
	int minute;

	hour = *time/100;
	minute = *time - (hour*100);
	if (minute >= 60) {
		minute -= 60;
		hour += 1;
	}
	*time = hour*100 + minute;
	sprintf(label, "%02d:%02d: ", hour, minute);
	return (label);
}

