#include <OI/appwin.H>			/* AppWithHelp.C */
#include <OI/btnmnu.H>
#include <OI/mnucel.H>
#include <OI/msgdlg.H>
int main(int argc, char** argv)
{

			void			process_horses(OI_menu_cell*,void*,OI_number);
			void			process_cattle(OI_menu_cell*,void*,OI_number);
			void			process_sheep(OI_menu_cell*,void*,OI_number);
			void			do_help(OI_menu_cell*,void*,OI_number);
			OI_connection		*conp;
			OI_app_window		*wp;
			OI_menu			*mp,*pull_mp;
			OI_menu_cell		*mcp;
			OI_dialog_box		*dbp;

		static	OI_cell_spec		main_cells[] = {
				{"animals","Farm Animals"},
			};
		static	OI_cell_spec		animal_cells[] = {
				{"horses","Horses",&process_horses},
				{"cattle","Cattle",&process_cattle},
				{"sheep","Sheep",&process_sheep},
			};

	if (conp = OI_init(&argc,argv,"AppWithHelp")) {
		wp = oi_create_app_window("main",170,60,"OI_app_window");
		wp->push_help("farm_animals","help.hp");
		mp = oi_create_button_menu("menu",OI_count(main_cells),&main_cells[0],OI_horizontal);
		wp->set_main_menu(mp);

		// Make pull-down menu to attach to main menu "animals" button
		pull_mp = oi_create_button_menu("farm",OI_count(animal_cells),&animal_cells[0],OI_vertical);
		mcp = (OI_menu_cell*)mp->subobject("animals");
		pull_mp->set_associated_object(mcp,OI_def_loc,OI_def_loc,OI_active_not_displayed);

		// Make dialog box to process horses, attach to "horses" menu cell
		dbp = oi_message_dialog_box("horse_box","Process horses in this box");
		dbp->set_associated_object(pull_mp->subobject("horses"),OI_def_loc,OI_def_loc,OI_not_displayed);
		mcp = (OI_menu_cell*)pull_mp->subobject("horses");
		// use allow_subbox on menu cell since we use wait_button on dialog box
		mcp->allow_subbox();

		// Make dialog box to process cattle, attach to "cattle" menu cell
		dbp = oi_message_dialog_box("cattle_box","Process cattle in this box");
		dbp->set_associated_object(pull_mp->subobject("cattle"),OI_def_loc,OI_def_loc,OI_not_displayed);
		mcp = (OI_menu_cell*)pull_mp->subobject("cattle");
		mcp->allow_subbox();

		// Make dialog box to process sheep, attach to "sheep" menu cell
		dbp = oi_message_dialog_box("sheep_box","Process sheep in this box");
		dbp->set_associated_object(pull_mp->subobject("sheep"),OI_def_loc,OI_def_loc,OI_not_displayed);
		mcp = (OI_menu_cell*)pull_mp->subobject("sheep");
		mcp->allow_subbox();

		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
void process_horses(OI_menu_cell *cellp, void*, OI_number)
{
	static	OI_dialog_box	*dbp;

	cellp->app_window()->push_help(cellp->name(),"help.hp");
	dbp = (OI_dialog_box*)cellp->subobject("horse_box");
	dbp->wait_button();
	cellp->app_window()->pop_help();
	return;
}
void process_cattle(OI_menu_cell *cellp, void*, OI_number)
{
	static	OI_dialog_box	*dbp;

	cellp->app_window()->push_help(cellp->name(),"help.hp");
	dbp = (OI_dialog_box*)cellp->subobject("cattle_box");
	dbp->wait_button();
	cellp->app_window()->pop_help();
	return;
}
void process_sheep(OI_menu_cell *cellp, void*, OI_number)
{
	static	OI_dialog_box	*dbp;

	cellp->app_window()->push_help(cellp->name(),"help.hp");
	dbp = (OI_dialog_box*)cellp->subobject("sheep_box");
	dbp->wait_button();
	cellp->app_window()->pop_help();
	return;
}
void do_help(OI_menu_cell *cellp, void*, OI_number)
{
	cellp->app_window()->set_help(cellp->name(),"help.hp");
	cellp->app_window()->help();
	return;
}
