#include <stdlib.h>
#include <string.h>
#include <OI/oi.H>
#include <OI/lmrc.H>		/* needed to access row-col specific member functions */
#include <OI/lmrowcol.H>	/* needed to access row-column specific member functions */
#include <OI/lmwrap.H>		/* needed to access wrapped specific member functions */
#include <OI/lmtree.H>		/* needed to access tree specific member functions */

			OI_d_tech	*wp = NULL ;
			OI_box		*layout_boxp = NULL ;

/*
 ******************************************************************************
 *
 *	Function Name:	main
 *
 *		Description: 
 *			Demo / test program for supplied layout methods
 *
 *		Returns:
 * 
 *		Side Effects:
 *
 *		Warnings:
 *			This should really be built using uib, but since it's used to test the layout code
 *			I need to be able to run it when uib is broken
 *
 ******************************************************************************
 */
main(
			int			argc,		// # words on command line
			char			**argv)		// ptr to words
{
 /*	External Procedures: */
			void			add_it(OI_menu_cell*, void*, OI_number);
			void			box_object(OI_menu_cell*, void*, OI_number);
			void			chg_collapse(OI_menu_cell*, void*, OI_number);
			void			chg_layout(OI_menu_cell*, void*, OI_number);
			OI_ef_entry_chk_status	chg_wrap(OI_entry_field*,void*) ;
			OI_ef_entry_chk_status	chg_wrap_space(OI_entry_field*,void*) ;
			void			clear(OI_menu_cell*, void*, OI_number);
 /*	Local Variables: */
			OI_connection		*conp ;		// ptr to connection to X server
			OI_static_text		*stp ;		// ptr to static text object
			OI_menu			*mp ;		// ptr to generic menu
			OI_box			*bp ;		// ptr to box
			OI_menu_cell		*cellp ;	// ptr to menu cell
			OI_entry_field		*efp ;		// ptr to entry field
			OI_box			*geomp ;	// ptr to container for all geometry boxes
			OI_box			*rc_bp ;	// ptr to row-column geometry box
			OI_box			*tree_bp ;	// ptr to tree geometry box
			OI_box			*box_optp ;	// ptr to box containing box object options
			OI_box			*colbp ;	// ptr to box to get column alignment for box options next to other stuff

		static	OI_cell_spec		gravcells[] = {
				{NULL, "North", NULL,NULL,NULL_PMF,(void*)OI_grav_north},
				{NULL, "South", NULL,NULL,NULL_PMF,(void*)OI_grav_south},
				{NULL, "East", NULL,NULL,NULL_PMF,(void*)OI_grav_east},
				{NULL, "West", NULL,NULL,NULL_PMF,(void*)OI_grav_west},
				{NULL, "NorthEast", NULL,NULL,NULL_PMF,(void*)OI_grav_northeast},
				{NULL, "SouthEast", NULL,NULL,NULL_PMF,(void*)OI_grav_southeast},
				{NULL, "NorthWest", NULL,NULL,NULL_PMF,(void*)OI_grav_northwest},
				{NULL, "SouthWest", NULL,NULL,NULL_PMF,(void*)OI_grav_southwest},
				{NULL, "Center", NULL,NULL,NULL_PMF,(void*)OI_grav_center}
			} ;
		static	OI_cell_spec		option_cells[] = {
				{"collapse", "No Geometry Gaps", chg_collapse}
			} ;
		static	OI_cell_spec		size_trk_cells[] = {
//				{"none", "None", NULL, NULL, NULL_PMF, (void*)OI_size_track_none},
				{"full", "Full", NULL, NULL, NULL_PMF, (void*)OI_size_track_full},
				{"horz", "horizontal", NULL, NULL, NULL_PMF, (void*)OI_size_track_horizontal},
				{"vert", "Vertical", NULL, NULL, NULL_PMF, (void*)OI_size_track_vertical}
			} ;
		static	OI_cell_spec		ctl_cells[] = {
				{"add", "Add New Object", add_it},
				{"clear", "Clear All", clear},
			} ;
		static	OI_cell_spec		label_cells[] = {
				{"name", "Name Label"},
				{"gravity", "Gravity Label"},
				{"size_track", "Size Track Label"}
			} ;
		static	OI_cell_spec		obj_cells[] = {
				{"box", "Box", box_object},
				{"entry_field", "Entry Field"},
				{"seq_entry_field", "Sequenced Entry Field"},
				{"static_text", "Static Text"},
				{"menu", "Menu"},
				{"gauge", "Gauge"},
				{"slider", "Slider"}
			} ;
			OI_number		i ;
			OI_class		*lclsp ;	/* ptr to root class for layout methods */
			OI_class		*clsp ;		/* ptr to layout method class record */
 /*
	Procedure:
 */

	if (conp = OI_init(&argc,argv,"Layout")) {
		wp = oi_create_app_window("main", 400, 400, "Layout");
		wp->set_layout(OI_layout_row,15) ;
		wp->set_associated_object(wp->root(), OI_DEF_LOC, OI_DEF_LOC, OI_not_displayed);

		// Menu of layout methods
		// Start at class OI_layout_method and find all descendant classes which can be created
		mp = oi_create_excl_check_menu("layout",0,(OI_menu_cell**)NULL, OI_vertical, "Layout Method") ;
		lclsp = OI_class_object("OI_layout_method") ;
		for (clsp=lclsp ; clsp ; clsp=clsp->next(lclsp)) {
			if (clsp->is_createable()) {
				cellp = oi_create_menu_cell(NULL, clsp->name(), &chg_layout, clsp) ;
				mp->add_cell(cellp,mp->num_cells()) ;
			}
		}
		mp->layout_associated_object(wp,5,10,OI_active) ;

		// Options for specific layout methods
		bp = oi_create_box("option_box",10,10) ;
		bp->set_frame_width(0) ;
		bp->set_space(10) ;
		bp->layout_associated_object(wp, 6,10,OI_active) ;
		bp->set_layout(OI_layout_row) ;
		mp = oi_create_poly_check_menu("options",OI_n_cells(option_cells),&option_cells[0], OI_vertical, "Options") ;
		mp->layout_associated_object(bp,10,10,OI_active) ;

		// Options specific to wrapped layout methods
		efp = oi_create_seq_entry_field("nwrap",2,"Max items per row/col:","5") ;
		efp->set_entry_chk(chg_wrap) ;
		efp->layout_associated_object(bp,10,20,OI_not_displayed) ;
		efp = oi_create_seq_entry_field("wrap_sp",2,"Wrapped rows/col space:","5") ;
		efp->set_entry_chk(chg_wrap_space) ;
		efp->layout_associated_object(bp,10,30,OI_not_displayed) ;

		// Options specific to row-col based layout methods
		efp = oi_create_entry_field("last_row",6,"Last row:") ;
		efp->layout_associated_object(bp,10,40,OI_active) ;
		efp = oi_create_entry_field("last_col",6,"Last column:") ;
		efp->layout_associated_object(bp,10,50,OI_active) ;

		// Menu for type of object to insert in layout_box
		mp = oi_create_excl_check_menu("obj_typ", OI_count(obj_cells), &obj_cells[0], OI_vertical, "Object Type") ;
		mp->select(OI_yes,"box") ;
		mp->layout_associated_object(wp,7,10,OI_active) ;

		// Container to get layout box, etc on left and opject specific options on right
		colbp = oi_create_box("column_box",10,10) ;
		colbp->set_frame_width(0) ;
		colbp->set_layout(OI_layout_column) ;
		colbp->layout_associated_object(wp,10,50,OI_active) ;

		// Options specific to box objects
		box_optp = oi_create_box("box_options",10,10) ;
		box_optp->set_layout(OI_layout_row) ;
		box_optp->layout_associated_object(colbp,20,10,OI_active) ;
		stp = oi_create_static_text("box_hdr","Box Options") ;
		stp->set_gravity(OI_grav_center) ;
		stp->layout_associated_object(box_optp, 10, 5, OI_active) ;

		// Menu for which labels will show up in a box
		mp = oi_create_poly_check_menu("lbl_mnu",OI_n_cells(label_cells), label_cells, OI_vertical, "Labels");
		mp->set_gravity(OI_grav_north) ;
		for (i=0 ; i<mp->num_cells() ; i++)
			mp->num_select(OI_yes,i) ;
		mp->layout_associated_object(box_optp,10,10,OI_active) ;

		// Menu for size_track option
		mp = oi_create_excl_check_menu("siztrk",OI_n_cells(size_trk_cells), size_trk_cells, OI_vertical, "Size Track");
		mp->allow_unsel() ;
		if (mp->selected())
			mp->selected()->select(OI_no) ;
		mp->set_gravity(OI_grav_north) ;
		mp->layout_associated_object(box_optp,20,10,OI_active) ;

		// Box containing entry fields to set spacing around object specifically
		bp = oi_create_box("space_box",10,10) ;
		bp->set_frame_width(0) ;
		bp->layout_associated_object(box_optp, 40,10,OI_active) ;
		bp->set_layout(OI_layout_row_aligned) ;
		stp = oi_create_static_text("hdr","Object Spacing") ;
		stp->set_gravity(OI_grav_center) ;
		stp->layout_associated_object(bp,10,5,OI_active) ;
		efp = oi_create_entry_field("left_sp",2,"Left Space:") ;
		efp->layout_associated_object(bp,10,10,OI_active) ;
		efp = oi_create_entry_field("right_sp",2,"Right Space:") ;
		efp->layout_associated_object(bp,10,20,OI_active) ;
		efp = oi_create_entry_field("top_sp",2,"Top Space:") ;
		efp->layout_associated_object(bp,10,30,OI_active) ;
		efp = oi_create_entry_field("bottom_sp",2,"Bottom Space:") ;
		efp->layout_associated_object(bp,10,40,OI_active) ;

		// Object gravity menu
		mp = oi_create_excl_check_menu("grav",OI_n_cells(gravcells), gravcells, OI_vertical, "Object Gravity");
		mp->set_default_cell("NorthWest") ;
		mp->select(OI_yes,"NorthWest") ;
		mp->set_gravity(OI_grav_north) ;
		mp->layout_associated_object(wp,8,10,OI_active) ;

		// Create box for row-col geometry parameters
		// Populate box with appropriate geometry fields
		rc_bp = oi_create_box("row_col_geom",1,1) ;
		rc_bp->set_frame_width(0) ;
		rc_bp->set_space(0) ;
		rc_bp->set_layout(OI_layout_row_aligned) ;
		efp = oi_create_seq_entry_field("row_field", 4, "Row: ") ;
		efp->layout_associated_object(rc_bp,10,10,OI_active) ;
		efp = oi_create_seq_entry_field("col_field", 4, "Column: ") ;
		efp->layout_associated_object(rc_bp,10,20,OI_active) ;

		// Create box for tree geometry parameters
		// Populate box with appropriate geometry fields
		tree_bp = oi_create_box("tree_geom",1,1) ;
		tree_bp->set_frame_width(0) ;
		tree_bp->set_space(0) ;
		tree_bp->set_layout(OI_layout_row_aligned) ;
		efp = oi_create_entry_field("parent", 20, "Parent: ") ;
		efp->layout_associated_object(tree_bp,10,10,OI_active) ;
		efp = oi_create_entry_field("sib", 20, "Next Sibling: ") ;
		efp->layout_associated_object(tree_bp,10,20,OI_active) ;

		// Now associate all geometry boxes with the main window, but not displayed
		// Lay the larger one out to take up the proper amount of space so nothing jumps around
		// The boxes will be made active / not_displayed depending on which layout method is active
		geomp = oi_create_box("geom_box",1,1) ;
		geomp->set_gravity(OI_grav_center) ;
		geomp->set_frame_width(0) ;
		geomp->set_vert_space(0) ;
		geomp->set_layout(OI_layout_row) ;
		geomp->layout_associated_object(colbp,10,30,OI_active) ;
		rc_bp->set_associated_object(geomp,0,0,OI_not_displayed) ;
		tree_bp->set_associated_object(geomp,0,0,OI_not_displayed) ;
		if (rc_bp->size_y() > tree_bp->size_y())
			rc_bp->add_to_layout(10,30) ;
		else
			tree_bp->add_to_layout(10,30) ;

		// add control menu for insertion / deletion of objects into layout_box
		mp = oi_create_button_menu("ctl_mnu", OI_count(ctl_cells), &ctl_cells[0], OI_horizontal);
		mp->set_gravity(OI_grav_center) ;
		mp->layout_associated_object(colbp,10,40,OI_active) ;

		// Instructions to user
		stp = oi_create_static_text("msg", "Click on the object to delete it") ;
		stp->set_gravity(OI_grav_center) ;
		stp->layout_associated_object(colbp,10,45,OI_active) ;

		// Box containing laid out objects
		layout_boxp = oi_create_box("layout_box", 10, 10);
		layout_boxp->set_gravity(OI_grav_center) ;
		layout_boxp->set_frame_width(4) ;
		layout_boxp->set_layout((OI_layout)((OI_menu*)(wp->subobject("layout")))->selected()->get_arg()) ;
		layout_boxp->layout_associated_object(colbp,10,50,OI_active) ;

		// Set the appropriate geometry box active
		if (layout_boxp->layout_method()->is_derived_from("OI_layout_row_col"))
			rc_bp->set_state(OI_active) ;
		else if (layout_boxp->layout_method()->is_derived_from("OI_layout_tree"))
			tree_bp->set_state(OI_active) ;

		wp->set_state(OI_active) ;
		OI_begin_interaction();
	}
}

/*
 ******************************************************************************
 *
 *	Function Name:	update_labels
 *
 *		Description: 
 *			Update labels of box objects in layout_box
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Text objects displaying object positioning parameters are modified
 *			to reflect current conditions
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void update_labels()
{
 /*	External Procedures: */
			void		last() ;		/* get last row/column */
 /*	Local Variables: */
			OI_d_tech	*p ;			/* ptr to object in layout method */
			OI_static_text	*stp ;			/* ptr to position label in box objects */
			char		row_col_buff[30] ;
			OI_number	i ;
			OI_entry_field	*efp ;			/* ptr to parent/sibling labels in box objects */
			OI_d_tech	*dtp ;			/* ptr to parent / sibling object */
			OI_lm_row_col	*rc_lmp ;		/* layout method cast to proper type */
			OI_lm_tree	*tree_lmp ;		/* layout method cast to proper type */

	// For row-col based layouts, update row and column position in case they changed
	if (layout_boxp->layout_method()->is_derived_from("OI_layout_row_col")) {
		rc_lmp = (OI_lm_row_col*) layout_boxp->layout_method() ;
		for (i=0 ; i<layout_boxp->num_props() ; i++) {
			p = layout_boxp->numbered_child(i) ;
			if (stp = (OI_static_text*) p->subobject("nam")) {
				sprintf(row_col_buff, "%d-%d", rc_lmp->row_position(p), rc_lmp->column_position(p)) ;
				stp->set_text(row_col_buff) ;
			}
		}
		// Update last row & column display
		last() ;
	}
	// For tree based layouts, update parent and sibling is case they changed
	else if (layout_boxp->layout_method()->is_derived_from("OI_layout_tree")) {
		tree_lmp = (OI_lm_tree*) layout_boxp->layout_method() ;
		for (i=0 ; i<layout_boxp->num_props() ; i++) {
			p = layout_boxp->numbered_child(i) ;
			if (efp = (OI_entry_field*) p->subobject("parent")) {
				dtp = tree_lmp->parent(p) ;
				efp->set_text(dtp ? dtp->name() : "<null>") ;
			}
			if (efp = (OI_entry_field*) p->subobject("sib")) {
				dtp = tree_lmp->sibling(p) ;
				efp->set_text(dtp ? dtp->name() : "<null>") ;
			}
		}
	}
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	del_obj
 *
 *		Description: 
 *			Delete object in layout_box
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Object is deleted
 *			All other objects have their labels updated in case their layout metrics changed
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void del_obj(OI_d_tech *p, void*, OI_number, OI_number, OI_number, OI_number, OI_number)
{
 /*	External Procedures: */
 /*	Local Variables: */

	p->delete_all_delayed() ;
	update_labels() ;
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	create_the_object
 *
 *		Description: 
 *			Create new object to lay out in layout_box
 *
 *		Returns:
 * 
 *		Side Effects:
 *			New object is created and populated, but left in orphanage, ready to be placed in layout_box
 *
 *		Warnings:
 *
 ******************************************************************************
 */
OI_d_tech *create_the_object(
			void			*p1,		// first layout geometry parameter
			void			*p2)		// second layout geometry parameter
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_layout_method	*lmp ;		// ptr to layout method being used
			OI_d_tech		*obp ;		// ptr to box object which will be inserted in layout_box
			OI_static_text		*stp ;		// ptr to name / gravity / size track label in obp
			OI_entry_field		*efp ;
			OI_menu			*mp ;		// ptr to menu to check for options to include in obp
			OI_menu_cell		*cellp ;
			OI_menu			*grav_mp ;	// ptr to gravity selection menu
			OI_menu			*sztrk_mp ;	// ptr to size track selection menu
			char			nam_buff[30] ;	// object name generated here
		static	OI_cell_spec		cells[] = {
							{"cell1","Go Home"},
							{"cell2","Go To Work"},
							{"cell3","Go Eat"},
			} ;
			OI_number		sp ;
		// row-col specific local variables
			OI_number		row,col ;	// row and column for row-col based layout
		// tree specific local variables
			OI_d_tech		*prnt ;		// ptr to parent of new object in layout tree
			OI_d_tech		*sib ;		// ptr to immediately following sibling of new object in layout tree
		static	OI_number		itm_num = 0 ;

	lmp = layout_boxp->layout_method() ;
	// If row-col based layout
	if (lmp->is_derived_from("OI_layout_row_col")) {
		row = (OI_number)(long) p1 ;
		col = (OI_number)(long) p2 ;
		sprintf(nam_buff, "%d-%d", row, col) ;			// generate object name
	}
	else if (lmp->is_derived_from("OI_layout_tree")) {
		prnt = (OI_d_tech*) p1 ;
		sib = (OI_d_tech*) p2 ;
		sprintf(nam_buff,"item_%d",itm_num++) ;
	}
	mp = (OI_menu*) wp->descendant("obj_typ") ;
	grav_mp = (OI_menu*) wp->descendant("grav") ;
	cellp = mp->selected() ;
	// Create appropriate object type depending on object type menu setting
	if (! strcmp(cellp->name(),"box")) {
		obp = oi_create_box(nam_buff, 1, 1) ;
		obp->set_layout(OI_layout_row) ;
		obp->set_frame_width(2) ;
		obp->set_click(&del_obj) ;

		// For box objects, optionally label with object name / position, gravity, and size tracking
		mp = (OI_menu*) wp->descendant("box_options/lbl_mnu") ;
		cellp = (OI_menu_cell*) mp->subobject("name") ;
		if (cellp->selected()) {
			stp = oi_create_static_text("nam", nam_buff) ;
			stp->disallow_cut_paste() ;		// allow clicks to fall through to parent box
			stp->layout_associated_object(obp, 10, 10, OI_active) ;
			if (lmp->is_derived_from("OI_layout_tree")) {
				efp = oi_create_entry_field("prnt", 10, "Parent:", prnt ? prnt->name() : "<null>") ;
				efp->disallow_kb_input() ;
				efp->layout_associated_object(obp, 10, 20, OI_active) ;
				efp = oi_create_entry_field("sib", 10, "Sibling:", sib ? sib->name() : "<null>") ;
				efp->disallow_kb_input() ;
				efp->layout_associated_object(obp, 10, 30, OI_active) ;
			}
		}

		// Add the gravity text if requested
		// Note -- meaningless for tree layout
		if (grav_mp) {
			if (grav_mp->selected()) {
				obp->set_gravity((OI_gravity)(grav_mp->selected()->get_arg())) ;
				cellp = (OI_menu_cell*) mp->subobject("gravity") ;
				if (cellp->selected()) {
					stp = oi_create_static_text("grav_lbl", grav_mp->selected()->label()) ;
					stp->disallow_cut_paste() ;
					stp->layout_associated_object(obp, 10, 120, OI_active) ;
				}
			}
		}

		// Add the size tracking text if requested
		// Note -- meaningless for tree layout
		if (sztrk_mp = (OI_menu*) wp->descendant("box_options/siztrk")) {
			if (sztrk_mp->selected())
				obp->set_size_track((OI_size_track)(sztrk_mp->selected()->get_arg())) ;
			cellp = (OI_menu_cell*) mp->subobject("size_track") ;
			if (cellp->selected() && sztrk_mp->selected()) {
				stp = oi_create_static_text("siztrk_lbl",sztrk_mp->selected()->label()) ;
				stp->disallow_cut_paste() ;
				stp->layout_associated_object(obp, 10, 130, OI_active) ;
			}
		}

		// Set any special spacing
		if (efp = (OI_entry_field*) wp->descendant("left_sp")) {
			if (efp->part_text()) {
				sp = (OI_number) atol(efp->part_text()) ;
				obp->set_left_space(sp) ;
			}
		}
		if (efp = (OI_entry_field*) wp->descendant("right_sp")) {
			if (efp->part_text()) {
				sp = (OI_number) atol(efp->part_text()) ;
				obp->set_right_space(sp) ;
			}
		}
		if (efp = (OI_entry_field*) wp->descendant("top_sp")) {
			if (efp->part_text()) {
				sp = (OI_number) atol(efp->part_text()) ;
				obp->set_top_space(sp) ;
			}
		}
		if (efp = (OI_entry_field*) wp->descendant("bottom_sp")) {
			if (efp->part_text()) {
				sp = (OI_number) atol(efp->part_text()) ;
				obp->set_bottom_space(sp) ;
			}
		}
	}
	else if (! strcmp(cellp->name(), "entry_field")) {
		obp = oi_create_entry_field(nam_buff, 10, "Entry:") ;
		obp->set_click(&del_obj) ;
	}
	else if (! strcmp(cellp->name(), "seq_entry_field")) {
		obp = oi_create_seq_entry_field(nam_buff, 4, "Number:") ;
		obp->set_click(&del_obj) ;
	}
	else if (! strcmp(cellp->name(), "static_text")) {
		obp = oi_create_static_text(nam_buff, "Static Text") ;
		obp->set_click(&del_obj) ;
	}
	else if (! strcmp(cellp->name(), "menu")) {
		obp = oi_create_button_menu(nam_buff, OI_count(cells), &cells[0], OI_horizontal, "Selection:") ;
	}
	else if (! strcmp(cellp->name(), "slider")) {
		obp = oi_create_slider(nam_buff, 100, OI_vertical, 250, -100, NULL, NULL,
			"Control Setting:", OI_slider_ends_none, NULL, NULL, OI_slider_current_none, 7, OI_slider_ticks_all) ;
	}
	else if (! strcmp(cellp->name(), "gauge")) {
		obp = oi_create_gauge(nam_buff, 100, OI_vertical, 250, -100,
			"Control Setting:", OI_gauge_ends_none, NULL, NULL, OI_no, 7, OI_gauge_ticks_all) ;
	}

	// Set gravity according to gravity menu selection
	if (grav_mp && grav_mp->selected())
		obp->set_gravity((OI_gravity)(grav_mp->selected()->get_arg())) ;

	return(obp) ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	add_it
 *
 *		Description: 
 *			Add object to layout_box
 *
 *		Returns:
 * 
 *		Side Effects:
 *			New object is created and layed out in layout_box
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void add_it(OI_menu_cell *, void *, OI_number)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_d_tech	*objp ;		// ptr to new object to place
			void		*p1,*p2 ;	// Layout geometry parameters
			OI_entry_field	*efp ;		// ptr to entry field for geometry specs

	// Get proper layout geometry depending on type of layout
	if (layout_boxp->layout_method()->is_derived_from("OI_layout_row_col")) {
		p1 = p2 = (void*)0 ;
		if (efp = (OI_entry_field*) wp->descendant("row_col_geom/col_field"))
			p1 = (void*) atoi(efp->part_text()) ;
		if (efp = (OI_entry_field*) wp->descendant("row_col_geom/row_field"))
			p2 = (void*) atoi(efp->part_text()) ;
	}
	else if (layout_boxp->layout_method()->is_derived_from("OI_layout_tree")) {
		p1 = p2 = NULL ;
		if (efp = (OI_entry_field*) wp->descendant("tree_geom/parent")) {
			if (efp->part_text())
				p1 = layout_boxp->descendant(efp->part_text()) ;
		}
		if (efp = (OI_entry_field*) wp->descendant("tree_geom/sib")) {
			if (efp->part_text())
				p2 = layout_boxp->descendant(efp->part_text()) ;
		}
	}
	// Create new object and place it
	objp = create_the_object(p1, p2) ;
	objp->layout_associated_object(layout_boxp, p1, p2, OI_active) ;
	// Update labels in case objects have changed their layout geometry as a result of adding the new object
	update_labels() ;
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	clear
 *
 *		Description: 
 *			Remove all objects from layout_box
 *
 *		Returns:
 * 
 *		Side Effects:
 *			All objects in layout_box are deleted
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void clear(OI_menu_cell *, void *, OI_number)
{

	while (layout_boxp->num_props())
		layout_boxp->numbered_child(0)->delete_all() ;
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	chg_layout
 *
 *		Description: 
 *			Change the layout method
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Layout method for layout_box is changed
 *			Geometry of all objects is modified to fit new layout method
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void chg_layout(
			OI_menu_cell	*cellp,		// ptr to cell specifying new layout method
			void		*argp,		// new layout method
			OI_number	)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_d_tech		*geom_boxp ;	// ptr to container for all layout geometry containers
			OI_d_tech		*geomp ;	// ptr to container for layout geometry for new layout method
			OI_d_tech		*old_geomp ;	// ptr to container for layout geometry for old layout method
			OI_layout		lm ;		// selected layout method
			OI_ef_entry_chk_status	chg_wrap(OI_entry_field*,void*) ;
			OI_ef_entry_chk_status	chg_wrap_space(OI_entry_field*,void*) ;
			OI_d_tech		*dtp ;		// workspace
			OI_number		i ;

	if (layout_boxp) {
		if (! layout_boxp->parent()->is_orphanage()) {
			if (cellp->selected()) {
				geomp = old_geomp = NULL ;
				lm = (OI_layout) argp ;
				// Change the layout
				layout_boxp->set_layout(lm) ;
				// Condition new layout method depending on options
				if (((OI_menu_cell*)(wp->subobject("option_box/options/collapse")))->selected())
					layout_boxp->layout_method()->disallow_gaps() ;
				// Update object labels to conform to layout as best we can
				update_labels() ;
				// Turn on / off options depending on type of layout
				// row_col based
				if (layout_boxp->layout_method()->is_derived_from("OI_layout_row_col")) {
					geomp = wp->descendant("row_col_geom") ;
					wp->descendant("last_row")->set_state(OI_active) ;
					wp->descendant("last_col")->set_state(OI_active) ;
					if ((lm == OI_layout_wrapped_row) || (lm == OI_layout_wrapped_column)) {
						wp->descendant("nwrap")->set_state(OI_active) ;
						wp->descendant("wrap_sp")->set_state(OI_active) ;
						chg_wrap((OI_entry_field*)(wp->descendant("nwrap")),NULL) ;
						chg_wrap_space((OI_entry_field*)(wp->descendant("wrap_sp")),NULL) ;
					}
					else {
						wp->descendant("nwrap")->set_state(OI_not_displayed) ;
						wp->descendant("wrap_sp")->set_state(OI_not_displayed) ;
					}
				}
				// tree based
				else if (layout_boxp->layout_method()->is_derived_from("OI_layout_tree")) {
					geomp = wp->descendant("tree_geom") ;
					wp->descendant("nwrap")->set_state(OI_not_displayed) ;
					wp->descendant("wrap_sp")->set_state(OI_not_displayed) ;
					wp->descendant("last_row")->set_state(OI_not_displayed) ;
					wp->descendant("last_col")->set_state(OI_not_displayed) ;
				}
				// Make proper layout geometry parameters visible
				geom_boxp = wp->descendant("geom_box") ;
				for (i=0 ; i<geom_boxp->num_props() ; i++) {
					dtp = geom_boxp->numbered_child(i) ;
					if (dtp->state() == OI_active) {
						old_geomp = dtp ;
						break ;
					}
				}
				if (geomp != old_geomp) {
					if (old_geomp)
						old_geomp->set_state(OI_not_displayed) ;
					if (geomp)
						geomp->set_state(OI_active) ;
				}
			}
		}
	}
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	chg_collapse
 *
 *		Description: 
 *			Change layout option to collapse geometry sequence numbers
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Layout method is reconditioned to allow / disallow gaps in geometry sequences
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void chg_collapse(OI_menu_cell *cellp, void*, OI_number)
{
	if (layout_boxp) {
		if (! layout_boxp->parent()->is_orphanage()) {
			if (cellp->selected())
				layout_boxp->layout_method()->disallow_gaps() ;
			else
				layout_boxp->layout_method()->allow_gaps() ;
		}
	}
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	box_object
 *
 *		Description: 
 *			Turn options for box children off or on depending on type of child
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Option fields for populating box child object are enabled or disabled,
 *			depending on whether the child selection is for box or some other object
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void box_object(OI_menu_cell *cellp, void*, OI_number)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_d_tech	*dtp ;		// ptr to object whose state changes depending on whether or not layout object is a box

	if (dtp = wp->descendant("box_options"))
		dtp->set_state(cellp->selected() ? OI_active : OI_not_displayed) ;
	return ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	chg_wrap
 *
 *		Description: 
 *			Change wrap limit for wrapped row/column layout
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Wrap limit of layout_box layout method is modified;
 *			Objects may be repositioned
 *
 *		Warnings:
 *
 ******************************************************************************
 */
OI_ef_entry_chk_status chg_wrap(OI_entry_field *efp, void*)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_number		n ;		// wrap count
			char			*cp ;
			OI_ef_entry_chk_status	st ;		// return value
			OI_layout_method	*lmp ;

	st = OI_ef_entry_chk_bad ;
	if (cp = efp->part_text()) {
		n = atoi(cp) ;
		if (n > 0) {
			lmp = layout_boxp->layout_method() ;
			if (lmp->is_derived_from("OI_layout_wrapped_row"))
				((OI_lm_wrapped_row*)lmp)->set_wrap(n) ;
			else if (lmp->is_derived_from("OI_layout_wrapped_column"))
				((OI_lm_wrapped_column*)lmp)->set_wrap(n) ;
			st = OI_ef_entry_chk_ok ;
		}
	}
	return(st) ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	chg_wrap_space
 *
 *		Description: 
 *			Change space between mini rows/columns in wrapped layout
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Space between mini rows / columns in wrapped layout is modified
 *
 *		Warnings:
 *
 ******************************************************************************
 */
OI_ef_entry_chk_status chg_wrap_space(OI_entry_field *efp, void*)
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_number		n ;		// space between wrapped row/column mini rows/columns
			char			*cp ;
			OI_ef_entry_chk_status	st ;		// return value
			OI_layout_method	*lmp ;

	st = OI_ef_entry_chk_bad ;
	if (cp = efp->part_text()) {
		n = atoi(cp) ;
		if (n >= 0) {
			lmp = layout_boxp->layout_method() ;
			if (lmp->is_derived_from("OI_layout_wrapped_row"))
				((OI_lm_wrapped_row*)lmp)->set_wrap_space(n) ;
			else if (lmp->is_derived_from("OI_layout_wrapped_column"))
				((OI_lm_wrapped_column*)lmp)->set_wrap_space(n) ;
			st = OI_ef_entry_chk_ok ;
		}
	}
	return(st) ;
}

/*
 ******************************************************************************
 *
 *	Function Name:	last
 *
 *		Description: 
 *			Display last row / column
 *
 *		Returns:
 * 
 *		Side Effects:
 *			Entry fields displaying last row/column are updated
 *
 *		Warnings:
 *
 ******************************************************************************
 */
void last()
{
 /*	External Procedures: */
 /*	Local Variables: */
			OI_entry_field	*efp ;
			OI_number	rc ;		/* last row/column */
			char		buf[11] ;

	if (layout_boxp) {
		if (layout_boxp->layout_method()->is_derived_from("OI_layout_row")) {
			rc = layout_boxp->last_row() ;
			if (efp = (OI_entry_field*) wp->descendant("last_row")) {
				sprintf(buf,"%d",rc) ;
				efp->set_text(buf) ;
			}
			if (efp = (OI_entry_field*) wp->descendant("last_col")) {
				rc = layout_boxp->last_column(rc) ;
				sprintf(buf,"%d",rc) ;
				efp->set_text(buf) ;
			}
		}
		else if (layout_boxp->layout_method()->is_derived_from("OI_layout_column")) {
			rc = layout_boxp->last_column() ;
			if (efp = (OI_entry_field*) wp->descendant("last_col")) {
				sprintf(buf,"%d",rc) ;
				efp->set_text(buf) ;
			}
			if (efp = (OI_entry_field*) wp->descendant("last_row")) {
				rc = layout_boxp->last_row(rc) ;
				sprintf(buf,"%d",rc) ;
				efp->set_text(buf) ;
			}
		}
	}
	return ;
}

