/*
 *******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 *******************************************************************************
 *
 *	File:	pic.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_pic_image related class header
 *
 *	RCSid = "$Id: pic.H,v 4.2.1.1 1993/06/01 22:55:58 mth Exp $"
 *
 *******************************************************************************
 */

#ifndef OI_pic_H
#define OI_pic_H

		class	OI_pic_image ;
		class	OI_pic_spec ;
		class	OI_pic_spec_mask ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#define	OI_PIC_NORMAL_LOC	0
#define	OI_PIC_ACTIVE_LOC	5
#define	OI_PIC_ACTIVE_BKG_LOC	10

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		enum OI_pic_type{
			OI_pic_mask	= 0x1,
			OI_PIC_MASK	= OI_pic_mask,
			OI_pic_full	= 0x2,
			OI_PIC_FULL	= OI_pic_full
		};

		enum OI_pic_pixel {
			OI_pic_none		= 0x0,
			OI_PIC_NONE		= OI_pic_none,
			OI_pic_fg		= 0x1,
			OI_PIC_FG		= OI_pic_fg,
			OI_pic_bg		= 0x2,
			OI_PIC_BG		= OI_pic_bg,
			OI_pic_top		= 0x4,
			OI_PIC_TOP		= OI_pic_top,
			OI_pic_down		= 0x8,
			OI_PIC_DOWN		= OI_pic_down,
			OI_pic_bottom		= 0x10,
			OI_PIC_BOTTOM		= OI_pic_bottom,

			OI_pic_normal_fg	= (OI_PIC_FG<<OI_PIC_NORMAL_LOC),
			OI_PIC_NORMAL_FG	= OI_pic_normal_fg,
			OI_pic_normal_bg	= (OI_PIC_BG<<OI_PIC_NORMAL_LOC),
			OI_PIC_NORMAL_BG	= OI_pic_normal_bg,
			OI_pic_normal_top	= (OI_PIC_TOP<<OI_PIC_NORMAL_LOC),
			OI_PIC_NORMAL_TOP	= OI_pic_normal_top,
			OI_pic_normal_down	= (OI_PIC_DOWN<<OI_PIC_NORMAL_LOC),
			OI_PIC_NORMAL_DOWN	= OI_pic_normal_down,
			OI_pic_normal_bottom	= (OI_PIC_BOTTOM<<OI_PIC_NORMAL_LOC),
			OI_PIC_NORMAL_BOTTOM	= OI_pic_normal_bottom,

			OI_pic_active_fg	= (OI_PIC_FG<<OI_PIC_ACTIVE_LOC),
			OI_PIC_ACTIVE_FG	= OI_pic_active_fg,
			OI_pic_active_bg	= (OI_PIC_BG<<OI_PIC_ACTIVE_LOC),
			OI_PIC_ACTIVE_BG	= OI_pic_active_bg,
			OI_pic_active_top	= (OI_PIC_TOP<<OI_PIC_ACTIVE_LOC),
			OI_PIC_ACTIVE_TOP	= OI_pic_active_top,
			OI_pic_active_down	= (OI_PIC_DOWN<<OI_PIC_ACTIVE_LOC),
			OI_PIC_ACTIVE_DOWN	= OI_pic_active_down,
			OI_pic_active_bottom	= (OI_PIC_BOTTOM<<OI_PIC_ACTIVE_LOC),
			OI_PIC_ACTIVE_BOTTOM	= OI_pic_active_bottom,

			OI_pic_active_bkg_fg	= (OI_PIC_FG<<OI_PIC_ACTIVE_BKG_LOC),
			OI_PIC_ACTIVE_BKG_FG	= OI_pic_active_bkg_fg,
			OI_pic_active_bkg_bg	= (OI_PIC_BG<<OI_PIC_ACTIVE_BKG_LOC),
			OI_PIC_ACTIVE_BKG_BG	= OI_pic_active_bkg_bg,
			OI_pic_active_bkg_top	= (OI_PIC_TOP<<OI_PIC_ACTIVE_BKG_LOC),
			OI_PIC_ACTIVE_BKG_TOP	= OI_pic_active_bkg_top,
			OI_pic_active_bkg_down	= (OI_PIC_DOWN<<OI_PIC_ACTIVE_BKG_LOC),
			OI_PIC_ACTIVE_BKG_DOWN	= OI_pic_active_bkg_down,
			OI_pic_active_bkg_bottom= (OI_PIC_BOTTOM<<OI_PIC_ACTIVE_BKG_LOC),
			OI_PIC_ACTIVE_BKG_BOTTOM= OI_pic_active_bkg_bottom
		};

#define			OI_animate_continuous	0x1		/* animate continuously (cycle through the pixmaps forever) */
#define			OI_ANIMATE_CONTINUOUS	OI_animate_continuous
#define			OI_animate_single	0x2		/* animate once through the pixmaps */
#define			OI_ANIMATE_SINGLE	OI_animate_single
#define			OI_animate_term_stable	0x4		/* use stable pixmap for the glyph upon termination */
#define			OI_ANIMATE_TERM_STABLE	OI_animate_term_stable
#define			OI_animate_term_last	0x8		/* use last pixmap in animation sequence upon termination */
#define			OI_ANIMATE_TERM_LAST	OI_animate_term_last

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

	OI_pic_spec *oi_create_pic_pixmap(Pixmap);
	OI_pic_spec *oi_create_pic_file(const char *);
	OI_pic_spec *oi_create_pic_data(const char *);
	OI_pic_image *oi_create_pic_image_full(OI_d_tech *, OI_number, OI_pic_spec **, OI_number *, OI_number *, OI_number *,
			OI_bool=OI_yes);
	OI_pic_spec_mask *oi_create_pic_pixmap_mask(Pixmap, OI_pic_pixel, OI_pic_pixel, PIXEL=OI_unknown_pixel,
			PIXEL=OI_unknown_pixel);
	OI_pic_spec_mask *oi_create_pic_file_mask(const char *, OI_pic_pixel, OI_pic_pixel, PIXEL=OI_unknown_pixel,
			PIXEL=OI_unknown_pixel);
	OI_pic_spec_mask *oi_create_pic_data_mask(const char *, OI_pic_pixel, OI_pic_pixel, PIXEL=OI_unknown_pixel,
			PIXEL=OI_unknown_pixel);
	OI_pic_image *oi_create_pic_image_mask(OI_d_tech *, OI_number, OI_pic_spec_mask **, OI_pic_pixel,
			OI_number *, OI_number *, OI_bool=OI_yes);

#endif	/* OI_pic_H */
