/* @(#) log_tcp.h 1.3 93/03/07 22:47:41 */

/* Location of the access control files. */

#ifndef HOSTS_ALLOW
#define HOSTS_ALLOW	"/etc/hosts.allow"
#endif

#ifndef HOSTS_DENY
#define HOSTS_DENY	"/etc/hosts.deny"
#endif

 /* Structure filled in by the fromhost() routine. */

struct from_host {
    int     sock_type;			/* socket type, see below */
    char   *name;			/* host name */
    char   *addr;			/* host address */
    char   *user;			/* user name */
    struct sockaddr_in *sin;		/* their side of the link */
};

#define FROM_UNKNOWN	"unknown"	/* name or address lookup failed */
#define FROM_HOST(f) \
    (((f)->name[0] && strcmp((f)->name, FROM_UNKNOWN)) ? (f)->name : (f)->addr)

#define FROM_ADDRLEN	(4*3+3+1)	/* string with IP address */

/* Socket types: 0 means unknown. */

#define FROM_CONNECTED		1	/* connection-oriented */
#define FROM_UNCONNECTED	2	/* non connection-oriented */

/* Global functions. */

extern int fromhost();			/* get/validate remote host info */
extern int hosts_access();		/* access control */
extern void refuse();			/* refuse request */
extern void shell_cmd();		/* execute shell command */
extern void percent_x();		/* do %<char> expansion */
extern char *rfc931_name();		/* remote name from RFC 931 daemon */
extern char *hosts_info();		/* show origin of connection */
extern void clean_exit();		/* clean up and exit */

/* Global variables. */

extern int log_severity;		/* for connection logging */
