#include <stdio.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/************************************************************************
 *
 * Function:    setbuf
 *
 * Description:
 *    Ensure that the file has a buffer when one is needed. This function
 *    is obsolete, even for iBCS. You should use setvbuf which allows for
 *    a buffer of a size other than BUFSIZ.
 *
 * Entry:
 *    stream    - Pointer to the file stream
 *    pvBuffer  - Pointer to the buffer of BUFSIZ or NULL for unbuffered.
 *
 * Returns:
 *    none.
 */

void setbuf (FILE *stream, void *pvBuffer)
    {
    FILE2 *stream2 = file2p (stream);
    FUNC_ENTRY ("setbuf");
/*
 *  Flush the buffer and release the previous buffer data.
 */
    fflush   (stream);
    _freebuf (stream);
/*
 *  If the file is unbuffered then reset the indicator flags
 */
    if (!pvBuffer)
        {
        stream->_flag   |= _IONBF;
        stream->_flag   &= ~_IOMYBUF;
        stream2->_flag2  = 0;
        stream->_ptr     =
	stream->_base    = &(stream2->_charbuf);
        stream2->_bufsiz = 1;
        }
/*
 *  There is a buffer for the file.
 */
    else
        {
        _cflush++;  /* force library pre-termination procedure */
        stream->_flag    &= ~(_IOMYBUF | _IONBF);
        stream2->_flag2   = _IOYOURBUF;
        stream2->_bufsiz  = BUFSIZ;
        stream->_ptr      =
        stream->_base     = pvBuffer;
        }
/*
 *  Reset the count of characters in the buffers and return.
 */
    stream->_cnt = 0;
    FUNC_EXIT ("setbuf");
    }
