/*
 *  /vol/src/devel/gated/master/gated/src/isis_mib.c,v 1.1 1993/01/07 22:39:37 jch Exp
 */


/*
**    isis_mib.c
**
**    
**
**    John Chu <jychu@watson.ibm.com>
**
**
*/



/****************************
*                           *
*       Include Files       *
*                           *
****************************/



#define	INCLUDE_ISODE_SNMP
#include "include.h"



#if	defined(PROTO_ISIS) && defined(PROTO_SNMP)

#define	USE_SNMP_OK_NOTOK
#include "isis_pdus.h"
#include "isis_flood.h"
#include "snmp_isode.h"
#include "isis_mib.h"



/****************************
*                           *
*   External References     *
*                           *
****************************/


AreaAddrList parseLSPAreaAddrList();
AreaAddrList mergeAreaAddrList();


/****************************
*                           *
*   Local Definitions       *
*                           *
****************************/



/* IS-IS object request processors defined in this module */
/* for the get requests */
static int get_isisSysTable();
static int get_isisManAreaAddrTable();
static int get_isisAreaAddrTable();
static int get_isisL2SummAddrTable();
static int get_isisAuthAreaRecPwdTable();
static int get_isisAuthDomainRecPwdTable();
static int get_isisPartRepTable();
static int get_isisPartAreaAddrTable();
static int get_isisVirtAdjTable();
static int get_isisCircTable();
static int get_isisCircAuthRecPwdTable();
static int get_isisISAdjTable();
static int get_isisISAdjAreaAddrTable();
static int get_isisISAdjIPAddrTable();
static int get_isisISAdjProtSuppTable();
static int get_isisESAdjTable();
static int get_isisRATable();
static int get_isisIPRATable();
static int get_isisCLNPDestTable();
static int get_isisIPDestTable();
static int get_isisTestL1LSPDbaseTable();
static int get_isisTestL2LSPDbaseTable();

/* for the set requests */
static int set_isisSysTable();
static int set_isisManAreaAddrTable();
static int set_isisL2SummAddrTable();
static int set_isisAuthAreaRecPwdTable();
static int set_isisAuthDomainRecPwdTable();
static int set_isisPartRepTable();
static int set_isisCircTable();
static int set_isisCircAuthRecPwdTable();
static int set_isisESAdjTable();
static int set_isisRATable();
static int set_isisIPRATable();
static int set_isisTestL1LSPDbaseTable();
static int set_isisTestL2LSPDbaseTable();


/****************************
*                           *
*   Memory Allocation       *
*                           *
****************************/

char dummyOctetString[20];			/* for those not supported */

struct sockaddr_in netaddr;			/* for those not supported */



/*
**	Build the isis object tree
*/

static struct object_table isis_objects[] = {

    /* The System Group object tree, mandatory */

    /* Initialize the System Table, read-write */
   {"isisSysInstance",	      	get_isisSysTable, NULL,		1},
   {"isisSysExistState",	get_isisSysTable, NULL,		2},
   {"isisSysVersion",	      	get_isisSysTable, NULL,		3},
   {"isisSysType",		get_isisSysTable, NULL,		4},
   {"isisSysID",		get_isisSysTable, NULL,		5},
   {"isisSysMaxPathSplits",	get_isisSysTable, NULL,		6},
   {"isisSysMinLSPTransInt",    get_isisSysTable, NULL,		7},
   {"isisSysMaxLSPGenInt",	get_isisSysTable, NULL,		8},
   {"isisSysMinBroadLSPTransInt",get_isisSysTable, NULL,	9},
   {"isisSysCompSNPInt",	get_isisSysTable, NULL,		10},
   {"isisSysOrigL1LSPBuffSize", get_isisSysTable, NULL,		11},
   {"isisSysMaxAreaAddresses",  get_isisSysTable, NULL,		12},
   {"isisSysMinLSPGenInt",	get_isisSysTable, NULL,		13},
   {"isisSysPollESHelloRate",   get_isisSysTable, NULL,		14},
   {"isisSysPartSNPInt",	get_isisSysTable, NULL,		15},
   {"isisSysWaitTime",	        get_isisSysTable, NULL,		16},
   {"isisSysDRISISHelloTimer",  get_isisSysTable, NULL,		17},
   {"isisSysOperState",	        get_isisSysTable, NULL,		18},
   {"isisSysL1State",	        get_isisSysTable, NULL,		19},
   {"isisSysCorrLSPs",	        get_isisSysTable, NULL,		20},
   {"isisSysLSPL1DbaseOloads",  get_isisSysTable, NULL,		21},
   {"isisSysManAddrDropFromAreas",	get_isisSysTable, NULL,	22},
   {"isisSysAttemptToExMaxSeqNums",	get_isisSysTable, NULL,	23},
   {"isisSysSeqNumSkips",		get_isisSysTable, NULL, 24},
   {"isisSysOwnLSPPurges",		get_isisSysTable, NULL,	25},
   {"isisSysIDFieldLenMismatches",	get_isisSysTable, NULL,	26},
   {"isisSysMaxAreaAddrMismatches",	get_isisSysTable, NULL,	27},
   {"isisSysOrigL2LSPBufSize",  get_isisSysTable, NULL,		28},
   {"isisSysL2State",	        get_isisSysTable, NULL,		29},
   {"isisSysLSPL2DbaseOloads",  get_isisSysTable, NULL,		30},
   {"isisSysAuthAreaTransPwd",  get_isisSysTable, NULL,		31},
   {"isisSysAuthDomainTransPwd",get_isisSysTable, NULL,		32},
   {"isisSysAuthFails",	        get_isisSysTable, NULL,		33},

    /* Initialize the Level 1 Manual Area Address Table, read-write */
   {"isisManAreaAddrSysInstance",	get_isisManAreaAddrTable, NULL,	1},
   {"isisManAreaAddr",			get_isisManAreaAddrTable, NULL,	2},
   {"isisManAreaAddrExistState",	get_isisManAreaAddrTable, NULL,	3},

    /* Initialize the Level 1 Area Address Table, read-only */
   {"isisAreaAddrSysInstance",		get_isisAreaAddrTable, NULL,	1},
   {"isisAreaAddr",			get_isisAreaAddrTable, NULL,	2},


    /* The Level 2 IP Group, present if the system is a level 2 IS and supports
    /* integrated IS-IS */

    /* Initialize the Level 2 IP Summary Address Table, read-write */
   {"isisL2SummAddrSysInstance",	get_isisL2SummAddrTable, NULL,	1},
   {"isisL2SummAddress",		get_isisL2SummAddrTable, NULL,	2},
   {"isisL2SummAddrMask",		get_isisL2SummAddrTable, NULL,	3},
   {"isisL2SummAddrExistState",		get_isisL2SummAddrTable, NULL,	4},
   {"isisL2SummAddrOperState",		get_isisL2SummAddrTable, NULL,	5},
   {"isisL2SummAddrDefaultMetric",	get_isisL2SummAddrTable, NULL,	6},
   {"isisL2SummAddrDelayMetric",	get_isisL2SummAddrTable, NULL,	7},
   {"isisL2SummAddrExpenseMetric",	get_isisL2SummAddrTable, NULL,	8},
   {"isisL2SummAddrErrorMetric",	get_isisL2SummAddrTable, NULL,	9},


    /* The Authentication Group, present if the authentication procedures are
    /* supported */

    /* Initialize the Level 1 Area Receive Password Table, read-write */
   {"isisAuthAreaRecPwdSysInstance",	get_isisAuthAreaRecPwdTable, NULL,	1},
   {"isisAreaRecPwd",           	get_isisAuthAreaRecPwdTable, NULL,	2},
   {"isisAreaRecPwdExistState", 	get_isisAuthAreaRecPwdTable, NULL,	3},

    /* Initialize the Level 2 Domain Receive Password Table, read-write */
   {"isisAuthDomainRecPwdSysInstance",	get_isisAuthDomainRecPwdTable, NULL,	1},
   {"isisAuthDomainRecPwd",		get_isisAuthDomainRecPwdTable, NULL,	2},
   {"isisAuthDomainRecPwdExistState", 	get_isisAuthDomainRecPwdTable, NULL,	3},


    /* The Partition Repair Group, present if the system is a Level 2 IS and
    /* the partition repair option is implemented */

    /* Initialize the Partition Repair Table, read-write */
   {"isisPartRepSysInstance",	get_isisPartRepTable, NULL,	1},
   {"isisPartRepMaxVirtAdj",	get_isisPartRepTable, NULL,	2},
   {"isisPartRepDesL2IS",	get_isisPartRepTable, NULL,	3},
   {"isisPartRepVirtLinkChgs",	get_isisPartRepTable, NULL,	4},

    /* Initialize the Partition Area Address Table, read-only */
   {"isisPartAreaAddrSysInstance",	get_isisPartAreaAddrTable, NULL,	1},
   {"isisPartAreaAddr",			get_isisPartAreaAddrTable, NULL,	2},

    /* Initialize the Virtual Adjacency Table, read-only */
   {"isisVirtAdjSysInstance",	get_isisVirtAdjTable, NULL,	1},
   {"isisVirtAdjCircIndex",	get_isisVirtAdjTable, NULL,	2},
   {"isisVirtAdjIndex",		get_isisVirtAdjTable, NULL,	3},
   {"isisVirtAdjNET",		get_isisVirtAdjTable, NULL,	4},
   {"isisVirtAdjMetric",	get_isisVirtAdjTable, NULL,	5},


    /* The Circuit Group, mandatory */

    /* Initialize the Circuit Table, read-write */
   {"isisCircSysInstance",	get_isisCircTable, NULL,	1},
   {"isisCircIndex",		get_isisCircTable, NULL,	2},
   {"isisCircIfIndex",		get_isisCircTable, NULL,	3},
   {"isisCircOperState",	get_isisCircTable, NULL,	4},
   {"isisCircExistState",	get_isisCircTable, NULL,	5},
   {"isisCircType",		get_isisCircTable, NULL,	6},
   {"isisCircISISHelloTimer",	get_isisCircTable, NULL,	7},
   {"isisCircL1DefaultMetric",	get_isisCircTable, NULL,	8},
   {"isisCircL1DelayMetric",	get_isisCircTable, NULL,	9},
   {"isisCircL1ExpenseMetric",	get_isisCircTable, NULL,	10},
   {"isisCircL1ErrorMetric",	get_isisCircTable, NULL,	11},
   {"isisCircExtDomain",	get_isisCircTable, NULL,	12},
   {"isisCircAdjChanges",	get_isisCircTable, NULL,	13},
   {"isisCircInitFails",	get_isisCircTable, NULL,	14},
   {"isisCircRejAdjs",		get_isisCircTable, NULL,	15},
   {"isisCircOutCtrlPDUs",	get_isisCircTable, NULL,	16},
   {"isisCircInCtrlPDUs",	get_isisCircTable, NULL,	17},
   {"isisCircIDFieldLenMismatches",	get_isisCircTable, NULL,	18},
   {"isisCircMaxAreaAddrMismatches",	get_isisCircTable, NULL,	19},
   {"isisCircL2DefaultMetric",	get_isisCircTable, NULL,	20},
   {"isisCircL2DelayMetric",	get_isisCircTable, NULL,	21},
   {"isisCircL2ExpenseMetric",	get_isisCircTable, NULL,	22},
   {"isisCircL2ErrorMetric",	get_isisCircTable, NULL,	23},
   {"isisCircManL2Only",	get_isisCircTable, NULL,	24},
   {"isisCircL1ISPriority",	get_isisCircTable, NULL,	25},
   {"isisCircL1CircID",		get_isisCircTable, NULL,	26},
   {"isisCircL1DesIS",		get_isisCircTable, NULL,	27},
   {"isisCircLANL1DesISChanges",get_isisCircTable, NULL,	28},
   {"isisCircL2ISPriority",	get_isisCircTable, NULL,	29},
   {"isisCircL2CircID",		get_isisCircTable, NULL,	30},
   {"isisCircL2DesIS",		get_isisCircTable, NULL,	31},
   {"isisCircLANL2DesISChanges",get_isisCircTable, NULL,	32},
   {"isisCircPtToPtCircID",	get_isisCircTable, NULL,	33},
   {"isisCircStaticCallInfo",	get_isisCircTable, NULL,	34},
   {"isisCircDACallDefMetInc",	get_isisCircTable, NULL,	35},
   {"isisCircDACallDelMetInc",	get_isisCircTable, NULL,	36},
   {"isisCircDACallErrMetInc",	get_isisCircTable, NULL,	37},
   {"isisCircDACallExpMetInc",	get_isisCircTable, NULL,	38},
   {"isisCircAuthTransPwd",	get_isisCircTable, NULL,	39},
   {"isisCircAuthFails",	get_isisCircTable, NULL,	40},


    /* The Circuit Authentication Group, present if the Circuit authentication 
    /* procedures are implemented */

    /* Initialize the Circuit Receive Password Table, read-write */
   {"isisCircAuthRecPwdSysInstance",	get_isisCircAuthRecPwdTable, NULL,	1},
   {"isisCircAuthRecPwdCircIndex",	get_isisCircAuthRecPwdTable, NULL,	2},
   {"isisCircAuthRecPwd",		get_isisCircAuthRecPwdTable, NULL,	3},
   {"isisCircAuthRecPwdExistState",	get_isisCircAuthRecPwdTable, NULL,	4},


    /* The IS Adjacency Group, mandatory and contains info about adjacencies to 
    /* routers maintained by the Integrated IS-IS protocol */

    /* Initialize the IS Adjacency Table, read-only */
   {"isisISAdjSysInstance",		get_isisISAdjTable, NULL,	1},
   {"isisISAdjCircIndex",		get_isisISAdjTable, NULL,	2},
   {"isisISAdjIndex",			get_isisISAdjTable, NULL,	3},
   {"isisISAdjState",			get_isisISAdjTable, NULL,	4},
   {"isisISAdjNeighSNPAAddress",	get_isisISAdjTable, NULL,	5},
   {"isisISAdjNeighSysType",		get_isisISAdjTable, NULL,	6},
   {"isisISAdjNeighSysID",		get_isisISAdjTable, NULL,	7},
   {"isisISAdjUsage",			get_isisISAdjTable, NULL,	8},
   {"isisISAdjHoldTimer",		get_isisISAdjTable, NULL,	9},
   {"isisISAdjNeighPriority",		get_isisISAdjTable, NULL,	10},

    /* Initialize the IS Adjacency Area Address Table, read-only */
   {"isisISAdjAreaAddrSysInstance",	get_isisISAdjAreaAddrTable, NULL,	1},
   {"isisISAdjAreaAddrCircIndex", 	get_isisISAdjAreaAddrTable, NULL,	2},
   {"isisISAdjAreaAddrAdjIndex", 	get_isisISAdjAreaAddrTable, NULL,	3},
   {"isisISAdjAreaAddress",		get_isisISAdjAreaAddrTable, NULL,	4},


    /* The IS Adjacency IP Group, present if the system supports Integrated IS-IS */

    /* Initialize the IS Adjacency IP Address Table, read-only */
   {"isisISAdjIPAddrSysInstance",	get_isisISAdjIPAddrTable, NULL,	1},
   {"isisISAdjIPAddrCircIndex",		get_isisISAdjIPAddrTable, NULL,	2},
   {"isisISAdjIPAddrAdjIndex",		get_isisISAdjIPAddrTable, NULL,	3},
   {"isisISAdjIPAddress",		get_isisISAdjIPAddrTable, NULL,	4},

    /* Initialize the IS Adjacency Protocol Supported Table, read-only */
   {"isisISAdjProtSuppSysInstance",	get_isisISAdjProtSuppTable, NULL,	1},
   {"isisISAdjProtSuppCircIndex", 	get_isisISAdjProtSuppTable, NULL,	2},
   {"isisISAdjProtSuppAdjIndex",  	get_isisISAdjProtSuppTable, NULL,	3},
   {"isisISAdjProtSuppProtocol",  	get_isisISAdjProtSuppTable, NULL,	4},


    /* The ES Adjacency Group, present if the system supports reception of ES Hellos */

    /* Initialize the ES Adjacency Table, read-write */
   {"isisESAdjSysInstance",	get_isisESAdjTable, NULL,	1},
   {"isisESAdjCircIndex",	get_isisESAdjTable, NULL,	2},
   {"isisESAdjAdjIndex",	get_isisESAdjTable, NULL,	3},
   {"isisESAdjType",		get_isisESAdjTable, NULL,	4},
   {"isisESAdjState",		get_isisESAdjTable, NULL,	5},
   {"isisESAdjNeighSNPAAddress",get_isisESAdjTable, NULL,	6},
   {"isisESAdjExistState",	get_isisESAdjTable, NULL,	7},
   {"isisESAdjESID",		get_isisESAdjTable, NULL,	8},


    /* The Reachable Address Group, optional */

    /* Initialize the Reachable Address Table, read-write */
   {"isisRASysInstance",	get_isisRATable, NULL,	1},
   {"isisRACircIndex",		get_isisRATable, NULL,	2},
   {"isisRAIndex",		get_isisRATable, NULL,	3},
   {"isisRAExistState",		get_isisRATable, NULL,	4},
   {"isisRAOperState",		get_isisRATable, NULL,	5},
   {"isisRAAddrPrefix",		get_isisRATable, NULL,	6},
   {"isisRAMapType",		get_isisRATable, NULL,	7},
   {"isisRADefMetric",		get_isisRATable, NULL,	8},
   {"isisRADelMetric",		get_isisRATable, NULL,	9},
   {"isisRAExpMetric",		get_isisRATable, NULL,	10},
   {"isisRAErrMetric",		get_isisRATable, NULL,	11},
   {"isisRADefMetricType",	get_isisRATable, NULL,	12},
   {"isisRADelMetricType",	get_isisRATable, NULL,	13},
   {"isisRAExpMetricType",	get_isisRATable, NULL,	14},
   {"isisRAErrMetricType",	get_isisRATable, NULL,	15},
   {"isisRASNPAAddress",	get_isisRATable, NULL,	16},
   {"isisRASNPAMask",		get_isisRATable, NULL,	17},
   {"isisRASNPAPrefix",		get_isisRATable, NULL,	18},
   {"isisRASNPAPrefLastOctetLength",get_isisRATable, NULL,	19},


    /* The IP Reachable Address Group, optional */

    /* Initialize the IP Reachable Address Table, read-write */
   {"isisIPRASysInstance", 	get_isisIPRATable, NULL,	1},
   {"isisIPRACircIndex", 	get_isisIPRATable, NULL,	2},
   {"isisIPRAIndex", 		get_isisIPRATable, NULL,	3},
   {"isisIPRADest", 		get_isisIPRATable, NULL,	4},
   {"isisIPRAMask", 		get_isisIPRATable, NULL,	5},
   {"isisIPRAExistState", 	get_isisIPRATable, NULL,	6},
   {"isisIPRAOperState", 	get_isisIPRATable, NULL,	7},
   {"isisIPRADefMetric", 	get_isisIPRATable, NULL,	8},
   {"isisIPRADelMetric", 	get_isisIPRATable, NULL,	9},
   {"isisIPRAExpMetric", 	get_isisIPRATable, NULL,	10},
   {"isisIPRAErrMetric", 	get_isisIPRATable, NULL,	11},
   {"isisIPRADefMetricType",	get_isisIPRATable, NULL,	12},
   {"isisIPRADelMetricType",	get_isisIPRATable, NULL,	13},
   {"isisIPRAExpMetricType",	get_isisIPRATable, NULL,	14},
   {"isisIPRAErrMetricType",	get_isisIPRATable, NULL,	15},
   {"isisIPRASNPAAddress", 	get_isisIPRATable, NULL,	16},


    /* The CLNP Destination Group, present if the system forwards ISO 8473 packets */

    /* Initialize the CLNP Destination Table, read-only */
   {"isisCLNPRouteDest",	get_isisCLNPDestTable, NULL,	1},
   {"isisCLNPRouteMetQOS",	get_isisCLNPDestTable, NULL,	2},
   {"isisCLNPRouteMetType",	get_isisCLNPDestTable, NULL,	3},
   {"isisCLNPRouteIntMetric",	get_isisCLNPDestTable, NULL,	4},
   {"isisCLNPRouteExtMetric",	get_isisCLNPDestTable, NULL,	5},
   {"isisCLNPRouteForw",	get_isisCLNPDestTable, NULL,	6},
   {"isisCLNPRouteSource",	get_isisCLNPDestTable, NULL,	7},


    /* The IP Destination Group, present if the system forwards IP packets */

    /* Initialize the IP Destination Table, read-only */
   {"isisIPRouteDest",		get_isisIPDestTable, NULL,	1},
   {"isisIPRouteMask",		get_isisIPDestTable, NULL,	2},
   {"isisIPRouteMetQOS",	get_isisIPDestTable, NULL,	3},
   {"isisIPRouteMetType",	get_isisIPDestTable, NULL,	4},
   {"isisIPRouteIntMetric",	get_isisIPDestTable, NULL,	5},
   {"isisIPRouteExtMetric",	get_isisIPDestTable, NULL,	6},
   {"isisIPRouteForw",		get_isisIPDestTable, NULL,	7},
   {"isisIPRouteSource",	get_isisIPDestTable, NULL,	8},


   /* The Test Group */

   /* Initialize the Level 1 LSP Database Table */
   {"isisL1LSPIndex",		get_isisTestL1LSPDbaseTable, NULL,	1},
   {"isisL1LSPLinkForw",	get_isisTestL1LSPDbaseTable, NULL,	2},
   {"isisL1LSPLinkBack",	get_isisTestL1LSPDbaseTable, NULL,	3},
   {"isisL1LSPSigIdSourceId",	get_isisTestL1LSPDbaseTable, NULL,	4},
   {"isisL1LSPSigIdPseudonodeID", get_isisTestL1LSPDbaseTable, NULL,	5},
   {"isisL1LSPSigIdLSPNum",	get_isisTestL1LSPDbaseTable, NULL,	6},
   {"isisL1LSPSigSeqNum",	get_isisTestL1LSPDbaseTable, NULL,	7},
   {"isisL1LSPSigLifeTime",	get_isisTestL1LSPDbaseTable, NULL,	8},
   {"isisL1LSPSigLevel",	get_isisTestL1LSPDbaseTable, NULL,	9},
   {"isisL1LSPSigChecksum",	get_isisTestL1LSPDbaseTable, NULL,	10},
   {"isisL1LSPOrigLifeTime",	get_isisTestL1LSPDbaseTable, NULL,	11},
   {"isisL1LSPRemainTime",	get_isisTestL1LSPDbaseTable, NULL,	12},
   {"isisL1LSPArrivalTimestamp",get_isisTestL1LSPDbaseTable, NULL,	13},
   {"isisL1LSPSRM",		get_isisTestL1LSPDbaseTable, NULL,	14},
   {"isisL1LSPSSN",		get_isisTestL1LSPDbaseTable, NULL,	15},
   {"isisL1LSPFoundInSNP",	get_isisTestL1LSPDbaseTable, NULL,	16},
   {"isisL1LSPOnDeletedList",	get_isisTestL1LSPDbaseTable, NULL,	17},
   {"isisL1LSPBuf",		get_isisTestL1LSPDbaseTable, NULL,	18},
   {"isisL1LSPLen",		get_isisTestL1LSPDbaseTable, NULL,	19},
   {"isisL1LSPDesc",		get_isisTestL1LSPDbaseTable, NULL,	20},
   {"isisL1LSPHashNext",	get_isisTestL1LSPDbaseTable, NULL,	21},
   {"isisL1LSPSortNext",	get_isisTestL1LSPDbaseTable, NULL,	22},

   /* Initialize the Level 2 LSP Database Table */
   {"isisL2LSPIndex",		get_isisTestL2LSPDbaseTable, NULL,	1},
   {"isisL2LSPLinkForw",	get_isisTestL2LSPDbaseTable, NULL,	2},
   {"isisL2LSPLinkBack",	get_isisTestL2LSPDbaseTable, NULL,	3},
   {"isisL2LSPSigIdSourceId",	get_isisTestL2LSPDbaseTable, NULL,	4},
   {"isisL2LSPSigIdPseudonodeID", get_isisTestL2LSPDbaseTable, NULL,	5},
   {"isisL2LSPSigIdLSPNum",	get_isisTestL2LSPDbaseTable, NULL,	6},
   {"isisL2LSPSigSeqNum",	get_isisTestL2LSPDbaseTable, NULL,	7},
   {"isisL2LSPSigLifeTime",	get_isisTestL2LSPDbaseTable, NULL,	8},
   {"isisL2LSPSigLevel",	get_isisTestL2LSPDbaseTable, NULL,	9},
   {"isisL2LSPSigChecksum",	get_isisTestL2LSPDbaseTable, NULL,	10},
   {"isisL2LSPOrigLifeTime",	get_isisTestL2LSPDbaseTable, NULL,	11},
   {"isisL2LSPRemainTime",	get_isisTestL2LSPDbaseTable, NULL,	12},
   {"isisL2LSPArrivalTimestamp",get_isisTestL2LSPDbaseTable, NULL,	13},
   {"isisL2LSPSRM",		get_isisTestL2LSPDbaseTable, NULL,	14},
   {"isisL2LSPSSN",		get_isisTestL2LSPDbaseTable, NULL,	15},
   {"isisL2LSPFoundInSNP",	get_isisTestL2LSPDbaseTable, NULL,	16},
   {"isisL2LSPOnDeletedList",	get_isisTestL2LSPDbaseTable, NULL,	17},
   {"isisL2LSPBuf",		get_isisTestL2LSPDbaseTable, NULL,	18},
   {"isisL2LSPLen",		get_isisTestL2LSPDbaseTable, NULL,	19},
   {"isisL2LSPDesc",		get_isisTestL2LSPDbaseTable, NULL,	20},
   {"isisL2LSPHashNext",	get_isisTestL2LSPDbaseTable, NULL,	21},
   {"isisL2LSPSortNext",	get_isisTestL2LSPDbaseTable, NULL,	22},

   {NULL}

}; /* end of isis_objects[] */


/* Object tree node for isis */
struct snmp_tree isis_mib_tree = {
	NULL,
	NULL,
	"isis",
	NULLOID,
	readOnly,			/* for now */
	isis_objects,
	0
};


/****************************
*                           *
*  Procedure Definitions    *
*                           *
****************************/

/*
**	Initialize IS-IS mib
*/
void isis_init_mib(enabled)
int	enabled;
{
    if (enabled) {
        snmp_tree_register(&isis_mib_tree);
    }
    else {
        snmp_tree_unregister(&isis_mib_tree);
    }
}



/* Request processors */



/*
**	Process a request referencing a variable in the System Table
*/
static int get_isisSysTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
			    int request				)
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			/* leaf node in object tree */
    int		instance=0;		/* instance of an object */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisSysEntry	*pSysEntry;	/* ptr to a Sys entry */

    /* Validate the request and adjust variable name if necessary */
    switch (request) {
    case type_SMUX_PDUs_get__request:
	/* Examine the suffix to the object id whose value is requested */
	/* For 'get' request, the object identifier must be one element larger than */
 	/* that in the object type, and the extra element cannot be of value zero */

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) {
	    /* Instance was not specified in the request; it has to be */
	    return int_SNMP_error__status_noSuchName;
	}
	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) {
	    /* Instance was specified as 0 in the request; there is no 0th instance */
	    return int_SNMP_error__status_noSuchName;
	}
  	
        /* Get the instance if it exists */
        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    /* Instance does not exist */
	    return int_SNMP_error__status_noSuchName;
        }

    	break;

    case type_SMUX_PDUs_get__next__request:
	/* Examine the suffix to the object id */
	/* For 'get-next' request, the object id name should have the same number of */
	/* elements or more than that in the object type */

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {  	/* same */
	    ObjectID pnewoid;		/* ptr to a new object identifier */

	    /* Copy the object id and extend it by one element, in VarBind */
	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) {
		return int_SNMP_error__status_genErr;
	    }
	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    /* No instance was specified in the request */
	    instance = 0;
     	}
	else {		/* more */
	    /* Get the instance specified */
            instance = poid->oid_elements[pot->ot_name->oid_nelem];

	}

	/* Get the next instance if it exists */
        if ((pMibEntry = (IsisMibEntry *)locateNextEntry(&isisMibTable, instance)) ==
							         (IsisMibEntry *)NULL) {
            /* The next instance of the object does not exist  */
            /* The next object in the object tree should be handled */
	    return NOTOK;
        }        

	/* Place it in the variable binding struct */
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = ++instance;
  	    
	break;

    default:
	/* Unsupported request */
	return int_SNMP_error__status_genErr;

    } /* end of switch on request */

    pSysEntry = &pMibEntry->isisSysEntry;

    /* Extract the column number of the variable in the entry of this table */
    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    /* Put the requested variables's current value into the name/value binding struct */
    switch (column) {
    case 1:			/* isisSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysInstance);

    case 2:			/* isisSysExistState, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysExistState);

    case 3:                	/* isisSysVersion, OCTET STRING */
	return o_string(poi, pvarbind, pSysEntry->isisSysVersion.contents,
				       pSysEntry->isisSysVersion.len      );	

    case 4:			/* isisSysType, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysType);

    case 5: 			/* isisSysID, OCTET STRING */
	return o_string(poi, pvarbind, pSysEntry->isisSysID.contents,
				       pSysEntry->isisSysID.len      );

    case 6:			/* isisSysMaxPathSplits, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMaxPathSplits);

    case 7: 			/* isisSysMinLSPTransInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMinLSPTransInt);

    case 8:			/* isisSysMaxLSPGenInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMaxLSPGenInt);

    case 9: 			/* isisSysMinBroadLSPTransInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMinBroadLSPTransInt);

    case 10:			/* isisSysCompSNPInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysCompSNPInt);

    case 11:			/* isisSysOrigL1LSPBuffSize, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysOrigL1LSPBuffSize);

    case 12:			/* isisSysMaxAreaAddresses, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMaxAreaAddresses);

    case 13:			/* isisSysMinLSPGenInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysMinLSPGenInt);

    case 14:			/* isisSysPollESHelloRate, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysPollESHelloRate);

    case 15:			/* isisSysPartSNPInt, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysPartSNPInt);

    case 16:			/* isisSysWaitTime, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysWaitTime);

    case 17:			/* isisSysDRISISHelloTimer, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysDRISISHelloTimer);

    case 18:			/* isisSysOperState, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysOperState);

    case 19:			/* isisSysL1State, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysL1State);

    case 20:			/* isisSysCorrLSPs, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysCorrLSPs);

    case 21:			/* isisSysLSPL1DbaseOloads, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysLSPL1DbaseOloads);

    case 22:			/* isisSysManAddrDropFromAreas, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysManAddrDropFromAreas);

    case 23:			/* isisSysAttemptToExMaxSeqNums, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysAttemptToExMaxSeqNums);

    case 24:			/* isisSysSeqNumSkips, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysSeqNumSkips);

    case 25:			/* isisSysOwnLSPPurges, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysOwnLSPPurges);

    case 26:			/* isisSysIDFieldLenMismatches, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysIDFieldLenMismatches);

    case 27:			/* isisSysMaxAreaAddrMismatches, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysMaxAreaAddrMismatches);

    case 28:			/* isisSysOrigL2LSPBufSize, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysOrigL2LSPBufSize);

    case 29:			/* isisSysL2State, INTEGER */
	return o_integer(poi, pvarbind, pSysEntry->isisSysL2State);

    case 30:			/* isisSysLSPL2DbaseOloads, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysLSPL2DbaseOloads);

    case 31:			/* isisSysAuthAreaTransPwd, OCTET STRING */
	return o_string(poi, pvarbind, pSysEntry->isisSysAuthAreaTransPwd.contents,
				       pSysEntry->isisSysAuthAreaTransPwd.len      );

    case 32:			/* isisSysAuthDomainTransPwd, OCTET STRING */
	return o_string(poi, pvarbind, pSysEntry->isisSysAuthDomainTransPwd.contents,
				       pSysEntry->isisSysAuthDomainTransPwd.len      );

    case 33:			/* isisSysAuthFails, Counter */
	return o_number(poi, pvarbind, pSysEntry->isisSysAuthFails);

    default:
	return int_SNMP_error__status_noSuchName;

    } /* end of switch on colume */




} /* end of get_isisSysTable() */

static int set_isisSysTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisSysTable() */


/*
**	Process a request referencing a variable in the Level 1 Manual Area
**      Address Table
*/
static int get_isisManAreaAddrTable(ObjectInstance * poi,
 				    struct type_SNMP_VarBind * pvarbind,
 				    int request         		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		/* SysInstance */
    int		addrIndex=0;		/* index to manual area addresses */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisSysEntry	*pSysEntry;	/* ptr to a Sys entry */
    IsisManAreaAddrEntry *pManAreaAddrEntry;
    ObjectID 		pnewoid;	
    int			extendOID=0;

    /* ??? The isis mib definition uses the area address as object id. 	*/
    /* Its usefulness is yet to be seen.				*/
    /* An index is used to identify an area address, for time being. ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+2) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-2]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    return int_SNMP_error__status_noSuchName;
        }
	pSysEntry = &pMibEntry->isisSysEntry;

	if ((addrIndex = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pManAreaAddrEntry = 
	     (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable, 
					         addrIndex                        )) ==
					          (IsisManAreaAddrEntry *)NULL         ){
	    return int_SNMP_error__status_noSuchName;
        }

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem >= pot->ot_name->oid_nelem+2) {      
	    /* Instance and addr index are specified */

            if ((instance = poid->oid_elements[pot->ot_name->oid_nelem]) == 0) {
		/* The instance was specified as 0 */

		instance += 1;
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
		addrIndex = 1;
   	    }
	    else {	/* the instance was specified as none-zero */
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
		addrIndex = poid->oid_elements[pot->ot_name->oid_nelem+1] + 1;
	    }
	    pSysEntry = &pMibEntry->isisSysEntry;
		
            if ((pManAreaAddrEntry = 
	         (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisManAreaAddrEntry *)NULL         ){

		instance += 1;
                if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	                return NOTOK;
                }
    		pSysEntry = &pMibEntry->isisSysEntry;

		addrIndex = 1;
        	if ((pManAreaAddrEntry = 
	     	     (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable, addrIndex)) ==
					          (IsisManAreaAddrEntry *)NULL         ){

	                return NOTOK;

		}

	    }
	    /* pManAreaAddrEntry points to the desired manual area addr entry */

     	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+1) {
	    /* Instance was specified */

	    if ((instance = poid->oid_elements[pot->ot_name->oid_nelem]) == 0) {
		/* Instance was specified as zero */

		instance += 1;
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }

	    }
	    else {	/* the instance was specified as none-zero */
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
	    }
	    pSysEntry = &pMibEntry->isisSysEntry;	    
	    addrIndex = 1;
		
            if ((pManAreaAddrEntry = 
	         (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisManAreaAddrEntry *)NULL         ){

		instance += 1;
                if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	                return NOTOK;
                }
    		pSysEntry = &pMibEntry->isisSysEntry;

		addrIndex = 1;
        	if ((pManAreaAddrEntry = 
	     	     (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable, addrIndex)) ==
					          (IsisManAreaAddrEntry *)NULL         ){

	                return NOTOK;

		}

	    }
	    /* pManAreaAddrEntry points to the desired manual area addr entry */

	    extendOID = 1;

	}
	else {
	    /* Only object id was specified */

	    instance = 1;
            if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
            }
	    pSysEntry = &pMibEntry->isisSysEntry;
	    addrIndex = 1;

       	    if ((pManAreaAddrEntry = 
	         (IsisManAreaAddrEntry *)locateEntry(&pSysEntry->isisManAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisManAreaAddrEntry *)NULL         ){
	            return NOTOK;
            }

	    extendOID = 2;

	}
    	/* pManAreaAddrEntry points to the desired manual area addr entry */

	if (extendOID) {	/* binding oid needs to be extended */
	    if ((pnewoid = oid_extend(poid, extendOID)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

   	}

	/* New binding */
    	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+1] = addrIndex;

	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisManAreaAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pManAreaAddrEntry->isisManAreaAddrSysInstance);

    case 2: 			/* isisManAreaAddr, OSINSAddress */
 	return o_string(poi, pvarbind, pManAreaAddrEntry->isisManAreaAddr.contents,
				       pManAreaAddrEntry->isisManAreaAddr.len      );

    case 3: 			/* isisManAreaAddrExistState, INTEGER */
	return o_integer(poi, pvarbind, pManAreaAddrEntry->isisManAreaAddrExistState);

    default:
	return int_SNMP_error__status_noSuchName;

    } 



} /* end of get_isisManAreaAddrTable() */

static int set_isisManAreaAddrTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisManAreaAddrTable() */



/*
**	Process a request referencing a variable in the Level 1 Area Address Table
*/
static int get_isisAreaAddrTable(ObjectInstance * poi,
			         struct type_SNMP_VarBind * pvarbind,
 				 int request           		     )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		/* SysInstance */
    int		addrIndex=0;		/* index to manual area addresses */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisSysEntry	*pSysEntry;	/* ptr to a Sys entry */
    IsisAreaAddrEntry *pAreaAddrEntry;
    ObjectID 		pnewoid;	
    int			extendOID=0;

    /* ??? The isis mib definition uses the area address as object id. 	*/
    /* Its usefulness is yet to be seen.				*/
    /* An index is used to identify an area address, for time being. ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+2) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-2]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    return int_SNMP_error__status_noSuchName;
        }
	pSysEntry = &pMibEntry->isisSysEntry;

	if ((addrIndex = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pAreaAddrEntry = 
	     (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable, 
					         addrIndex                        )) ==
					          (IsisAreaAddrEntry *)NULL         ){
	    return int_SNMP_error__status_noSuchName;
        }

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem >= pot->ot_name->oid_nelem+2) {      
	    /* Instance and addr index are specified */

            if ((instance = poid->oid_elements[pot->ot_name->oid_nelem]) == 0) {
		/* The instance was specified as 0 */

		instance += 1;
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
		addrIndex = 1;
   	    }
	    else {	/* the instance was specified as none-zero */
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
		addrIndex = poid->oid_elements[pot->ot_name->oid_nelem+1] + 1;
	    }
	    pSysEntry = &pMibEntry->isisSysEntry;
		
            if ((pAreaAddrEntry = 
	         (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisAreaAddrEntry *)NULL         ){

		instance += 1;
                if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	                return NOTOK;
                }
    		pSysEntry = &pMibEntry->isisSysEntry;

		addrIndex = 1;
        	if ((pAreaAddrEntry = 
	     	     (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable, addrIndex)) ==
					          (IsisAreaAddrEntry *)NULL         ){

	                return NOTOK;

		}

	    }
	    /* pAreaAddrEntry points to the desired manual area addr entry */

     	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+1) {
	    /* Instance was specified */

	    if ((instance = poid->oid_elements[pot->ot_name->oid_nelem]) == 0) {
		/* Instance was specified as zero */

		instance += 1;
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }

	    }
	    else {	/* the instance was specified as none-zero */
                if ((pMibEntry = 
		     (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
                }
	    }
	    pSysEntry = &pMibEntry->isisSysEntry;	    
	    addrIndex = 1;
		
            if ((pAreaAddrEntry = 
	         (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisAreaAddrEntry *)NULL         ){

		instance += 1;
                if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	                return NOTOK;
                }
    		pSysEntry = &pMibEntry->isisSysEntry;

		addrIndex = 1;
        	if ((pAreaAddrEntry = 
	     	     (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable, addrIndex)) ==
					          (IsisAreaAddrEntry *)NULL         ){

	                return NOTOK;

		}

	    }
	    /* pAreaAddrEntry points to the desired manual area addr entry */

	    extendOID = 1;

	}
	else {
	    /* Only object id was specified */

	    instance = 1;
            if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	     					                  (IsisMibEntry *)NULL) {
	            return NOTOK;
            }
	    pSysEntry = &pMibEntry->isisSysEntry;
	    addrIndex = 1;

       	    if ((pAreaAddrEntry = 
	         (IsisAreaAddrEntry *)locateEntry(&pSysEntry->isisAreaAddrTable,
				                            addrIndex            )) ==
					          (IsisAreaAddrEntry *)NULL         ){
	            return NOTOK;
            }

	    extendOID = 2;

	}
    	/* pAreaAddrEntry points to the desired manual area addr entry */

	if (extendOID) {	/* binding oid needs to be extended */
	    if ((pnewoid = oid_extend(poid, extendOID)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

   	}

	/* New binding */
    	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+1] = addrIndex;

	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Use the L1 LSP database directly */
    {
    
    LSEntry		*pLSEntry;		/* ptr to L1 LSP db */
    AreaAddrList 	aggregatedList;
    AreaAddr		*pAreaAddr;

    for (pLSEntry = firstLSP(1); pLSEntry; pLSEntry = pLSEntry->sortNext) {
	if (pLSEntry->signature.id.LSPNumber != 0) { /* not locally gen'ed */
	    aggregatedList = mergeAreaAddrList(parseLSPAreaAddrList(pLSEntry->buf,
								    pLSEntry->len ),
					       aggregatedList                       );

 	}
    }

    if (addrIndex > aggregatedList.count) {
	/* Not that many area addresses */
	if (request == type_SMUX_PDUs_get__request) 	    
	    return int_SNMP_error__status_noSuchName;
	else return NOTOK;
    }    

    pAreaAddr = retrieveAreaAddr(aggregatedList.areaAddr[addrIndex-1]);


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisAreaAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pAreaAddrEntry->isisAreaAddrSysInstance);

    case 2: 			/* isisAreaAddr, OSINSAddress */
 	return o_string(poi, pvarbind, pAreaAddr->addr, pAreaAddr->len);

/* 	return o_string(poi, pvarbind, pAreaAddrEntry->isisAreaAddr.contents,
				       pAreaAddrEntry->isisAreaAddr.len      );
*/

    default:
	return int_SNMP_error__status_noSuchName;

    } 

    } /* end of using L1 LSP database directly */


} /* end of get_isisAreaAddrTable() */


/*
**	Process a request referencing a variable in the Level 2 IP Group,
**      the Level 2 IP summary address table
*/
static int get_isisL2SummAddrTable(ObjectInstance * poi,
				   struct type_SNMP_VarBind * pvarbind,
 				   int request         		       )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisL2SummAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2: 			/* isisL2SummAddress, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 3:			/* isisL2SummAddrMask, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 4: 			/* isisL2SummAddrExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 5:			/* isisL2SummAddrOperState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 6:			/* isisL2SummAddrDefaultMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 7:			/* isisL2SummAddrDelayMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 8:			/* isisL2SummAddrExpenseMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 9:			/* isisL2SummAddrErrorMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisL2SummAddrTable() */


static int set_isisL2SummAddrTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisL2SummAddrTable() */

/*
**	Process a request referencing a variable in the Authentication Group,
**      the Level 1 Area Receive Password Table
*/
static int get_isisAuthAreaRecPwdTable(ObjectInstance * poi,
				       struct type_SNMP_VarBind * pvarbind,
 				       int request         		   )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		

    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisAuthAreaRecPwdSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisAreaRecPwd, OCTET STRING */
        return o_string(poi, pvarbind, dummyOctetString, 16);

    case 3:			/* isisAreaRecPwdExistState. INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisAuthAreaRecPwdTable() */

static int set_isisAuthAreaRecPwdTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* set_isisAuthAreaRecPwdTable() */

/*
**	Process a request referencing a variable in the Authentication Group,
**   	the Level 2 Domain Receive Password Table
*/
static int get_isisAuthDomainRecPwdTable(ObjectInstance * poi,
					 struct type_SNMP_VarBind * pvarbind,
 					 int request         		     )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisAuthDomainRecPwdSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisAuthDomainRecPwd, OCTET STRING */
	return o_string(poi, pvarbind, dummyOctetString, 16);

    case 3:			/* isisAuthDomainRecPwdExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisAuthDomainRecPwdTable() */

static int set_isisAuthDomainRecPwdTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisAuthDomainRecPwdTable() */

/*
**	Process a request referencing a variable in the Partition Repair Group,
**	the Part Repair Table
*/
static int get_isisPartRepTable(ObjectInstance * poi,
				struct type_SNMP_VarBind * pvarbind,
 				int request         		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		

    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisPartRepSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisPartRepMaxVirtAdj, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisPartRepDesL2IS, OCTET STRING */
	return o_string(poi, pvarbind, dummyOctetString, 8);

    case 4:			/* isisPartRepVirtLinkChgs, Counter */
	return o_number(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisPartRepTable() */

static int set_isisPartRepTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* set_isisPartRepTable() */

/*
**	Process a request referencing a variable in the Partition Repair Group,
**	the Partition Area Address Table
*/
static int get_isisPartAreaAddrTable(ObjectInstance * poi,
				     struct type_SNMP_VarBind * pvarbind,
 				     int request         		 )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisPartAreaAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisPartAreaAddr, OSINSAddress */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisPartAreaAddrTable() */

/*
**	Process a request referencing a variable in the Virtual Adjacency Table
*/
static int get_isisVirtAdjTable(ObjectInstance * poi,
			        struct type_SNMP_VarBind * pvarbind,
 				int request         		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisVirtAdjSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisVirtAdjCircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisVirtAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisVirtAdjNET, OSINSAddress */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 5:			/* isisVirtAdjMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisVirtAdjTable() */


/*
**	Process a request referencing a variable in the Circuit Group,
**   	the Circuit Table
*/
static int get_isisCircTable(ObjectInstance * poi,
			     struct type_SNMP_VarBind * pvarbind,
 			     int request         		     )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    unsigned int 	instances[HEIGHTCIRCUIT];
    int		instance=0;		/* SysInstance */
    int		circIndex=0;		/* index to a circuit */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisCircTable	*pCircTable;
    IsisCircEntry 	*pCircEntry;
    ObjectID 		pnewoid;	
    int			extendOID=0;


    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+2) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-2]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    return int_SNMP_error__status_noSuchName;
        }
	pCircTable = &pMibEntry->isisCircTable;

	if ((circIndex = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pCircEntry = (IsisCircEntry *)locateEntry(pCircTable, circIndex)) ==
					                    (IsisCircEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem >= pot->ot_name->oid_nelem+2) {      
	    /* Instance and circuit index were specified */
	    extendOID = 0;

	    instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
	    instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1] + 1;

     	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+1) {
	    /* Instance was specified */
	    extendOID = 1;

	    instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
	    instances[1] = 1;

	}
	else {
	    /* Only object id was specified */
	    extendOID = 2;

	    instances[0] = 1;
	    instances[1] = 1;

	}

    	if ((pCircEntry = (IsisCircEntry *)searchEntry(instances,
		                                       HEIGHTCIRCUIT,
						       DEPTHSYSTEM,
						       &isisMibTable )) ==
		                                     (IsisCircEntry *)NULL) {
	    
	    return NOTOK;
	}
	/* pCircEntry points to the desired circuit entry */


	if (extendOID) {	/* binding oid needs to be extended */
	    if ((pnewoid = oid_extend(poid, extendOID)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

   	}

	/* New binding */
    	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instances[0];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+1] = instances[1];

        instance = instances[0];
	circIndex = instances[1];

	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisCircSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircSysInstance);

    case 2:			/* isisCircIndex, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircIndex);

    case 3:			/* isisCircIfIndex, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircIfIndex);

    case 4:			/* isisCircOperState, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircOperState);

    case 5:			/* isisCircExistState, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircExistState);

    case 6:			/* isisCircType, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircType);

    case 7:			/* isisCircISISHelloTimer, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircISISHelloTimer);

    case 8:			/* isisCircL1DefaultMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL1DefaultMetric);

    case 9:			/* isisCircL1DelayMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL1DelayMetric);

    case 10:			/* isisCircL1ExpenseMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL1ExpenseMetric);

    case 11:			/* isisCircL1ErrorMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL1ErrorMetric);

    case 12:			/* isisCircExtDomain, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircExtDomain);

    case 13:			/* isisCircAdjChanges, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircAdjChanges);

    case 14:			/* isisCircInitFails, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircInitFails);

    case 15:			/* isisCircRejAdjs, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircRejAdjs);

    case 16:			/* isisCircOutCtrlPDUs, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircOutCtrlPDUs);

    case 17:			/* isisCircInCtrlPDUs, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircInCtrlPDUs);

    case 18:			/* isisCircIDFieldLenMismatches, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircIDFieldLenMismatches);

    case 19:			/* isisCircMaxAreaAddrMismatches, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircMaxAreaAddrMismatches);

    case 20:			/* isisCircL2DefaultMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL2DefaultMetric);

    case 21:			/* isisCircL2DelayMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL2DelayMetric);

    case 22:			/* isisCircL2ExpenseMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL2ExpenseMetric);

    case 23:			/* isisCircL2ErrorMetric, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL2ErrorMetric);

    case 24:			/* isisCircManL2Only, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircManL2Only);

    case 25:			/* isisCircL1ISPriority, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL1ISPriority);

    case 26:			/* isisCircL1CircID, OCTET STRING */
	return o_string(poi, pvarbind, pCircEntry->isisCircL1CircID.contents,
				       pCircEntry->isisCircL1CircID.len  	);

    case 27:			/* isisCircL1DesIS, OCTET STRING */
	return o_string(poi, pvarbind, pCircEntry->isisCircL1DesIS.contents,
				       pCircEntry->isisCircL1DesIS.len  	);

    case 28:			/* isisCircLANL1DesISChanges, Counter */
  	return o_number(poi, pvarbind, pCircEntry->isisCircLANL1DesISChanges);

    case 29:			/* isisCircL2ISPriority, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircL2ISPriority);

    case 30:			/* isisCircL2CircID, OCTET STRING */
	return o_string(poi, pvarbind, pCircEntry->isisCircL2CircID.contents,
				       pCircEntry->isisCircL2CircID.len  	);

    case 31:			/* isisCircL2DesIS, OCTET STRING */
	return o_string(poi, pvarbind, pCircEntry->isisCircL2DesIS.contents,
				       pCircEntry->isisCircL2DesIS.len  	);

    case 32:			/* isisCircLANL2DesISChanges, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircLANL2DesISChanges);

    case 33:			/* isisCircPtToPtCircID, OCTET STRING */
	return o_string(poi, pvarbind, pCircEntry->isisCircPtToPtCircID.contents,
				       pCircEntry->isisCircPtToPtCircID.len  	 );

    case 34:			/* isisCircStaticCallInfo, OBJECT IDENTIFIER */
	return o_specific(poi, pvarbind, text2oid("0.0"));     /* ??? */

    case 35:			/* isisCircDACallDefMetInc, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircDACallDefMetInc);

    case 36:			/* isisCircDACallDelMetInc, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircDACallDelMetInc);

    case 37:			/* isisCircDACallErrMetInc, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircDACallErrMetInc);

    case 38:			/* isisCircDACallExpMetInc, INTEGER */
	return o_integer(poi, pvarbind, pCircEntry->isisCircDACallExpMetInc);

    case 39:			/* isisCircAuthTransPwd. OCTET STRING */
   	return o_string(poi, pvarbind, pCircEntry->isisCircAuthTransPwd.contents,
				       pCircEntry->isisCircAuthTransPwd.len   	 );

    case 40:			/* isisCircAuthFails, Counter */
	return o_number(poi, pvarbind, pCircEntry->isisCircAuthFails);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisCircTable() */


static int set_isisCircTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisCircTable() */

/*
**	Process a request referencing a variable in the Circuit Authentication Group,
**   	the Circuit Receive Password Table
*/
static int get_isisCircAuthRecPwdTable(ObjectInstance * poi,
				       struct type_SNMP_VarBind * pvarbind,
 				       int request         		       )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:           		/* isisCircAuthRecPwdSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisCircAuthRecPwdCircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisCircAuthRecPwd, OCTET STRING */
        return o_string(poi, pvarbind, dummyOctetString, 16);

    case 4:			/* isisCircAuthRecPwdExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisCircAuthRecPwdTable() */

static int set_isisCircAuthRecPwdTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisCircAuthRecPwdTable() */

/*
**	Process a request referencing a variable in the IS Adjacency Group,
**    	the IS Adjacency Table
*/
static int get_isisISAdjTable(ObjectInstance * poi,
			      struct type_SNMP_VarBind * pvarbind,
 			      int request         		      )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    unsigned int instances[HEIGHTISADJ];
    int		instance=0;		/* SysInstance */
    int		circIndex=0;		/* index to a circuit */
    int		adjIndex=0;		/* index to an adjacency */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisCircTable	*pCircTable;
    IsisCircEntry 	*pCircEntry;
    IsisISAdjTable	*pISAdjTable;
    IsisISAdjEntry	*pISAdjEntry;
    ObjectID 		pnewoid;	
    int			extendOID=0;


    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+3) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-3]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    return int_SNMP_error__status_noSuchName;
        }
	pCircTable = &pMibEntry->isisCircTable;

	if ((circIndex = poid->oid_elements[poid->oid_nelem-2]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pCircEntry = (IsisCircEntry *)locateEntry(pCircTable, circIndex)) ==
					                    (IsisCircEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }
        pISAdjTable = &pCircEntry->isisISAdjTable;

	if ((adjIndex = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pISAdjEntry = (IsisISAdjEntry *)locateEntry(pISAdjTable, adjIndex)) ==
					                    (IsisISAdjEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }
	/* pISAdjEntry points to the desired IS Adj entry */

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem+3) {      
	    /* Instance and circuit index and adj index  were specified */
	    extendOID = 0;	    

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1];
            instances[2] = poid->oid_elements[pot->ot_name->oid_nelem+2] + 1;

        }
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+2) {      
	    /* Instance and circuit index were specified */
	    extendOID = 1;	    

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1];
            instances[2] = 1;

     	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+1) {
	    /* Instance was specified */
	    extendOID = 2;

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = 1;
            instances[2] = 1;

	}
	else {
	    /* Only object id was specified */
	    extendOID = 3;

            instances[0] = 1;
            instances[1] = 1;
            instances[2] = 1;

	}

	if ((pISAdjEntry = (IsisISAdjEntry *)searchEntry(instances,
							 HEIGHTISADJ,
							 DEPTHSYSTEM,
							 &isisMibTable)) ==
						     (IsisISAdjEntry *)NULL) {

	    return NOTOK;
	}
    	/* pISAdjEntry points to the desired IS Adj entry */

	if (extendOID) {	/* binding oid needs to be extended */
	    if ((pnewoid = oid_extend(poid, extendOID)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

   	}

	/* New binding */
    	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instances[0];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+1] = instances[1];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+2] = instances[2];

  	instance = instances[0];
	circIndex = instances[1];
	adjIndex = instances[2];

	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisISAdjSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjSysInstance);

    case 2:			/* isisISAdjCircIndex, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjCircIndex);

    case 3:			/* isisISAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjIndex);

    case 4:			/* isisISAdjState, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjState);

    case 5:			/* isisISAdjNeighSNPAAddress, OCTET STRING */
	return o_string(poi, pvarbind, pISAdjEntry->isisISAdjNeighSNPAAddress.contents,
				       pISAdjEntry->isisISAdjNeighSNPAAddress.len    );

    case 6:			/* isisISAdjNeighSysType, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjNeighSysType);

    case 7:			/* isisISAdjNeighSysID, OCTET STRING */
	return o_string(poi, pvarbind, pISAdjEntry->isisISAdjNeighSysID.contents,
				       pISAdjEntry->isisISAdjNeighSysID.len      );

    case 8:			/* isisISAdjUsage, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjUsage);

    case 9:			/* isisISAdjHoldTimer, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjHoldTimer);

    case 10:			/* isisISAdjNeighPriority, INTEGER */
	return o_integer(poi, pvarbind, pISAdjEntry->isisISAdjNeighPriority);

    default:
	return int_SNMP_error__status_noSuchName;

    } 



} /* end of get_isisISAdjTable() */

/*
**	Process a request referencing a variable in the IS Adjacency Group,
**	the IS Adjacency Area Address Table
*/
static int get_isisISAdjAreaAddrTable(ObjectInstance * poi,
				      struct type_SNMP_VarBind * pvarbind,
 				      int request         		  )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    unsigned int instances[HEIGHTISADJAREAADDR];
    int		instance=0;		/* SysInstance */
    int		circIndex=0;		/* index to a circuit */
    int		adjIndex=0;		/* index to an adjacency */
    int		addrIndex=0;		/* index to an adjacency area address */
    IsisMibEntry	*pMibEntry;	/* ptr to an isis mib entry */
    IsisCircTable	*pCircTable;
    IsisCircEntry 	*pCircEntry;
    IsisISAdjTable	*pISAdjTable;
    IsisISAdjEntry	*pISAdjEntry;
    IsisISAdjAreaAddrTable	*pISAdjAreaAddrTable;
    IsisISAdjAreaAddrEntry	*pISAdjAreaAddrEntry;
    ObjectID 		pnewoid;	
    int			extendOID=0;


    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+4) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-4]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pMibEntry = (IsisMibEntry *)locateEntry(&isisMibTable, instance)) ==
	    					             (IsisMibEntry *)NULL){
	    return int_SNMP_error__status_noSuchName;
        }
	pCircTable = &pMibEntry->isisCircTable;

	if ((circIndex = poid->oid_elements[poid->oid_nelem-3]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pCircEntry = (IsisCircEntry *)locateEntry(pCircTable, circIndex)) ==
					                    (IsisCircEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }
        pISAdjTable = &pCircEntry->isisISAdjTable;

	if ((adjIndex = poid->oid_elements[poid->oid_nelem-2]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pISAdjEntry = (IsisISAdjEntry *)locateEntry(pISAdjTable, adjIndex)) ==
					                    (IsisISAdjEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }
	pISAdjAreaAddrTable = &pISAdjEntry->isisISAdjAreaAddrTable;

	if ((addrIndex = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if ((pISAdjAreaAddrEntry = (IsisISAdjAreaAddrEntry *)locateEntry(pISAdjAreaAddrTable, addrIndex)) ==
				                    (IsisISAdjAreaAddrEntry *)NULL) {
	    return int_SNMP_error__status_noSuchName;
        }
	/* pISAdjAreaAddrEntry points to the desired IS Adj Area Address entry */

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem+4) {      
	    /* Instance and circuit index, adj index and addr index were specified */
	    extendOID = 0;	    

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1];
            instances[2] = poid->oid_elements[pot->ot_name->oid_nelem+2];
            instances[3] = poid->oid_elements[pot->ot_name->oid_nelem+3] + 1;
	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+3) {      
	    /* Instance and circuit index and adj index  were specified */
	    extendOID = 1;	    

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1];
            instances[2] = poid->oid_elements[pot->ot_name->oid_nelem+2];
            instances[3] = 1;
        }
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+2) {      
	    /* Instance and circuit index were specified */
	    extendOID = 2;	    

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = poid->oid_elements[pot->ot_name->oid_nelem+1];
            instances[2] = 1;
            instances[3] = 1;

     	}
	else if (poid->oid_nelem == pot->ot_name->oid_nelem+1) {
	    /* Instance was specified */
	    extendOID = 3;

            instances[0] = poid->oid_elements[pot->ot_name->oid_nelem];
            instances[1] = 1;
            instances[2] = 1;
            instances[3] = 1;

	}
	else {
	    /* Only object id was specified */
	    extendOID = 4;

            instances[0] = 1;
            instances[1] = 1;
            instances[2] = 1;
            instances[3] = 1;

	}

	if ((pISAdjAreaAddrEntry = (IsisISAdjAreaAddrEntry *)searchEntry(instances,
							            HEIGHTISADJAREAADDR,
							            DEPTHSYSTEM,
							            &isisMibTable)) ==
						        (IsisISAdjAreaAddrEntry *)NULL) {

	    return NOTOK;
	}
    	/* pISAdjAreaAddrEntry points to the desired IS Adj Area Address entry */

	if (extendOID) {	/* binding oid needs to be extended */
	    if ((pnewoid = oid_extend(poid, extendOID)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

   	}

	/* New binding */
    	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instances[0];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+1] = instances[1];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+2] = instances[2];
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem+3] = instances[3];

  	instance = instances[0];
	circIndex = instances[1];
	adjIndex = instances[2];
	addrIndex = instances[3];

	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisISAdjAreaAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, pISAdjAreaAddrEntry->isisISAdjAreaAddrSysInstance);

    case 2:			/* isisISAdjAreaAddrCircIndex, INTEGER */
	return o_integer(poi, pvarbind, pISAdjAreaAddrEntry->isisISAdjAreaAddrCircIndex);

    case 3:			/* isisISAdjAreaAddrAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, pISAdjAreaAddrEntry->isisISAdjAreaAddrAdjIndex);

    case 4:			/* isisISAdjAreaAddress, OSINSAddress */
	return o_string(poi, pvarbind, pISAdjAreaAddrEntry->isisISAdjAreaAddress.contents,
				       pISAdjAreaAddrEntry->isisISAdjAreaAddress.len    );

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisISAdjAreaAddrTable() */



/*
**	Process a request referencing a variable in the IS Adjacency Group,
**	the IS Adjacency IP Address Table
*/
static int get_isisISAdjIPAddrTable(ObjectInstance * poi,
				    struct type_SNMP_VarBind * pvarbind,
 				    int request         		)
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisISAdjIPAddrSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisISAdjIPAddrCircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisISAdjIPAddrAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisISAdjIPAddress, IpAddress */
	return o_string(poi, pvarbind, &netaddr);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisISAdjIPAddrTable() */


 

/*
**	Process a request referencing a variable in the IS Adjacency Group,
**	the IS Adjacency Protocol Supported Table
*/
static int get_isisISAdjProtSuppTable(ObjectInstance * poi,
				      struct type_SNMP_VarBind * pvarbind,
 				      int request         		  )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisISAdjProtSuppSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisISAdjProtSuppCircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisISAdjProtSuppAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisISAdjProtSuppProtocol, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisISAdjProtSuppTable() */




/*
**	Process a request referencing a variable in the ES Adjacency Group,
**	the ES Adjacency Table
*/
static int get_isisESAdjTable(ObjectInstance * poi,
			      struct type_SNMP_VarBind * pvarbind,
 			      int request         		      )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisESAdjSysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisESAdjCircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisESAdjAdjIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisESAdjType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 5:			/* isisESAdjState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 6: 	 		/* isisESAdjNeighSNPAAddress, OCTET STRING */
 	return o_string(poi, pvarbind, dummyOctetString, 20);
	
    case 7:			/* isisESAdjExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 8:			/* isisESAdjESID, OCTET STRING */
 	return o_string(poi, pvarbind, dummyOctetString, 8);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisESAdjTable() */


static int set_isisESAdjTable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisESAdjTable() */



/*
**	Process a request referencing a variable in the Reachable Address Group,
**	the Reachable Address Table
*/
static int get_isisRATable(ObjectInstance * poi,
			   struct type_SNMP_VarBind * pvarbind,
 			   int request         		       )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisRASysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisRACircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisRAIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisRAExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 5:			/* isisRAOperState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 6:			/* isisRAAddrPrefix, OSINSAddress */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 7:			/* isisRAMapType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 8:			/* isisRADefMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 9:			/* isisRADelMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 10:			/* isisRAExpMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 11:			/* isisRAErrMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 12:			/* isisRADefMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 13:			/* isisRADelMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 14:			/* isisRAExpMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 15:			/* isisRAErrMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 16:			/* isisRASNPAAddress, OCTET STRING */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 17:			/* isisRASNPAMask, OSINSAddress */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 18:			/* isisRASNPAPrefix, OCTET STRING */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 19:			/* isisRASNPAPrefLastOctetLength, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisRATable() */

static int set_isisRATable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisRATable() */




/*
**	Process a request referencing a variable in the IP Reachable Address Group,
**	the IP Reachable Address Table
*/
static int get_isisIPRATable(ObjectInstance * poi,
			     struct type_SNMP_VarBind * pvarbind,
 			     int request         		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisIPRASysInstance, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 2:			/* isisIPRACircIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisIPRAIndex, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisIPRADest, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 5:			/* isisIPRAMask, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 6:			/* isisIPRAExistState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 7:			/* isisIPRAOperState, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 8:			/* isisIPRADefMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 9:			/* isisIPRADelMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 10:			/* isisIPRAExpMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 11:			/* isisIPRAErrMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 12:			/* isisIPRADefMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 13:			/* isisIPRADelMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 14:			/* isisIPRAExpMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 15:			/* isisIPRAErrMetricType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 16:			/* isisIPRASNPAAddress, OCTET STRING */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisIPRATable() */

static int set_isisIPRATable(ObjectInstance * poi,
			    struct type_SNMP_VarBind * pvarbind,
 			    int request         		    )
{




} /* end of set_isisIPRATable() */


/*
**	Process a request referencing a variable in the CLNP Destination Group,
**	the CLNP Destination Table
*/
static int get_isisCLNPDestTable(ObjectInstance * poi,
				 struct type_SNMP_VarBind * pvarbind,
 				 int request         		     )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		

    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisCLNPRouteDest, OSINSAddress */
	return o_string(poi, pvarbind, dummyOctetString, 20);

    case 2:			/* isisCLNPRouteMetQOS, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 3:			/* isisCLNPRouteMetType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisCLNPRouteIntMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 5:			/* isisCLNPRouteExtMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 6:			/* isisCLNPRouteForw, OBJECT IDENTIFIER */
	return o_specific(poi, pvarbind, text2oid("0.0"));

    case 7:			/* isisCLNPRouteSource, INTEGER */
	return o_integer(poi, pvarbind, 0);


    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisCLNPDestTable() */




/*
**	Process a request referencing a variable in the IP Destination Group,
**	the IP Destination Table
*/
static int get_isisIPDestTable(ObjectInstance * poi,
			       struct type_SNMP_VarBind * pvarbind,
 			       int request         		   )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		


    /* Determine the number of is-is instances in existence at this point in time */
    /* ??? */

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

        if (locateinstance(instance) == NULL) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}

        if ((instance = locatenextinstance(instance)) == NULL) 
	    return NOTOK;

	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 


    /* Get access to this mib entry, updated if necessary */
    /* ??? */

    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:			/* isisIPRouteDest, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 2:			/* isisIPRouteMask, IpAddress */
	return o_ipaddr(poi, pvarbind, &netaddr);

    case 3:			/* isisIPRouteMetQOS, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 4:			/* isisIPRouteMetType, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 5:			/* isisIPRouteIntMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 6:			/* isisIPRouteExtMetric, INTEGER */
	return o_integer(poi, pvarbind, 0);

    case 7:			/* isisIPRouteForw, OBJECT IDENTIFIER */
 	return o_specific(poi, pvarbind, text2oid("0.0"));

    case 8:			/* isisIPRouteSource, INTEGER */
	return o_integer(poi, pvarbind, 0);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisIPDestTable() */




/*
**	Process a request referencing a variable in the Test Group,
**	the Level 1 LSP Database Table
*/

static int get_isisTestL1LSPDbaseTable(ObjectInstance * poi,
			               struct type_SNMP_VarBind * pvarbind,
 			               int request	     		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		
    LSEntry	*pLSEntry;
    int		i, found;

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}
	instance += 1;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 

    /* Locate the desired instance */
    for (i = 1, found = FALSE, pLSEntry = firstLSP(1); pLSEntry; ++i) {
	if (i == instance) {
	    found = TRUE;		/* the desired instance */
	    break;
	}
	
	pLSEntry = pLSEntry->sortNext;
    }

    if (found) {
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
    }
    else {
	if (request == type_SMUX_PDUs_get__request)
	    return int_SNMP_error__status_noSuchName;
	else return NOTOK;

    }


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:				/* isisL1LSPIndex, INTEGER */
	return o_integer(poi, pvarbind, instance);

    case 2:				/* isisL1LSPLinkForw, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->links.forw);

    case 3:				/* isisL1LSPLinkBack, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->links.back);

    case 4:				/* isisL1LSPSigIdSourceId, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->signature.id.sourceID, 6);

    case 5:				/* isisL1LSPSigIdPseudonodeID, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.id.pseudonodeID);

    case 6:				/* isisL1LSPSigIdLSPNum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.id.LSPNumber);

    case 7:				/* isisL1LSPSigSeqNum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.seqNum);

    case 8:				/* isisL1LSPSigLifeTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.lifetime);

    case 9:				/* isisL1LSPSigLevel, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.level);

    case 10:				/* isisL1LSPSigChecksum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.checksum);

    case 11:				/* isisL1LSPOrigLifeTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->originalLifetime);

    case 12:				/* isisL1LSPRemainTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->remainingTime);

    case 13:				/* isisL1LSPArrivalTimestamp, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->arrivalTimestamp);

    case 14:				/* isisL1LSPSRM, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->SRM, 10);

    case 15:				/* isisL1LSPSSN, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->SSN, 10);

    case 16:				/* isisL1LSPFoundInSNP, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->foundInSNP);

    case 17:				/* isisL1LSPOnDeletedList, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->onDeletedList);

    case 18:				/* isisL1LSPBuf, INTEGER */ 
	return o_string(poi, pvarbind, pLSEntry->buf, pLSEntry->len);

    case 19:				/* isisL1LSPLen, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->len);

    case 20:				/* isisL1LSPDesc, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->lspDesc);

    case 21:				/* isisL1LSPHashNext, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->hashNext);

    case 22:				/* isisL1LSPSortNext, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->sortNext);

    default:
	return int_SNMP_error__status_noSuchName;

    } 






} /* end of get_isisTestL1LSPDbaseTable() */



static int set_isisTestL1LSPDbaseTable(ObjectInstance * poi,
			               struct type_SNMP_VarBind * pvarbind,
 			               int request	     		    )
{




} /* end of set_isisTestL1LSPDbaseTable() */



/*
**	Process a request referencing a variable in the Test Group,
**	the Level 2 LSP Database Table
*/

static int get_isisTestL2LSPDbaseTable(ObjectInstance * poi,
			               struct type_SNMP_VarBind * pvarbind,
 			               int request	     		    )
{
    ObjectID	poid = poi->oi_name;
    ObjectType	*pot = poi->oi_type;
    int		column;			
    int		instance=0;		
    LSEntry	*pLSEntry;
    int		i, found;

    switch (request) {
    case type_SMUX_PDUs_get__request:

	if (poid->oid_nelem != pot->ot_name->oid_nelem+1) 
	    return int_SNMP_error__status_noSuchName;

	if ((instance = poid->oid_elements[poid->oid_nelem-1]) == 0) 
	    return int_SNMP_error__status_noSuchName;

    	break;

    case type_SMUX_PDUs_get__next__request:

	if (poid->oid_nelem == pot->ot_name->oid_nelem) {      
	    ObjectID pnewoid;		

	    if ((pnewoid = oid_extend(poid, 1)) == NULLOID) 
		return int_SNMP_error__status_genErr;

	    if (pvarbind->name) free_SMI_ObjectName(pvarbind->name);
	    pvarbind->name = pnewoid;

	    instance = 0;
     	}
	else {	       
            instance = poid->oid_elements[pot->ot_name->oid_nelem];
	}
	instance += 1;
  	    
	break;

    default:
	return int_SNMP_error__status_genErr;

    } 

    /* Locate the desired instance */
    for (i = 1, found = FALSE, pLSEntry = firstLSP(2); pLSEntry; ++i) {
	if (i == instance) {
	    found = TRUE;		/* the desired instance */
	    break;
	}
	
	pLSEntry = pLSEntry->sortNext;
    }

    if (found) {
	pvarbind->name->oid_elements[pot->ot_name->oid_nelem] = instance;
    }
    else {
	if (request == type_SMUX_PDUs_get__request)
	    return int_SNMP_error__status_noSuchName;
	else return NOTOK;

    }


    column = pot->ot_name->oid_elements[pot->ot_name->oid_nelem-1];

    switch (column) {
    case 1:				/* isisL2LSPIndex, INTEGER */
	return o_integer(poi, pvarbind, instance);

    case 2:				/* isisL2LSPLinkForw, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->links.forw);

    case 3:				/* isisL2LSPLinkBack, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->links.back);

    case 4:				/* isisL2LSPSigIdSourceId, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->signature.id.sourceID, 6);

    case 5:				/* isisL2LSPSigIdPseudonodeID, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.id.pseudonodeID);

    case 6:				/* isisL2LSPSigIdLSPNum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.id.LSPNumber);

    case 7:				/* isisL2LSPSigSeqNum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.seqNum);

    case 8:				/* isisL2LSPSigLifeTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.lifetime);

    case 9:				/* isisL2LSPSigLevel, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.level);

    case 10:				/* isisL2LSPSigChecksum, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->signature.checksum);

    case 11:				/* isisL2LSPOrigLifeTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->originalLifetime);

    case 12:				/* isisL2LSPRemainTime, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->remainingTime);

    case 13:				/* isisL2LSPArrivalTimestamp, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->arrivalTimestamp);

    case 14:				/* isisL2LSPSRM, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->SRM, 10);

    case 15:				/* isisL2LSPSSN, OCTET STRING */
	return o_string(poi, pvarbind, pLSEntry->SSN, 10);

    case 16:				/* isisL2LSPFoundInSNP, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->foundInSNP);

    case 17:				/* isisL2LSPOnDeletedList, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->onDeletedList);

    case 18:				/* isisL2LSPBuf, INTEGER */ 
	return o_string(poi, pvarbind, pLSEntry->buf, pLSEntry->len);

    case 19:				/* isisL2LSPLen, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->len);

    case 20:				/* isisL2LSPDesc, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->lspDesc);

    case 21:				/* isisL2LSPHashNext, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->hashNext);

    case 22:				/* isisL2LSPSortNext, INTEGER */
	return o_integer(poi, pvarbind, pLSEntry->sortNext);

    default:
	return int_SNMP_error__status_noSuchName;

    } 





} /* end of get_isisTestL2LSPDbaseTable() */



static int set_isisTestL2LSPDbaseTable(ObjectInstance * poi,
			               struct type_SNMP_VarBind * pvarbind,
 			               int request	     		    )
{




} /* end of set_isisTestL2LSPDbaseTable() */







/*
**	For the objects not supported, yet.
*/
int locateinstance(instance) 
int		instance;
{


    return(instance);


} /* end of locateinstance() */



int locatenextinstance(instance) 
int		instance;
{

    if (instance > 8) return(0);	/* limit the breadth for dummys */
    return(instance+1);


} /* end of locatenextinstance() */



#endif	/* defined(PROTO_ISIS) && defined(PROTO_SNMP) */

/* end of isis_mib.c */



