------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              U N I X L I B                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.12 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package body Unixlib is

   ----------------------
   -- Unix_File_Length --
   ----------------------

   function Unix_File_Length (FD : Unix_FD) return Int is

      function file_length (FD : Unix_FD) return Int;
      pragma Import (C, file_length, "file_length");

   begin
      return file_length (FD);
   end Unix_File_Length;

   ---------------------------
   -- Unix_File_Time_Stamp  --
   ---------------------------

   function Unix_File_Time_Stamp (FD : Unix_FD) return Time_Stamp_Type is
      Stamp : Time_Stamp_Type;

      procedure file_time (FD : Unix_FD; Stamp : in out Time_Stamp_Type);
      pragma Import (C, file_time, "file_time");

   begin
      file_time (FD, Stamp);
      return Stamp;
   end Unix_File_Time_Stamp;

   --------------------------
   -- Unix_Is_Regular_File --
   --------------------------

   function Unix_Is_Regular_File (Name : String) return Boolean is

      function is_regular_file (Name : Address) return Integer;
      pragma Import (C, is_regular_file, "is_regular_file");

      F_Name : String (1 .. Name'Last + 1);

   begin
      F_Name (Name'range) := Name;
      F_Name (F_Name'Last) := NUL;
      return is_regular_file (F_Name'Address) /= 0;
   end Unix_Is_Regular_File;

   -----------------
   -- Unix_Getenv --
   -----------------

   function Unix_Getenv (Name : String) return String is

      procedure get_env_value_ptr (Name, Length, Ptr : Address);
      pragma Import (C, get_env_value_ptr, "get_env_value_ptr");

      procedure strncpy (Astring_Addr, Cstring : Address; N : Integer);
      pragma Import (C, strncpy, "strncpy");

      Env_Value_Ptr    : Address;
      Env_Value_Length : Integer;
      F_Name           : String (1 .. Name'Last + 1);

   begin
      F_Name (Name'range) := Name;
      F_Name (F_Name'Last) := NUL;

      get_env_value_ptr
        (F_Name'Address, Env_Value_Length'Address, Env_Value_Ptr'Address);

      declare
         Ret_String : String (1 .. Env_Value_Length);

      begin
         if Env_Value_Length > 0 then
            strncpy (Ret_String'Address, Env_Value_Ptr, Env_Value_Length);
         end if;

         return Ret_String;
      end;
   end Unix_Getenv;

end Unixlib;
