------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             G E T _ T A R G                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package body Get_Targ is

   function Width_From_Size  (Size : Pos) return Pos is
   begin
      if Size =  8 then return  4; end if;
      if Size = 16 then return  6; end if;
      if Size = 32 then return 11; end if;
      if Size = 64 then return 21; end if;
      pragma Assert (False);
      --  Should never have a size different from above
   end Width_From_Size;

   function Digits_From_Size (Size : Pos) return Pos is
   begin
      if Size =  32 then return  6; end if;
      if Size =  64 then return 15; end if;
      if Size =  96 then return 18; end if;
      if Size = 128 then return 18; end if;
      pragma Assert (False);
      --  Should never have a size different from above
   end Digits_From_Size;

end Get_Targ;
