/****************************************************************************
 *                                                                          *
 *                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               *
 *                                                                          *
 *                    G e t _ P O S I X _ C o n s t a n t s                 *
 *                                                                          *
 *                          C   G e n e r a t e d                           *
 *                                                                          *
 *                             $Revision: 1.2 $                            *
 *                                                                          *
 *           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         *
 *                                                                          *
 *  GNARL is free software; you can redistribute it and/or modify it  under *
 *  terms  of  the  GNU  Library General Public License as published by the *
 *  Free Software Foundation; either version 2, or  (at  your  option)  any *
 *  later  version.   GNARL is distributed in the hope that it will be use- *
 *  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of *
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- *
 *  eral Library Public License for more details.  You should have received *
 *  a  copy of the GNU Library General Public License along with GNARL; see *
 *  file COPYING. If not, write to the Free Software Foundation,  675  Mass *
 *  Ave, Cambridge, MA 02139, USA.                                          *
 *     								            *
 ****************************************************************************
 */


#define ADA_MIN_PRIO 0
#define ADA_MAX_PRIO 99
#define ADD_PRIO 2 
/* additional prio levels for int. entries, mutex ceiling */


/* pthread.h should be able to stand on its own, but it currently needs
   definitions from stddef.h and sys/time.h on the SGI Indy.  The Sun version
   seems to tolerate this.
*/
#include <stddef.h>
#include <sys/time.h>
#include <pthread.h>

/* The Sun version of Pthreads defines its own jump buffers in pthread.h
   (which is probably wrong) whereas SGI uses the system definition.
   Bring in the system setjmp.h file only if needed.
*/
#ifndef jmp_buf
#include <setjmp.h>
#endif

#include <sys/errno.h>

/* The Sun version of Pthreads defines its own signal handling types and
   functions in pthreads.h (which is probably wrong),
   whereas SGI uses the system definition.
   Bring in the system signal.h file only if needed.
*/
#ifndef sigset_t
#include <signal.h>
#endif



/* The Sun version of Pthreads defines some POSIX error codes that are not
   provided by the SunOS include files.  This file only defines the
   error codes if they are not already defined.
*/
#include <pthread/errno.h>

main(argc, argv)
    int argc;
    char *argv[];
{
  pthread_t p = NULL;

  if(argc > 2)
      {
	 printf("Usage: get_c_constants [-g]\n");
	 exit(0);
      }
  else
      {
	printf("----------------------------------------");
        printf("-------------------------------------\n");
	printf("--                                      ");
        printf("                                   --\n");
	printf("--                GNU ADA RUNTIME LIBRAR");
        printf("Y (GNARL) COMPONENTS               --\n");
	printf("--                                     ");
        printf("                                    --\n");
	printf("--                       P O S I X _ C ");
        printf("o n s t a n t s                     --\n");
	printf("--                                     ");
        printf("                                    --\n");
	printf("--                                 S p e");
        printf(" c                                 --\n");
	printf("--                                      ");
        printf("                                   --\n");
	printf("--                            $Revision:");
        printf(" 1.1 $                            --\n");
	printf("--                                      ");
        printf("                                   --\n");
	printf("--          Copyright (c) 1991,1992,1993");
        printf(", FSU, All Rights Reserved         --\n");
	printf("--                                      ");
        printf("                                   --\n");
	printf("-- GNARL is free software; you can redis");
        printf("tribute it and/or modify it  under --\n");
	printf("-- terms  of  the  GNU  Library General ");
        printf("Public License as published by the --\n");
	printf("-- Free Software Foundation; either vers");
        printf("ion 2, or  (at  your  option)  any --\n");
	printf("-- later  version.   GNARL is distribute");
        printf("d in the hope that it will be use- --\n");
	printf("-- ful, but but WITHOUT ANY WARRANTY; wi");
        printf("thout even the implied warranty of --\n");
	printf("-- MERCHANTABILITY  or FITNESS FOR A PAR");
        printf("TICULAR PURPOSE.  See the GNU Gen- --\n");
	printf("-- eral Library Public License for more ");
        printf("details.  You should have received --\n");
	printf("-- a  copy of the GNU Library General Pu");
        printf("blic License along with GNARL; see --\n");
	printf("-- file COPYING. If not, write to the Fr");
        printf("ee Software Foundation,  675  Mass --\n");
	printf("-- Ave, Cambridge, MA 02139, USA.       ");
        printf("                                   --\n");
	printf("--                                      ");
        printf("                                   --\n");
	printf("----------------------------------------");
        printf("-------------------------------------\n");
	 printf("\n");

         printf("package System.POSIX_Constants is\n\n");
	 printf("   pthread_t_size : constant Integer := %d;\n", 
		sizeof(pthread_t));
	 printf("   pthread_attr_t_size : constant Integer := %d;\n", 
		sizeof(pthread_attr_t));
	 printf("   pthread_mutexattr_t_size : constant Integer := %d;\n", 
		sizeof(pthread_mutexattr_t));
	 printf("   pthread_mutex_t_size : constant Integer := %d;\n", 
		sizeof(pthread_mutex_t));
	 printf("   pthread_condattr_t_size : constant Integer := %d;\n", 
		sizeof(pthread_condattr_t));
	 printf("   pthread_cond_t_size : constant Integer := %d;\n", 
		sizeof(pthread_cond_t));
	 printf("   pthread_key_t_size : constant Integer := %d;\n", 
		sizeof(pthread_key_t));

         /* Our Pthreads redefines jmp_buf and sigjmp_buf, and defines them
	    as structs.  This requires all references to these types to start
	    with the struct keyword.  This is wrong; they should be done
	    with a typedef. */
	 printf("   pthread_jmp_buf_size : constant Integer := %d;\n",
		sizeof(jmp_buf));
	 printf("   pthread_sigjmp_buf_size : constant Integer := %d;\n",
		sizeof(sigjmp_buf));

	 printf("   posix_sigset_t_size : constant Integer := %d;\n",
		sizeof(sigset_t));

	 printf("   SIG_BLOCK : constant := %d;\n", SIG_BLOCK);
	 printf("   SIG_UNBLOCK : constant := %d;\n", SIG_UNBLOCK);
	 printf("   SIG_SETMASK : constant := %d;\n", SIG_SETMASK);

	 printf("   SA_NOCLDSTOP : constant := %d;\n", SA_NOCLDSTOP);
	 printf("   SA_SIGINFO : constant := %d;\n", SA_SIGINFO);

	 printf("   SIG_ERR : constant := %d;\n", SIG_ERR);
	 printf("   SIG_DFL : constant := %d;\n", SIG_DFL);
	 printf("   SIG_IGN : constant := %d;\n", SIG_IGN);

	 printf("   SIGKILL : constant := %d;\n", SIGKILL);
	 printf("   SIGSTOP : constant := %d;\n", SIGSTOP);
	 printf("   SIGILL : constant := %d;\n", SIGILL);
	 printf("   SIGABRT : constant := %d;\n", SIGABRT);
	 printf("   SIGEMT : constant := %d;\n", SIGEMT);
	 printf("   SIGFPE : constant := %d;\n", SIGFPE);
	 printf("   SIGBUS : constant := %d;\n", SIGBUS);
	 printf("   SIGSEGV : constant := %d;\n", SIGSEGV);
	 printf("   SIGPIPE : constant := %d;\n", SIGPIPE);
	 printf("   SIGALRM : constant := %d;\n", SIGALRM);
	 printf("   SIGUSR1 : constant := %d;\n", SIGUSR1);
	 printf("   SIGUSR2 : constant := %d;\n", SIGUSR2);

         /* Not POSIX, but SGI dbx won't work if it is masked.  Since
            it also exists on the Sun, this should not cause problems
	    for now. */
	 printf("   SIGTRAP : constant := %d;\n", SIGTRAP);

	 printf("   EPERM    : constant := %d;\n", EPERM    );
	 printf("   ENOENT   : constant := %d;\n", ENOENT   );
	 printf("   ESRCH    : constant := %d;\n", ESRCH    );
	 printf("   EINTR    : constant := %d;\n", EINTR    );
	 printf("   EIO      : constant := %d;\n", EIO      );
	 printf("   ENXIO    : constant := %d;\n", ENXIO    );
	 printf("   E2BIG    : constant := %d;\n", E2BIG    );
	 printf("   ENOEXEC  : constant := %d;\n", ENOEXEC  );
	 printf("   EBADF    : constant := %d;\n", EBADF    );
	 printf("   ECHILD   : constant := %d;\n", ECHILD   );
	 printf("   EAGAIN   : constant := %d;\n", EAGAIN   );
	 printf("   ENOMEM   : constant := %d;\n", ENOMEM   );
	 printf("   EACCES   : constant := %d;\n", EACCES   );
	 printf("   EFAULT   : constant := %d;\n", EFAULT   );
	 printf("   ENOTBLK  : constant := %d;\n", ENOTBLK  );
	 printf("   EBUSY    : constant := %d;\n", EBUSY    );
	 printf("   EEXIST   : constant := %d;\n", EEXIST   );
	 printf("   EXDEV    : constant := %d;\n", EXDEV    );
	 printf("   ENODEV   : constant := %d;\n", ENODEV   );
	 printf("   ENOTDIR  : constant := %d;\n", ENOTDIR  );
	 printf("   EISDIR   : constant := %d;\n", EISDIR   );
	 printf("   EINVAL   : constant := %d;\n", EINVAL   );
	 printf("   ENFILE   : constant := %d;\n", ENFILE   );
	 printf("   EMFILE   : constant := %d;\n", EMFILE   );
	 printf("   ENOTTY   : constant := %d;\n", ENOTTY   );
	 printf("   ETXTBSY  : constant := %d;\n", ETXTBSY  );
	 printf("   EFBIG    : constant := %d;\n", EFBIG    );
	 printf("   ENOSPC   : constant := %d;\n", ENOSPC   );
	 printf("   ESPIPE   : constant := %d;\n", ESPIPE   );
	 printf("   EROFS    : constant := %d;\n", EROFS    );
	 printf("   EMLINK   : constant := %d;\n", EMLINK   );
	 printf("   EPIPE    : constant := %d;\n", EPIPE    );
	 printf("   ENOSYS   : constant := %d;\n", ENOSYS   );
	 printf("   ENOTSUP  : constant := %d;\n", ENOTSUP  );

/* SGI doesn't define these, so put in dummy values if they are undefined. */
#ifdef NO_PRIO_INHERIT
	 printf("   NO_PRIO_INHERIT : constant := %d;\n", NO_PRIO_INHERIT);
	 printf("   PRIO_INHERIT : constant := %d;\n", PRIO_INHERIT);
	 printf("   PRIO_PROTECT : constant := %d;\n", PRIO_PROTECT);
#else
	 printf("   NO_PRIO_INHERIT : constant := 0;\n");
	 printf("   PRIO_INHERIT : constant := 0;\n");
	 printf("   PRIO_PROTECT : constant := 0;\n");
#endif

/* A kludge to get the SGI version working; it appears to implement
   priorities, but does not have the usual POSIX definitions for it. */
#ifdef SCHED_FIFO
	 if (sched_get_priority_min(SCHED_FIFO) > ADA_MIN_PRIO ||
	     sched_get_priority_max(SCHED_FIFO) < ADA_MAX_PRIO + ADD_PRIO)
	   fprintf(stderr, "ERROR: Pthreads priority range too small\n");
	 else
#endif
	   printf("   Add_Prio : constant Integer := %d;\n", ADD_PRIO);

         printf("\nend System.POSIX_Constants;\n");
      }
  return(0);
}
