

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<assert.h>
#include"types.c"
#include"util.e"
#include"debug.e"



static char rcsversion[]= "$Revision: 1.17 $";
static char rcsdate[]= "$Date: 92/12/07 19:32:00 $";
static int doctp;
typedef enum{
	t_start,t_class,t_name,t_superclass,t_publicvars,
	t_privatevars,
	t_actions,t_translations,t_exports,t_methods,t_imports,
	t_utilities,t_classvars,t_section,t_macro,t_publicvar,t_action,
	t_code,t_hidden,
	t_table,t_tablehead,t_row,t_resname,t_resclass,t_restype,
	t_resdefault,t_inline,
	t_underline,t_backslash,t_tilde,t_hashmark,t_dollar,t_less,t_greater,
	t_percent,t_caret,t_ampersand,t_lbrace,t_rbrace,t_bar,
	t_type,t_incl}
tagtype;
typedef char *tagpair[2];
typedef tagpair taglist[3];
static taglist tag[]= {
    /* \TeX,			 {\sc SGML} */
    /* open, close,		 open, close */
    {						/* |t_start| */
      {"\\input wbuildmac.tex\n", "\\bye\n"},
      {"<!DOCTYPE wbuild SYSTEM>\n", ""},
      {".\\\"remove .ig hn for full docs\n.de hi\n.ig eh\n..\n.de eh\n..\n", ""}},
    {						/* |t_class| */
      {"\\Class", ""},
      {"<class>\n", "</>\n"},
      {".TH \"\" 3 \"\" \"Version 3.0\" \"Free Widget Foundation\"\n", ""}},
    {	   					/* |t_name| */
      {"{", "}\n"},
      {"<name>", "</>"},
      {".SH NAME\n", "\n.SH DESCRIPTION\n"}},
    {	   					/* |t_superclass| */
      {"\\Super{",  "}\n"},
      {"<super>", "</>\n"},
      {"", ""}},
    {	   					/* |t_publicvars| */
      {"\\Publicvars\n", "\\End"},
      {"<pubvars>", "</>"},
      {"\n.SS \"Public variables\"\n", ""}},
    {	   					/* |t_privatevars| */
      {"\\Privatevars\n", "\\End"},
      {"<privvars>", "</>"},
      {"\n.hi\n.SS \"Private variables\"\n", "\n.hi\n"}},
    {	   					/* |t_actions| */
      {"\\Actions\n", "\\End"},
      {"<actions>", "</>>"},
      {"\n.hi\n.SS \"Actions\"\n", "\n.hi\n"}},
    {			       			/* |t_translations| */
      {"\\Translations\n","\\End"},
      {"<trnsltns>","</>"},
      {"\n.SS \"Translations\"\n", ""}},
    {	   					/* |t_exports| */
      {"\\Exports\n", "\\End"},
      {"<exports>", "</>"},
      {"\n.SS \"Exports\"\n", ""}},
    {	   					/* |t_methods| */
      {"\\Methods\n", "\\End"},
      {"<methods>", "</>"},
      {"\n.hi\n.SS \"Methods\"\n", "\n.hi\n"}},
    {	   					/* |t_imports| */
      {"\\Imports\n", "\\End"},
      {"<imports>", "</>"},
      {"\n.hi\n.SH \"Importss\"\n", "\n.hi\n"}},
    {	   					/* |t_utilities| */
      {"\\Utilities\n", "\\End"},
      {"<utils>", "</>"},
      {"\n.hi\n.SH \"Utilities\"\n", "\n.hi\n"}},
    {	   					/* |t_classvars| */
      {"\\Classvars\n", "\\End"},
      {"<clasvars>", "</>"},
      {"\n.hi\n.SH \"Class variables\"\n", "\n.hi\n"}},
    {	   					/* |t_section| */
      {"\\Section\n", "\n\n"},
      {"<section>", "</>"},
      {"\n", "\n"}},
    {	   					/* |t_macro| */
      {"\\Macro\n", "\\endMacro\n"},
      {"<macro>", "</>"},
      {"\\fBdef\\fP ", ""}},
    {	   					/* |t_publicvar| */
      {"\\Publicvar{", "}\n"},
      {"<pubvar>", "</>"},
      {"\n.TP\n.I \"", "\"\n"}},
    {	   					/* |t_action| */
      {"\\Action{", "}"},
      {"<action>", "</>"},
      {"\n.TP\n.I \"", "\n\n"}},
    {	   					/* |t_code| */
      {"\\Code\n", "\\endCode\n"},
      {"<code>", "</>"},
      {"\n.nf\n", "\n.fi\n"}},
    {	   					/* |t_hidden| */
      {"\\HCode\n", "\\endHCode\n"},
      {"<hidden>", "</>"},
      {"\n.hi\n", "\n.eh\n"}},
    {	   					/* |t_table| */
      {"\\Table", "\\endTable\n"},
      {"<table>", "</>"},
      {"\n.ps-2\n.TS\ncenter box;\ncBsss\nlB|lB|lB|lB\nl|l|l|l.\n", "\n.TE\n.ps\n"}},
    {	   					/* |t_tablehead| */
      {"{",  "}\n"},
      {"<tblhead>", "</>"},
      {"", "\nName\tClass\tType\tDefault\n"}},
    {	   					/* |t_row| */
      {"",  "\\cr\n"},
      {"<row>", "</>"},
      {"", "\n"}},
    {	   					/* |t_resname| */
      {"",  ""},
      {"<resname>", "</>"},
      {"", ""}},
    {	   					/* |t_resclass| */
      {"&",  ""},
      {"<resclass>", "</>"},
      {"\t", ""}},
    {	   					/* |t_restype| */
      {"&",  ""},
      {"<restype>", "</>"},
      {"\t", ""}},
    {	   					/* |t_resdefault| */
      {"&",  ""},
      {"<resdeflt>", "</>"},
      {"\t", ""}},
    {	   					/* |t_inline| */
      {"{\\tt ",  "}"},
      {"<inline>", "</>"},
      {"\\fI", "\\fP"}},
    {	   					/* |t_underline| */
      {"{\\underline}", ""},
      {"_", ""},
      {"_", ""}},
    {	   					/* |t_backslash| */
      {"{\\backslash}", ""},
      {"\\{}", ""},
      {"\\\\", ""}},
    {	   					/* |t_tilde| */
      {"{\\tilde}", ""},
      {"~", ""},
      {"~", ""}},
    {	   					/* |t_hashmark| */
      {"{\\hashmark}", ""},
      {"#", ""},
      {"#", ""}},
    {	   					/* |t_dollar| */
      {"{\\dollar}", ""},
      {"$", ""},
      {"$", ""}},
    {	   					/* |t_less| */
      {"{\\langle}", ""},
      {"&langle;", ""},
      {"<", ""}},
    {	   					/* |t_greater| */
      {"{\\rangle}", ""},
      {"&rangle;", ""},
      {">", ""}},
    {	   					/* |t_percent| */
      {"{\\percent}", ""},
      {"%", ""},
      {"%", ""}},
    {	   					/* |t_caret| */
      {"{\\caret}", ""},
      {"^", ""},
      {"^", ""}},
    {	   					/* |t_ampersand| */
      {"{\\ampersand}", ""},
      {"&", ""},
      {"", ""}},
    {	   					/* |t_lbrace| */
      {"{\\lbrace}", ""},
      {"{", ""},
      {"{", ""}},
    {	   					/* |t_rbrace| */
      {"{\\rbrace}", ""},
      {"}", ""},
      {"}", ""}},
    {	   					/* |t_bar| */
      {"{\\bar}", ""},
      {"|", ""},
      {"|", ""}},
    {	   					/* |t_type| */
      {"{\\type}", ""},
      {"&type;", ""},
      {"\n.B type\n", ""}},
    {	   					/* |t_incl| */
      {"{\\incl}", ""},
      {"&incl;", ""},
      {"\n.B incl\n", ""}},
  };


static int err= 0;
static STRING NOCODE,NODOC;


static STRING DOLLAR;
struct _Section action_proto;


static STRING CORE,RECTOBJ,COMPOSITE,SHELL,
CONSTRAINT,OBJECT,OVERRIDESHELL,WMSHELL,VENDORSHELL,
TRANSIENTSHELL,TOPLEVELSHELL,APPLICATIONSHELL;


static STRING CLASS_INITIALIZE,CLASS_PART_INITIALIZE;
static STRING INITIALIZE,INITIALIZE_HOOK,REALIZE;
static STRING COMPRESS_MOTION,COMPRESS_EXPOSURE;
static STRING COMPRESS_ENTERLEAVE,VISIBLE_INTEREST;
static STRING DESTROY,RESIZE,EXPOSE;
static STRING SET_VALUES,SET_VALUES_HOOK;
static STRING SET_VALUES_ALMOST,GET_VALUES_HOOK,ACCEPT_FOCUS;
static STRING QUERY_GEOMETRY,DISPLAY_ACCELERATOR;
static STRING EXTENSION;


static STRING GEOMETRY_MANAGER,CHANGE_MANAGED,
INSERT_CHILD,DELETE_CHILD;


static STRING SELF;



static void print_body(f,body,class,procname,lineno,ismacro)
FILE *f;
STRING body;
Class class;
STRING procname;
int lineno;
Boolean ismacro;
{
	char *p,prev= '\0';
	Boolean quoted= False,squoted= False,comment= False;
	Class part;
	STRING word,word1;
	for(p= get(body); *p;prev=  *p,p++)
		switch( *p){
		case'"':
			putc('"',f);
			if(!squoted&&!comment&&prev!='\\')quoted= !quoted;
			break;
		case'\'':
			putc('\'',f);
			if(!quoted&&!comment&&prev!='\\')squoted= !squoted;
			break;
		case'*':
			putc('*',f);
			if(!quoted&&!squoted&&!comment&&prev=='/')comment= True;
			break;
		case'/':
			putc('/',f);
			if(comment&&prev=='*')comment= False;
			break;
		case'$':
			if(quoted||squoted||comment||prev=='\\')
				putc('$',f);
			else{

				if( *(p+1)=='$'){
					p++;
					(void)putc('$',f);
					break;
				}
				word1= SELF;
				word= get_word(p+1);
				if(word==((STRING)NULL)){
					(void)fputs("self",f);
					break;
				}
				p+= Strlen(word);
				if( *(p+1)=='$'){
					word1= word;
					word= get_word(p+2);
					if(word==((STRING)NULL))break;
					p+= Strlen(word)+1;
				}
				if((part= find_instvar_class(class,word))!=NULL)
					(void)fprintf(f,"((%sWidget)%s)->%s.%s",get(class->name), get(word1),get(get_instname(part->name)),
					    get(word));
				else if((part= find_method_class(class,word))!=NULL ||(part= find_classvar_class(class,word))!=NULL)
					(void)fprintf(f,"((%sWidgetClass)%s->core.widget_class)->%s_class.%s", get(class->name),
					    get(word1),get(get_instname(part->name)),get(word));
				else{
					(void)fprintf(stderr,"%s:%d: (in %s) identifier `$%s' is unknown\n", get(class->filename),
					    lineno,get(procname),get(word));
					err++;
				}
				delete(word);
				if(word1!=SELF)delete(word1);


			}
			break;
		case'#':
			if(quoted||squoted||comment||prev=='\\')
				putc('#',f);
			else{

				if( *(p+1)=='#'){
					p++;
					(void)putc('#',f);
					break;
				}
				if(!class->super){
					(void)fprintf(stderr,"%s:%d: (in %s) no superclass (#) defined\n", get(class->filename),
					    lineno,get(procname));
					err++;
					break;
				}
				word= get_word(p+1);
				if(word==((STRING)NULL)){
					fputs("self->core.superclass",f);
					break;
				}
				p+= Strlen(word);
				if((part= find_method_class(class->super,word))!=NULL ||(part= find_classvar_class(class->super,
				    word))!=NULL)
					(void)fprintf(f,"%sClassRec.%s_class.%s", get(get_instname(class->super->name)),
					    get(get_instname(part->name)),get(word));
				else{
					(void)fprintf(stderr,"%s:%d: (in %s) identifier `#%s' is unknown\n", get(class->filename),
					    lineno,get(procname),get(word));
					err++;
				}
				delete(word);


			}
			break;
		case'\n':
			if(ismacro)putc('\\',f);
			putc('\n',f);
			break;
		default:
			putc( *p,f);
		}
	putc('\n',f);
}


static void define_macro(f,d,c)
FILE *f;
Decl d;
Class c;
{
	Decl d1;
	(void)fputs("#define ",f);
	(void)fputs(get(d->name),f);
	if(d->params){
		(void)putc('(',f);
		for(d1= d->params;d1;d1= d1->next){
			(void)fputs(get(d1->name),f);
			if(d1->next)(void)fputs(", ",f);
		}
		(void)putc(')',f);
	}
	(void)putc(' ',f);
	print_body(f,d->body,c,d->name,d->lineno,True);
	(void)fputs("\n\n",f);
}


static void declare_superclassparts(f,c)
FILE *f;
Class c;
{
	if(c!=NULL){
		declare_superclassparts(f,c->super);
		(void)fprintf(f,"%sClassPart %s_class;\n", get(c->name),get(get_instname(c->name)));
	}
}


static void declare_superparts(f,c)
FILE *f;
Class c;
{
	if(c!=NULL){
		if(c->super)declare_superparts(f,c->super);
		(void)fprintf(f,"%sPart %s;\n", get(c->name),get(get_instname(c->name)));
	}
}


static void declare_function(export,name,d,f)
Boolean export;
STRING name;
Decl d;
FILE *f;
{
	Decl d1;
	if(!export)(void)fputs("static ",f);
	if(d->type)(void)fputs(get(d->type),f);
	else(void)fputs("void",f);
	(void)putc(' ',f);
	(void)fputs(get(name),f);
	(void)fputs("(\n#if NeedFunctionPrototypes\n",f);
	if(d->params==NULL)
		(void)fputs("void",f);
	else
		for(d1= d->params;d1;d1= d1->next){
			if(d1->name==DOLLAR)
				(void)fputs("Widget",f);
			else
				(void)fputs(get(d1->type),f);
			if(d1->next)(void)putc(',',f);
		}
	(void)fputs("\n#endif\n);\n",f);
}


static int number_of_decls(sect)
Section sect;
{
	int n= 0;
	Section s;
	for(s= sect;s;s= s->next)
		if(s->decl&&s->decl->tp!=Def)n++;
	return n;
}


static void init_class_parts(f,self,part)
FILE *f;
Class self,part;
{
	int n;
	Section s;
	STRING h;
	if(part->superclass==CORE ||part->superclass==OBJECT ||part->superclass==RECTOBJ){

		(void)fprintf(f,"{ /* core_class part */\n");
		(void)fprintf(f,"(WidgetClass) &%sClassRec,\n", get(get_instname(self->superclass)));
		(void)fprintf(f,"\"%s\",\n",get(self->name));
		(void)fprintf(f,"sizeof(%sRec),\n",get(self->name));
		(void)fprintf(f,"%s,\n",has_method(self,CLASS_INITIALIZE)? "class_initialize":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,CLASS_PART_INITIALIZE)? "class_part_initialize":"_resolve_inheritance");
		(void)fprintf(f,"FALSE,\n");
		(void)fprintf(f,"%s,\n",has_method(self,INITIALIZE)? "initialize":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,INITIALIZE_HOOK)? "initialize_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,REALIZE)? "realize":"XtInheritRealize");
		{
			int nd;
			nd= number_of_decls(self->actions);
			if(nd==0)
				(void)fprintf(f,"NULL,\n");
			else
				(void)fprintf(f,"actionsList,\n");
			(void)fprintf(f,"%d,\n",nd);
			nd= number_of_decls(self->publicvars);
			if(nd==0)
				(void)fprintf(f,"NULL,\n");
			else
				(void)fprintf(f,"resources,\n");
			(void)fprintf(f,"%d,\n",nd);
		}
		(void)fprintf(f,"NULLQUARK,\n");
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_MOTION)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_EXPOSURE)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_ENTERLEAVE)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,VISIBLE_INTEREST)));
		(void)fprintf(f,"%s,\n",has_method(self,DESTROY)? "destroy":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,RESIZE)? "resize":"XtInheritResize");
		(void)fprintf(f,"%s,\n",has_method(self,EXPOSE)? "expose":"XtInheritExpose");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES)? "set_values":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES_HOOK)? "set_values_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES_ALMOST)? "set_values_almost":"XtInheritSetValuesAlmost");
		(void)fprintf(f,"%s,\n",has_method(self,GET_VALUES_HOOK)? "get_values_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,ACCEPT_FOCUS)? "accept_focus":"XtInheritAcceptFocus");
		(void)fprintf(f,"XtVersion,\n");
		(void)fprintf(f,"NULL,\n");
		if(number_of_decls(self->translations)==0)
			(void)fputs("NULL,\n",f);
		else
			(void)fprintf(f,"defaultTranslations,\n");
		(void)fprintf(f,"%s,\n",has_method(self,QUERY_GEOMETRY)? "query_geometry":"XtInheritQueryGeometry");
		(void)fprintf(f,"%s,\n",has_method(self,DISPLAY_ACCELERATOR)? "display_accelerator":"XtInheritDisplayAccelerator");
		(void)fprintf(f,"%s\n",get(find_classvar_value(self,EXTENSION)));
		(void)fprintf(f,"},\n");


	} else if(part->superclass==COMPOSITE){


		(void)fprintf(f,"{ /* core_class part */\n");
		(void)fprintf(f,"(WidgetClass) &%sClassRec,\n", get(get_instname(self->superclass)));
		(void)fprintf(f,"\"%s\",\n",get(self->name));
		(void)fprintf(f,"sizeof(%sRec),\n",get(self->name));
		(void)fprintf(f,"%s,\n",has_method(self,CLASS_INITIALIZE)? "class_initialize":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,CLASS_PART_INITIALIZE)? "class_part_initialize":"_resolve_inheritance");
		(void)fprintf(f,"FALSE,\n");
		(void)fprintf(f,"%s,\n",has_method(self,INITIALIZE)? "initialize":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,INITIALIZE_HOOK)? "initialize_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,REALIZE)? "realize":"XtInheritRealize");
		{
			int nd;
			nd= number_of_decls(self->actions);
			if(nd==0)
				(void)fprintf(f,"NULL,\n");
			else
				(void)fprintf(f,"actionsList,\n");
			(void)fprintf(f,"%d,\n",nd);
			nd= number_of_decls(self->publicvars);
			if(nd==0)
				(void)fprintf(f,"NULL,\n");
			else
				(void)fprintf(f,"resources,\n");
			(void)fprintf(f,"%d,\n",nd);
		}
		(void)fprintf(f,"NULLQUARK,\n");
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_MOTION)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_EXPOSURE)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,COMPRESS_ENTERLEAVE)));
		(void)fprintf(f,"%s,\n",get(find_classvar_value(self,VISIBLE_INTEREST)));
		(void)fprintf(f,"%s,\n",has_method(self,DESTROY)? "destroy":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,RESIZE)? "resize":"XtInheritResize");
		(void)fprintf(f,"%s,\n",has_method(self,EXPOSE)? "expose":"XtInheritExpose");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES)? "set_values":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES_HOOK)? "set_values_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,SET_VALUES_ALMOST)? "set_values_almost":"XtInheritSetValuesAlmost");
		(void)fprintf(f,"%s,\n",has_method(self,GET_VALUES_HOOK)? "get_values_hook":"NULL");
		(void)fprintf(f,"%s,\n",has_method(self,ACCEPT_FOCUS)? "accept_focus":"XtInheritAcceptFocus");
		(void)fprintf(f,"XtVersion,\n");
		(void)fprintf(f,"NULL,\n");
		if(number_of_decls(self->translations)==0)
			(void)fputs("NULL,\n",f);
		else
			(void)fprintf(f,"defaultTranslations,\n");
		(void)fprintf(f,"%s,\n",has_method(self,QUERY_GEOMETRY)? "query_geometry":"XtInheritQueryGeometry");
		(void)fprintf(f,"%s,\n",has_method(self,DISPLAY_ACCELERATOR)? "display_accelerator":"XtInheritDisplayAccelerator");
		(void)fprintf(f,"%s\n",get(find_classvar_value(self,EXTENSION)));
		(void)fprintf(f,"},\n");


		(void)fprintf(f,"{ /* composite_class part */\n");
		(void)fprintf(f,"%s,\n",has_method(self,GEOMETRY_MANAGER)? "geometry_manager":"XtInheritGeometryManager");
		(void)fprintf(f,"%s,\n",has_method(self,CHANGE_MANAGED)? "change_managed":"XtInheritChangeManaged");
		(void)fprintf(f,"%s,\n",has_method(self,INSERT_CHILD)? "insert_child":"XtInheritInsertChild");
		(void)fprintf(f,"%s,\n",has_method(self,DELETE_CHILD)? "delete_child":"XtInheritDeleteChild");
		(void)fprintf(f,"NULL\n");
		(void)fprintf(f,"},\n");






	} else if(!part->super){
		(void)fprintf(stderr,"superclass %s not found\n", get(part->superclass));
		err++;
	} else{
		init_class_parts(f,self,part->super);
	}
	(void)fprintf(f,"{ /* %s_class part */\n",get(part->name));
	n= 0;
	for(s= part->methods;s;s= s->next){
		if(s->decl&&s->decl->tp==Proc &&find_method_class(part,s->decl->name)==part){
			if(has_method(self,s->decl->name))
				(void)fprintf(f,"%s,\n",get(s->decl->name));
			else
				(void)fprintf(f,"XtInherit_%s,\n",get(s->decl->name));
			n++;
		}
	}
	for(s= part->classvars;s;s= s->next){
		if(s->decl&&s->decl->tp==Var &&find_classvar_class(part,s->decl->name)==part){
			h= find_classvar_value(self,s->decl->name);
			(void)fprintf(f,"%s,\n",get(h));
			n++;
		}
	}
	if(n==0)
		(void)fprintf(f,"0\n");
	(void)fprintf(f,"},\n");
}


static void define_header(export,d,f)
Boolean export;
Decl d;
FILE *f;
{
	Decl d1;
	(void)fputs("/*ARGSUSED*/",f);
	if(!export)(void)fputs("static ",f);
	if(d->type)(void)fputs(get(d->type),f);
	else(void)fputs("void",f);
	(void)fprintf(f," %s(",get(d->name));
	for(d1= d->params;d1;d1= d1->next){
		if(d1->name==DOLLAR)
			(void)fputs("self",f);
		else
			(void)fputs(get(d1->name),f);
		if(d1->next)(void)putc(',',f);
	}
	(void)putc(')',f);
	for(d1= d->params;d1;d1= d1->next)
		if(d1->name==DOLLAR)
			(void)fprintf(f,"Widget self;");
		else
			(void)fprintf(f,"%s %s;",get(d1->type),get(d1->name));
	(void)putc('\n',f);
}


static void define_function(export,d,body,c,f)
Boolean export;
Decl d;
STRING body;
Class c;
FILE *f;
{
	define_header(export,d,f);
	print_body(f,body,c,d->name,d->lineno,False);
}


static void print_text_par(f,text,file,lineno)
FILE *f;
STRING text,file;
int lineno;
{
	char *p;
	Boolean between_bars= False;
	for(p= get(text); *p;p++){
		if(between_bars){
			switch( *p){
			case'_':
				(void)fputs((tag[t_underline][doctp][0]),f);
				break;
			case'\\':
				(void)fputs((tag[t_backslash][doctp][0]),f);
				break;
			case'~':
				(void)fputs((tag[t_tilde][doctp][0]),f);
				break;
			case'#':
				(void)fputs((tag[t_hashmark][doctp][0]),f);
				break;
			case'$':
				(void)fputs((tag[t_dollar][doctp][0]),f);
				break;
			case'%':
				(void)fputs((tag[t_percent][doctp][0]),f);
				break;
			case'^':
				(void)fputs((tag[t_caret][doctp][0]),f);
				break;
			case'&':
				(void)fputs((tag[t_ampersand][doctp][0]),f);
				break;
			case'{':
				(void)fputs((tag[t_lbrace][doctp][0]),f);
				break;
			case'}':
				(void)fputs((tag[t_rbrace][doctp][0]),f);
				break;
			case'|':
				(void)fputs((tag[t_inline][doctp][1]),f);
				between_bars= False;
				break;
			default:
				(void)putc( *p,f);
			}
		} else if( *p=='|'){
			between_bars= True;
			(void)fputs((tag[t_inline][doctp][0]),f);
		} else
			(void)putc( *p,f);
	}
	if(between_bars){
		(void)fprintf(stderr,"%s:%d: unmatched \"|\" in text\n", get(file),lineno);
		err++;
		(void)fputs((tag[t_inline][doctp][1]),f);
	}
	(void)putc('\n',f);
	(void)putc('\n',f);
}


static void putcode(text,f)
FILE *f;
STRING text;
{
	char *p;
	for(p= get(text); *p;p++){
		switch( *p){
		case'_':
			(void)fputs((tag[t_underline][doctp][0]),f);
			break;
		case'\\':
			(void)fputs((tag[t_backslash][doctp][0]),f);
			break;
		case'~':
			(void)fputs((tag[t_tilde][doctp][0]),f);
			break;
		case'#':
			(void)fputs((tag[t_hashmark][doctp][0]),f);
			break;
		case'$':
			(void)fputs((tag[t_dollar][doctp][0]),f);
			break;
		case'%':
			(void)fputs((tag[t_percent][doctp][0]),f);
			break;
		case'^':
			(void)fputs((tag[t_caret][doctp][0]),f);
			break;
		case'<':
			(void)fputs((tag[t_less][doctp][0]),f);
			break;
		case'>':
			(void)fputs((tag[t_greater][doctp][0]),f);
			break;
		case'&':
			(void)fputs((tag[t_ampersand][doctp][0]),f);
			break;
		case'{':
			(void)fputs((tag[t_lbrace][doctp][0]),f);
			break;
		case'}':
			(void)fputs((tag[t_rbrace][doctp][0]),f);
			break;
		case'|':
			(void)fputs((tag[t_bar][doctp][0]),f);
			break;
		default:
			(void)putc( *p,f);
		}
	}
}


static void tabulate_inherited_resources(f,self,part)
FILE *f;
Class self,part;
{
	Section s;
	if(part==NULL)
		return;
	if(part->publicvars!=NULL){
		(void)fputs((tag[t_table][doctp][0]),f);
		(void)fputs((tag[t_tablehead][doctp][0]),f);
		(void)putcode(part->name,f);
		(void)fputs((tag[t_tablehead][doctp][1]),f);
		for(s= part->publicvars;s;s= s->next){
			if(s->decl&&find_instvar_class(part,s->decl->name)==part){
				(void)fputs((tag[t_row][doctp][0]),f);
				(void)fputs((tag[t_resname][doctp][0]),f);
				if(s->decl->namesym)
					(void)putcode(s->decl->namesym,f);
				else{
					(void)fputs("XtN",f);
					(void)putcode(s->decl->name,f);
				}
				(void)fputs((tag[t_resname][doctp][1]),f);
				(void)fputs((tag[t_resclass][doctp][0]),f);
				(void)fputs("XtC",f);
				if(s->decl->namesym)
					(void)putcode(get_classname(s->decl->namesym),f);
				else
					(void)putcode(get_classname(s->decl->name),f);
				(void)fputs((tag[t_resclass][doctp][1]),f);
				(void)fputs((tag[t_restype][doctp][0]),f);

				if(s->decl->typesym)
					(void)putcode(s->decl->typesym,f);
				else
					(void)putcode(get_classname(s->decl->type),f);
				(void)fputs((tag[t_restype][doctp][1]),f);
				(void)fputs((tag[t_resdefault][doctp][0]),f);
				(void)putcode(s->decl->value,f);
				(void)fputs((tag[t_resdefault][doctp][1]),f);
				(void)fputs((tag[t_row][doctp][1]),f);
			}
		}
		(void)fputs((tag[t_table][doctp][1]),f);
	}
	tabulate_inherited_resources(f,self,part->super);
}


static FILE *mustopen(name,mode)
STRING name;
char *mode;
{
	FILE *f;
	if(!(f= fopen(get(name),mode))){
		perror(get(name));
		exit(1);
	}
	return f;
}



int generate(headerdir,implemdir,docdir,prefix,sgml,lines,only)
char *headerdir, *implemdir, *docdir, *prefix, *only;
Boolean sgml,lines;
{
	Class c;
	STRING guard,instname,dummy1,filebase;
	FILE *f;
	Section s,s2;
	Decl d1;
	int n;

	doctp= sgml;
	NOCODE= hash("nocode");
	NODOC= hash("nodoc");


	DOLLAR= hash("$");
	action_proto.decl= malloc(sizeof(struct _Decl));
	action_proto.decl->type= hash("void");
	action_proto.decl->params= malloc(sizeof(struct _Decl));
	action_proto.decl->params->type= ((STRING)NULL);
	action_proto.decl->params->name= DOLLAR;
	action_proto.decl->params->next= malloc(sizeof(struct _Decl));
	action_proto.decl->params->next->type= hash("XEvent*");
	action_proto.decl->params->next->name= hash("event");
	action_proto.decl->params->next->next= malloc(sizeof(struct _Decl));
	action_proto.decl->params->next->next->type= hash("String*");
	;
	action_proto.decl->params->next->next->name= hash("params");
	action_proto.decl->params->next->next->next= malloc(sizeof(struct _Decl));
	action_proto.decl->params->next->next->next->type= hash("Cardinal*");
	action_proto.decl->params->next->next->next->name= hash("num_params");
	action_proto.decl->params->next->next->next->next= NULL;


	CORE= hash("Core");
	RECTOBJ= hash("RectObj");
	OBJECT= hash("Object");
	COMPOSITE= hash("Composite");
	SHELL= hash("Shell");
	OVERRIDESHELL= hash("OverrideShell");
	WMSHELL= hash("WMShell");
	VENDORSHELL= hash("VendorShell");
	TRANSIENTSHELL= hash("TransientShell");
	TOPLEVELSHELL= hash("TopLevelShell");
	APPLICATIONSHELL= hash("ApplicationShell");
	CONSTRAINT= hash("Constraint");


	DISPLAY_ACCELERATOR= hash("display_accelerator");
	QUERY_GEOMETRY= hash("query_geometry");
	CLASS_INITIALIZE= hash("class_initialize");
	CLASS_PART_INITIALIZE= hash("class_part_initialize");
	INITIALIZE= hash("initialize");
	INITIALIZE_HOOK= hash("initialize_hook");
	REALIZE= hash("realize");
	COMPRESS_MOTION= hash("compress_motion");
	COMPRESS_EXPOSURE= hash("compress_exposure");
	COMPRESS_ENTERLEAVE= hash("compress_enterleave");
	VISIBLE_INTEREST= hash("visible_interest");
	DESTROY= hash("destroy");
	RESIZE= hash("resize");
	EXPOSE= hash("expose");
	SET_VALUES= hash("set_values");
	SET_VALUES_HOOK= hash("set_values_hook");
	SET_VALUES_ALMOST= hash("set_values_almost");
	GET_VALUES_HOOK= hash("get_values_hook");
	ACCEPT_FOCUS= hash("accept_focus");
	EXTENSION= hash("extension");


	GEOMETRY_MANAGER= hash("geometry_manager");
	CHANGE_MANAGED= hash("change_managed");
	INSERT_CHILD= hash("insert_child");
	DELETE_CHILD= hash("delete_child");


	SELF= hash("self");


	for(c= classes;c;c= c->next){
		if(!get_option(&filebase,c,hash("file")))filebase= c->name;
		if(only!=NULL&&strcmp(only,get(filebase))!=0)continue;
		instname= get_instname(c->name);
		if(!get_option(&dummy1,c,NOCODE)){

			f= mustopen(get_headername(headerdir,c),"w");

			(void)fprintf(f,"/* Generated by wbuild from \"%s\"\n",get(c->filename));
			(void)fprintf(f,"** (generator version %s of %s)\n",rcsversion,rcsdate);
			(void)fprintf(f,"*/\n");


			guard= get_guard(c);
			(void)fprintf(f,"#ifndef %s\n",get(guard));
			(void)fprintf(f,"#define %s\n",get(guard));

			if(c->superclass==CORE)
				(void)fputs("#include <X11/Core.h>\n",f);
			else if(c->superclass==RECTOBJ)
				(void)fputs("#include <X11/RectObj.h>\n",f);
			else if(c->superclass==COMPOSITE)
				(void)fputs("#include <X11/Composite.h>\n",f);
			else if(c->superclass==SHELL ||c->superclass==OVERRIDESHELL ||c->superclass==WMSHELL ||c->superclass==VENDORSHELL
			    ||c->superclass==TRANSIENTSHELL ||c->superclass==TOPLEVELSHELL ||c->superclass==APPLICATIONSHELL)
				(void)fputs("#include <X11/Shell.h>\n",f);
			else if(c->superclass==CONSTRAINT)
				(void)fputs("#include <X11/Constraint.h>\n",f);
			else if(c->super)
				(void)fprintf(f,"#include <%s>\n", get(get_headername(prefix,c->super)));



			for(s= c->exports;s;s= s->next){
				if(s->decl){
					assert(s->decl->tp==Var||s->decl->tp==Def||s->decl->tp== Proc||s->decl->tp==Type||s->decl->tp==Incl);
					switch(s->decl->tp){
					case Var:/*16:*/

						(void)fputs(get(s->decl->type),f);
						(void)putc(' ',f);
						(void)fputs(get(s->decl->name),f);
						(void)fputs(";\n\n",f);

						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					case Proc:
						declare_function(True,s->decl->name,s->decl,f);
						break;
					case Type:/*11:*/

						(void)fputs("typedef ",f);
						(void)fputs(get(s->decl->type),f);
						(void)putc(' ',f);
						(void)fputs(get(s->decl->name),f);
						(void)fputs(";\n\n",f);

						break;
					case Incl:/*31:*/

						(void)fprintf(f,"#include %s\n",get(s->decl->name));

						break;
					default:
						;
					}
				}
			}



			for(s= c->publicvars;s;s= s->next){
				if(s->decl&&s->decl->tp==Var &&find_instvar_class(c,s->decl->name)==c){
					STRING hi,hc,ht;
					if(s->decl->namesym!=((STRING)NULL)){
						hi= get_instname(s->decl->namesym);
						hc= get_classname(s->decl->namesym);
					} else{
						hi= get_instname(s->decl->name);
						hc= get_classname(s->decl->name);
					}
					if(s->decl->typesym!=((STRING)NULL))
						ht= hdup(s->decl->typesym);
					else
						ht= get_word(get(get_classname(s->decl->type)));
					(void)fprintf(f,"#ifndef XtN%s\n",get(hi));
					(void)fprintf(f,"#define XtN%1$s \"%1$s\"\n",get(hi));
					(void)fprintf(f,"#endif\n");
					(void)fprintf(f,"#ifndef XtC%s\n",get(hc));
					(void)fprintf(f,"#define XtC%1$s \"%1$s\"\n",get(hc));
					(void)fprintf(f,"#endif\n");
					(void)fprintf(f,"#ifndef XtR%s\n",get(ht));
					(void)fprintf(f,"#define XtR%1$s \"%1$s\"\n",get(ht));
					(void)fprintf(f,"#endif\n\n");
					delete(hi);
					delete(hc);
					delete(ht);
				}
			}



			(void)fprintf(f,"typedef struct _%1$sClassRec *%1$sWidgetClass;\n", get(c->name));
			(void)fprintf(f,"typedef struct _%1$sRec *%1$sWidget;\n",get(c->name));
			(void)fprintf(f,"externalref WidgetClass %sWidgetClass;\n", get(instname));


			(void)fprintf(f,"#endif /*%s*/\n",get(guard));
			(void)fclose(f);



			f= mustopen(get_headerPname(headerdir,c),"w");

			(void)fprintf(f,"/* Generated by wbuild from \"%s\"\n",get(c->filename));
			(void)fprintf(f,"** (generator version %s of %s)\n",rcsversion,rcsdate);
			(void)fprintf(f,"*/\n");


			guard= get_guardP(c);
			(void)fprintf(f,"#ifndef %s\n",get(guard));
			(void)fprintf(f,"#define %s\n",get(guard));

			if(c->superclass==CORE)
				(void)fputs("#include <X11/CoreP.h>\n",f);
			else if(c->superclass==RECTOBJ)
				(void)fputs("#include <X11/RectObjP.h>\n",f);
			else if(c->superclass==COMPOSITE)
				(void)fputs("#include <X11/CompositeP.h>\n",f);
			else if(c->superclass==SHELL ||c->superclass==OVERRIDESHELL ||c->superclass==WMSHELL ||c->superclass==VENDORSHELL
			    ||c->superclass==TRANSIENTSHELL ||c->superclass==TOPLEVELSHELL ||c->superclass==APPLICATIONSHELL)
				(void)fputs("#include <X11/ShellP.h>\n",f);
			else if(c->superclass==CONSTRAINT)
				(void)fputs("#include <X11/ConstraintP.h>\n",f);
			else if(c->super)
				(void)fprintf(f,"#include <%s>\n", get(get_headerPname(prefix,c->super)));
			(void)fprintf(f,"#include <%s>\n",get(get_headername(prefix,c)));



			for(s= c->methods;s;s= s->next){
				if(s->decl&&find_method_class(c,s->decl->name)==c){
					(void)fprintf(f,"typedef %s (*%s_Proc)(\n", s->decl->type?get(s->decl->type):"void",
					    get(s->decl->name));
					(void)fprintf(f,"#if NeedFunctionPrototypes\n");
					for(d1= s->decl->params;d1;d1= d1->next){
						if(d1->name==DOLLAR)
							(void)fputs("Widget",f);
						else
							(void)fputs(get(d1->type),f);
						if(d1->next)(void)putc(',',f);
					}
					(void)fprintf(f,"\n#endif\n);\n");
					(void)fprintf(f,"#define XtInherit_%1$s ((%1$s_Proc) _XtInherit)\n", get(s->decl->name));
				}
			}



			(void)fprintf(f,"typedef struct {\n");
			n= 0;
			(void)fprintf(f,"/* methods */\n");
			for(s= c->methods;s;s= s->next)
				if(s->decl){
					assert(s->decl->tp==Proc||s->decl->tp==Def);
					switch(s->decl->tp){
					case Proc:
						if(find_method_class(c,s->decl->name)==c){
							(void)fprintf(f,"%1$s_Proc %1$s;\n",get(s->decl->name));
							n++;
						}
						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						break;
					}
				}
			(void)fprintf(f,"/* class variables */\n");
			for(s= c->classvars;s;s= s->next)
				if(s->decl){
					assert(s->decl->tp==Var||s->decl->tp==Def);
					switch(s->decl->tp){
					case Var:
						if(find_classvar_class(c,s->decl->name)==c){
							(void)fprintf(f,"%s %s;\n",get(s->decl->type),get(s->decl->name));
							n++;
						}
						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						break;
					}
				}
			if(n==0)(void)fprintf(f,"int dummy;\n");
			(void)fprintf(f,"} %sClassPart;\n",get(c->name));



			(void)fprintf(f,"typedef struct _%sClassRec {\n",get(c->name));
			declare_superclassparts(f,c);
			(void)fprintf(f,"} %sClassRec;\n\n",get(c->name));



			(void)fprintf(f,"typedef struct {\n");
			n= 0;
			(void)fprintf(f,"/* resources */\n");
			for(s= c->publicvars;s;s= s->next)
				if(s->decl){
					assert(s->decl->tp==Var||s->decl->tp==Def);
					switch(s->decl->tp){
					case Var:
						if(find_instvar_class(c,s->decl->name)==c){
							(void)fprintf(f,"%s %s;\n",get(s->decl->type),get(s->decl->name));
							n++;
						}
						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						break;
					}
				}
			(void)fprintf(f,"/* private state */\n");
			for(s= c->privatevars;s;s= s->next)
				if(s->decl){
					assert(s->decl->tp==Var||s->decl->tp==Def);
					switch(s->decl->tp){
					case Var:
						if(find_instvar_class(c,s->decl->name)==c){
							(void)fprintf(f,"%s %s;\n",get(s->decl->type),get(s->decl->name));
							n++;
						}
						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						break;
					}
				}
			if(n==0)(void)fprintf(f,"int dummy;\n");
			(void)fprintf(f,"} %sPart;\n\n",get(c->name));



			(void)fprintf(f,"typedef struct _%sRec {\n",get(c->name));
			declare_superparts(f,c);
			(void)fprintf(f,"} %sRec;\n\n",get(c->name));



			(void)fprintf(f,"externalref %sClassRec %sClassRec;\n\n", get(c->name),get(instname));


			(void)fprintf(f,"#endif /* %s */\n",get(guard));
			(void)fclose(f);



			f= mustopen(get_implementationname(implemdir,c),"w");

			(void)fprintf(f,"/* Generated by wbuild from \"%s\"\n",get(c->filename));
			(void)fprintf(f,"** (generator version %s of %s)\n",rcsversion,rcsdate);
			(void)fprintf(f,"*/\n");



			(void)fprintf(f,"#include <X11/IntrinsicP.h>\n");
			(void)fprintf(f,"#include <X11/StringDefs.h>\n");
			for(s= c->imports;s;s= s->next){
				if(s->decl){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
					assert(s->decl->tp==Proc||s->decl->tp==Var||s->decl->tp==Incl);
					switch(s->decl->tp){
					case Proc:/*33:*/

						declare_function(True,s->decl->name,s->decl,f);

						break;
					case Var:/*32:*/

						(void)fprintf(f,"extern %s %s;\n",get(s->decl->type),get(s->decl->name));

						;
						break;
					case Incl:/*31:*/

						(void)fprintf(f,"#include %s\n",get(s->decl->name));

						break;
					default:
						;
					}
				}
			}
			(void)fprintf(f,"#include <%s>\n",get(get_headerPname(prefix,c)));



			for(s= c->actions;s;s= s->next){
				if(s->decl){
					assert(s->decl->tp==Proc||s->decl->tp==Def);
					switch(s->decl->tp){
					case Proc:
						if(s->decl->params!=NULL)err++,(void)fprintf(stderr,"%s:%d: Parameter list of `%s' ignored\n",
						    get(c->filename),s->decl->lineno,get( s->decl->name));
						if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
						declare_function(False,s->decl->name,action_proto.decl,f);
						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						break;
					}
				}
			}



			if(number_of_decls(c->actions)!=0){
				(void)fprintf(f,"\nstatic XtActionsRec actionsList[] = {\n");
				for(s= c->actions;s;s= s->next){
					if(s->decl&&s->decl->tp==Proc){
						(void)fprintf(f,"{\"%s\", %s},\n", get(s->decl->name),get(s->decl->name));
					}
				}
				(void)fprintf(f,"};\n");
			}
			if(number_of_decls(c->translations)!=0){
				(void)fprintf(f,"\nstatic char defaultTranslations[] = \"\\\n");
				for(s= c->translations;s;s= s->next){
					if(s->decl){
						assert(s->decl->tp==Trans);
						(void)fprintf(f,"%s: %s\\n\\\n", get(s->decl->type),get(s->decl->value));
					}
				}
				(void)fprintf(f,"\";\n");
			}




			(void)fprintf(f,"static void _resolve_inheritance(\n");
			(void)fprintf(f,"#if NeedFunctionPrototypes\n");
			(void)fprintf(f,"WidgetClass\n");
			(void)fprintf(f,"#endif\n");
			(void)fprintf(f,");\n");


			for(s= c->methods;s;s= s->next){
				if(s->decl&&s->decl->tp==Proc){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));

					if((s2= find_method(c,s->decl->name))!=s)
						if(s->decl->params!=NULL)err++,(void)fprintf(stderr,"%s:%d: Parameter list of `%s' ignored\n",
						    get(c->filename),s->decl->lineno,get( s->decl->name));
					declare_function(False,s->decl->name,s2->decl,f);


				}
			}



			for(s= c->utilities;s;s= s->next){
				if(s->decl){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
					assert(s->decl->tp==Proc||s->decl->tp==Var||s->decl->tp ==Type||s->decl->tp==Def);
					switch(s->decl->tp){
					case Proc:
						declare_function(False,s->decl->name,s->decl,f);
						break;
					case Var:/*61:*/

						(void)fprintf(f,"static %s %s",get(s->decl->type),get(s->decl->name));
						if(s->decl->value)
							(void)fprintf(f," = %s",get(s->decl->value));
						(void)fputs(";\n",f);

						break;
					case Type:/*60:*/

						(void)fprintf(f,"typedef %s %s;\n", get(s->decl->type),get(s->decl->name));

						break;
					case Def:
						define_macro(f,s->decl,c);
						break;
					default:
						;
					}
				}
			}
			for(s= c->utilities;s;s= s->next){
				if(s->decl&&s->decl->tp==Proc){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
					define_function(False,s->decl,s->decl->body,c,f);
				}
			}



			if(number_of_decls(c->publicvars)!=0){
				(void)fprintf(f,"\nstatic XtResource resources[] = {\n");
				for(s= c->publicvars;s;s= s->next){
					Section s1;
					if(s->decl){
						assert(s->decl->tp==Var||s->decl->tp==Def);
						switch(s->decl->tp){
						case Var:
							s1= find_pubvar(c,s->decl->name);
							if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));

							(void)fprintf(f,"{XtN%s,XtC%s,", s1->decl->namesym?get(s1->decl->namesym):get(s1->decl->name),
							    s1->decl->namesym?get(get_classname(s1->decl->namesym)) :get(get_classname(s1->decl->name)));



							(void)fprintf(f,"XtR%s,",s1->decl->typesym?get(s1->decl->typesym)
							    :get(get_classname(get_word(get(s1->decl->type)))));



							(void)fprintf(f,"sizeof(((%sRec*)NULL)->%s.%s),",get(c->name), get(get_instname(find_instvar_class(c,
							    s1->decl->name)->name)), get(s1->decl->name));
							(void)fprintf(f,"XtOffsetOf(%sRec,%s.%s),",get(c->name), get(get_instname(find_instvar_class(c,
							    s1->decl->name)->name)), get(s1->decl->name));



							if(s->decl->valuesym)
								(void)fprintf(f,"XtR%s,",get(s->decl->valuesym));
							else
								(void)fprintf(f,"XtRImmediate,");
							(void)fprintf(f,"(XtPointer)%s},\n",get(s->decl->value));


							break;
						case Def:
							break;
						default:
							break;
						}
					}
				}
				(void)fprintf(f,"};\n");
			}



			(void)fprintf(f,"\n%sClassRec %sClassRec = {\n", get(c->name),get(instname));
			init_class_parts(f,c,c);
			(void)fprintf(f,"};\n");
			(void)fprintf(f, "WidgetClass %1$sWidgetClass = (WidgetClass) &%1$sClassRec;\n", get(instname));



			for(s= c->actions;s;s= s->next){
				if(s->decl&&s->decl->tp==Proc){
					(void)fputs("/*ARGSUSED*/\n",f);
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
					(void)fprintf(f,"static void %s(self,event,params,num_params)", get(s->decl->name));
					(void)fprintf(f, "Widget self;XEvent*event;String*params;Cardinal*num_params;\n");
					print_body(f,s->decl->body,c,s->decl->name,s->decl->lineno,False);
					(void)putc('\n',f);
				}
			}




			(void)fprintf(f,"static void _resolve_inheritance(class)\n");
			(void)fprintf(f,"WidgetClass class;\n");
			(void)fprintf(f,"{\n");
			(void)fprintf(f,"  %1$sWidgetClass c = (%1$sWidgetClass) class;\n", get(c->name));
			(void)fprintf(f,"  %sWidgetClass super;\n",get(c->name));
			(void)fprintf(f,"  if (class == %sWidgetClass) return;\n",get(instname));
			(void)fprintf(f,"  super = (%sWidgetClass) c->core_class.superclass;\n", get(c->name));
			for(s= c->methods;s;s= s->next){
				if(s->decl&&s->decl->tp==Proc &&find_method_class(c,s->decl->name)==c){
					(void)fprintf(f,"  if (c->%1$s_class.%2$s == XtInherit_%2$s)\n", get(instname),get(s->decl->name));
					(void)fprintf(f,"    c->%1$s_class.%2$s = super->%1$s_class.%2$s;\n", get(instname),
					    get(s->decl->name));
				}
			}
			(void)fprintf(f,"}\n");


			for(s= c->methods;s;s= s->next){
				if(s->decl&&s->decl->tp==Proc){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));

					s2= find_method(c,s->decl->name);
					if(s->decl->name==INSERT_CHILD){

						define_header(False,s2->decl,f);
						(void)fprintf(f,"{ Widget self = XtParent(%s); ", get(s2->decl->params->name));
						print_body(f,s->decl->body,c,s2->decl->name,s->decl->lineno,False);
						(void)fputs("}\n",f);


					} else if(s->decl->name==DELETE_CHILD){

						define_header(False,s2->decl,f);
						(void)fprintf(f,"{ Widget self = XtParent(%s); ", get(s2->decl->params->name));
						print_body(f,s->decl->body,c,s2->decl->name,s->decl->lineno,False);
						(void)fputs("}\n",f);


					} else if(s->decl->name==GEOMETRY_MANAGER){

						define_header(False,s2->decl,f);
						(void)fprintf(f,"{ Widget self = XtParent(%s); ", get(s2->decl->params->name));
						print_body(f,s->decl->body,c,s2->decl->name,s->decl->lineno,False);
						(void)fputs("}\n",f);


					} else{
						define_function(False,s2->decl,s->decl->body,c,f);
					}


				}
			}



			for(s= c->exports;s;s= s->next){
				if(s->decl){
					if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
					assert(s->decl->tp==Proc||s->decl->tp==Var||s->decl->tp ==Type||s->decl->tp==Def||s->decl->tp==Incl);
					switch(s->decl->tp){
					case Proc:/*73:*/

						define_function(True,s->decl,s->decl->body,c,f);

						break;
					case Var:/*72:*/

						if(s->decl->value){
							if(lines)(void)fprintf(f,"#line %d \"%s\"\n",s->decl->lineno,get(c->filename));
							(void)fprintf(f,"%s %s = %s;\n", get(s->decl->type),get(s->decl->name),
							    get(s->decl->value));
						}

						break;
					case Type:
					case Def:
					case Incl:
						break;
					default:
						;
					}
				}
			}


			(void)fclose(f);


		}
		if(!get_option(&dummy1,c,NODOC)){


			f= mustopen(get_docfilename(docdir,c),"w");
			(void)fputs((tag[t_start][doctp][0]),f);



			(void)fputs((tag[t_class][doctp][0]),f);
			(void)fputs((tag[t_name][doctp][0]),f);
			(void)putcode(c->name,f);
			(void)fputs((tag[t_name][doctp][1]),f);
			print_text_par(f,c->text,c->filename,c->lineno);



			if(c->publicvars!=NULL){
				(void)fputs((tag[t_publicvars][doctp][0]),f);

				(void)fputs((tag[t_table][doctp][0]),f);
				(void)fputs((tag[t_tablehead][doctp][0]),f);
				(void)putcode(c->name,f);
				(void)fputs((tag[t_tablehead][doctp][1]),f);
				for(s= c->publicvars;s;s= s->next){
					if(s->decl&&find_instvar_class(c,s->decl->name)==c){
						(void)fputs((tag[t_row][doctp][0]),f);
						(void)fputs((tag[t_resname][doctp][0]),f);
						if(s->decl->namesym)
							(void)putcode(s->decl->namesym,f);
						else{
							(void)fputs("XtN",f);
							(void)putcode(s->decl->name,f);
						}
						(void)fputs((tag[t_resname][doctp][1]),f);
						(void)fputs((tag[t_resclass][doctp][0]),f);
						(void)fputs("XtC",f);
						if(s->decl->namesym)
							(void)putcode(get_classname(s->decl->name),f);
						else
							(void)putcode(get_classname(s->decl->name),f);
						(void)fputs((tag[t_resclass][doctp][1]),f);
						(void)fputs((tag[t_restype][doctp][0]),f);

						if(s->decl->typesym)
							(void)putcode(s->decl->typesym,f);
						else
							(void)putcode(get_classname(s->decl->type),f);
						(void)fputs((tag[t_restype][doctp][1]),f);
						(void)fputs((tag[t_resdefault][doctp][0]),f);
						(void)putcode(s->decl->value,f);
						(void)fputs((tag[t_resdefault][doctp][1]),f);
						(void)fputs((tag[t_row][doctp][1]),f);
					}
				}
				(void)fputs((tag[t_table][doctp][1]),f);


				for(s= c->publicvars;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					if(s->decl){
						(void)fputs((tag[t_publicvar][doctp][0]),f);
						if(s->decl->namesym)
							(void)putcode(s->decl->namesym,f);
						else{
							(void)fputs("XtN",f);
							(void)putcode(s->decl->name,f);
						}
						(void)fputs((tag[t_publicvar][doctp][1]),f);
					}
					print_text_par(f,s->text,c->filename,c->lineno);
					if(s->decl){
						(void)fputs((tag[t_hidden][doctp][0]),f);
						(void)fputs((tag[t_code][doctp][0]),f);
						if(s->decl->typesym){
							(void)fputs((tag[t_less][doctp][0]),f);
							(void)putcode(s->decl->typesym,f);
							(void)fputs((tag[t_greater][doctp][0]),f);
							(void)putc(' ',f);
						}
						(void)putcode(s->decl->type,f);
						(void)putc(' ',f);
						if(s->decl->namesym){
							(void)fputs((tag[t_less][doctp][0]),f);
							(void)putcode(s->decl->namesym,f);
							(void)fputs((tag[t_greater][doctp][0]),f);
							(void)putc(' ',f);
						}
						(void)putcode(s->decl->name,f);
						(void)fputs(" = ",f);
						if(s->decl->valuesym){
							(void)fputs((tag[t_less][doctp][0]),f);
							(void)putcode(s->decl->valuesym,f);
							(void)fputs((tag[t_greater][doctp][0]),f);
						}
						(void)putcode(s->decl->value,f);
						(void)fputs((tag[t_code][doctp][1]),f);
						(void)fputs((tag[t_hidden][doctp][1]),f);
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_publicvars][doctp][1]),f);
			}



			if(c->superclass!=NULL){
				tabulate_inherited_resources(f,c,c->super);
			}



			if(c->exports!=NULL){
				(void)fputs((tag[t_exports][doctp][0]),f);
				for(s= c->exports;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){

						assert(s->decl->tp==Proc||s->decl->tp==Var||s->decl->tp== Type||s->decl->tp==Def||s->decl->tp==Incl);
						switch(s->decl->tp){
						case Proc:
							(void)fputs((tag[t_code][doctp][0]),f);
							(void)putcode(s->decl->type,f);
							if(s->decl->type!=((STRING)NULL))(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							if(s->decl->params){
								(void)putc('(',f);
								for(d1= s->decl->params;d1;d1= d1->next){
/* code folded from here */
	(void)putcode(d1->type,f);
	(void)putc(' ',f);
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
								(void)putc(')',f);
							}
							(void)fputs((tag[t_code][doctp][1]),f);
							(void)fputs((tag[t_hidden][doctp][0]),f);
							(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_hidden][doctp][1]),f);
							break;
						case Var:/*94:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)putcode(s->decl->type,f);
							if(s->decl->type!=((STRING)NULL))(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							if(s->decl->value!=((STRING)NULL)){
								(void)fputs(" = ",f);
								(void)putcode(s->decl->value,f);
							}
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Type:/*95:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)fputs((tag[t_type][doctp][0]),f);
							(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							(void)fputs(" = ",f);
							(void)putcode(s->decl->type,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Def:/*96:*/

							(void)fputs((tag[t_macro][doctp][0]),f);
							(void)putcode(s->decl->name,f);
							if(s->decl->params){
								(void)putc('(',f);
								for(d1= s->decl->params;d1;d1= d1->next){
/* code folded from here */
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
								(void)fputs(") =\n",f);
							} else
								(void)fputs(" = ",f);
							(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_macro][doctp][1]),f);

							break;
						case Incl:/*89:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)fputs((tag[t_incl][doctp][0]),f);
							(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						default:
							;
						}


					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_exports][doctp][1]),f);
			}



			if(c->translations!=NULL){
				(void)fputs((tag[t_translations][doctp][0]),f);
				for(s= c->translations;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					(void)fputs((tag[t_code][doctp][0]),f);
					(void)putcode(s->decl->type,f);
					(void)fputs(": ",f);
					(void)putcode(s->decl->value,f);
					(void)fputs((tag[t_code][doctp][1]),f);
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_translations][doctp][1]),f);
			}



			if(c->actions!=NULL){
				(void)fputs((tag[t_actions][doctp][0]),f);
				for(s= c->actions;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					if(s->decl&&s->decl->tp==Proc){
						(void)fputs((tag[t_action][doctp][0]),f);
						(void)putcode(s->decl->name,f);
						(void)fputs((tag[t_action][doctp][1]),f);
					}
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){
						assert(s->decl->tp==Proc||s->decl->tp==Def);
						(void)fputs((tag[t_hidden][doctp][0]),f);
						switch(s->decl->tp){
						case Proc:
							s2= &action_proto;/*93:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							if(s2->decl->type!=((STRING)NULL)){
								(void)putcode(s2->decl->type,f);
								(void)putc(' ',f);
							}
							(void)putcode(s->decl->name,f);
							(void)putc('(',f);
							if(s2->decl->params){
								for(d1= s2->decl->params;d1;d1= d1->next){
/* code folded from here */
	if(d1->type!=((STRING)NULL)){
		(void)putcode(d1->type,f);
		(void)putc(' ',f);
	}
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
							}
							(void)putc(')',f);
							(void)putc('\n',f);
							if(s->decl->body)(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Def:/*96:*/

							(void)fputs((tag[t_macro][doctp][0]),f);
							(void)putcode(s->decl->name,f);
							if(s->decl->params){
								(void)putc('(',f);
								for(d1= s->decl->params;d1;d1= d1->next){
/* code folded from here */
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
								(void)fputs(") =\n",f);
							} else
								(void)fputs(" = ",f);
							(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_macro][doctp][1]),f);

							break;
						default:
							break;
						}
						(void)fputs((tag[t_hidden][doctp][1]),f);
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_actions][doctp][1]),f);
			}



			if(c->imports!=NULL){
				(void)fputs((tag[t_imports][doctp][0]),f);
				for(s= c->imports;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){
						assert(s->decl->tp==Proc||s->decl->tp==Var|| s->decl->tp==Incl);
						switch(s->decl->tp){
						case Proc:
							s2= s;/*93:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							if(s2->decl->type!=((STRING)NULL)){
								(void)putcode(s2->decl->type,f);
								(void)putc(' ',f);
							}
							(void)putcode(s->decl->name,f);
							(void)putc('(',f);
							if(s2->decl->params){
								for(d1= s2->decl->params;d1;d1= d1->next){
/* code folded from here */
	if(d1->type!=((STRING)NULL)){
		(void)putcode(d1->type,f);
		(void)putc(' ',f);
	}
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
							}
							(void)putc(')',f);
							(void)putc('\n',f);
							if(s->decl->body)(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Var:/*94:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)putcode(s->decl->type,f);
							if(s->decl->type!=((STRING)NULL))(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							if(s->decl->value!=((STRING)NULL)){
								(void)fputs(" = ",f);
								(void)putcode(s->decl->value,f);
							}
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Incl:/*89:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)fputs((tag[t_incl][doctp][0]),f);
							(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						default:
							;
						}
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_imports][doctp][1]),f);
			}



			if(c->privatevars!=NULL){
				(void)fputs((tag[t_privatevars][doctp][0]),f);
				for(s= c->privatevars;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){
						(void)fputs((tag[t_code][doctp][0]),f);
						(void)putcode(s->decl->type,f);
						(void)putc(' ',f);
						(void)putcode(s->decl->name,f);
						(void)fputs((tag[t_code][doctp][1]),f);
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_privatevars][doctp][1]),f);
			}



			if(c->classvars!=NULL){
				(void)fputs((tag[t_classvars][doctp][0]),f);
				for(s= c->classvars;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){

						(void)fputs((tag[t_code][doctp][0]),f);
						(void)putcode(s->decl->type,f);
						if(s->decl->type!=((STRING)NULL))(void)putc(' ',f);
						(void)putcode(s->decl->name,f);
						if(s->decl->value!=((STRING)NULL)){
							(void)fputs(" = ",f);
							(void)putcode(s->decl->value,f);
						}
						(void)fputs((tag[t_code][doctp][1]),f);


					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_classvars][doctp][1]),f);
			}



			if(c->methods!=NULL){
				(void)fputs((tag[t_methods][doctp][0]),f);
				for(s= c->methods;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){
						assert(s->decl->tp==Proc||s->decl->tp==Def);
						switch(s->decl->tp){
						case Proc:
							s2= find_method(c,s->decl->name);

							(void)fputs((tag[t_code][doctp][0]),f);
							if(s2->decl->type!=((STRING)NULL)){
								(void)putcode(s2->decl->type,f);
								(void)putc(' ',f);
							}
							(void)putcode(s->decl->name,f);
							(void)putc('(',f);
							if(s2->decl->params){
								for(d1= s2->decl->params;d1;d1= d1->next){
/* code folded from here */
	if(d1->type!=((STRING)NULL)){
		(void)putcode(d1->type,f);
		(void)putc(' ',f);
	}
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
							}
							(void)putc(')',f);
							(void)putc('\n',f);
							if(s->decl->body)(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_code][doctp][1]),f);


							break;
						case Def:/*96:*/

							(void)fputs((tag[t_macro][doctp][0]),f);
							(void)putcode(s->decl->name,f);
							if(s->decl->params){
								(void)putc('(',f);
								for(d1= s->decl->params;d1;d1= d1->next){
/* code folded from here */
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
								(void)fputs(") =\n",f);
							} else
								(void)fputs(" = ",f);
							(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_macro][doctp][1]),f);

							break;
						default:
							;
						}
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_methods][doctp][1]),f);
			}



			if(c->utilities!=NULL){
				(void)fputs((tag[t_utilities][doctp][0]),f);
				for(s= c->utilities;s;s= s->next){
					(void)fputs((tag[t_section][doctp][0]),f);
					print_text_par(f,s->text,c->filename,s->decl->lineno);
					if(s->decl){
						assert(s->decl->tp==Proc||s->decl->tp==Var|| s->decl->tp==Type||s->decl->tp==Def);
						switch(s->decl->tp){
						case Proc:
							s2= s;/*93:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							if(s2->decl->type!=((STRING)NULL)){
								(void)putcode(s2->decl->type,f);
								(void)putc(' ',f);
							}
							(void)putcode(s->decl->name,f);
							(void)putc('(',f);
							if(s2->decl->params){
								for(d1= s2->decl->params;d1;d1= d1->next){
/* code folded from here */
	if(d1->type!=((STRING)NULL)){
		(void)putcode(d1->type,f);
		(void)putc(' ',f);
	}
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
							}
							(void)putc(')',f);
							(void)putc('\n',f);
							if(s->decl->body)(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Var:/*94:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)putcode(s->decl->type,f);
							if(s->decl->type!=((STRING)NULL))(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							if(s->decl->value!=((STRING)NULL)){
								(void)fputs(" = ",f);
								(void)putcode(s->decl->value,f);
							}
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Type:/*95:*/

							(void)fputs((tag[t_code][doctp][0]),f);
							(void)fputs((tag[t_type][doctp][0]),f);
							(void)putc(' ',f);
							(void)putcode(s->decl->name,f);
							(void)fputs(" = ",f);
							(void)putcode(s->decl->type,f);
							(void)fputs((tag[t_code][doctp][1]),f);

							break;
						case Def:/*96:*/

							(void)fputs((tag[t_macro][doctp][0]),f);
							(void)putcode(s->decl->name,f);
							if(s->decl->params){
								(void)putc('(',f);
								for(d1= s->decl->params;d1;d1= d1->next){
/* code folded from here */
	(void)putcode(d1->name,f);
	if(d1->next)(void)fputs(", ",f);
/* unfolding */
								}
								(void)fputs(") =\n",f);
							} else
								(void)fputs(" = ",f);
							(void)putcode(s->decl->body,f);
							(void)fputs((tag[t_macro][doctp][1]),f);

							break;
						default:
							;
						}
					}
					(void)fputs((tag[t_section][doctp][1]),f);
				}
				(void)fputs((tag[t_utilities][doctp][1]),f);
			}



			(void)fputs((tag[t_start][doctp][1]),f);
			(void)fclose(f);




		}
	}
	return err;
}
