#ifndef _FDC_IO_H
#define _FDC_IO_H

/*
 * Copyright (C) 1993,1994 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.10/RCS/fdc-io.h,v $
 $Author: bas $
 *
 $Revision: 1.23 $
 $Date: 1994/02/20 15:26:55 $
 $State: Alpha $
 *
 *      This file contains the low level functions
 *      that communicate with the floppy disk controller,
 *      for the QIC-40/80 floppy-tape driver for Linux.
 */

#include <linux/fdreg.h>

#define FDC_SK_BIT      (0x20)
#define FDC_MT_BIT      (0x80)

#define FDC_READ        (FD_READ & ~(FDC_SK_BIT | FDC_MT_BIT))
#define FDC_WRITE       (FD_WRITE & ~FDC_MT_BIT)
#define FDC_READ_DELETED (0x4c)
#define FDC_WRITE_DELETED (0x49)
#define FDC_READID      (0x4a)
#define FDC_SENSED      (0x04)
#define FDC_SENSEI      (FD_SENSEI)
#define FDC_RECAL       (FD_RECALIBRATE)
#define FDC_SEEK        (FD_SEEK)
#define FDC_SPECIFY     (FD_SPECIFY)
#define FDC_RECALIBR    (FD_RECALIBRATE)

#define FDC_STATUS      (FD_STATUS)
#define FDC_DATA        (FD_DATA)
#define FDC_CONTROL     (FD_DOR)
#define FDC_VFO         (FD_DCR)

#define FDC_STATUS_MASK (STATUS_BUSY | STATUS_DMA | STATUS_DIR | STATUS_READY)
#define FDC_DATA_READY  (STATUS_READY)
#define FDC_DATA_OUTPUT (STATUS_DIR)
#define FDC_DATA_READY_MASK (STATUS_READY | STATUS_DIR)
#define FDC_DATA_OUT_READY  (STATUS_READY | STATUS_DIR)
#define FDC_DATA_IN_READY   (STATUS_READY)
#define FDC_BUSY        (STATUS_BUSY)

#define ST0_INT_MASK    (ST0_INTR)
#define FDC_INT_NORMAL  (ST0_INTR & 0x00)
#define FDC_INT_ABNORMAL (ST0_INTR & 0x40)
#define FDC_INT_INVALID (ST0_INTR & 0x80)
#define FDC_INT_READYCH (ST0_INTR & 0xC0)
#define ST0_SEEK_END    (ST0_SE)
#define ST3_TRACK_0     (ST3_TZ)

#define FDC_RESET_NOT   (0x04)
#define FDC_DMA_MODE    (0x08)
#define FDC_MOTOR_0     (0x10)
#define FDC_MOTOR_1     (0x20)

typedef enum {
  empty = 0,
  reading,
  writing,
  full,
  error,
} buffer_state_enum;

typedef volatile enum {
  fdc_idle = 0,
  fdc_reading_data = FDC_READ,
  fdc_seeking = FDC_SEEK, 
  fdc_writing_data = FDC_WRITE,
  fdc_reading_id = FDC_READID,
  fdc_recalibrating = FDC_RECAL,
} fdc_mode_enum;

/*
 *      fdc-io.c defined public variables
 */
extern fdc_mode_enum fdc_mode;
extern volatile enum runner_status_enum runner_status;
extern int old_vfo;
extern volatile int head;
extern volatile int tail;
extern int fdc_setup_error; /* outdated ??? */
extern struct wait_queue *wait_intr;
extern volatile unsigned int next_segment; /* next segment for read ahead */
extern int ftape_unit;          /* fdc unit specified at ftape_open() */
extern int ftape_motor;         /* fdc motor line state */
extern int current_cylinder;    /* track nr the FDC thinks we're on */
extern volatile byte fdc_head;  /* FDC head */
extern volatile byte fdc_cyl;   /* FDC track */
extern volatile byte fdc_sect;  /* FDC sector */

/*
 *      fdc-io.c defined public functions
 */
extern void fdc_catch_stray_interrupts( unsigned count);
extern int fdc_ready_wait( int timeout);
extern int fdc_write( byte data);
extern int fdc_read( byte* data);
extern int fdc_command( byte* cmd_data, int cmd_len);
extern int fdc_result( byte* res_data, int res_len);
extern int fdc_issue_command( byte *out_data, int out_count,\
                             byte *in_data, int in_count);
extern void fdc_isr( void);
extern int fdc_interrupt_wait( int time);
extern void fdt_sleep( unsigned int time);
extern int fdc_specify( int head_unload_time, int seek_rate,
                       int head_load_time, int non_dma);
extern int fdc_set_seek_rate( int seek_rate);
extern int fdc_seek( int track);
extern int fdc_sense_drive_status( int *st3);
extern void fdc_motor(int motor);
extern void fdc_reset(void);
extern int fdc_recalibrate( void);
extern void fdc_disable( void);
extern int fdc_wait_calibrate( void);
extern int fdc_sense_interrupt_status( int *st0, int *current_cylinder);

#endif
