-----------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--            S Y S T E M . C O M P I L E R _ E X C E P T I O N S           --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.7 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or  (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------


with System.Error_Reporting;
--  Used for,  Error_Reporting.Unimplemented_Operation
--             Error_Reporting.Assert

with System.Task_Primitives;
--  Used for,  Task_Primitives.Machine_Exceptions;
--             Task_Primitives.Error_Information;

with System.Tasking;
--  Used for,  Tasking.Self
--             Tasking.Pre_Call_State
--             Tasking.Null_Exception
--             Tasking.Exception_ID
--             Tasking.Numeric_Error_ID
--             Tasking.Constraint_Error_ID
--             Tasking.Storage_Error_ID

package body System.Compiler_Exceptions is

   procedure Unimplemented renames
      System.Error_Reporting.Unimplemented_Operation;

   ---------------------
   -- Raise_Exception --
   ---------------------

   procedure Raise_Exception (E : Tasking.Exception_ID) is
   begin
      if E /= Tasking.Null_Exception then
         Unimplemented;
      end if;
   end Raise_Exception;

   ----------------------
   -- Notify_Exception --
   ----------------------


   procedure Notify_Exception
     (Which              : Task_Primitives.Machine_Exceptions;
      Info               :  Task_Primitives.Error_Information;
      Modified_Registers : Tasking.Pre_Call_State)
   is
   begin
      Unimplemented;
   end Notify_Exception;

   -----------------------
   -- Current_Exception --
   -----------------------

   function Current_Exception return Tasking.Exception_ID is
   begin
      Unimplemented;
      return Tasking.Null_Exception;
   end Current_Exception;

   -----------
   -- Image --
   -----------

   function Image
     (E    : Tasking.Exception_ID)
      return Exception_ID_String
   is
   begin
      Unimplemented;
      return "Not Implemented*";
   end Image;

end System.Compiler_Exceptions;
