/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.rdbms.RdbmsConnection;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.RdbmsTripleRepository;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.evaluation.QueryBuilderFactory;
import org.openrdf.sail.rdbms.evaluation.RdbmsEvaluationFactory;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.managers.BNodeManager;
import org.openrdf.sail.rdbms.managers.HashManager;
import org.openrdf.sail.rdbms.managers.LiteralManager;
import org.openrdf.sail.rdbms.managers.NamespaceManager;
import org.openrdf.sail.rdbms.managers.PredicateManager;
import org.openrdf.sail.rdbms.managers.TransTableManager;
import org.openrdf.sail.rdbms.managers.TripleManager;
import org.openrdf.sail.rdbms.managers.TripleTableManager;
import org.openrdf.sail.rdbms.managers.UriManager;
import org.openrdf.sail.rdbms.optimizers.RdbmsQueryOptimizer;
import org.openrdf.sail.rdbms.optimizers.SelectQueryOptimizerFactory;
import org.openrdf.sail.rdbms.schema.BNodeTable;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.IntegerIdSequence;
import org.openrdf.sail.rdbms.schema.LiteralTable;
import org.openrdf.sail.rdbms.schema.LongIdSequence;
import org.openrdf.sail.rdbms.schema.NamespacesTable;
import org.openrdf.sail.rdbms.schema.TableFactory;
import org.openrdf.sail.rdbms.schema.URITable;
import org.openrdf.sail.rdbms.schema.ValueTableFactory;

public class RdbmsConnectionFactory {
    private RdbmsStore sail;
    private DataSource ds;
    private String user;
    private String password;
    private Connection resourceInserts;
    private Connection literalInserts;
    private Connection hashLookups;
    private Connection nsAndTableIndexes;
    private NamespaceManager namespaces;
    private TripleTableManager tripleTableManager;
    private HashManager hashManager;
    private RdbmsValueFactory vf;
    private UriManager uriManager;
    private BNodeManager bnodeManager;
    private LiteralManager literalManager;
    private PredicateManager predicateManager;
    private int maxTripleTables;
    private boolean triplesIndexed = true;
    private boolean sequenced;
    private HashTable hashTable;
    private URITable uriTable;
    private BNodeTable bnodeTable;
    private LiteralTable literalTable;
    private IdSequence ids;
    private final Lock lock = new ReentrantLock();

    public void setSail(RdbmsStore sail) {
        this.sail = sail;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    public void setDataSource(DataSource ds, String user, String password) {
        this.ds = ds;
        this.user = user;
        this.password = password;
    }

    public int getMaxNumberOfTripleTables() {
        return this.maxTripleTables;
    }

    public void setMaxNumberOfTripleTables(int max) {
        this.maxTripleTables = max;
    }

    public boolean isSequenced() {
        return this.sequenced || this.hashManager != null;
    }

    public void setSequenced(boolean useSequence) {
        this.sequenced = useSequence;
    }

    public boolean isTriplesIndexed() {
        return this.triplesIndexed;
    }

    public void setTriplesIndexed(boolean triplesIndexed) throws SailException {
        this.triplesIndexed = triplesIndexed;
        if (this.tripleTableManager != null) {
            try {
                if (triplesIndexed) {
                    this.tripleTableManager.createTripleIndexes();
                } else {
                    this.tripleTableManager.dropTripleIndexes();
                }
            }
            catch (SQLException e) {
                throw new RdbmsException(e);
            }
        }
    }

    public RdbmsValueFactory getValueFactory() {
        return this.vf;
    }

    public void init() throws SailException {
        try {
            this.nsAndTableIndexes = this.getConnection();
            this.resourceInserts = this.getConnection();
            this.literalInserts = this.getConnection();
            this.nsAndTableIndexes.setAutoCommit(true);
            this.resourceInserts.setAutoCommit(true);
            this.literalInserts.setAutoCommit(true);
            this.bnodeManager = new BNodeManager();
            this.uriManager = new UriManager();
            this.literalManager = new LiteralManager();
            ValueTableFactory tables = this.createValueTableFactory();
            tables.setSequenced(this.sequenced);
            if (this.sequenced) {
                this.ids = new IntegerIdSequence();
                tables.setIdSequence(this.ids);
                this.hashLookups = this.getConnection();
                this.hashLookups.setAutoCommit(true);
                this.hashManager = new HashManager();
                this.hashTable = tables.createHashTable(this.hashLookups, this.hashManager.getQueue());
                this.ids.setHashTable(this.hashTable);
                this.ids.init();
                this.hashManager.setHashTable(this.hashTable);
                this.hashManager.setBNodeManager(this.bnodeManager);
                this.hashManager.setLiteralManager(this.literalManager);
                this.hashManager.setUriManager(this.uriManager);
                this.hashManager.setIdSequence(this.ids);
                this.hashManager.init();
            } else {
                this.ids = new LongIdSequence();
                this.ids.init();
                tables.setIdSequence(this.ids);
            }
            this.namespaces = new NamespaceManager();
            this.namespaces.setConnection(this.resourceInserts);
            NamespacesTable nsTable = tables.createNamespacesTable(this.nsAndTableIndexes);
            nsTable.initialize();
            this.namespaces.setNamespacesTable(nsTable);
            this.namespaces.initialize();
            this.bnodeManager.setHashManager(this.hashManager);
            this.bnodeManager.setIdSequence(this.ids);
            this.uriManager.setHashManager(this.hashManager);
            this.uriManager.setIdSequence(this.ids);
            this.bnodeTable = tables.createBNodeTable(this.resourceInserts, this.bnodeManager.getQueue());
            this.uriTable = tables.createURITable(this.resourceInserts, this.uriManager.getQueue());
            this.literalManager.setHashManager(this.hashManager);
            this.literalManager.setIdSequence(this.ids);
            this.literalTable = tables.createLiteralTable(this.literalInserts, this.literalManager.getQueue());
            this.literalTable.setIdSequence(this.ids);
            this.vf = new RdbmsValueFactory();
            this.vf.setDelegate(ValueFactoryImpl.getInstance());
            this.vf.setIdSequence(this.ids);
            this.uriManager.setUriTable(this.uriTable);
            this.uriManager.init();
            this.predicateManager = new PredicateManager();
            this.predicateManager.setUriManager(this.uriManager);
            this.tripleTableManager = new TripleTableManager(tables);
            this.tripleTableManager.setConnection(this.nsAndTableIndexes);
            this.tripleTableManager.setIdSequence(this.ids);
            this.tripleTableManager.setBNodeManager(this.bnodeManager);
            this.tripleTableManager.setUriManager(this.uriManager);
            this.tripleTableManager.setLiteralManager(this.literalManager);
            this.tripleTableManager.setHashManager(this.hashManager);
            this.tripleTableManager.setPredicateManager(this.predicateManager);
            this.tripleTableManager.setMaxNumberOfTripleTables(this.maxTripleTables);
            this.tripleTableManager.setIndexingTriples(this.triplesIndexed);
            this.tripleTableManager.initialize();
            if (this.triplesIndexed) {
                this.tripleTableManager.createTripleIndexes();
            } else {
                this.tripleTableManager.dropTripleIndexes();
            }
            this.bnodeManager.setTable(this.bnodeTable);
            this.bnodeManager.init();
            this.vf.setBNodeManager(this.bnodeManager);
            this.vf.setURIManager(this.uriManager);
            this.literalManager.setTable(this.literalTable);
            this.literalManager.init();
            this.vf.setLiteralManager(this.literalManager);
            this.vf.setPredicateManager(this.predicateManager);
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    public boolean isWritable() throws SailException {
        try {
            return !this.nsAndTableIndexes.isReadOnly();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    public SailConnection createConnection() throws SailException {
        try {
            Connection db = this.getConnection();
            db.setAutoCommit(true);
            if (db.getTransactionIsolation() != 2) {
                db.setTransactionIsolation(2);
            }
            TripleManager tripleManager = new TripleManager();
            RdbmsTripleRepository s = new RdbmsTripleRepository();
            s.setTripleManager(tripleManager);
            s.setValueFactory(this.vf);
            s.setConnection(db);
            s.setBNodeTable(this.bnodeTable);
            s.setURITable(this.uriTable);
            s.setLiteralTable(this.literalTable);
            s.setIdSequence(this.ids);
            DefaultSailChangedEvent sailChangedEvent = new DefaultSailChangedEvent(this.sail);
            s.setSailChangedEvent(sailChangedEvent);
            TableFactory tables = this.createTableFactory();
            TransTableManager trans = this.createTransTableManager();
            trans.setIdSequence(this.ids);
            tripleManager.setTransTableManager(trans);
            trans.setBatchQueue(tripleManager.getQueue());
            trans.setSailChangedEvent(sailChangedEvent);
            trans.setConnection(db);
            trans.setTemporaryTableFactory(tables);
            trans.setStatementsTable(this.tripleTableManager);
            trans.setFromDummyTable(this.getFromDummyTable());
            trans.initialize();
            s.setTransaction(trans);
            QueryBuilderFactory bfactory = this.createQueryBuilderFactory();
            bfactory.setValueFactory(this.vf);
            bfactory.setUsingHashTable(this.hashManager != null);
            s.setQueryBuilderFactory(bfactory);
            RdbmsConnection conn = new RdbmsConnection(this.sail, s);
            conn.setNamespaces(this.namespaces);
            RdbmsEvaluationFactory efactory = new RdbmsEvaluationFactory();
            efactory.setQueryBuilderFactory(bfactory);
            efactory.setRdbmsTripleRepository(s);
            efactory.setIdSequence(this.ids);
            conn.setRdbmsEvaluationFactory(efactory);
            RdbmsQueryOptimizer optimizer = this.createOptimizer();
            SelectQueryOptimizerFactory selectOptimizerFactory = this.createSelectQueryOptimizerFactory();
            selectOptimizerFactory.setTransTableManager(trans);
            selectOptimizerFactory.setValueFactory(this.vf);
            selectOptimizerFactory.setIdSequence(this.ids);
            optimizer.setSelectQueryOptimizerFactory(selectOptimizerFactory);
            optimizer.setValueFactory(this.vf);
            optimizer.setBnodeTable(this.bnodeTable);
            optimizer.setUriTable(this.uriTable);
            optimizer.setLiteralTable(this.literalTable);
            optimizer.setHashTable(this.hashTable);
            conn.setRdbmsQueryOptimizer(optimizer);
            conn.setLock(this.lock);
            return conn;
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    public void shutDown() throws SailException {
        try {
            if (this.tripleTableManager != null) {
                this.tripleTableManager.close();
            }
            if (this.uriManager != null) {
                this.uriManager.close();
            }
            if (this.bnodeManager != null) {
                this.bnodeManager.close();
            }
            if (this.literalManager != null) {
                this.literalManager.close();
            }
            if (this.hashManager != null) {
                this.hashManager.close();
            }
            if (this.resourceInserts != null) {
                this.resourceInserts.close();
                this.resourceInserts = null;
            }
            if (this.literalInserts != null) {
                this.literalInserts.close();
                this.literalInserts = null;
            }
            if (this.hashLookups != null) {
                this.hashLookups.close();
                this.hashLookups = null;
            }
            if (this.nsAndTableIndexes != null) {
                this.nsAndTableIndexes.close();
                this.nsAndTableIndexes = null;
            }
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    protected QueryBuilderFactory createQueryBuilderFactory() {
        return new QueryBuilderFactory();
    }

    protected ValueTableFactory createValueTableFactory() {
        return new ValueTableFactory(this.createTableFactory());
    }

    protected TableFactory createTableFactory() {
        return new TableFactory();
    }

    protected TransTableManager createTransTableManager() {
        return new TransTableManager();
    }

    protected RdbmsQueryOptimizer createOptimizer() {
        return new RdbmsQueryOptimizer();
    }

    protected SelectQueryOptimizerFactory createSelectQueryOptimizerFactory() {
        return new SelectQueryOptimizerFactory();
    }

    protected String getFromDummyTable() {
        return "FROM DUAL";
    }

    protected Connection getConnection() throws SQLException {
        if (this.user == null) {
            return this.ds.getConnection();
        }
        return this.ds.getConnection(this.user, this.password);
    }
}

