/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.io.ByteArrayUtil;
import info.aduna.iteration.CloseableIterationBase;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;
import org.openrdf.sail.nativerdf.model.NativeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NativeStatementIterator
extends CloseableIterationBase<Statement, IOException> {
    private RecordIterator btreeIter;
    private ValueStore valueStore;
    private byte[] nextValue;

    public NativeStatementIterator(RecordIterator btreeIter, ValueStore valueStore) throws IOException {
        this.btreeIter = btreeIter;
        this.valueStore = valueStore;
        this.nextValue = btreeIter.next();
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public Statement next() throws IOException {
        byte[] nextValue = this.nextValue;
        if (nextValue == null) {
            throw new NoSuchElementException();
        }
        int subjID = ByteArrayUtil.getInt(nextValue, 0);
        Resource subj = (Resource)((Object)this.valueStore.getValue(subjID));
        int predID = ByteArrayUtil.getInt(nextValue, 4);
        URI pred = (URI)((Object)this.valueStore.getValue(predID));
        int objID = ByteArrayUtil.getInt(nextValue, 8);
        NativeValue obj = this.valueStore.getValue(objID);
        Resource context = null;
        int contextID = ByteArrayUtil.getInt(nextValue, 12);
        if (contextID != 0) {
            context = (Resource)((Object)this.valueStore.getValue(contextID));
        }
        this.nextValue = this.btreeIter.next();
        return this.valueStore.createStatement(subj, pred, obj, context);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws IOException {
        this.nextValue = null;
        this.btreeIter.close();
    }
}

