/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository;

import info.aduna.lang.FileFormat;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;

public abstract class QueryResultView
implements View {
    public static final String QUERY_RESULT_KEY = "queryResult";
    public static final String FACTORY_KEY = "factory";
    public static final String FILENAME_HINT_KEY = "filenameHint";

    protected void setContentType(HttpServletResponse response, FileFormat fileFormat) throws IOException {
        String mimeType = fileFormat.getDefaultMIMEType();
        if (fileFormat.hasCharset()) {
            Charset charset = fileFormat.getCharset();
            mimeType = mimeType + "; charset=" + charset.name();
        }
        response.setContentType(mimeType);
    }

    protected void setContentDisposition(Map model, HttpServletResponse response, FileFormat fileFormat) throws IOException {
        String filename = (String)model.get(FILENAME_HINT_KEY);
        if (filename == null || filename.length() == 0) {
            filename = "result";
        }
        if (fileFormat.getDefaultFileExtension() != null) {
            filename = filename + "." + fileFormat.getDefaultFileExtension();
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
    }
}

