--TEST--
Testing randomization of shuffle() and str_shuffle().
--FILE--
<?php
function stats($f, $a) {
    $times = 90000;
    print "$f\n";
    ksort($a);
    foreach($a as $k => $v)
        print "$k: $v: " . sprintf('%0.3f', $v / $times) . "\n";
}
$a = array();
$times = 90000;
for ($i = 0; $i < $times; $i++) {
    $p = range(1,4);
    shuffle($p);
    $s = join('', $p);
    if (empty($a[$s])) $a[$s] = 0; 
    $a[$s]++;
}

stats('shuffle', $a);
$a = array();
$times = 90000;
for ($i = 0; $i < $times; $i++) {
    $p = '1234';
    $s = str_shuffle($p);
    if (empty($a[$s])) $a[$s] = 0;
    $a[$s]++;
}

stats('str_shuffle', $a);
?>
--EXPECTREGEX--
shuffle
1234: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1243: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1324: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1342: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1423: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1432: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2134: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2143: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2314: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2341: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2413: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2431: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3124: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3142: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3214: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3241: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3412: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3421: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4123: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4132: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4213: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4231: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4312: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4321: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
str_shuffle
1234: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1243: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1324: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1342: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1423: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
1432: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2134: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2143: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2314: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2341: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2413: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
2431: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3124: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3142: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3214: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3241: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3412: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
3421: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4123: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4132: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4213: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4231: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4312: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
4321: 3[0-9][0-9][0-9]: 0.0[3-4][0-9]
