/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.List;
import javax.swing.SortOrder;
import javax.swing.event.EventListenerList;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowSorter<M> {
    private EventListenerList listenerList = new EventListenerList();

    public abstract M getModel();

    public abstract void toggleSortOrder(int var1);

    public abstract int convertRowIndexToModel(int var1);

    public abstract int convertRowIndexToView(int var1);

    public abstract void setSortKeys(List<? extends SortKey> var1);

    public abstract List<? extends SortKey> getSortKeys();

    public abstract int getViewRowCount();

    public abstract int getModelRowCount();

    public abstract void modelStructureChanged();

    public abstract void allRowsChanged();

    public abstract void rowsInserted(int var1, int var2);

    public abstract void rowsDeleted(int var1, int var2);

    public abstract void rowsUpdated(int var1, int var2);

    public abstract void rowsUpdated(int var1, int var2, int var3);

    public void addRowSorterListener(RowSorterListener rowSorterListener) {
        this.listenerList.add(RowSorterListener.class, rowSorterListener);
    }

    public void removeRowSorterListener(RowSorterListener rowSorterListener) {
        this.listenerList.remove(RowSorterListener.class, rowSorterListener);
    }

    protected void fireSortOrderChanged() {
        this.fireRowSorterChanged(new RowSorterEvent(this));
    }

    protected void fireRowSorterChanged(int[] nArray) {
        this.fireRowSorterChanged(new RowSorterEvent(this, RowSorterEvent.Type.SORTED, nArray));
    }

    void fireRowSorterChanged(RowSorterEvent rowSorterEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RowSorterListener.class) continue;
            ((RowSorterListener)objectArray[i + 1]).sorterChanged(rowSorterEvent);
        }
    }

    public static class SortKey {
        private int column;
        private SortOrder sortOrder;

        public SortKey(int n, SortOrder sortOrder) {
            if (sortOrder == null) {
                throw new IllegalArgumentException("sort order must be non-null");
            }
            this.column = n;
            this.sortOrder = sortOrder;
        }

        public final int getColumn() {
            return this.column;
        }

        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.column;
            n = 37 * n + this.sortOrder.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof SortKey) {
                return ((SortKey)object).column == this.column && ((SortKey)object).sortOrder == this.sortOrder;
            }
            return false;
        }
    }
}

