/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.OperationEntry;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XMBean;

public abstract class XOperations
extends JPanel
implements ActionListener {
    public static final String OPERATION_INVOCATION_EVENT = "jam.xoperations.invoke.result";
    private List<NotificationListener> notificationListenersList;
    private Hashtable<JButton, OperationEntry> operationEntryTable;
    private XMBean mbean;
    private MBeanInfo mbeanInfo;
    private MBeansTab mbeansTab;

    public XOperations(MBeansTab mBeansTab) {
        super(new GridLayout(1, 1));
        this.mbeansTab = mBeansTab;
        this.operationEntryTable = new Hashtable();
        ArrayList arrayList = new ArrayList(1);
        this.notificationListenersList = Collections.synchronizedList(arrayList);
    }

    public void removeOperations() {
        this.removeAll();
    }

    public void loadOperations(XMBean xMBean, MBeanInfo mBeanInfo) {
        this.mbean = xMBean;
        this.mbeanInfo = mBeanInfo;
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        this.invalidate();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            ((JButton)componentArray[i]).removeActionListener(this);
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(mBeanOperationInfoArray.length, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(mBeanOperationInfoArray.length, 1));
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            JLabel jLabel = new JLabel(Utils.getReadableClassName(mBeanOperationInfoArray[i].getReturnType()), 4);
            jPanel3.add(jLabel);
            if (jLabel.getText().length() > 20) {
                jLabel.setText(jLabel.getText().substring(jLabel.getText().lastIndexOf(".") + 1, jLabel.getText().length()));
            }
            JButton jButton = new JButton(mBeanOperationInfoArray[i].getName());
            jButton.setToolTipText(mBeanOperationInfoArray[i].getDescription());
            boolean bl = this.isCallable(mBeanOperationInfoArray[i].getSignature());
            if (bl) {
                jButton.addActionListener(this);
            } else {
                jButton.setEnabled(false);
            }
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
            OperationEntry operationEntry = new OperationEntry(mBeanOperationInfoArray[i], bl, jButton, this);
            this.operationEntryTable.put(jButton, operationEntry);
            jPanel4.add(jButton);
            if (mBeanParameterInfoArray.length == 0) {
                jPanel4.add(new JLabel("( )", 0));
            } else {
                jPanel4.add(operationEntry);
            }
            jPanel.add((Component)jPanel3, "West");
            jPanel2.add((Component)jPanel4, "Center");
        }
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "Center");
        this.validate();
    }

    private boolean isCallable(MBeanParameterInfo[] mBeanParameterInfoArray) {
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            if (Utils.isEditableType(mBeanParameterInfoArray[i].getType())) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performInvokeRequest((JButton)actionEvent.getSource());
    }

    void performInvokeRequest(final JButton jButton) {
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    OperationEntry operationEntry = (OperationEntry)XOperations.this.operationEntryTable.get(jButton);
                    Object object = null;
                    object = XOperations.this.mbean.invoke(jButton.getText(), operationEntry.getParameters(), operationEntry.getSignature());
                    if (operationEntry.getReturnType() != null && !operationEntry.getReturnType().equals(Void.TYPE.getName()) && !operationEntry.getReturnType().equals(Void.class.getName())) {
                        XOperations.this.fireChangedNotification(XOperations.OPERATION_INVOCATION_EVENT, jButton, object);
                    } else {
                        EventQueue.invokeLater(new ThreadDialog(jButton, Resources.getText("Method successfully invoked", new Object[0]), Resources.getText("Info", new Object[0]), 1));
                    }
                }
                catch (Throwable throwable) {
                    if (JConsole.isDebug()) {
                        throwable.printStackTrace();
                    }
                    Throwable throwable2 = Utils.getActualException(throwable);
                    String string = throwable2.toString();
                    EventQueue.invokeLater(new ThreadDialog(jButton, Resources.getText("Problem invoking", new Object[0]) + " " + jButton.getText() + " : " + string, Resources.getText("Error", new Object[0]), 0));
                }
            }
        });
    }

    public void addOperationsListener(NotificationListener notificationListener) {
        this.notificationListenersList.add(notificationListener);
    }

    public void removeOperationsListener(NotificationListener notificationListener) {
        this.notificationListenersList.remove(notificationListener);
    }

    private void fireChangedNotification(String string, Object object, Object object2) {
        Notification notification = new Notification(string, object, 0L);
        for (NotificationListener notificationListener : this.notificationListenersList) {
            notificationListener.handleNotification(notification, object2);
        }
    }

    protected abstract MBeanOperationInfo[] updateOperations(MBeanOperationInfo[] var1);
}

