/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Text
extends ControlsSurface {
    static Image img;
    static TexturePaint texture;
    private String clipType = "Lines";
    private DemoControls controls;
    protected boolean doClip = true;

    public Text() {
        this.setBackground(Color.WHITE);
        img = this.getImage("clouds.jpg");
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("sansserif", 1, 32);
        String string = new String("JAVA");
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        double d = textLayout.getBounds().getWidth();
        double d2 = textLayout.getBounds().getHeight();
        double d3 = (double)(n - 40) / d;
        double d4 = (double)(n2 - 40) / d2;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d4);
        Shape shape = textLayout.getOutline(affineTransform);
        d = shape.getBounds().getWidth();
        d2 = shape.getBounds().getHeight();
        affineTransform = AffineTransform.getTranslateInstance((double)(n / 2) - d / 2.0, (double)(n2 / 2) + d2 / 2.0);
        shape = affineTransform.createTransformedShape(shape);
        Rectangle rectangle = shape.getBounds();
        if (this.doClip) {
            graphics2D.clip(shape);
        }
        if (this.clipType.equals("Lines")) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(rectangle);
            graphics2D.setColor(Color.YELLOW);
            graphics2D.setStroke(new BasicStroke(1.5f));
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; i += 3) {
                Line2D.Float float_ = new Line2D.Float(rectangle.x, i, rectangle.x + rectangle.width, i);
                graphics2D.draw(float_);
            }
        } else if (this.clipType.equals("Image")) {
            graphics2D.drawImage(img, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else if (this.clipType.equals("TP")) {
            graphics2D.setPaint(texture);
            graphics2D.fill(rectangle);
        } else if (this.clipType.equals("GP")) {
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLUE, n, n2, Color.YELLOW));
            graphics2D.fill(rectangle);
        } else if (this.clipType.equals("Text")) {
            graphics2D.setColor(Color.BLACK);
            graphics2D.fill(shape.getBounds());
            graphics2D.setColor(Color.CYAN);
            font = new Font("serif", 1, 10);
            textLayout = new TextLayout("java", font, fontRenderContext);
            d = textLayout.getBounds().getWidth();
            int n3 = rectangle.x;
            int n4 = (int)((float)rectangle.y + textLayout.getAscent());
            d2 = rectangle.y + rectangle.height;
            while ((double)n4 < d2) {
                textLayout.draw(graphics2D, n3, n4);
                if ((n3 += (int)d) <= rectangle.x + rectangle.width) continue;
                n3 = rectangle.x;
                n4 += (int)textLayout.getAscent();
            }
        }
        graphics2D.setClip(new Rectangle(0, 0, n, n2));
        graphics2D.setColor(Color.GRAY);
        graphics2D.draw(shape);
    }

    public static void main(String[] stringArray) {
        Text.createDemoFrame(new Text());
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.YELLOW);
        graphics2D.clearRect(0, 0, 5, 5);
        graphics2D.setColor(Color.RED);
        graphics2D.fillRect(0, 0, 3, 3);
        texture = new TexturePaint(bufferedImage, new Rectangle(0, 0, 5, 5));
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Text demo;
        JToolBar toolbar;

        public DemoControls(Text text) {
            super(text.name);
            this.demo = text;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Clip", true);
            this.addTool("Lines", true);
            this.addTool("Image", false);
            this.addTool("TP", false);
            this.addTool("GP", false);
            this.addTool("Text", false);
        }

        public void addTool(String string, boolean bl) {
            JToggleButton jToggleButton = (JToggleButton)this.toolbar.add(new JToggleButton(string));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setSelected(bl);
            jToggleButton.addActionListener(this);
            int n = jToggleButton.getPreferredSize().width;
            Dimension dimension = new Dimension(n, 21);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMaximumSize(dimension);
            jToggleButton.setMinimumSize(dimension);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.toolbar.getComponentAtIndex(0))) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                this.demo.doClip = jToggleButton.isSelected();
            } else {
                for (Component component : this.toolbar.getComponents()) {
                    ((JToggleButton)component).setSelected(false);
                }
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                jToggleButton.setSelected(true);
                this.demo.clipType = jToggleButton.getText();
            }
            this.demo.repaint();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception exception) {
                return;
            }
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 1; i < this.toolbar.getComponentCount() - 1; ++i) {
                    ((AbstractButton)this.toolbar.getComponentAtIndex(i)).doClick();
                    try {
                        Thread.sleep(4444L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

