/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private static final Level[] knownLevels = new Level[]{ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF};
    private String name;
    private int value;
    private String resourceBundleName;
    static final long serialVersionUID = -8176160795706313070L;

    protected Level(String name, int value) {
        this(name, value, null);
    }

    protected Level(String name, int value, String resourceBundleName) {
        this.name = name;
        this.value = value;
        this.resourceBundleName = resourceBundleName;
    }

    private Object readResolve() {
        for (int i = 0; i < knownLevels.length; ++i) {
            if (this.value != knownLevels[i].intValue()) continue;
            return knownLevels[i];
        }
        return this;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        String localizedName = null;
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle b = ResourceBundle.getBundle(this.resourceBundleName);
                localizedName = b.getString(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (localizedName != null) {
            return localizedName;
        }
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    public final int intValue() {
        return this.value;
    }

    public static Level parse(String name) throws IllegalArgumentException {
        name = name.intern();
        for (int i = 0; i < knownLevels.length; ++i) {
            if (name != Level.knownLevels[i].name) continue;
            return knownLevels[i];
        }
        try {
            int num = Integer.parseInt(name);
            for (int i = 0; i < knownLevels.length; ++i) {
                if (num != Level.knownLevels[i].value) continue;
                return knownLevels[i];
            }
        }
        catch (NumberFormatException msg) {
            // empty catch block
        }
        String msg = "Not the name of a standard logging level: \"" + name + "\"";
        throw new IllegalArgumentException(msg);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Level)) {
            return false;
        }
        return this.value == ((Level)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    final boolean isStandardLevel() {
        for (int i = 0; i < knownLevels.length; ++i) {
            if (knownLevels[i] != this) continue;
            return true;
        }
        return false;
    }
}

