/*
 *  Global structures used in GUS driver
 */

struct GUS_STRU_CARD;
typedef struct GUS_STRU_CARD gus_card_t;

#define __DRIVER_STRU__
#include "gf1.h"
#include "codec.h"
#include "pcm.h"
#include "mixer.h"
#include "midi.h"
#include "sequencer.h"
#undef __DRIVER_STRU__

#define GUS_DMAS	4	/* 2 x GF1 + 2 x CODEC */

#define GUS_DMA_GPLAY		0x0000
#define GUS_DMA_GRECORD		0x0001
#define GUS_DMA_CRECORD		0x0002
#define GUS_DMA_CPLAY		0x0003

struct GUS_STRU_DMA {
  unsigned short static_alloc: 1, /* pre-allocated */
  		 mmaped: 1;	  /* mmaped area */
  short used;			/* dma channel is used (count) */
  short dma;			/* DMA number */
  unsigned char *buf;		/* pointer to DMA buffer */
  long size;			/* real size of DMA buffer */
  long rsize;			/* requested size of DMA buffer */
  long usize;			/* used size of DMA buffer */
  long ursize;			/* used requested size of DMA buffer */
  unsigned short lock;		/* lock flags for this DMA channel */
  char *owner;			/* owner of this DMA channel */
  char *old_owner;		/* old owner of this DMA channel */
};

/* main structure for GUS card */

struct GUS_STRU_CARD {
  int number;			/* number of card (index to gus_cards) */
  int dnumber;			/* detected number of card (index to gus_cards) */
  int version;			/* version of GUS card */
  char id[ 8 ];			/* id string of this card */
  unsigned int interrupt_stat;	/* total interrupts */
  unsigned int detection:1,	/* detection phase */
               equal_irq:1,	/* GF1 and CODEC shares IRQ (GUS MAX only) */
  	       equal_dma:1,	/* if dma channels are equal (not valid for daughter board) */
  	       ics_flag:1,	/* have we ICS mixer chip */
  	       ics_flipped:1,	/* ICS mixer have flipped some channels? */
  	       codec_flag:1,	/* have we CODEC chip? */
  	       max_flag:1,	/* have we GUS MAX card? */
  	       daughter_flag:1, /* have we daughter board? */
  	       use_codec:1,	/* use CODEC chip for PCM? */
  	       pnp_flag:1,	/* hey - we have PnP card */ 
  	       pnp_pro_flag:1;	/* PnP Pro card flag */
  unsigned int dma1_ok:1,
  	       dma2_ok:1,
  	       dmad_ok:1,
  	       gf1_irq_ok:1,
  	       codec_irq_ok:1;
  short dma1, dma2, dmad;	/* dma numbers */
  int dma1_size, dma2_size, dmad_size;	/* requested dma sizes */
  struct GUS_STRU_DMA dmas_data[ GUS_DMAS - 2 ]; /* data dma channels */
  struct GUS_STRU_DMA *dmas[ GUS_DMAS ]; /* pointers to dma channels */
  unsigned short max_cntrl_val;	/* GUS MAX control value */
  struct GUS_STRU_GF1 gf1;
#ifdef GUSCFG_CODEC
  struct GUS_STRU_CODEC codec;
#endif
  struct GUS_STRU_MIXER mixer;
  struct GUS_STRU_PCM pcm;
#ifdef GUSCFG_MIDI_DEVICES
  struct GUS_STRU_MIDI midi[ 2 ];	/* 0 - MIDI port, 1 = internal MIDI emulation */
#endif
#ifdef GUSCFG_USS
  struct GUS_STRU_SEQUENCER seq;
#endif
  /* sleep part */
  SLEEP_DEFINE( dma1 )
  SLEEP_DEFINE( dma2 )
  SLEEP_DEFINE( wqueue )
  SLEEP_DEFINE( tqueue )
  SLEEP_DEFINE( rqueue )
  SLEEP_DEFINE( synth_tmp )
  SLEEP_DEFINE( daemon )
  SLEEP_DEFINE( daemon_wait )
  SLEEP_DEFINE( playback )
  SLEEP_DEFINE( record )
#ifdef GUSCFG_GF1PCM
  SLEEP_DEFINE( playback_sync )
  SLEEP_DEFINE( dma1_lock )
#endif
#ifdef GUSCFG_MIDI_DEVICES
  SLEEP_DEFINE( uart_flush )
#endif
#ifdef GUSCFG_MIDI
  SLEEP_DEFINE( midi_in )
  SLEEP_DEFINE( midi_out )
#endif
#ifdef GUSCFG_USS
  SLEEP_DEFINE( seq_in )
  SLEEP_DEFINE( seq_out )
#endif
  gus_card_t *next;
};
