/*
 *  defines for VoxWare sequencer emulator
 */

#ifdef GUSCFG_USS

#ifdef __DRIVER_STRU__

#define SEQFLG_GO		0x0001

struct GUS_STRU_SEQ_VOICE {
  unsigned short flags;
  short pgm;
  int bender;
  int bender_range;
  int midi_main_vol;
  int midi_volume;
  int midi_expression_vol;
  int midi_patch_vol;
  unsigned short panning;
  unsigned short volume;
  gus_instrument_t *instrument;
};

typedef struct GUS_STRU_SEQ_VOICE gus_seq_voice_t;
                  
#define GUS_SEQ_F_MIDI_EMUL	0x00000001
#define GUS_SEQ_F_EFFEN		0x00000002	/* effect enable */
#define GUS_SEQ_F_D0SWAP	0x00000003	/* swap device 0 to device 2 in input queue */
                  
struct GUS_STRU_SEQUENCER {
  unsigned int flags;
  int voices_count;
  struct GUS_STRU_SEQ_VOICE *voices;
  int volume_base;
  int volume_scale;
  unsigned short vol_mode;
  unsigned short volume_mode;
  unsigned short freq_mode;
  unsigned short gf1_voices;
  int iw_effect[ 2 ];
  struct GUS_STRU_MIDI_CMD gf1_emul;
  struct GUS_STRU_MIDI_CMD ext_dev;
};

#endif /* __DRIVER_STRU__ */

#endif /* GUSCFG_USS */
