/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Routines for the MIDI interface - command decoding
 */

#include "driver.h"
#include "midi.h"

#ifdef GUSCFG_MIDI_DEVICES

void gus_midi_cmd_init( struct GUS_STRU_MIDI_CMD *cmd, int prev )
{
  if ( prev )
    cmd -> prev_cmd = 0x00;
  cmd -> used = cmd -> left = 0;
}

void gus_midi_cmd_byte( struct GUS_STRU_MIDI_CMD *cmd, unsigned char data )
{
  static unsigned char len_tab[] = 	/* # of data bytes following a status */
  {
  	2,	/* 8x */
  	2,	/* 9x */
  	2,	/* Ax */
  	2,	/* Bx */
  	1,	/* Cx */
  	1,	/* Dx */
  	2,	/* Ex */
  	0,	/* Fx */
  };
  
#if 0
  PRINTK( "dev = 0x%x, byte - 0x%x, used = %i, left = %i\n", cmd -> dev, data, cmd -> used, cmd -> left );
#endif
  if ( cmd -> used >= cmd -> size )
    {
      PRINTK( "gus: MIDI CMD BYTE - overflow - dev = 0x%x, used = %i, cmd = 0x%x\n", cmd -> dev, cmd -> used, cmd -> buf[ 0 ] );
      gus_midi_cmd_init( cmd, 1 );		/* this isn't good */
      return;
    }
  cmd -> buf[ cmd -> used++ ] = data;
  if ( cmd -> used == 1 )		/* init byte */
    {
      if ( data & 0x80 )		/* MIDI status byte */
        {
          if ( ( data & 0xf0 ) == 0xf0 ) /* common message */
            {
              switch ( data ) {
                case GUS_MCMD_COMMON_SYSEX:
                  return;
                case GUS_MCMD_COMMON_MTC_QUARTER:
                case GUS_MCMD_COMMON_SONG_SELECT:
                  cmd -> left = 1;
                  return;
                case GUS_MCMD_COMMON_SONG_POS:
                  cmd -> left = 2;
                  return;
                case GUS_MCMD_COMMON_TUNE_REQUEST:
                case GUS_MCMD_COMMON_START:
                case GUS_MCMD_COMMON_CONTINUE:
                case GUS_MCMD_COMMON_STOP:
                  cmd -> ack( cmd -> dev, cmd -> buf, cmd -> used );
                  gus_midi_cmd_init( cmd, 0 );
                  return;
                case GUS_MCMD_COMMON_SYSEX_END:	/* something is wrong :-( */
                case GUS_MCMD_COMMON_CLOCK:
                case GUS_MCMD_COMMON_SENSING:
                case GUS_MCMD_COMMON_RESET:
                  gus_midi_cmd_init( cmd, 0 );
                  return;
                default:
                  PRINTK( "gus: MIDI CMD BYTE - unknown Fx cmd - 0x%x\n", data );
                  gus_midi_cmd_init( cmd, 0 );
                  return;
              }
            }
           else
            {
              cmd -> left = len_tab[ ( data >> 4 ) & 0x07 ];
              cmd -> prev_cmd = data;
              return;
            }
        }
       else
        {
          if ( !cmd -> prev_cmd )		/* probably unexpected data */
            {
              gus_midi_cmd_init( cmd, 1 );
              return;
            }
          cmd -> buf[ 0 ] = cmd -> prev_cmd;
          cmd -> buf[ 1 ] = data;
          cmd -> used = 2;
          cmd -> left = len_tab[ ( cmd -> prev_cmd >> 4 ) & 0x07 ] - 1;
          if ( !cmd -> left )
            {
              cmd -> ack( cmd -> dev, cmd -> buf, cmd -> used );
              gus_midi_cmd_init( cmd, 0 );
              return;
            }
        }
    }
  if ( cmd -> left )		/* ok. some next data */
    {
      if ( !(--cmd -> left) )	/* finished */
        {
          cmd -> ack( cmd -> dev, cmd -> buf, cmd -> used );
          gus_midi_cmd_init( cmd, 0 );
        }
      return;
    }
  switch ( cmd -> buf[ 0 ] & 0xf0 ) {
    case 0xf0:				/* SysEx */
      if ( data == 0xf7 )		/* SysEx end */
        {          
          cmd -> ack( cmd -> dev, cmd -> buf, cmd -> used );
          gus_midi_cmd_init( cmd, 0 );
        }
      break;
    default:
      PRINTK( "gus: MIDI CMD BYTE - unexpected status - 0x%x\n", cmd -> buf[ 0 ] );
  }
}

#endif /* GUSCFG_MIDI */
