/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 */

#ifdef GUSCFG_MIDI_DEVICES

#ifdef __DRIVER_STRU__

#define GUS_MIDI_BUF_SIZE	512		/* this should be enough */
#define GUS_MIDI_QUEUE_SIZE	(8*1024)	/* global Rx/Tx buffer size */
#define GUS_MIDI_CMD_SIZE	(4*1024)	/* command size */

struct GUS_STRU_MIDI_CMD {
  unsigned int dev;
  unsigned char *buf;
  unsigned int size;
  unsigned int used;
  unsigned int left;
  unsigned char prev_cmd;
  void (*ack)( unsigned int device, unsigned char *buffer, unsigned int cound );
};

struct GUS_STRU_MIDI {
  unsigned int flags;
  unsigned int dev;			/* device = ( card# << 4 ) | midi_device */
  unsigned char *tx_buf;
  unsigned int tx_size;
  unsigned int tx_used;
  unsigned int tx_head;
  unsigned int tx_tail;
  unsigned char tx_prev_cmd;
  struct GUS_STRU_MIDI_CMD rx;
  unsigned short thru_mask;
  struct {
    unsigned char device;
    unsigned char channel;
    unsigned char velocity;
  } thru[ 16 ][ GUS_MIDID_LAST + 1 ];
  int (*init_write)( gus_card_t *card );
  int (*init_read)( gus_card_t *card );
  void (*done_write)( gus_card_t *card );
  void (*done_read)( gus_card_t *card );
  int (*putcmd)( gus_card_t *card, unsigned char *buffer, unsigned int count );
};

#endif /* __DRIVER_STRU__ */

#ifdef __DRIVER_MAIN__

#define GUS_MIDIF_USED_IN	0x00000001
#define GUS_MIDIF_USED_OUT	0x00000002
#define GUS_MIDIF_USED		(GUS_MIDIF_USED_IN|GUS_MIDIF_USED_OUT)
#define GUS_MIDIF_SEQUENCER	0x00000004

/* midi_cmd.c */

extern void gus_midi_cmd_init( struct GUS_STRU_MIDI_CMD *cmd, int prev );
extern void gus_midi_cmd_byte( struct GUS_STRU_MIDI_CMD *cmd, unsigned char data );

/* midi.c */

extern void gus_midi_rx_command( unsigned int device, unsigned char *buffer, unsigned int count );

#endif /* __DRIVER_MAIN__ */

#endif /* GUSCFG_MIDI_DEVICES */
